/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include "Panel.h"
#include "ikp_globalE.h"
#define CBP XtCallbackProc

                                /* Prototype of callback functions. */
/*
extern XtCallbackProc printCB(Widget,XtPointer,XtPointer);
*/
extern XtCallbackProc openCB(Widget,XtPointer,XtPointer);
extern XtCallbackProc saveCB(Widget,XtPointer,XtPointer);
extern XtCallbackProc newCB(Widget,XtPointer,XtPointer);
extern XtCallbackProc runCB(Widget,XtPointer,XtPointer);
extern XtCallbackProc exitCB(Widget,XtPointer,XtPointer);

extern XtCallbackProc foreach_moduleCB(Widget,XtPointer,XtPointer);
extern XtCallbackProc ifthen_moduleCB(Widget,XtPointer,XtPointer);
extern XtCallbackProc ifthenelse_moduleCB(Widget,XtPointer,XtPointer);
extern XtCallbackProc custom_moduleCB(Widget,XtPointer,XtPointer);
extern XtCallbackProc delete_moduleCB(Widget,XtPointer,XtPointer);

void fileMenu();
void editMenu();
void viewMenu();
void helpMenu();

static Widget menu_bar;

Widget menubar(Widget main_window)
{
  menu_bar=XmCreateMenuBarVa(main_window,"menu",
			     NULL);

  fileMenu();
  editMenu();
  viewMenu();
  helpMenu();

  return(menu_bar);
}


				/* Create "File" pulldown. */
void fileMenu()
{
  Widget pulldown;
  Widget cascade;
  Widget button;

  pulldown=XmCreatePulldownMenuVa(menu_bar,"pulldown",
                                  XtNmanageChild,False,
                                  NULL);
 
  cascade=XmCreateCascadeButtonVa(menu_bar,"File",
                                  XmNsubMenuId,pulldown,
                                  XmNmnemonic,'F',
                                  NULL);

  button=XmCreatePushButtonVa(pulldown,"New",
                              XmNmnemonic,'N',
			      XmNactivateCallback,CBl(newCB,0),
                              NULL);
 
  button=XmCreatePushButtonVa(pulldown,"Run",
                              XmNmnemonic,'R',
                              XmNacceleratorText,XMstr("Ctrl+R"),
                              XmNaccelerator,"Ctrl <Key>R",
			      XmNactivateCallback,CBl(runCB,0),
                              NULL);
 
  button=XmCreatePushButtonVa(pulldown,"Open...",
                              XmNmnemonic,'O',
			      XmNactivateCallback,CBl(openCB,0),
                              NULL);
 
  button=XmCreatePushButtonVa(pulldown,"Save",
                              XmNmnemonic,'S',
			      XmNactivateCallback,CBl(saveCB,0),
                              NULL);
 
  button=XmCreatePushButtonVa(pulldown,"Save As...",
                              XmNmnemonic,'A',
			      XmNactivateCallback,CBl(saveCB,0),
                              NULL);
 
  button=XmCreatePushButtonVa(pulldown,"Print...",
                              XmNmnemonic,'P',
/*			      XmNactivateCallback,CBl(printCB,"junk.ras"), */
                              NULL);

  button=XmCreatePushButtonVa(pulldown,"Close",
                              XmNmnemonic,'C',
                              NULL);
/*  XtAddCallback(button,XmNactivateCallback,(XtCallbackProc)closeCB,0); */
 
  button=XmCreatePushButtonVa(pulldown,"Exit",
                              XmNmnemonic,'E',
			      XmNactivateCallback,CBl(exitCB,0),
                              NULL);
}
 
                                /* Create "Edit" pulldown. */
void editMenu()
{
  Widget pulldown;
  Widget cascade;
  Widget button;
  Widget separator;
 
  pulldown=XmCreatePulldownMenuVa(menu_bar,"pulldown",
                                  XtNmanageChild,False,
                                  (char *)0);
  
  cascade=XmCreateCascadeButtonVa(menu_bar,"Edit",
                                  XmNsubMenuId,pulldown,
                                  XmNmnemonic,'E',
                                  (char *)0);
 
  button=XmCreatePushButtonVa(pulldown,"Foreach",
                              XmNmnemonic,'F',
			      XmNactivateCallback,CBl(foreach_moduleCB,0),
                              NULL);

  button=XmCreatePushButtonVa(pulldown,"If Then",
                              XmNmnemonic,'I',
			      XmNactivateCallback,CBl(ifthen_moduleCB,0),
                              NULL);

  button=XmCreatePushButtonVa(pulldown,"If Then Else",
                              XmNmnemonic,'I',
			      XmNactivateCallback,CBl(ifthenelse_moduleCB,0),
                              NULL);

  button=XmCreatePushButtonVa(pulldown,"Custom",
                              XmNmnemonic,'C',
			      XmNactivateCallback,CBl(custom_moduleCB,0),
                              NULL);
 
  button=XmCreatePushButtonVa(pulldown,"Delete",
                              XmNmnemonic,'D',
                              XmNacceleratorText,XMstr("Shift+D"),
                              XmNaccelerator,"Shift <Key>D",
			      XmNactivateCallback,CBl(delete_moduleCB,0),
                              NULL);
}


				/* Create "View" pulldown. */
void viewMenu()
{
  Widget pulldown;
  Widget cascade;
  Widget button;

  pulldown=XmCreatePulldownMenuVa(menu_bar,"pulldown",
                                  XtNmanageChild,False,
                                  NULL);
  
  cascade=XmCreateCascadeButtonVa(menu_bar,"View",
                                  XmNsubMenuId,pulldown,
                                  XmNmnemonic,'V',
                                  NULL);
 
  button=XmCreatePushButtonVa(pulldown,"Change View",NULL);
}

				/* Create "Help" pulldown. */
void helpMenu()
{
  Widget pulldown;
  Widget cascade;
  Widget button;

  pulldown=XmCreatePulldownMenuVa(menu_bar,"pulldown",
                                  XtNmanageChild,False,
                                  NULL);
  
  cascade=XmCreateCascadeButtonVa(menu_bar,"Help",
                                  XmNsubMenuId,pulldown,
                                  XmNmnemonic,'H',
                                  NULL);
 
  XtVaSetValues(menu_bar,
                XmNmenuHelpWidget,cascade,
                NULL);
 
  button=XmCreatePushButtonVa(pulldown,"On Context",
                              XmNmnemonic,'C',
                              NULL);
 
  button=XmCreatePushButtonVa(pulldown,"On Window",
                              XmNmnemonic,'W',
                              NULL);
 
  button=XmCreatePushButtonVa(pulldown,"On Keys",
                              XmNmnemonic,'K',
                              NULL);
 
  button=XmCreatePushButtonVa(pulldown,"Index",
                              XmNmnemonic,'I',
                              NULL);
 
  button=XmCreatePushButtonVa(pulldown,"On Help",
                              XmNmnemonic,'H',
                              NULL);
 
  button=XmCreatePushButtonVa(pulldown,"Tutorial",
                              XmNmnemonic,'T',
                              NULL);
 
  button=XmCreatePushButtonVa(pulldown,"On Version",
                              XmNmnemonic,'V',
                              NULL);
}
