/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include "Panel.h"
#include "ikp_globalE.h"

extern void open_flow(char *);
extern void save_flow(char *);

extern Widget filer_box;

char buf1[1024];

XtCallbackProc runCB(Widget w,XtPointer client_data,XtPointer call_data)
{
  char *tmp_file;

  tmp_file=tmpnam(NULL);

  save_flow(tmp_file);
  
  sprintf(buf1,"xcat -busy -e \"%s.script; echo DONE\" &",tmp_file);

  system(buf1);
}


XtCallbackProc open_okCB(Widget w,
			 XtPointer client_data,
			 XmFileSelectionBoxCallbackStruct *call_data)
{
  char *str;

  XmStringGetLtoR(call_data->value,XmSTRING_DEFAULT_CHARSET,&str);
 
  if (strlen(str)>0) 
    open_flow(str);
}
 
XtCallbackProc openCB(Widget w,XtPointer client_data,XtPointer call_data)
{
  XtVaSetValues(filer_box,
                XmNokCallback,CBl(open_okCB,0),
		XmNdialogTitle,XMstr("Open Flow"),
                NULL);

  XtManageChild(filer_box);
}


XtCallbackProc save_okCB(Widget w,
			 XtPointer client_data,
			 XmFileSelectionBoxCallbackStruct *call_data)
{
  char *str;

  XmStringGetLtoR(call_data->value,XmSTRING_DEFAULT_CHARSET,&str);
 
  if (strlen(str)>0) 
    save_flow(str);
}
 
XtCallbackProc saveCB(Widget w,XtPointer client_data,XtPointer call_data)
{
  XtVaSetValues(filer_box,
                XmNokCallback,CBl(save_okCB,0),
		XmNdialogTitle,XMstr("Save Flow"),
                NULL);

  XtManageChild(filer_box);
}


XtCallbackProc exitCB(Widget w,XtPointer client_data,XtPointer call_data)
{
  exit(0);
}


