/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include "Panel.h"
#include "ikp_globalE.h"
/* - changed to fcntl, which should get stat.h 
#include <sys/stat.h>
*/
#include <fcntl.h>

#define MAX_NESTING 10

extern Widget draw_area;

extern Panel *map_dialog(Widget,char *,int,int,int);
extern void reset_filerbox(Panel *,int,int);

void draw_modules();
void unmanage_dialog();

typedef struct Stack Stack;
struct Stack {
  Module *module;
  Stack *previous;
};
static Stack *stack_module=NULL;

static Module *current_module=NULL;
static Module *else_module;
static Module *end_module;
static Module *start_module=NULL;
static GC gc;
static Window top;
static int current_width,current_height;

static char buf1[1024],buf2[1024];

void free_module(Module *module)
{
  if (module->name!=NULL)
    free(module->name);

  if (module->command!=NULL)
    free(module->command);


}


void create_module(char *module_name,Widget dialog_window,int stdout_flag)
{
  Module *module;

  if (current_module==NULL) {
    current_module=(Module *)malloc(sizeof(Module));
    start_module=current_module;
    module=NULL;
  } else {
    module=current_module->next;
    current_module->next=(Module *)malloc(sizeof(Module));
    current_module=current_module->next;
  }
  current_module->name=strdup(module_name);
  current_module->command=NULL;
  current_module->dialog=dialog_window;
  current_module->stdout_flag=stdout_flag;
  current_module->next=module;
  current_module->item=NULL;
  current_module->link=NULL;
}

XtCallbackProc custom_moduleCB(Widget w,
			       XtPointer client_data,
			       XtPointer call_data)
{
  map_dialog(NULL,"Custom",0,0,0);
  draw_modules();
}

XtCallbackProc foreach_okCB(Widget w,
			    XtPointer client_data,
			    XtPointer call_data)
{
  Module *module=(Module *)client_data;
  char *str1=NULL,*str2=NULL,*command=NULL;
  int size=2;
  float count,start=0.0,end=0.0,incr=0.0;

  XtVaGetValues(module->text_variable,
		XmNvalue,&str1,
		NULL);
  XtVaGetValues(module->text_list,
		XmNvalue,&str2,
		NULL);

  if ((str1!=NULL)&&(str2!=NULL)) {
    if (strchr(str2,',')==NULL) {
      sprintf(buf1,"for %s in %s ;do",str1,str2);
      module->command=strdup(buf1);
    } else {
      strcpy(buf2,str2);
      strcpy(strchr(buf2,','),"");
      sscanf(buf2,"%f",&start);
      strcpy(buf2,strchr(str2,',')+1);
      if (strchr(buf2,',')!=NULL) {
	strcpy(strchr(buf2,','),"");
	sscanf(buf2,"%f",&end);
	strcpy(buf2,strchr(str2,',')+1);
	strcpy(buf2,strchr(buf2,',')+1);
	sscanf(buf2,"%f",&incr);
      }
      command=malloc(1000*size);
      sprintf(command,"for %s in ",str1);
      for (count=start; count<=end; count+=incr) {
	sprintf(buf2,"%f ",count);
	strcat(command,buf2);
	if (strlen(command)>1000*(size-1)) {
	  size++;
	  command=realloc(command,size*1000);
	}
      }
      strcat(command," ;do");
      module->command=strdup(command);
    }
  }

  XtFree(str1);
  XtFree(str2);
  XtFree(command);

  unmanage_dialog();
}

XtCallbackProc foreach_cancelCB(Widget w,
			    XtPointer client_data,
			    XtPointer call_data)
{
  unmanage_dialog();
}

void create_foreach_module()
{
  Module *module;
  Widget dialog_window;
  Widget button;
  Widget label;

  if (current_module==NULL) {
    current_module=(Module *)malloc(sizeof(Module));
    start_module=current_module;
    module=NULL;
  } else {
    module=current_module->next;
    current_module->next=(Module *)malloc(sizeof(Module));
    current_module=current_module->next;
  }

  dialog_window=XmCreateFormDialogVa(top_level,"form",
				     XmNmarginHeight,10,
				     XmNmarginWidth,10,
				     XtNmanageChild,False,
				     NULL);
  
  label=XmCreateLabelVa(dialog_window,"Variable  ",
			XmNtopAttachment,XmATTACH_FORM,
			XmNtopOffset,16,
			XmNleftAttachment,XmATTACH_FORM,
			NULL);
  
  current_module->text_variable=XmCreateTextVa(dialog_window,"text",
				       XmNtopAttachment,XmATTACH_FORM,
				       XmNleftAttachment,XmATTACH_WIDGET,
				       XmNleftWidget,label,
				       NULL);
  
  label=XmCreateLabelVa(dialog_window,"Item List ",
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,current_module->text_variable,
			XmNtopOffset,8,
			XmNleftAttachment,XmATTACH_FORM,
			NULL);
  
  
  current_module->text_list=XmCreateTextVa(dialog_window,"text",
				   XmNtopAttachment,XmATTACH_WIDGET,
				   XmNtopWidget,current_module->text_variable,
				   XmNleftAttachment,XmATTACH_WIDGET,
				   XmNleftWidget,label,
				   XmNrightAttachment,XmATTACH_FORM,
				   XmNcolumns,30,
				   NULL);
  
  button=XmCreatePushButtonVa(dialog_window,"  OK  ",
			      XmNtopAttachment,XmATTACH_WIDGET,
			      XmNtopWidget,current_module->text_list,
			      XmNtopOffset,10,
			      XmNleftAttachment,XmATTACH_POSITION,
			      XmNleftPosition,5,
			      XmNbottomAttachment,XmATTACH_FORM,
			      XmNbottomOffset,10,
			      XmNactivateCallback,
			      CBl(foreach_okCB,current_module),
			      NULL);
  
  button=XmCreatePushButtonVa(dialog_window,"Cancel",
			      XmNtopAttachment,XmATTACH_WIDGET,
			      XmNtopWidget,current_module->text_list,
			      XmNtopOffset,10,
			      XmNleftAttachment,XmATTACH_POSITION,
			      XmNleftPosition,45,
			      XmNbottomAttachment,XmATTACH_FORM,
			      XmNbottomOffset,10,
			      XmNactivateCallback,CBl(foreach_cancelCB,0),
			      NULL);
  
  button=XmCreatePushButtonVa(dialog_window," Help ",
			      XmNtopAttachment,XmATTACH_WIDGET,
			      XmNtopWidget,current_module->text_list,
			      XmNtopOffset,10,
			      XmNleftAttachment,XmATTACH_POSITION,
			      XmNleftPosition,80,
			      XmNbottomAttachment,XmATTACH_FORM,
			      XmNbottomOffset,10,
			      XmNactivateCallback,
			      /*                              CBl(panel_helpCB,item->program_help), */
			      NULL);

  current_module->name=strdup("Foreach_Loop");
  current_module->command=NULL;
  current_module->dialog=dialog_window;
  current_module->stdout_flag=0;
  current_module->next=module;
  current_module->item=NULL;
  current_module->link=NULL;

}

void create_end_module()
{
  Module *module;

  module=current_module->next;
  current_module->next=(Module *)malloc(sizeof(Module));
  end_module=current_module->next;
				/* Add link so end gets delete with foreach. */
  current_module->link=end_module;

  end_module->name=strdup("End_Loop");
  end_module->command=strdup("done");
  end_module->dialog=NULL;
  end_module->stdout_flag=0;
  end_module->next=module;
  end_module->item=NULL;
  end_module->link=NULL;
}

XtCallbackProc ifthen_okCB(Widget w,
			   XtPointer client_data,
			   XtPointer call_data)
{
  Module *module=(Module *)client_data;
  char *str1,*command;
  int size=2;
  float count,start=0.0,end=0.0,incr=0.0;

  XtVaGetValues(module->text_variable,
		XmNvalue,&str1,
		NULL);

  if (str1!=NULL) {
    sprintf(buf1,"if ( test %s ) then",str1);
    module->command=strdup(buf1);
  }

  XFree(str1);
  XFree(command);

  unmanage_dialog();
}

XtCallbackProc ifthen_cancelCB(Widget w,
			    XtPointer client_data,
			    XtPointer call_data)
{
  unmanage_dialog();
}

void create_ifthen_module()
{
  Module *module;
  Widget dialog_window;
  Widget button;
  Widget label;

  if (current_module==NULL) {
    current_module=(Module *)malloc(sizeof(Module));
    start_module=current_module;
    module=NULL;
  } else {
    module=current_module->next;
    current_module->next=(Module *)malloc(sizeof(Module));
    current_module=current_module->next;
  }

  dialog_window=XmCreateFormDialogVa(top_level,"form",
				     XmNmarginHeight,10,
				     XmNmarginWidth,10,
				     XtNmanageChild,False,
				     NULL);
  
  label=XmCreateLabelVa(dialog_window,"Expression",
			XmNtopAttachment,XmATTACH_FORM,
			XmNtopOffset,16,
			XmNleftAttachment,XmATTACH_FORM,
			NULL);
  
  current_module->text_variable=XmCreateTextVa(dialog_window,"text",
				       XmNtopAttachment,XmATTACH_FORM,
				       XmNleftAttachment,XmATTACH_WIDGET,
				       XmNleftWidget,label,
				       NULL);
  
  button=XmCreatePushButtonVa(dialog_window,"  OK  ",
			      XmNtopAttachment,XmATTACH_WIDGET,
			      XmNtopWidget,current_module->text_variable,
			      XmNtopOffset,10,
			      XmNleftAttachment,XmATTACH_POSITION,
			      XmNleftPosition,5,
			      XmNbottomAttachment,XmATTACH_FORM,
			      XmNbottomOffset,10,
			      XmNactivateCallback,
			      CBl(ifthen_okCB,current_module),
			      NULL);
  
  button=XmCreatePushButtonVa(dialog_window,"Cancel",
			      XmNtopAttachment,XmATTACH_WIDGET,
			      XmNtopWidget,current_module->text_variable,
			      XmNtopOffset,10,
			      XmNleftAttachment,XmATTACH_POSITION,
			      XmNleftPosition,45,
			      XmNbottomAttachment,XmATTACH_FORM,
			      XmNbottomOffset,10,
			      XmNactivateCallback,CBl(ifthen_cancelCB,0),
			      NULL);
  
  button=XmCreatePushButtonVa(dialog_window," Help ",
			      XmNtopAttachment,XmATTACH_WIDGET,
			      XmNtopWidget,current_module->text_variable,
			      XmNtopOffset,10,
			      XmNleftAttachment,XmATTACH_POSITION,
			      XmNleftPosition,80,
			      XmNbottomAttachment,XmATTACH_FORM,
			      XmNbottomOffset,10,
			      XmNactivateCallback,
			      /*                              CBl(panel_helpCB,item->program_help), */
			      NULL);

  current_module->name=strdup("If_Then");
  current_module->command=NULL;
  current_module->dialog=dialog_window;
  current_module->stdout_flag=0;
  current_module->next=module;
  current_module->item=NULL;
  current_module->link=NULL;

}

void create_elseif_module()
{
  Module *module,*else_module;

  module=current_module->next;
  current_module->next=(Module *)malloc(sizeof(Module));
  else_module=current_module->next;
				/* Add link so else gets delete with if. */
  current_module->link=else_module;

  else_module->name=strdup("Else_If");
  else_module->command=strdup("else");
  else_module->dialog=NULL;
  else_module->stdout_flag=0;
  else_module->next=module;
  else_module->item=NULL;
  else_module->link=NULL;

  current_module=else_module;
}

void create_endif_module()
{
  Module *module;

  module=current_module->next;
  current_module->next=(Module *)malloc(sizeof(Module));
  end_module=current_module->next;
				/* Add link so end gets delete with foreach. */
  current_module->link=end_module;

  end_module->name=strdup("End_If");
  end_module->command=strdup("fi");
  end_module->dialog=NULL;
  end_module->stdout_flag=0;
  end_module->next=module;
  end_module->item=NULL;
  end_module->link=NULL;
}


XtCallbackProc ifthen_moduleCB(Widget w,
			       XtPointer client_data,
			       XtPointer call_data)
{
  create_ifthen_module();
  create_endif_module();

  draw_modules();
}


XtCallbackProc ifthenelse_moduleCB(Widget w,
			       XtPointer client_data,
			       XtPointer call_data)
{
  create_ifthen_module();
  create_elseif_module();
  create_endif_module();

  draw_modules();
}


XtCallbackProc foreach_moduleCB(Widget w,
			       XtPointer client_data,
			       XtPointer call_data)
{
  create_foreach_module();
  create_end_module();

  draw_modules();
}


XtCallbackProc newCB(Widget w,
		     XtPointer client_data,
		     XtPointer call_data)
{
  Module *module,*lnk_module;

  if (start_module==NULL)
    return;


  module=start_module;
  while (module!=NULL) {
    current_module=module;
    module=module->next;
    free_module(current_module);
  }
  start_module=NULL;

  draw_modules();
}

XtCallbackProc delete_moduleCB(Widget w,
			       XtPointer client_data,
			       XtPointer call_data)
{
  Module *module,*lnk_module;

  if ((start_module==NULL)||(current_module==NULL))
    return;

  if ((int)client_data==0) {
    if ((strcmp(current_module->name,"End_Loop")==0)||
	(strcmp(current_module->name,"End_If")==0)||
	(strcmp(current_module->name,"Else_If")==0))
      return;
  }

				/* If deleting the first module. */
  if (start_module==current_module) {
    start_module=current_module->next;
    module=NULL;
    if (current_module!=NULL) {
      if (current_module->item!=NULL)
	delete_panel(current_module->item);
      lnk_module=current_module->link;
      free_module(current_module);
      
      current_module=start_module;
      
      if (lnk_module!=NULL) {
	current_module=lnk_module;
	delete_moduleCB(NULL,(XtPointer)1,NULL);
      }
    }
  } else {			/* Find previous module. */
    module=start_module;
    while (module!=NULL) {
      if (module->next==current_module)
	break;
      module=module->next;
    }
    if (current_module!=NULL) {
      if (current_module->item!=NULL)
	delete_panel(current_module->item);
      lnk_module=current_module->link;
      module->next=current_module->next;
      free_module(current_module);
      
      if (lnk_module!=NULL) {
	current_module=lnk_module;
	delete_moduleCB(NULL,(XtPointer)1,NULL);
      }

      current_module=module;

    }
  }

  draw_modules();
}

void set_default_command(char *command_tmp,Panel *item)
{
  if (current_module==NULL) 
    return;

  if (current_module->command!=NULL)
    free(current_module->command);
  
  current_module->command=strdup(command_tmp);
  current_module->item=item;
}

void set_command(char *command_tmp,Widget w)
{
  Module *module;

  if ((w==NULL)||(start_module==NULL))
    return;

  module=start_module;
  while (module!=NULL) {
    if (w==module->dialog) {
      if (module->command!=NULL)
	free(module->command);
      module->command=strdup(command_tmp);
    }
    module=module->next;
  }
}    


void open_flow(char *filename)
{
  FILE *in;
  char *error,keyword[1024];
  int pipe_in_flag=0,pipe_out_flag=0;
  Panel *item;
  Stack *old_module=NULL;
  Module *tmp_module;

  in=fopen(filename,"r");
  if (in==NULL) {
    fprintf(stderr,"Error openning out file %s\n",filename);
    return;
  }

  error=fgets(buf1,1024,in);
  while (error!=NULL) {
    if (strlen(buf1)>1)
      buf1[strlen(buf1)-1]=NULL;
    strcpy(keyword,"");
    strcpy(buf2,"");
    sscanf(buf1,"%s",keyword);
    if (strcmp(keyword,"PIPE")==0) {
      pipe_in_flag=pipe_out_flag;
      pipe_out_flag=1;
    } else {
      if (strcmp(keyword,"NO_PIPE")==0) {
	pipe_in_flag=pipe_out_flag;
	pipe_out_flag=0;
      } else {
	if ((strcmp(keyword,"Foreach_Loop")!=0)&&
	    (strcmp(keyword,"End_Loop")!=0)&&
	    (strcmp(keyword,"If_Then")!=0)&&
	    (strcmp(keyword,"Else_If")!=0)&&
	    (strcmp(keyword,"End_If")!=0)) {
	  item=map_dialog(NULL,keyword,0,pipe_in_flag,pipe_out_flag);
	  draw_modules();
	  sscanf(buf1,"%s %s",keyword,buf2);
	  strcpy(buf2,strstr(buf1+strlen(keyword),buf2));
	  sscanf(buf2,"%s %s",keyword,buf1);
	  if (strstr(buf2+strlen(keyword),buf1)!=NULL) {
	    strcpy(buf1,strstr(buf2+strlen(keyword),buf1));
	    set_panel(item,buf1); 
	  }
	}
	if (strcmp(keyword,"Foreach_Loop")==0) {
	  create_foreach_module();
	  if (stack_module==NULL) {
	    stack_module=(Stack *)malloc(sizeof(Stack));
	    stack_module->previous=NULL;
	  } else {
	    old_module=stack_module;
	    stack_module=(Stack *)malloc(sizeof(Stack));
	    stack_module->previous=old_module;
	  }
	  stack_module->module=current_module;

	  sscanf(buf1,"%s %s",keyword,buf2);
	  strcpy(buf2,strstr(buf1+strlen(keyword),buf2));
	  sscanf(buf2,"%s %s",keyword,buf1);
	  XtVaSetValues(current_module->text_variable,
			XmNvalue,buf1,
			NULL);
	  if (strstr(buf2+strlen(buf1),"in")!=NULL) {
	    strcpy(buf1,strstr(buf2+strlen(buf1),"in")+3);
	    strcpy(strstr(buf1,";do"),"");
	    XtVaSetValues(current_module->text_list,
			  XmNvalue,buf1,
			  NULL);
	  }
	}
	
	if (strcmp(keyword,"End_Loop")==0) {
	  create_end_module();

	  tmp_module=stack_module->module;
	  old_module=stack_module->previous;
	  free(stack_module);
	  stack_module=old_module;
	  tmp_module->link=end_module;
	  current_module->link=NULL;
	}

	if (strcmp(keyword,"If_Then")==0) {
	  create_ifthen_module();

	  strcpy(buf2,strstr(buf1,"test ")+5);
	  strcpy(strrchr(buf2,')'),"");
	  XtVaSetValues(current_module->text_variable,
			XmNvalue,buf2,
			NULL);

	  if (stack_module==NULL) {
	    stack_module=(Stack *)malloc(sizeof(Stack));
	    stack_module->previous=NULL;
	  } else {
	    old_module=stack_module;
	    stack_module=(Stack *)malloc(sizeof(Stack));
	    stack_module->previous=old_module;
	  }
	  stack_module->module=current_module;
	}

	if (strcmp(keyword,"Else_If")==0)
	  create_elseif_module();

	if (strcmp(keyword,"End_If")==0) {
	  create_endif_module();

	  tmp_module=stack_module->module;
	  old_module=stack_module->previous;
	  free(stack_module);
	  stack_module=old_module;
	  tmp_module->link=end_module;
	  current_module->link=NULL;
	}

	while (current_module->next!=NULL)
	  current_module=current_module->next;
      }
    }
    error=fgets(buf1,1024,in);
  }
}

void save_flow(char *filename)
{
  FILE *out,*out_flow;
  Module *module;

  strcpy(buf1,filename);
  strcat(buf1,".script");
  out=fopen(buf1,"w");
  if (out==NULL) {
    fprintf(stderr,"Error openning out file %s\n",filename);
    return;
  }
  chmod(buf1,S_IRWXU|S_IRGRP|S_IXGRP|S_IROTH|S_IXOTH);

  out_flow=fopen(filename,"w");
  if (out_flow==NULL) {
    fprintf(stderr,"Error openning out file %s\n",filename);
    return;
  }
  

  fprintf(out,"#!/bin/sh \n\n");
  fprintf(out,"#\n#\n#   This script was build using the xsb interface.\n");
  fprintf(out,"#\n#\n\n\n");
 
  module=start_module;

  while (module!=NULL) {
				/* Output to script file. */
    fprintf(out,"%s",module->command);
    if (module->stdout_flag) {
      fprintf(out," | \\\n");
    } else {
      fprintf(out,"\n\n");
    }
				/* Output to flow file. */
    if (module->stdout_flag) {
      fprintf(out_flow,"PIPE\n");
    } else {
      fprintf(out_flow,"NO_PIPE\n");
    }
    fprintf(out_flow,"%s %s\n",module->name,module->command);
    module=module->next;
  }
  fclose(out_flow);
  fclose(out);
}    


void draw_moduleCB(Widget w,
		   XtPointer client_data,
		   XmDrawingAreaCallbackStruct *call_data)
{
  static int init=0;
  int x,y,width,height;

  XExposeEvent *expose=(XExposeEvent *)call_data->event;
  XGCValues values;
 
                                /* Get x, y, width, and height 
                                   of exposed area. */
  x=expose->x;
  y=expose->y;
  width=expose->width;
  height=expose->height;
  if (init) {
    draw_modules();
  } else { 
    init=1;
    current_width=WIDTH;
    current_height=HEIGHT;
    top=XtWindow(w);
    values.foreground = BlackPixel(display,DefaultScreen(display));
    values.background = WhitePixel(display,DefaultScreen(display));
    values.line_width=0;
    values.font=XLoadFont(display,"9x15");
    
				/* Create GC for the window. */
    gc = XCreateGC( display,top, 
		   GCForeground|GCBackground|GCLineWidth|GCFont,
		   &values );
    draw_modules();
  } 
}


void draw_modules()
{
  XFontStruct *font;
  XCharStruct overall;
  int direction,ascent,descent,width,height,x1,y1,bg;
  int x=0,y=0,count=0,x_tmp=0;
  int level_foreach=0,level_if=0;
  int start_foreach[MAX_NESTING],start_if[MAX_NESTING];
  Module *module;

  font=XQueryFont(display,XLoadFont(display,"9x15"));
/*  XSetFont(display,xdisplay[id].gc,XLoadFont(display,font_name));*/

  XClearArea(display,top,0,0,current_width,current_height,False);

  module=start_module;

  x=WIDTH/2;
  y=MODULE_HEIGHT*1.5;
  

  while (module!=NULL) {
    XTextExtents(font,module->name,strlen(module->name),
		 &direction,&ascent,&descent,&overall);

    if (module->stdout_flag) {
      XDrawLine(display,top,gc,
		x,y+MODULE_HEIGHT,
		x,y+MODULE_HEIGHT*2);
      XDrawLine(display,top,gc,
		x,y+MODULE_HEIGHT*2,
		x-3,y+MODULE_HEIGHT*2-7);
      XDrawLine(display,top,gc,
		x,y+MODULE_HEIGHT*2,
		x+3,y+MODULE_HEIGHT*2-7);
    }

    if (module==current_module)
      XFillArc(display,top,gc,10,y,8,8,0,23040);

    if (module->dialog!=NULL)
      if (XtIsManaged(module->dialog))
	XSetLineAttributes(display,gc,5,LineSolid,CapNotLast,JoinRound);
      else
	XSetLineAttributes(display,gc,0,LineSolid,CapNotLast,JoinRound);
    else
	XSetLineAttributes(display,gc,0,LineSolid,CapNotLast,JoinRound);
      
    XDrawRectangle(display,top,gc,
		   x-MODULE_WIDTH,y-MODULE_HEIGHT,
		   MODULE_WIDTH*2,MODULE_HEIGHT*2);
    XDrawString(display,top,gc,
		x-overall.width/2,y+(ascent+descent)/2,
                module->name,strlen(module->name));

				/* Draw loop. */
    if (strcmp(module->name,"Foreach_Loop")==0) {
      level_foreach++;
      start_foreach[level_foreach]=y;		
    }
    if (strcmp(module->name,"End_Loop")==0) {
      x_tmp=x+MODULE_WIDTH+5*(MAX_NESTING-level_foreach);
      XDrawLine(display,top,gc,
		x+MODULE_WIDTH,start_foreach[level_foreach],
		x_tmp,start_foreach[level_foreach]);
      XDrawLine(display,top,gc,
		x+MODULE_WIDTH,y,
		x_tmp,y);
      XDrawLine(display,top,gc,
		x_tmp,start_foreach[level_foreach],
		x_tmp,y);
      level_foreach--;
    }

    if (strcmp(module->name,"If_Then")==0) {
      level_if++;
      start_if[level_if]=y;		
    }
    if (strcmp(module->name,"End_If")==0) {
      x_tmp=x-MODULE_WIDTH+(-5*(MAX_NESTING-level_if));
      XDrawLine(display,top,gc,
		x-MODULE_WIDTH,start_if[level_if],
		x_tmp,start_if[level_if]);
      XDrawLine(display,top,gc,
		x-MODULE_WIDTH,y,
		x_tmp,y);
      XDrawLine(display,top,gc,
		x_tmp,start_if[level_if],
		x_tmp,y);
      level_if--;
    }
    if (strcmp(module->name,"Else_If")==0) {
      XDrawLine(display,top,gc,
		x-MODULE_WIDTH,y,
		x-MODULE_WIDTH+(-5*(MAX_NESTING-level_if)),y);
    }

    y+=MODULE_HEIGHT*3;
    if (y>current_height) {
      current_height+=HEIGHT;
      XtVaSetValues(draw_area,
		    XmNheight,current_height,
		    NULL);
    }

    XSetLineAttributes(display,gc,0,LineSolid,CapNotLast,JoinRound);
    module=module->next;
    count++;
  }
  
}

void pipe_dialog(int module_number)
{
  int count=0,stdin_flag=0;
  Module *module;

  module=start_module;

  while ((module!=NULL)&&(count<module_number)) {
    stdin_flag=module->stdout_flag;
    module=module->next;
    count++;
  }
  if (module==NULL)
    return;

  if (module->item!=NULL) {
    if ((module->next!=NULL)&&(module->next->item!=NULL)) {
      if (module->stdout_flag) {
	module->stdout_flag=0;
      } else {
	module->stdout_flag=1;
      }
      reset_filerbox(module->item,stdin_flag,module->stdout_flag);
    }

    if (module->next!=NULL) {
      stdin_flag=module->stdout_flag;
      module=module->next;
      if (module->item!=NULL)
	reset_filerbox(module->item,stdin_flag,module->stdout_flag);
    }
    
    draw_modules();
  }
}

void manage_dialog(int module_number)
{
  int count=0;
  Module *module;
  Dimension max_width,max_height,border;
  Dimension width,height;
  Position x,y;
  Screen *screen_struct;
  screen_struct=DefaultScreenOfDisplay(display);

  module=start_module;

  while ((module!=NULL)&&(count<module_number)) {
    module=module->next;
    count++;
  }
  if (module==NULL) {
    return;
  }
/*
   this code makes sure that the actual values of the command in the
   module structure are displayed.
					- Joe M. Wade 5/02/95

   commented this back out since it caused the defaults to get used 
   on dialogs pertaining to saved nets rather than the previously
   saved values. hopefully this doesn't break anything else...
					- Joe M. Wade 7/26/95
  if (module->command != NULL)
    set_panel(module->item,strchr(module->command,' '));
*/
/*
   added code here to make sure the dialog is smaller than the screen size
					- Joe M. Wade 3/29/95 
*/
  if (module->dialog!=NULL) {
    XtManageChild(module->dialog);
    max_width = WidthOfScreen(screen_struct) - 50;
    max_height = HeightOfScreen(screen_struct) - 50;
    XtVaGetValues(module->dialog,
		XmNx, &x,
		XmNy, &y,
		XmNwidth, &width,
		XmNheight, &height,
		XmNborderWidth, &border,
		NULL);
    if (width > max_width) width = max_width;
    if (height > max_height) height = max_height;
    if (width == max_width || height == max_height) {
      XtUnmanageChild(module->dialog);
      XtResizeWidget(module->dialog,width,height,border);
      XtManageChild(module->dialog);
      }
    }
}

void set_current_module(int module_number)
{
  int count=0;
  Module *module;

  module=start_module;

  while ((module!=NULL)&&(count<module_number)) {
    module=module->next;
    count++;
  }
  current_module=module;
}

void unmanage_dialog()
{
}

