/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "ikp_global.h"
#include "Panel.h"
#include "ikp_globalE.h"
#include <cu_defs.h>

#define USAGE "\nUsage: %s [-l library] [flow] -V -help \n"

#define VERSION  0.01           /* Version number. */

extern void ikp_lib_read(char *);
extern void parse_command(char *);

static XtAppContext app_context;
static int screen;
static char buf1[1024],buf2[1024];

int verbose=0;

int main(int argc,char **argv)
{
  char *command,*lib_file;

  if (C_ARGIS("-help", &argc, argv) || C_ARGIS("-?", &argc, argv)) {
    fprintf(stderr, USAGE, argv[0]);
    exit(1);
  }

  lib_file=C_ARGSTR("-l",NULL,"","",&argc,argv);
  while (strlen(lib_file)>0)  {
    ikp_lib_read(lib_file);
    free(lib_file);
    lib_file=C_ARGSTR("-l",NULL,"","",&argc,argv);
  }
 
  verbose=C_ARGIS("-V",&argc,argv);

  xui_trace_flag_internal = C_ARGIS("-trace",&argc,argv);

/*  command=get_arg("-cmd","",&argc,argv); */
  if (argc==1) {
    command=strdup("");
  } else {
    if (argc==2) {
      command=strdup(argv[1]);
    } else {
      fprintf(stderr,USAGE,argv[0]);
      exit(1);
    }
  }

  if (verbose) {
    fprintf(stderr,"\n");
    fprintf(stderr,"Version %1.2f\n",VERSION);
  }
 
  top_level=XtAppInitialize(&app_context,"Xsb",NULL,0,
                            &argc,argv,app_defs,NULL,0);


  display=XtDisplay(top_level);
  screen=XDefaultScreen(display);

  parse_command(command);

  XtRealizeWidget(top_level);
 
  XtAppMainLoop(app_context);
 
  return 0;
}

int yyerror()
{
  return(1);
}

int yywrap()
{
  return(1);
}


