/* 
	NOTE! NOTE! NOTE!
	Do not save widgets and just remap because the name supplied in the arg
	list is a resource name which is used for associating resources from
	the app-defaults file with the widget at creation time.  Hence, any
	attempts to get the associated string for a *.somethime.messageString
	resource so that the messageString (and possibly other resources) may
	be assigned to the widget are (completely?) impossible using the given
	Motif function set.

	Also note that a resource list cannot be modified or read after passing
	it to XtGetApplicationResources since the intrinsics compile the
	resource list into an efficient internal form!
*/
/*
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
 */
/*
 * Motif Release 1.2
 */
/*
	Added object persistence (Bob Mars).
*/

#include <Xm/Xm.h>
#include <Xm/DialogS.h>
#include <Xm/MessageB.h>
#include <Xm/SelectioB.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/FileSB.h>
#include <Xm/Form.h>

#include <X11/cursorfont.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>	/* free */
#include <ctype.h>	/* toupper */

#include "Dialog.h"
#include "Xgoodies.h"
#include "stringutils.h"

#define Offset(field)	XtOffsetOf( ApplicationData, field )

typedef struct  {
        String	messageString;
} ApplicationData;

static ApplicationData	app_data;

static XtResource       resources[] = {
				{
				XmNmessageString,
/*				XmCMessageString, */
				"MessageString",
/*				XmCString, */
				XmRString, sizeof( String ),
				Offset( messageString ),
				XmRString, (XtPointer)"No message"
				},
			};

void dialogSetVisualDepthColormap( Widget, Visual*, int, Colormap, Arg*, int* );
void response(Widget, XtPointer, XtPointer);
void save_response(Widget, XtPointer, XtPointer);
void working_timer_activate(XtPointer, XtIntervalId*);
int Question(Widget, char*, int, unsigned char);
int Information(Widget, char*, int, unsigned char);
int Error(Widget, char*, int, unsigned char);
int Selection(Widget, char*, int, unsigned char);
int Warning(Widget, char*, int, unsigned char);
int SaveWarning(Widget, char*, int, unsigned char);
int Working(Widget, char*, int, unsigned char);
int PromptDialog(Widget, char*, int, unsigned char);
int FileSelectionDialog(Widget, char*, int, unsigned char, String*);

static String	selection_string = NULL;


void dialogSetVisualDepthColormap( Widget widget, Visual *aVisual, int aDepth,
	Colormap aColormap, Arg *args, int *n )
{
	static Visual	*visual = NULL;
	static int	depth = 0;
	static Colormap	colormap = NULL;

	Display	*display;
	int	screenNum;

	if( !visual || !colormap || depth == 0
	|| aVisual || aColormap || aDepth != 0 )
	{
		display = XtDisplay( widget );
		screenNum = DefaultScreen( display );

		if( aVisual )
			visual = aVisual;
		else if( !visual )
			visual = DefaultVisual( display, screenNum );

		if( aDepth != 0 )
			depth = aDepth;
		else if( depth == 0 )
			depth = DefaultDepth( display, screenNum );

		if( aColormap )
			colormap = aColormap;
		else if( !colormap )
			colormap = DefaultColormap( display, screenNum );
	}

	if( args )
	{
		XtSetArg (args[*n], XmNvisual, visual); ++*n;
		XtSetArg (args[*n], XmNdepth, depth ); ++*n;
		XtSetArg (args[*n], XmNcolormap, colormap); ++*n;
	}
}

/* Handles responses to a message dialog */

/* ARGSUSED */
void response (Widget widget, XtPointer client_data, XtPointer call_data)
{
  int *answer = (int *) client_data;
  XmAnyCallbackStruct *reason = (XmAnyCallbackStruct *) call_data;

  switch (reason->reason) {
  case XmCR_OK:
    *answer = RET_OK;
/*  (void)XmStringGetLtoR(
	(XmString)((XmFileSelectionBoxCallbackStruct*)call_data)->value,
	XmSTRING_DEFAULT_CHARSET, (char **)&selection_string );
RJM: CAN'T DO SAFELY AS MAY NOT BE A XmFileSelectionBoxCallbackStruct */
    break;
  case XmCR_CANCEL:
    *answer = RET_CANCEL;
    break;
  case XmCR_HELP:
    *answer = RET_HELP;
    break;
  default:
    return;
  }
}

/* Handles responses to a saving changes dialog */

/* ARGSUSED */
void save_response (Widget widget, XtPointer client_data, XtPointer call_data)
{
  int *answer = (int *) client_data;
  XmAnyCallbackStruct *reason = (XmAnyCallbackStruct *) call_data;
  switch (reason->reason) {
  case XmCR_OK:
    *answer = RET_SAVE;
    break;
  case XmCR_APPLY:
    *answer = RET_DISCARD;
    break;
  case XmCR_CANCEL:
    *answer = RET_CANCEL;
    break;
  case XmCR_HELP:
    *answer = RET_HELP;
    break;
  default:
    return;
  }
}


/* Timeout callback */

/* ARGSUSED */
void working_timer_activate (XtPointer client_data, XtIntervalId *id)
{
  int *answer = (int *) client_data;

  *answer = RET_DONE;
  return;
}


/* Posts a Question dialog */

int Question (Widget widget, char *name, int buttons, unsigned char defbut)
/*
Widget          widget;		* needed for context *
char           *name;           * name of widget *
int 		buttons;	* RET_OK | RET_CANCEL | RET_HELP *
unsigned char	defbut;		* for XmdefaultButtonType *
*/
{
  static Widget        	dialog = NULL;	
  static int            answer;
  Arg             	args[10];
  int             	n = 0;
  XtAppContext    	context;
  String		tmp1, tmp2;

if( dialog ) { XtDestroyWidget( dialog ); dialog = NULL; } /* SEE TOP NOTE!!! */
  n = 0;
  XtSetArg (args[n], XmNallowShellResize, True); n++;
  XtSetArg (args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;
  XtSetArg (args[n], XmNdefaultButtonType, defbut); n++;
  if( dialog ) {
/*  XtSetArg (args[n], XmNmessageString, XMstr(name)); n++; THIS NAME IS THE RESOURCE NAME, NOT MSG STRING */
/*  resources[0].resource_name = tmp1 = concat( name, ".messageString", NULL );
*/
    resources[0].resource_name = tmp1 = strdup( name );
    resources[0].resource_class = tmp2 = strdup( resources[0].resource_name );
    resources[0].resource_class[0] = toupper( (int)resources[0].resource_class[0] );
    {
/* comment this section out since references toplevel 
    extern Widget           toplevel;
    XtGetApplicationResources( toplevel, (XtPointer)&app_data, resources,
			XtNumber( resources ), (Arg*)NULL, (Cardinal)0 );
*/
    }

/*  resource list is corrupted by internal intrinsics compilation of list */
    free( tmp1 );
    free( tmp2 );

    XtSetArg (args[n], XmNmessageString, XMstr( app_data.messageString) ); n++;
    XtSetValues( dialog, args, n );
    XtManageChild (XmMessageBoxGetChild (dialog, XmDIALOG_OK_BUTTON));
    XtManageChild (XmMessageBoxGetChild (dialog,XmDIALOG_CANCEL_BUTTON));
    XtManageChild (XmMessageBoxGetChild (dialog,XmDIALOG_HELP_BUTTON));
  } else {
dialogSetVisualDepthColormap( widget, (Visual*)NULL, (int)NULL, (Colormap)NULL, args, &n );
    dialog = XmCreateQuestionDialog (widget, name, args, n);
  
    XtAddCallback (dialog, XmNokCallback, response, &answer);
    XtAddCallback (dialog, XmNcancelCallback, response, &answer);
    XtAddCallback (dialog, XmNhelpCallback, response, &answer);
  }
  
  if ( !(RET_OK & buttons) )
    XtUnmanageChild (XmMessageBoxGetChild (dialog, XmDIALOG_OK_BUTTON));
  if ( !(RET_CANCEL & buttons) )
    XtUnmanageChild (XmMessageBoxGetChild (dialog,XmDIALOG_CANCEL_BUTTON));
  if ( !(RET_HELP & buttons) )
    XtUnmanageChild (XmMessageBoxGetChild (dialog,XmDIALOG_HELP_BUTTON));
  
  XtManageChild (dialog);
  
  answer = RET_NONE;
  context = XtWidgetToApplicationContext (widget);
  while ( answer == RET_NONE || XtAppPending (context) ) {
    XtAppProcessEvent (context, XtIMAll);
  }

  XtUnmanageChild (dialog);
  return answer;
}


/* Posts a Information dialog */

int Information(Widget widget, char *name, int buttons, unsigned char defbut)
{
  static Widget        	dialog = NULL;	
  static int            answer; /* must be static since address gets passed to
				response callback only during creation */
  Arg             	args[10];
  int             	n = 0;
  XtAppContext    	context;

if( dialog ) { XtDestroyWidget( dialog ); dialog = NULL; } /* SEE TOP NOTE!!! */
  n = 0;
  XtSetArg (args[n], XmNallowShellResize, True); n++;
  XtSetArg (args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;
  XtSetArg (args[n], XmNdefaultButtonType, defbut); n++;
  if( dialog ) {
/*  XtSetArg (args[n], XmNmessageString, XMstr(name)); n++; THIS NAME IS THE RESOURCE NAME, NOT MSG STRING */
    XtSetValues( dialog, args, n );
    XtManageChild (XmMessageBoxGetChild (dialog, XmDIALOG_OK_BUTTON));
    XtManageChild (XmMessageBoxGetChild (dialog,XmDIALOG_CANCEL_BUTTON));
    XtManageChild (XmMessageBoxGetChild (dialog,XmDIALOG_HELP_BUTTON));
  } else {
dialogSetVisualDepthColormap( widget, (Visual*)NULL, (int)NULL, (Colormap)NULL, args, &n );
    dialog = XmCreateInformationDialog (widget, name, args, n);
  
    XtAddCallback (dialog, XmNokCallback, response, &answer);
    XtAddCallback (dialog, XmNcancelCallback, response, &answer);
    XtAddCallback (dialog, XmNhelpCallback, response, &answer);
  }
  
  if ( !(RET_OK & buttons) )
    XtUnmanageChild (XmMessageBoxGetChild (dialog, XmDIALOG_OK_BUTTON));
  if ( !(RET_CANCEL & buttons) )
    XtUnmanageChild (XmMessageBoxGetChild (dialog,XmDIALOG_CANCEL_BUTTON));
  if ( !(RET_HELP & buttons) )
    XtUnmanageChild (XmMessageBoxGetChild (dialog,XmDIALOG_HELP_BUTTON));
  
  XtManageChild (dialog);
  
  answer = RET_NONE;
  context = XtWidgetToApplicationContext (widget);
  while ( answer == RET_NONE || XtAppPending (context) )
    XtAppProcessEvent (context, XtIMAll);

  XtUnmanageChild (dialog);
  return answer;
}


/* Posts an error dialog */

int Error(Widget widget, char *name, int buttons, unsigned char defbut)
{
  static Widget        	dialog = NULL;	
  static int            answer; /* must be static since address gets passed to
				response callback only during creation */
  Arg             	args[10];
  int             	n = 0;
  XtAppContext    	context;

if( dialog ) { XtDestroyWidget( dialog ); dialog = NULL; } /* SEE TOP NOTE!!! */
  n = 0;
  XtSetArg (args[n], XmNallowShellResize, True); n++;
  XtSetArg (args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;
  XtSetArg (args[n], XmNdefaultButtonType, defbut); n++;
  if( dialog ) {
/*  XtSetArg (args[n], XmNmessageString, XMstr(name)); n++; THIS NAME IS THE RESOURCE NAME, NOT MSG STRING */
    XtSetValues( dialog, args, n );
    XtManageChild (XmMessageBoxGetChild (dialog, XmDIALOG_OK_BUTTON));
    XtManageChild (XmMessageBoxGetChild (dialog,XmDIALOG_CANCEL_BUTTON));
    XtManageChild (XmMessageBoxGetChild (dialog,XmDIALOG_HELP_BUTTON));
  } else {
dialogSetVisualDepthColormap( widget, (Visual*)NULL, (int)NULL, (Colormap)NULL, args, &n );
    dialog = XmCreateErrorDialog (widget, name, args, n);
  
    XtAddCallback (dialog, XmNokCallback, response, &answer);
    XtAddCallback (dialog, XmNcancelCallback, response, &answer);
    XtAddCallback (dialog, XmNhelpCallback, response, &answer);
  }
  
  if ( !(RET_OK & buttons) )
    XtUnmanageChild (XmMessageBoxGetChild (dialog, XmDIALOG_OK_BUTTON));
  if ( !(RET_CANCEL & buttons) )
    XtUnmanageChild (XmMessageBoxGetChild (dialog,XmDIALOG_CANCEL_BUTTON));
  if ( !(RET_HELP & buttons) )
    XtUnmanageChild (XmMessageBoxGetChild (dialog,XmDIALOG_HELP_BUTTON));
  
  XtManageChild (dialog);
  
  answer = RET_NONE;
  context = XtWidgetToApplicationContext (widget);
  while ( answer == RET_NONE || XtAppPending (context) ) {
    XtAppProcessEvent (context, XtIMAll);
  }

  XtUnmanageChild (dialog);
  return answer;
}


/* Posts a selection dialog */

/*ARGSUSED*/
int Selection(Widget widget, char *name, int buttons, unsigned char defbut)
{
  static Widget        	dialog = NULL;	
  static int            answer; /* must be static since address gets passed to
				response callback only during creation */
  Arg                   args[10];
  int                   n = 0;
  XtAppContext          context;

if( dialog ) { XtDestroyWidget( dialog ); dialog = NULL; } /* SEE TOP NOTE!!! */
  n = 0;
  XtSetArg (args[n], XmNallowShellResize, True); n++;
  XtSetArg (args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;
  XtSetArg (args[n], XmNdefaultButtonType, defbut); n++;
  if( dialog ) {
/*  XtSetArg (args[n], XmNmessageString, XMstr(name)); n++; THIS NAME IS THE RESOURCE NAME, NOT MSG STRING */
    XtSetValues( dialog, args, n );
    XtManageChild (XmSelectionBoxGetChild (dialog, XmDIALOG_OK_BUTTON));
    XtManageChild (XmSelectionBoxGetChild (dialog,XmDIALOG_CANCEL_BUTTON));
    XtManageChild (XmSelectionBoxGetChild (dialog,XmDIALOG_APPLY_BUTTON));
    XtManageChild (XmSelectionBoxGetChild (dialog,XmDIALOG_HELP_BUTTON));
  } else {
dialogSetVisualDepthColormap( widget, (Visual*)NULL, (int)NULL, (Colormap)NULL, args, &n );
    dialog = XmCreateSelectionDialog(widget, name, args, n);

    XtAddCallback (dialog, XmNokCallback, response, &answer);
    XtAddCallback (dialog, XmNcancelCallback, response, &answer);
    XtAddCallback (dialog, XmNhelpCallback, response, &answer);
  }

  if ( !(RET_OK & buttons) )
    XtUnmanageChild (XmSelectionBoxGetChild (dialog, XmDIALOG_OK_BUTTON));
  if ( !(RET_CANCEL & buttons) )
    XtUnmanageChild (XmSelectionBoxGetChild (dialog,XmDIALOG_CANCEL_BUTTON));
  if ( !(RET_APPLY & buttons) )
    XtUnmanageChild (XmSelectionBoxGetChild (dialog,XmDIALOG_APPLY_BUTTON));
  if ( !(RET_HELP & buttons) )
    XtUnmanageChild (XmSelectionBoxGetChild (dialog,XmDIALOG_HELP_BUTTON));

  XtManageChild (dialog);

  answer = RET_NONE;
  context = XtWidgetToApplicationContext (widget);
  while ( answer == RET_NONE || XtAppPending (context) ) {
    XtAppProcessEvent (context, XtIMAll);
  }

  XtUnmanageChild (dialog);
  return answer;
}


/* Posts a warning dialog */

int Warning(Widget widget, char *name, int buttons, unsigned char defbut)
{
  static Widget        	dialog = NULL;	
  static int            answer; /* must be static since address gets passed to
				response callback only during creation */
  Arg             	args[10];
  int             	n = 0;
  XtAppContext    	context;

if( dialog ) { XtDestroyWidget( dialog ); dialog = NULL; } /* SEE TOP NOTE!!! */
  n = 0;
  XtSetArg (args[n], XmNallowShellResize, True); n++;
  XtSetArg (args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;
  XtSetArg (args[n], XmNdefaultButtonType, defbut); n++;
  if( dialog ) {
/*  XtSetArg (args[n], XmNmessageString, XMstr(name)); n++; THIS NAME IS THE RESOURCE NAME, NOT MSG STRING */
    XtSetValues( dialog, args, n );
    XtManageChild (XmMessageBoxGetChild (dialog, XmDIALOG_OK_BUTTON));
    XtManageChild (XmMessageBoxGetChild (dialog,XmDIALOG_CANCEL_BUTTON));
    XtManageChild (XmMessageBoxGetChild (dialog,XmDIALOG_HELP_BUTTON));
  } else {
dialogSetVisualDepthColormap( widget, (Visual*)NULL, (int)NULL, (Colormap)NULL, args, &n );
    dialog = XmCreateWarningDialog (widget, name, args, n);
  
    XtAddCallback (dialog, XmNokCallback, response, &answer);
    XtAddCallback (dialog, XmNcancelCallback, response, &answer);
    XtAddCallback (dialog, XmNhelpCallback, response, &answer);
  }
  
  if ( !(RET_OK & buttons) )
    XtUnmanageChild (XmMessageBoxGetChild (dialog, XmDIALOG_OK_BUTTON));
  if ( !(RET_CANCEL & buttons) )
    XtUnmanageChild (XmMessageBoxGetChild (dialog,XmDIALOG_CANCEL_BUTTON));
  if ( !(RET_HELP & buttons) )
    XtUnmanageChild (XmMessageBoxGetChild (dialog,XmDIALOG_HELP_BUTTON));
  
  XtManageChild (dialog);
  
  answer = RET_NONE;
  context = XtWidgetToApplicationContext (widget);
  while ( answer == RET_NONE || XtAppPending (context) ) {
    XtAppProcessEvent (context, XtIMAll);
  }

  XtUnmanageChild (dialog);
  return answer;
}


/* Posts a warning dialog */

/* ARGSUSED */
int SaveWarning(Widget widget, char *name, int buttons, unsigned char defbut)
{
  static Widget        	dialog = NULL;	
  static int            answer; /* must be static since address gets passed to
				response callback only during creation */
  Widget          	discard_button ;
  Arg             	args[10];
  int             	n = 0;
  XtAppContext    	context;

if( dialog ) { XtDestroyWidget( dialog ); dialog = NULL; } /* SEE TOP NOTE!!! */
  n = 0;
  XtSetArg (args[n], XmNallowShellResize, True); n++;
  XtSetArg (args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;
  XtSetArg (args[n], XmNdefaultButtonType, defbut); n++;
  if( dialog ) {
/*  XtSetArg (args[n], XmNmessageString, XMstr(name)); n++; THIS NAME IS THE RESOURCE NAME, NOT MSG STRING */
    XtSetValues( dialog, args, n );
    XtManageChild (XmMessageBoxGetChild (dialog, XmDIALOG_OK_BUTTON));
    XtManageChild (XmMessageBoxGetChild (dialog,XmDIALOG_CANCEL_BUTTON));
    XtManageChild (XmMessageBoxGetChild (dialog,XmDIALOG_HELP_BUTTON));
  } else {
dialogSetVisualDepthColormap( widget, (Visual*)NULL, (int)NULL, (Colormap)NULL, args, &n );
    dialog = XmCreateWarningDialog (widget, name, args, n);
  
    XtAddCallback (dialog, XmNokCallback, save_response, &answer);
    XtAddCallback (dialog, XmNcancelCallback, save_response, &answer);
    XtAddCallback (dialog, XmNhelpCallback, save_response, &answer);

    n = 0;
    discard_button = XmCreatePushButton (dialog, "discard_button", args, n);
    XtManageChild (discard_button);
  }

  if ( !(RET_OK & buttons) )
    XtUnmanageChild (XmMessageBoxGetChild (dialog, XmDIALOG_OK_BUTTON));
  if ( !(RET_CANCEL & buttons) )
    XtUnmanageChild (XmMessageBoxGetChild (dialog,XmDIALOG_CANCEL_BUTTON));
  if ( !(RET_HELP & buttons) )
    XtUnmanageChild (XmMessageBoxGetChild (dialog,XmDIALOG_HELP_BUTTON));
  
  XtManageChild (dialog);
  
  answer = RET_NONE;
  context = XtWidgetToApplicationContext (widget);
  while ( answer == RET_NONE || XtAppPending (context) ) {
    XtAppProcessEvent (context, XtIMAll);
  }

  XtUnmanageChild (dialog);
  return answer;
}


/* Posts a working dialog and sets a timer */

int Working(Widget widget, char *name, int buttons, unsigned char defbut)
{
  static int            answer; /* must be static since address gets passed to
				response callback only during creation */
  static Widget        	dialog = NULL;	
  Arg             	args[5];
  int             	n = 0;
  XtAppContext    	context;
  Cursor		cursor;
  Pixmap		hour_pixmap, hourm_pixmap;
  Pixel			bg, fg;
  XColor		backg, foreg;

#define hour_x_hot 7
#define hour_y_hot 7
#define hour_width 16
#define hour_height 16
  static unsigned char hour_bits[] = {
    0x00, 0x00, 0xfe, 0x7f, 0x14, 0x28, 0x14, 0x28, 0x14, 0x28, 0x24, 0x24,
    0x44, 0x22, 0x84, 0x21, 0x84, 0x21, 0x44, 0x22, 0x24, 0x24, 0x14, 0x28,
    0x94, 0x29, 0xd4, 0x2b, 0xfe, 0x7f, 0x00, 0x00};
#define hourm_width 16
#define hourm_height 16
  static unsigned char hourm_bits[] = {
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x7f, 0xfe, 0x7f, 0xfe, 0x7f, 0xfe, 0x7f,
    0xfe, 0x7f, 0xfe, 0x7f, 0xfe, 0x7f, 0xfe, 0x7f, 0xfe, 0x7f, 0xfe, 0x7f,
    0xfe, 0x7f, 0xfe, 0x7f, 0xff, 0xff, 0xff, 0xff};

  n = 0;
  XtSetArg (args[n], XmNforeground, &fg); n++;
  XtSetArg (args[n], XmNbackground, &bg); n++;
  XtGetValues (widget, args, n);

  hour_pixmap =  (Pixmap) XCreatePixmapFromBitmapData
    (XtDisplay(widget),
     DefaultRootWindow(XtDisplay(widget)),
     (char *)hour_bits,
     hour_width,
     hour_height,
     (unsigned long)0,
     (unsigned long)1,
     (unsigned int)1);
  
  hourm_pixmap = (Pixmap)XCreatePixmapFromBitmapData
    (XtDisplay(widget),
     DefaultRootWindow(XtDisplay(widget)),
     (char *)hourm_bits,
     hourm_width,
     hourm_height,
     (unsigned long)1,
     (unsigned long)0,
     (unsigned int)1);
  
  backg.pixel = WhitePixelOfScreen (XtScreen(widget));
  foreg.pixel = BlackPixelOfScreen (XtScreen(widget));
  
  XQueryColor (XtDisplay(widget), DefaultColormapOfScreen (XtScreen(widget)),
	       &backg);
  XQueryColor (XtDisplay(widget), DefaultColormapOfScreen (XtScreen(widget)),
	       &foreg);

  cursor = XCreatePixmapCursor (XtDisplay(widget), hour_pixmap, hourm_pixmap,
				&backg, &foreg,	hour_x_hot, hour_y_hot);

  n = 0;
  XtSetArg (args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;
  XtSetArg (args[n], XmNdefaultButtonType, defbut); n++;
dialogSetVisualDepthColormap( widget, (Visual*)NULL, (int)NULL, (Colormap)NULL, args, &n );
  dialog = XmCreateWorkingDialog (widget, name, args, n);
  
  XtAddCallback (dialog, XmNokCallback, response, &answer);
  XtAddCallback (dialog, XmNcancelCallback, response, &answer);
  XtAddCallback (dialog, XmNhelpCallback, response, &answer);

  if ( !(RET_OK & buttons) )
    XtUnmanageChild (XmMessageBoxGetChild (dialog, XmDIALOG_OK_BUTTON));
  if ( !(RET_CANCEL & buttons) )
    XtUnmanageChild (XmMessageBoxGetChild (dialog,XmDIALOG_CANCEL_BUTTON));
  if ( !(RET_HELP & buttons) )
    XtUnmanageChild (XmMessageBoxGetChild (dialog,XmDIALOG_HELP_BUTTON));

  context = XtWidgetToApplicationContext (widget);

  XtAppAddTimeOut (context, WORKING_TIME, working_timer_activate, &answer);
  
  XtManageChild (dialog);
  XDefineCursor (XtDisplay (dialog), XtWindow (dialog), cursor);
  
  answer = RET_NONE;
  while ( answer == RET_NONE || answer == RET_OK || XtAppPending (context) ) {
    XtAppProcessEvent (context, XtIMAll);
  }

  XtUnmanageChild (dialog);
  XFreeCursor (XtDisplay (widget), cursor);
  XtDestroyWidget( dialog );
  return answer;
}



/* Posts a TextField in a message box with buttons labeled OK, Cancel and Help*/

int PromptDialog(Widget widget, char *name, int buttons, unsigned char defbut)
{
  static Widget        	dialog = NULL;	
  static int            answer; /* must be static since address gets passed to
				response callback only during creation */
  Arg             	args[10];
  int             	n = 0;
  XtAppContext    	context;

if( dialog ) { XtDestroyWidget( dialog ); dialog = NULL; } /* SEE TOP NOTE!!! */
  n = 0;
  XtSetArg (args[n], XmNallowShellResize, True); n++;
  XtSetArg (args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;
  XtSetArg (args[n], XmNdefaultButtonType, defbut); n++;
  if( dialog ) {
/*  XtSetArg (args[n], XmNmessageString, XMstr(name)); n++; THIS NAME IS THE RESOURCE NAME, NOT MSG STRING */
    XtSetValues( dialog, args, n );
    XtManageChild (XmMessageBoxGetChild (dialog, XmDIALOG_OK_BUTTON));
    XtManageChild (XmMessageBoxGetChild (dialog,XmDIALOG_CANCEL_BUTTON));
    XtManageChild (XmMessageBoxGetChild (dialog,XmDIALOG_HELP_BUTTON));
  } else {
dialogSetVisualDepthColormap( widget, (Visual*)NULL, (int)NULL, (Colormap)NULL, args, &n );
    dialog = XmCreatePromptDialog (widget, name, args, n);
  
    XtAddCallback (dialog, XmNokCallback, response, &answer);
    XtAddCallback (dialog, XmNcancelCallback, response, &answer);
    XtAddCallback (dialog, XmNhelpCallback, response, &answer);
  }
  
  if ( !(RET_OK & buttons) )
    XtUnmanageChild (XmMessageBoxGetChild (dialog, XmDIALOG_OK_BUTTON));
  if ( !(RET_CANCEL & buttons) )
    XtUnmanageChild (XmMessageBoxGetChild (dialog,XmDIALOG_CANCEL_BUTTON));
  if ( !(RET_HELP & buttons) )
    XtUnmanageChild (XmMessageBoxGetChild (dialog,XmDIALOG_HELP_BUTTON));
  
  XtManageChild (dialog);
  
  answer = RET_NONE;
  context = XtWidgetToApplicationContext (widget);
  while ( answer == RET_NONE || XtAppPending (context) ) {
    XtAppProcessEvent (context, XtIMAll);
  }

  XtUnmanageChild (dialog);

  return answer;
}


/* Posts a File Selection Dialog */

int FileSelectionDialog(Widget widget, char *name, int buttons, unsigned char defbut,
			String *selection)
{
  static Widget        	dialog = NULL;	
  static int            answer; /* must be static since address gets passed to
				response callback only during creation */
  Arg             	args[10];
  int             	n = 0;
  XtAppContext    	context;

if( dialog ) { XtDestroyWidget( dialog ); dialog = NULL; } /* SEE TOP NOTE!!! */
  n = 0;
  XtSetArg (args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;
/*XtSetArg (args[n], XmNdialogStyle, XmDIALOG_MODELESS); n++; */
  XtSetArg (args[n], XmNdefaultButtonType, defbut); n++;
  if( dialog ) {
/*  XtSetArg (args[n], XmNmessageString, XMstr(name)); n++; THIS NAME IS THE RESOURCE NAME, NOT MSG STRING */
    XtSetValues( dialog, args, n );
    XtManageChild (XmFileSelectionBoxGetChild (dialog, XmDIALOG_OK_BUTTON));
    XtManageChild (XmFileSelectionBoxGetChild (dialog,XmDIALOG_CANCEL_BUTTON));
    XtManageChild (XmFileSelectionBoxGetChild (dialog,XmDIALOG_APPLY_BUTTON));
    XtManageChild (XmFileSelectionBoxGetChild (dialog,XmDIALOG_HELP_BUTTON));
  } else {
dialogSetVisualDepthColormap( widget, (Visual*)NULL, (int)NULL, (Colormap)NULL, args, &n );
    dialog = XmCreateFileSelectionDialog (widget, name, args, n);
  
    XtAddCallback (dialog, XmNokCallback, response, &answer);
    XtAddCallback (dialog, XmNcancelCallback, response, &answer);
    XtAddCallback (dialog, XmNhelpCallback, response, &answer);
  }
  
  if ( !(RET_OK & buttons) )
    XtUnmanageChild (XmFileSelectionBoxGetChild (dialog, XmDIALOG_OK_BUTTON));
  if ( !(RET_CANCEL & buttons) )
    XtUnmanageChild (XmFileSelectionBoxGetChild(dialog,XmDIALOG_CANCEL_BUTTON));
  if ( !(RET_APPLY & buttons) )
    XtUnmanageChild (XmFileSelectionBoxGetChild (dialog,XmDIALOG_APPLY_BUTTON));
  if ( !(RET_HELP & buttons) )
    XtUnmanageChild (XmFileSelectionBoxGetChild (dialog,XmDIALOG_HELP_BUTTON));
  
  XtManageChild (dialog);
  
  answer = RET_NONE;
  context = XtWidgetToApplicationContext (widget);
  while ( answer == RET_NONE || XtAppPending (context) ) {
    XtAppProcessEvent (context, XtIMAll);
  }

  if( selection_string )
     *selection = strdup( selection_string );
  else
     *selection = "";

  XtUnmanageChild (dialog);

  return answer;
}
