/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
 * Digital Line Drawing
 * by Paul Heckbert
 * from "Graphics Gems", Academic Press, 1990
 */

/*
 * digline: draw digital line from (x1,y1) to (x2,y2),
 * calling a user-supplied procedure at each pixel.
 * Does no clipping.  Uses Bresenham's algorithm.
 *
 * Paul Heckbert	3 Sep 85
 */

#include "xdisplayP.h"
#include "GraphicsGems.h"
#include "prototyping.h"


/* void digline(int x1, int y1, int x2, int y2, int nv, int line_flag) RJM */
void digline(int x1, int y1, int x2, int y2, Pixel nv, int line_flag)
{
  int d, x, y, ax, ay, sx, sy, dx, dy;

  dx = x2-x1;  ax = ABS(dx)<<1;  sx = SGN(dx);
  dy = y2-y1;  ay = ABS(dy)<<1;  sy = SGN(dy);
  
  x = x1;
  y = y1;
  if (ax>ay) {		/* x dominant */
    d = ay-(ax>>1);
    for (;;) {
      if (line_flag)
	pixelprint(x,y,nv);
      else
	pixelwrite(x,y,nv);
      if (x==x2) return;
      if (d>=0) {
	y += sy;
	d -= ax;
	}
      x += sx;
      d += ay;
    }
  }
  else {			/* y dominant */
    d = ax-(ay>>1);
    for (;;) {
      if (line_flag)
	pixelprint(x,y,nv);
      else
	pixelwrite(x,y,nv);
      if (y==y2) return;
	if (d>=0) {
	  x += sx;
	  d -= ay;
	}
      y += sy;
      d += ax;
    }
  }
}
