/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#ifndef _PolyDef
#define _PolyDef

#include "std.h"


typedef struct _Point {
	float	x;
	float	y;
	float	z;
} Point;

typedef struct _Vertex {
	float	x;
	float	y;
	float	z;
} Vertex;

typedef struct _DVertex {
	double	x;
	double	y;
	double	z;
} DVertex;

typedef struct _Vertex2D {
	float	x;
	float	y;
} Vertex2D;

typedef struct _DVertex2D {
	double	x;
	double	y;
} DVertex2D;

typedef struct _Curve
{
	int		npts;
	Vertex		*pts;
} Curve;

typedef struct _DCurve
{
	int		npts;
	DVertex		*pts;
} DCurve;

typedef struct _Curve2D
{
	int		npts;
	Vertex2D	*pts;
} Curve2D;

typedef struct _DCurve2D
{
	int		npts;
	DVertex2D	*pts;
} DCurve2D;

typedef struct _PolyCurve
{
	int		ncurves;
	Curve		*curves;
} PolyCurve;

typedef struct _PolyCurve2D
{
	int		ncurves;
	Curve2D		*curves;
} PolyCurve2D;

typedef struct _EdgeVtxIdx
{
	int		v1;
	int		v2;
} EdgeVtxIdx;

typedef struct _Edge
{
	Vertex		v1;
	Vertex		v2;
} Edge;

typedef struct _Edge2D
{
	Vertex2D	v1;
	Vertex2D	v2;
} Edge2D;

typedef struct _TriangleEdgeIdx
{
	int		e1;
	int		e2;
	int		e3;
} TriangleEdgeIdx;

typedef struct _TriangleVtxIdx
{
	int		v1;
	int		v2;
	int		v3;
} TriangleVtxIdx;

typedef struct _Triangle
{
	Vertex		v1;
	Vertex		v2;
	Vertex		v3;
} Triangle;

typedef struct _Triangle2D
{
	Vertex2D	v1;
	Vertex2D	v2;
	Vertex2D	v3;
} Triangle2D;

typedef struct _DTriangle2D
{
	DVertex2D	v1;
	DVertex2D	v2;
	DVertex2D	v3;
} DTriangle2D;

typedef struct _TriangleEdge
{
	Edge		e1;
	Edge		e2;
	Edge		e3;
} TriangleEdge;

#endif /* _PolyDef */
