/*******************************************************************************
**
** Program name:        ReadColor (subroutine workhorse)
**
** Language:            C
**
** Author:              Gary Murphy
**
** Date written:        June 2, 92
**
**
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
**
** Abstract:    Read xcube, xsd, and xrpm colormaps.
**
** Modification history:        June 2, 1992    Initial release
**
**
********************************************************************************
**
*/

/*
#include <localsys.h>
#include <argsys.h>
*/
#include <stdio.h>
#include <unistd.h>	/* close */
#include <stdlib.h>	/* atoi */
#include <ctype.h>	/* isascii */
#include <fcntl.h>
#include <malloc.h>
#include "ExpandFile.h"

/*
 *      CRAY System
 */
#ifdef CRAYSYSTEM
#else

/*
 *      SUN System
 */
#endif

#define TRUE 1
#define FALSE 0
#define MAXCOLORS 256
#define MAXLINE 256
#define MAXDESCRIPTION 20
#define MAXHEADER 15
#define MAXXRPMCOLORS 114
/* #define MYDEBUG */


void ymcrgb(int c, int m, int y, int bk, char *r, char *g, char *b);


char *ReadColor (char *input, int *length_out, int verbos)
{

  int fdi, input_file = FALSE;
  char *rc, *expanded_input;
  FILE *fdi_descriptor;
  char *rgb;
  char *rgb_out;
  int maxcolor_length = MAXCOLORS * MAXDESCRIPTION + MAXHEADER;
  int file_length, length;
  int ncolors, pixel;
  int ascii = FALSE;
  int temp1;
  float temp;
  unsigned long r, g, b;
  int *xymc;
  char black[25], yellow[25], magenta[25], cyan[25];
  int i, j;
  char cdummy[49];
  int number_of_requested_colors;
  char *isnotis[2];
  isnotis[0] = "is not";
  isnotis[1] = "is";

/*
** Store number of requested colors locally for zero check
** When length_out == 0, return actual number of entries in
** colortable up to a maximum of MAXCOLORS.
*/

  number_of_requested_colors = *length_out<=0?MAXCOLORS:*length_out;
  if (verbos)
    fprintf (stderr, "number of requested colors is %d\n",
       number_of_requested_colors);

/*
** Expand twiddle for borne shell usage.
*/

  expanded_input = ExpandFile(input, verbos);
  input_file = TRUE;

/*
** Open input dataset
*/

  if (input_file) {
/*  fdi = open (expanded_input, O_RDONLY, 0644); RJM: 644 not req'd on RDONLY */
    fdi = open (expanded_input, O_RDONLY );
    if (fdi == -1) {
      rc = NULL;
      fprintf (stderr, 
         "***Error Unable to open file= %s in read_colors.\n", expanded_input);
      close(fdi);
      return (rc) ;
    }
  } else {
    fdi = 0;
  }

/*
** Read colormap
*/

  if (!(rgb = malloc (maxcolor_length))) {
    fprintf (stderr, "Unable to make room for colormap\n");
    rc = NULL;
    close(fdi);
    return (rc);
  }
  
  file_length=read(fdi,rgb,maxcolor_length);

  close(fdi);

  if (file_length == maxcolor_length)
    fprintf (stderr, "some colors truncated.\n");

  if (verbos) fprintf (stderr, "length of colorfile is %d\n", file_length);

/*
** Check for at least one non-ascii character
*/

  for (i=0,ascii=TRUE;i<file_length;i++) {
    if (!isascii(rgb[i])){
      ascii = FALSE;
      break;
    }
  }

/*
** Check report status
*/

  if (verbos) fprintf (stderr, "color file %s ascii\n", isnotis[ascii]);

/*
** See if ascii file is xcube or xrpm format
*/

  if (ascii) {
    if (!(fdi_descriptor = fopen (expanded_input, "r"))) {
      fprintf (stderr, "error opening ascii file %s\n", expanded_input);
      rc = NULL;
      return (rc);
    }
    if (fscanf (fdi_descriptor, "ncolors = %d\n", &ncolors)) {

      if (verbos) 
        fprintf (stderr, "reading xcube colormap\n");

      for (i=0; i<ncolors; i++) {
        if ((fscanf (fdi_descriptor, "%d %d %d\n", &r, &g, &b)) != 3) {
          fprintf (stderr, "error reading xcube colormap entry %d\n", i);
          rc = NULL;
          fclose (fdi_descriptor);
          return (rc);
        }
        rgb [3*i]     = r>>8;
        rgb [(3*i)+1] = g>>8;
        rgb [(3*i)+2] = b>>8;
#ifdef MYDEBUG
	fprintf (stderr, "before r %x g %x b %x\n", r>>8, g>>8, b>>8);
	fprintf (stderr, "after  r %x g %x b %x\n", 
		 rgb[3*i], rgb[(3*i)+1], rgb[(3*i)+2]);
#endif
      }
      length = ncolors*3;
      fclose (fdi_descriptor);

/*
** Check for xmplot colormap (pltr)
*/

    } else if (fscanf (fdi_descriptor, "1COLR%48c%2d\n", cdummy, &ncolors)) {

      if (verbos) {
        fprintf (stderr, "reading xmplot colormap with %d colors\n", ncolors);
      }

      xymc = (int *) malloc (4*ncolors*sizeof(int));
      for (i=0; i<ncolors; i++) {
        rgb[i*3] = 255;
        rgb[(i*3)+1] = 255;
        rgb[(i*3)+2] = 255;
      }

      if (verbos) {
        fprintf(stderr, "read and initialized rgb\n");
      }

      for (i=0; i<ncolors; ) {
        fscanf(fdi_descriptor,
		"2COLR%4c%2c%2c%2c%4c%2c%2c%2c%4c%2c%2c%2c%4c%2c%2c%2c%4c%2c%2c%2c\n", 
		&black[0],  &yellow[0], &magenta[0], &cyan[0],
		&black[5],  &yellow[5], &magenta[5], &cyan[5],
		&black[10], &yellow[10], &magenta[10], &cyan[10],
		&black[15], &yellow[15], &magenta[15], &cyan[15],
		&black[20], &yellow[20], &magenta[20], &cyan[20]);
        if (verbos) fprintf (stderr, "read 2COLR card\n");
        for (j=0; i<ncolors && j<5; i++, j++) {
          black[j*5+2]    = '\0';
          yellow[j*5+2]   = '\0';
          magenta[j*5+2]  = '\0';
          cyan[j*5+2]     = '\0';
#ifdef MYDEBUG
          fprintf(stderr, "black %x yellow %x magenta %x cyan %x\n",
                   &black[j*5],&yellow[j*5],&magenta[j*5],&cyan[j*5]);
#endif
          xymc[(i*4)+0] = atoi(&black[j*5]);
          xymc[(i*4)+1] = atoi(&yellow[j*5]);
          xymc[(i*4)+2] = atoi(&magenta[j*5]);
          xymc[(i*4)+3] = atoi(&cyan[j*5]);
          if (verbos) {
            fprintf (stderr, "%s %s %s %s\n", &black[j*5], &yellow[j*5], &magenta[j*5], 
		     &cyan[j*5]);
            fprintf (stderr, "iymc %d %d %d %d %d %d\n", 
		     i, j, xymc[(i*4)+3], xymc[(i*4)+2], xymc[(i*4)+1], xymc[i*4]);
          }
          ymcrgb(xymc[(i*4)+3], xymc[(i*4)+2], xymc[(i*4)+1], xymc[i*4], 
                 &rgb[(i*3)], &rgb[(i*3)+1], &rgb[(i*3)+2]);
          if (verbos) {
            r = (int)rgb[i*3]&0x000000ff;
            g = (int)rgb[(i*3)+1]&0x000000ff;
            b = (int)rgb[(i*3)+2]&0x000000ff;
            fprintf(stderr, "%d %d %d %d\n", i, r, g, b);
          }
        }
      }

      free (xymc);

      length = ncolors*3;    
      fclose (fdi_descriptor);

/*
** If it is an xrpm colormap, reopen the file to start at beginning
** since it has no header
*/

    } else {
      if (verbos)
        fprintf (stderr, "reading xrpm colormap\n");

      if (!(fdi_descriptor = freopen (expanded_input, "r", fdi_descriptor))) {
        fprintf (stderr, "error reopening xrpm colormap %s\n", expanded_input);
        rc = NULL;
        return (rc);
      }

      for (i=0; ((fscanf (fdi_descriptor, " %d %d %d %d\n", 
         &pixel, &r, &g, &b)) == 4) && (i<MAXXRPMCOLORS); i++) {
        rgb [3*i]     = r;
        rgb [(3*i)+1] = g;
        rgb [(3*i)+2] = b;
        if (verbos) {
          fprintf (stderr, "pixel %d\n", pixel);
          fprintf (stderr, "before r %x g %x b %x\n", r, g, b);
          fprintf (stderr, "after  r %x g %x b %x\n", 
           rgb[3*i], rgb[(3*i)+1], rgb[(3*i)+2]);
        }
      }
      length = i*3;
    }
    fclose (fdi_descriptor);
  } else {
    length = file_length;
    if (length==384) {
      if (verbos)
        fprintf (stderr, "reading old oper colormap\n");
      length-=39;
    }

/* RJM: here we're skipping the first color triplet!  Why???  Commented out:
    for (i=3; i<(length-2); i+=3) {
      rgb[i-3]=rgb[i];
      rgb[i-2]=rgb[i+1];
      rgb[i-1]=rgb[i+2];
#ifdef MYDEBUG
        fprintf (stderr, "expanded_input %d: r %x g %x b %x\n",
		 i-3, rgb[i-3], rgb[i-2], rgb[i-1] );
#endif
    }
*/
  }

  if (verbos) 
    fprintf (stderr, "actual length of color file is %d\n", length/3);

  if (*length_out <= 0)
    *length_out = length/3;

  if (!(rgb_out = malloc (*length_out*3))) {
    fprintf (stderr, "Unable to make room for colormap\n");
    rc = NULL;
    return (rc);
  }

/*
** Make output colortable requested size
*/

/* RJM: commented out Gary's original code: reason?  See example below:
	e.g., given that length=600
		*length_out=200
		temp = (600-1) / ((200-1)*3.0) = 599.0/597.0
		which is incorrect for length=600; the correct ratio is 1.0
  temp=(length-1)/(((*length_out)-1)*3.0);
  for (i=0; i<*length_out; i++) {
    temp1=(int)(i*temp);
    rgb_out[i*3] = rgb[temp1*3];
    rgb_out[i*3+1] = rgb[temp1*3+1];
    rgb_out[i*3+2] = rgb[temp1*3+2];
*/

  /* RJM: correct ratio: */
  temp=(length/3.0) / (float)*length_out;
  for (i=0; i<*length_out; i++) {
    temp1=3*(int)(i*temp);	/* RJM: added 3* for corrected ratio */
    rgb_out[i*3] = rgb[temp1];
    rgb_out[i*3+1] = rgb[temp1+1];
    rgb_out[i*3+2] = rgb[temp1+2];

    if (verbos) {
      r = (int)rgb_out[i*3]&0xff;
      g = (int)rgb_out[(i*3)+1]&0xff;
      b = (int)rgb_out[(i*3)+2]&0xff;
      fprintf (stderr, "%d %f %d %d %d %d\n", i, temp, temp1, r, g, b);
    }
  }
  free (rgb);
  return (rgb_out);
}

void ymcrgb(int c, int m, int y, int bk, char *r, char *g, char *b)
{
  int cc,mm,yy;
  float rr, gg, bb;
  
  cc = c;
  mm = m;
  yy = y;
  
  if (bk > 0) {
    cc += bk;
    mm += bk;
    yy += bk;
    if (cc > 16) cc = 16;
    if (mm > 16) mm = 16;
    if (yy > 16) yy = 16;
  }
  
  rr = 16 - cc;
  gg = 16 - mm;
  bb = 16 - yy;
  
  rr = (rr/16.) * 255.;
  gg = (gg/16.) * 255.;
  bb = (bb/16.) * 255.;
  
  *r = (short int)rr;
  *g = (short int)gg;
  *b = (short int)bb;
}
