/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/************************************************************************
 * Routine: DCURV3DMINMAX
 * Purpose: Find the minimum and maximum values of a set of curvilinear
 *          segments.
 * Author:  Bob Mars
 * Date:    12-22-89
 ***********************************************************************/



#include <math.h>

#define MIN   0
#define MAX   1

typedef struct {
   double  x;
   double  y;
   double  z;
} Dtuple, *Dtupleptr;


void dcurv3dminmax( crvs, ncrvs, ncrvpts, minmax )
   Dtupleptr  crvs[];
   Dtuple     minmax[];
   int        ncrvs, ncrvpts[];
{
   Dtupleptr  ptr;
   int        curve, scurve, pt;


   if( ncrvs <= 0 )
      return;

   /* find min and max x, y & z of all curves */
   for( scurve = 0;  scurve < ncrvs;  scurve++ )
      if( ncrvpts[scurve] > 0 )  {
         minmax[MIN].x = minmax[MAX].x = crvs[scurve]->x;
         minmax[MIN].y = minmax[MAX].y = crvs[scurve]->y;
         minmax[MIN].z = minmax[MAX].z = crvs[scurve]->z;
         break;
      }

   for( curve = scurve;  curve < ncrvs;  curve++ )
      for( pt = 0, ptr = crvs[curve];  pt < ncrvpts[curve];  pt++, ptr++ )  {
         if( ptr->x > minmax[MAX].x )
            minmax[MAX].x = ptr->x;
         else if( ptr->x < minmax[MIN].x )  {
            minmax[MIN].x = ptr->x;
         }

         if( ptr->y > minmax[MAX].y )
            minmax[MAX].y = ptr->y;
         else if( ptr->y < minmax[MIN].y )  {
            minmax[MIN].y = ptr->y;
         }

         if( ptr->z > minmax[MAX].z )
            minmax[MAX].z = ptr->z;
         else if( ptr->z < minmax[MIN].z )  {
            minmax[MIN].z = ptr->z;
         }
      }
}
