/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
  This file contains the function for
  setting default variables and parameters.
*/

#include "xdisplayP.h"
#include "prototyping.h"

extern char directory[4][1024],colorname[80];
extern char *colordir,*pickdir;
extern Boolean color_flag;
extern char *filename;
extern Boolean dir_flag[4];


static Widget text_default[14];
static Widget toggle_picks=NULL;
char project[1024];
char recover[1024];
char printer_name[1024]="";
int max_traces=2000;


void init_defaults(void)
{
  char buf1[1024], *home;
  int fp;

				/* Initialize directories. */
  strcpy(&directory[0][0],"");
  strcpy(&directory[1][0],"");
  strcpy(&directory[2][0],"");
  strcpy(&directory[3][0],"");
  strcpy(colorname,"");

				/* Find xsd_defaults file in HOME directory. */
  if ((home=getenv("HOME")) != NULL) {
    strcpy(project,home);
    strcat(project,"/.xsd_defaults");
    load_defaults(project,0); 
  }

				/* Use home directory for the color and pick 
                                   directoryies if exists, otherwise use the
                                   current directory. */
  if (colordir) free(colordir);
  if (pickdir)  free(pickdir);
  if (home) {
    colordir=(char *)malloc(strlen(home)+1);
    strcpy(colordir,home);
    pickdir =(char *)malloc(strlen(home)+1);
    strcpy(pickdir,home);
  } else {
    colordir=(char *)getcwd(NULL,255);
    pickdir =(char *)getcwd(NULL,255);
  }

				/* If hostname is empty set to "=". */
  if (strlen(hostname)==0) strcpy(hostname,"=");
				/* If username is empty set to cuserid.  */
  if (strlen(username)==0) strcpy(username,(char*)cuserid(NULL));

				/* Check if ".xsd_define" file exists. */
  if (home) {
    strcpy(buf,home);
    strcat(buf,"/.xsd_define");
    fp=open(buf,O_RDONLY);
    if (fp==-1) {			/* File doesn't exist new xsd user. */
      sprintf(buf1,"echo \"Don't erase this file.\" > %s",buf);
      system(buf1);
    } else { /* RJM: added */
      close(fp);
    }
  }

				/* Create global window. */
  init_global();

				/* Set remote filer box directory toggles. */
  dir_flag[0]=True;
  dir_flag[1]=False;
  dir_flag[2]=False;
  dir_flag[3]=False;

				/* Store top window attributes. */
  xdisplay[0].window=top_level;
  xdisplay[0].axis_units[0]=1.0;
  xdisplay[0].axis_units[1]=1.0;
  xdisplay[0].axis_units[2]=1.0;
}


/*
  This function creates a window
  list all the default parameters
  that the user can change.
*/
void defaults_fileCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  Widget dialog_form;
  Widget dialog_window;
  Widget button;
  Widget separator;
  ClientData *message;
  long id = (long)client_data;	/* RJM: handle 64-bit architectures */

  dialog_form=XmCreateFormDialogVa(w,"form",
				   XmNmarginHeight,10,
				   XmNmarginWidth,10,
				   XmNdeleteResponse,XmDO_NOTHING,
				   XmNdialogTitle,XMstr("Project File"),
				   XtNmanageChild,False,
				   XmNallowShellResize, True,
				   NULL);
  XtAddCallback(dialog_form,XmNhelpCallback,helpCB,"project.help");
  
  text_default[0]=XmCreateTextVa(dialog_form,"username",
				 XmNvalue,username,
				 XmNcolumns,50,
				 XmNtopAttachment,XmATTACH_FORM,
				 XmNtopOffset,10,
				 XmNleftAttachment,XmATTACH_FORM,
				 XmNleftOffset,200,
				 XmNrightAttachment,XmATTACH_FORM,
				 XmNrightOffset,10,
				 NULL);  
  
  text_default[1]=XmCreateTextVa(dialog_form,"hostname",
				 XmNvalue,hostname,
				 XmNcolumns,50,
				 XmNtopAttachment,XmATTACH_WIDGET,
				 XmNtopWidget,text_default[0],
				 XmNtopOffset,5,
				 XmNleftAttachment,XmATTACH_OPPOSITE_WIDGET, 
				 XmNleftWidget,text_default[0],
				 XmNrightAttachment,XmATTACH_FORM,
				 XmNrightOffset,10,
				 NULL);  
  
  
  text_default[2]=XmCreateTextVa(dialog_form,"colorname",
				 XmNvalue,colorname,
				 XmNcolumns,50,
				 XmNtopAttachment,XmATTACH_WIDGET,
				 XmNtopWidget,text_default[1],
				 XmNtopOffset,5,
				 XmNleftAttachment,XmATTACH_OPPOSITE_WIDGET, 
				 XmNleftWidget,text_default[1],
				 XmNrightAttachment,XmATTACH_FORM,
				 XmNrightOffset,10,
				 NULL);  
  
  
  text_default[3]=XmCreateTextVa(dialog_form,"directory",
				 XmNvalue,&directory[0][0],
				 XmNcolumns,50,
				 XmNtopAttachment,XmATTACH_WIDGET,
				 XmNtopWidget,text_default[2],
				 XmNtopOffset,5,
				 XmNleftAttachment,XmATTACH_OPPOSITE_WIDGET, 
				 XmNleftWidget,text_default[2],
				 XmNrightAttachment,XmATTACH_FORM,
				 XmNrightOffset,10,
				 NULL);  
  
  
  text_default[4]=XmCreateTextVa(dialog_form,"directory",
				 XmNvalue,&directory[1][0],
				 XmNcolumns,50,
				 XmNtopAttachment,XmATTACH_WIDGET,
				 XmNtopWidget,text_default[3],
				 XmNtopOffset,5,
				 XmNleftAttachment,XmATTACH_OPPOSITE_WIDGET, 
				 XmNleftWidget,text_default[3],
				 XmNrightAttachment,XmATTACH_FORM,
				 XmNrightOffset,10,
				 NULL);  
  
  
  text_default[5]=XmCreateTextVa(dialog_form,"directory",
				 XmNvalue,&directory[2][0],
				 XmNcolumns,50,
				 XmNtopAttachment,XmATTACH_WIDGET,
				 XmNtopWidget,text_default[4],
				 XmNtopOffset,5,
				 XmNleftAttachment,XmATTACH_OPPOSITE_WIDGET, 
				 XmNleftWidget,text_default[4],
				 XmNrightAttachment,XmATTACH_FORM,
				 XmNrightOffset,10,
				 NULL);  
  
  
  text_default[6]=XmCreateTextVa(dialog_form,"directory",
				 XmNvalue,&directory[3][0],
				 XmNcolumns,50,
				 XmNtopAttachment,XmATTACH_WIDGET,
				 XmNtopWidget,text_default[5],
				 XmNtopOffset,5,
				 XmNleftAttachment,XmATTACH_OPPOSITE_WIDGET, 
				 XmNleftWidget,text_default[5],
				 XmNrightAttachment,XmATTACH_FORM,
				 XmNrightOffset,10,
				 NULL);  
  
  
  text_default[7]=XmCreateTextVa(dialog_form,"directory",
				 XmNvalue,printer_name,
				 XmNcolumns,50,
				 XmNtopAttachment,XmATTACH_WIDGET,
				 XmNtopWidget,text_default[6],
				 XmNtopOffset,5,
				 XmNleftAttachment,XmATTACH_OPPOSITE_WIDGET, 
				 XmNleftWidget,text_default[6],
				 XmNrightAttachment,XmATTACH_FORM,
				 XmNrightOffset,10,
				 NULL);  
  
  
  text_default[8]=XmCreateTextVa(dialog_form,"directory",
				 XmNvalue,recover,
				 XmNcolumns,50,
				 XmNtopAttachment,XmATTACH_WIDGET,
				 XmNtopWidget,text_default[7],
				 XmNtopOffset,5,
				 XmNleftAttachment,XmATTACH_OPPOSITE_WIDGET, 
				 XmNleftWidget,text_default[7],
				 XmNrightAttachment,XmATTACH_FORM,
				 XmNrightOffset,10,
				 NULL);  
  
  sprintf(buf,"%d",line_width);
  
  text_default[9]=XmCreateTextVa(dialog_form,"text",
				 XmNvalue,buf,
				 XmNcolumns,50,
				 XmNtopAttachment,XmATTACH_WIDGET,
				 XmNtopWidget,text_default[8],
				 XmNtopOffset,5,
				 XmNleftAttachment,XmATTACH_OPPOSITE_WIDGET, 
				 XmNleftWidget,text_default[8],
				 XmNrightAttachment,XmATTACH_FORM,
				 XmNrightOffset,10,
				 NULL);  
  
  sprintf(buf,"%d",max_traces);
  
  text_default[10]=XmCreateTextVa(dialog_form,"text",
				  XmNvalue,buf,
				  XmNcolumns,50,
				  XmNtopAttachment,XmATTACH_WIDGET,
				  XmNtopWidget,text_default[9],
				  XmNtopOffset,5,
				  XmNleftAttachment,XmATTACH_OPPOSITE_WIDGET, 
				  XmNleftWidget,text_default[9],
				  XmNrightAttachment,XmATTACH_FORM,
				  XmNrightOffset,10,
				  NULL);  
  
  text_default[11]=XmCreateTextVa(dialog_form,"trace_header",
				  XmNvalue,trace_data1,
				  XmNcolumns,50,
				  XmNtopAttachment,XmATTACH_WIDGET,
				  XmNtopWidget,text_default[10],
				  XmNtopOffset,5,
				  XmNleftAttachment,XmATTACH_OPPOSITE_WIDGET, 
				  XmNleftWidget,text_default[10],
				  XmNrightAttachment,XmATTACH_FORM,
				  XmNrightOffset,10,
				  NULL);  
  
  text_default[12]=XmCreateTextVa(dialog_form,"trace_header",
				  XmNvalue,trace_data2,
				  XmNcolumns,50,
				  XmNtopAttachment,XmATTACH_WIDGET,
				  XmNtopWidget,text_default[11],
				  XmNtopOffset,5,
				  XmNleftAttachment,XmATTACH_OPPOSITE_WIDGET, 
				  XmNleftWidget,text_default[11],
				  XmNrightAttachment,XmATTACH_FORM,
				  XmNrightOffset,10,
				  NULL);  
  
  text_default[13]=XmCreateTextVa(dialog_form,"trace_header",
				  XmNvalue,trace_data3,
				  XmNcolumns,50,
				  XmNtopAttachment,XmATTACH_WIDGET,
				  XmNtopWidget,text_default[12],
				  XmNtopOffset,5,
				  XmNleftAttachment,XmATTACH_OPPOSITE_WIDGET, 
				  XmNleftWidget,text_default[12],
				  XmNrightAttachment,XmATTACH_FORM,
				  XmNrightOffset,10,
				  NULL);  
  

  (void)XmCreateLabelVa(dialog_form,"Login Id",
			XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			XmNtopWidget,text_default[0],
			XmNtopOffset,5,
			XmNleftAttachment,XmATTACH_FORM, 
			XmNleftOffset,10,
			NULL);
  (void)XmCreateLabelVa(dialog_form,"Host Computer",
			XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			XmNtopWidget,text_default[1],
			XmNtopOffset,5,
			XmNleftAttachment,XmATTACH_FORM, 
			XmNleftOffset,10,
			NULL);
  (void)XmCreateLabelVa(dialog_form,"Colormap File",
			XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			XmNtopWidget,text_default[2],
			XmNtopOffset,5,
			XmNleftAttachment,XmATTACH_FORM, 
			XmNleftOffset,10,
			NULL);
  (void)XmCreateLabelVa(dialog_form,"Directory #1",
			XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			XmNtopWidget,text_default[3],
			XmNtopOffset,5,
			XmNleftAttachment,XmATTACH_FORM, 
			XmNleftOffset,10,
			NULL);
  (void)XmCreateLabelVa(dialog_form,"Directory #2",
			XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			XmNtopWidget,text_default[4],
			XmNtopOffset,5,
			XmNleftAttachment,XmATTACH_FORM, 
			XmNleftOffset,10,
			NULL);
  (void)XmCreateLabelVa(dialog_form,"Directory #3",
			XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			XmNtopWidget,text_default[5],
			XmNtopOffset,5,
			XmNleftAttachment,XmATTACH_FORM, 
			XmNleftOffset,10,
			NULL);
  (void)XmCreateLabelVa(dialog_form,"Directory #4",
			XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			XmNtopWidget,text_default[6],
			XmNtopOffset,5,
			XmNleftAttachment,XmATTACH_FORM, 
			XmNleftOffset,10,
			NULL);
  (void)XmCreateLabelVa(dialog_form,"Printer Name",
			XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			XmNtopWidget,text_default[7],
			XmNtopOffset,5,
			XmNleftAttachment,XmATTACH_FORM, 
			XmNleftOffset,10,
			NULL);
  (void)XmCreateLabelVa(dialog_form,"Recover Dir.",
			XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			XmNtopWidget,text_default[8],
			XmNtopOffset,5,
			XmNleftAttachment,XmATTACH_FORM, 
			XmNleftOffset,10,
			NULL);
  (void)XmCreateLabelVa(dialog_form,"Line Width",
			XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			XmNtopWidget,text_default[9],
			XmNtopOffset,5,
			XmNleftAttachment,XmATTACH_FORM, 
			XmNleftOffset,10,
			NULL);
  (void)XmCreateLabelVa(dialog_form,"Maximum # of Traces",
			XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			XmNtopWidget,text_default[10],
			XmNtopOffset,5,
			XmNleftAttachment,XmATTACH_FORM, 
			XmNleftOffset,10,
			NULL);
  (void)XmCreateLabelVa(dialog_form,"Trace Header #1",
			XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			XmNtopWidget,text_default[11],
			XmNtopOffset,5,
			XmNleftAttachment,XmATTACH_FORM, 
			XmNleftOffset,10,
			NULL);
  (void)XmCreateLabelVa(dialog_form,"Trace Header #2",
			XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			XmNtopWidget,text_default[12],
			XmNtopOffset,5,
			XmNleftAttachment,XmATTACH_FORM, 
			XmNleftOffset,10,
			NULL);
  (void)XmCreateLabelVa(dialog_form,"Trace Header #3",
			XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			XmNtopWidget,text_default[13],
			XmNtopOffset,5,
			XmNleftAttachment,XmATTACH_FORM, 
			XmNleftOffset,10,
			NULL);
  
  toggle_picks=XmCreateToggleButtonVa(dialog_form,"Save Pick Colors",
				      XmNtopAttachment,XmATTACH_WIDGET,
				      XmNtopWidget,text_default[13],
				      XmNtopOffset,10,
				      XmNleftAttachment,XmATTACH_FORM, 
				      NULL);
  XmToggleButtonSetState(toggle_picks,True,False);

  separator=XmCreateSeparatorVa(dialog_form,"separator",
				XmNleftAttachment,XmATTACH_FORM,
				XmNrightAttachment,XmATTACH_FORM,
				XmNtopAttachment,XmATTACH_WIDGET,
				XmNtopWidget,toggle_picks,
				XmNtopOffset,10,
				NULL);

  
  dialog_window=XmCreateRowColumnVa(dialog_form,"row_column",
				    XmNorientation,XmHORIZONTAL,
				    XmNadjustLast,False,
				    XmNentryAlignment,XmALIGNMENT_CENTER,
				    XmNpacking,XmPACK_TIGHT,
				    XmNmarginHeight,10,
				    XmNmarginWidth,10,
				    XmNnumColumns,1,
				    XmNspacing,10, 
				    XmNtopAttachment,XmATTACH_WIDGET,
				    XmNtopWidget,separator,
				    XmNtopOffset,0,
				    XmNbottomAttachment,XmATTACH_FORM, 
				    XmNbottomOffset,0,
				    XmNleftAttachment,XmATTACH_FORM, 
				    XmNleftOffset,0,
				    XmNrightAttachment,XmATTACH_FORM, 
				    XmNrightOffset,0,
				    NULL);

  button=XmCreatePushButtonVa(dialog_window,"Load from File",NULL);
  XtAddCallback(button,XmNactivateCallback,set_typeCB,(XtPointer)4L); 
  XtAddCallback(button,XmNactivateCallback,filer_promptCB,client_data); 
  XtAddCallback(button,XmNactivateCallback,destroyCB,dialog_form); 

  message=(ClientData *)malloc(sizeof(ClientData));
  message->w=dialog_form;
  message->id=id;
  button=XmCreatePushButtonVa(dialog_window,"Save to File",NULL);
  XtManageChild(button);
  XtAddCallback(button,XmNactivateCallback,get_defaultsCB,message); 
  XtAddCallback(button,XmNactivateCallback,set_typeCB,(XtPointer)5L); 
  XtAddCallback(button,XmNactivateCallback,filer_promptCB,client_data); 

  message=(ClientData *)malloc(sizeof(ClientData));
  message->w=dialog_form;
  message->id=id;
  button=XmCreatePushButtonVa(dialog_window,"Save as Default",NULL);
  XtManageChild(button);
  XtAddCallback(button,XmNactivateCallback,get_defaultsCB,message); 
  XtAddCallback(button,XmNactivateCallback,save_as_defaultCB,(XtPointer)id); 
  XtAddCallback(button,XmNactivateCallback,destroyCB,dialog_form); 

  message=(ClientData *)malloc(sizeof(ClientData));
  message->w=dialog_form;
  message->id=id;
  button=XmCreatePushButtonVa(dialog_window,"Apply",NULL);
  XtManageChild(button);
  XtAddCallback(button,XmNactivateCallback,get_defaultsCB,message); 

  button=XmCreatePushButtonVa(dialog_window,"Cancel",NULL);
  XtManageChild(button);
  XtAddCallback(button,XmNactivateCallback,destroyCB,dialog_form); 

  button=XmCreatePushButtonVa(dialog_window,"Help",NULL);
  XtManageChild(button);
  XtAddCallback(button,XmNactivateCallback,helpCB,"project.help");

  XtManageChild(dialog_form);
}



/*
  This function saves the default
  parameters into the user defaults
  file --> $HOME/.xsd_defaults.
*/
void save_as_defaultCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  char	*home;

  if( (home=getenv("HOME")) != NULL )
  {
    strcpy(buf,home);
    strcat(buf,"/.xsd_defaults");
    save_defaults(buf,(long)client_data);
  }
}



/*
  This function set the variables
  from the default window.
*/
void get_defaultsCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  ClientData *message=(ClientData *)client_data; 
  char *str;
  int n;
  long id;	/* RJM: handle 64-bit architectures */

  id=message->id;

  n=0;
  XtSetArg(args[n],XmNvalue,&str); n++;

				/* Get default parameters from text widgets. */
  XtGetValues(text_default[0],args,n);
  strcpy(username,str);
  XtFree(str);
  XtGetValues(text_default[1],args,n);
  strcpy(hostname,str);
  XtFree(str);
  XtGetValues(text_default[2],args,n);
  strcpy(colorname,str);
  XtFree(str);
  XtGetValues(text_default[3],args,n);
  strcpy(&directory[0][0],str);
  XtFree(str);
  XtGetValues(text_default[4],args,n);
  strcpy(&directory[1][0],str);
  XtFree(str);
  XtGetValues(text_default[5],args,n);
  strcpy(&directory[2][0],str);
  XtFree(str);
  XtGetValues(text_default[6],args,n);
  strcpy(&directory[3][0],str);
  XtFree(str);
  XtGetValues(text_default[7],args,n);
  strcpy(printer_name,str);
  XtFree(str);
  XtGetValues(text_default[8],args,n);
  strcpy(recover,str);
  XtFree(str);
  XtGetValues(text_default[9],args,n);
  sscanf(str,"%d",&line_width);
  XtFree(str);
  XtGetValues(text_default[10],args,n);
  sscanf(str,"%d",&max_traces);
  XtFree(str);
  XtGetValues(text_default[11],args,n);
  sscanf(str,"%6s",trace_data1);
  XtFree(str);
  XtGetValues(text_default[12],args,n);
  sscanf(str,"%6s",trace_data2);
  XtFree(str);
  XtGetValues(text_default[13],args,n);
  sscanf(str,"%6s",trace_data3);
  XtFree(str);

  if (xdisplay[id].init==-1) {
    expose_image(id);
  }
  
  if( message->w != NULL )
    XtDestroyWidget( message->w );
  free(message);
}



/*
  This function load the default
  parameters from a file.
*/
void load_defaults(char *default_file, long id)
{
  FILE *in;
  char temp[256+2], *cwd;
  int color_count,red,green,blue;

  color_count=start_pick_color;

  strcpy(trace_data1,"RecNum");
  strcpy(trace_data2,"TrcNum");
  strcpy(trace_data3,"TrcNum");
  if( (cwd = getcwd( NULL, 256)) == NULL )
    strcpy(&directory[0][0],"./");
  else {
    strcpy(&directory[0][0],cwd);
    free( cwd );
  }

				/* Open default file. */
  in=fopen(default_file,"r");

				/* Check file is open. */
  if (in!=NULL) {
				/* Loop through and read all the defaults. */
    while (fgets(buf,256,in)!=NULL) {
      sscanf(buf,"%s",temp);
      if (strcmp(temp,"Directory1:")==0)
        sscanf(buf,"%*s %s",&directory[0][0]);
      else if (strcmp(temp,"Directory2:")==0)
        sscanf(buf,"%*s %s",&directory[1][0]);
      else if (strcmp(temp,"Directory3:")==0)
        sscanf(buf,"%*s %s",&directory[2][0]);
      else if (strcmp(temp,"Directory4:")==0)
        sscanf(buf,"%*s %s",&directory[3][0]);
      else if (strcmp(temp,"Printer:")==0)
        sscanf(buf,"%*s %s",printer_name);
      else if (strcmp(temp,"Recover:")==0)
        sscanf(buf,"%*s %s",recover);
      else if (strcmp(temp,"Line_Width:")==0)
        sscanf(buf,"%*s %d",&line_width);
      else if (strcmp(temp,"Max_Traces:")==0)
        sscanf(buf,"%*s %d",&max_traces);
      else if (strcmp(temp,"Traces1:")==0)
        sscanf(buf,"%*s %s",trace_data1);
      else if (strcmp(temp,"Traces2:")==0)
        sscanf(buf,"%*s %s",trace_data2);
      else if (strcmp(temp,"Traces3:")==0)
        sscanf(buf,"%*s %s",trace_data3);
      else if ((strcmp(temp,"Host:")==0)&&(strlen(hostname)==0))
        sscanf(buf,"%*s %s",hostname);
      else if ((strcmp(temp,"Login:")==0)&&(strlen(username)==0))
        sscanf(buf,"%*s %s",username);
      else if (strcmp(temp,"Color:")==0) {
        sscanf(buf,"%*s %s",colorname);
        color_flag=True;
	load_color_file(colorname,-1);
      }
      else if ((strcmp(temp,"Pick:")==0)&&(color_count<=end_pick_color)) {
        sscanf(buf,"%*s %d %d %d",&red,&green,&blue);
	*(raster_color_red[id]+color_count)=red;
	*(raster_color_green[id]+color_count)=green;
	*(raster_color_blue[id]+color_count)=blue;
	color_count++;
      }
    }

    fclose(in);
  }
}



/*
  This function saves the default
  parameters to a file.
*/
void save_defaults(char *filename, long id)
{
  FILE *out;
  int n;

				/* Open file to save defaults. */
  out=fopen(filename,"w");

				/* Check file is open. */
  if (out==NULL) {
    error_message("Can't write project file.");
    return;
  }

				/* Write out the defaults. */
  if (strlen(hostname)!=0)
    fprintf(out,"Host: %s\n",hostname);
  if (strlen(username)!=0)
    fprintf(out,"Login: %s\n",username);
  if (strlen(colorname)!=0) {
    fprintf(out,"Color: %s\n",colorname);
    load_color_file(colorname,-1);
  }
  if (strlen(&directory[0][0])!=0)
    fprintf(out,"Directory1: %s\n",&directory[0][0]);
  if (strlen(&directory[1][0])!=0)
    fprintf(out,"Directory2: %s\n",&directory[1][0]);
  if (strlen(&directory[2][0])!=0)
    fprintf(out,"Directory3: %s\n",&directory[2][0]);
  if (strlen(&directory[3][0])!=0)
    fprintf(out,"Directory4: %s\n",&directory[3][0]);
  if (strlen(recover)==0)
    strcpy(recover,"/tmp");
  fprintf(out,"Printer: %s\n",printer_name);
  fprintf(out,"Recover: %s\n",recover);
  fprintf(out,"Line_Width: %d\n",line_width);
  fprintf(out,"Max_Traces: %d\n",max_traces);
  fprintf(out,"Traces1: %s\n",trace_data1);
  fprintf(out,"Traces2: %s\n",trace_data2);
  fprintf(out,"Traces3: %s\n",trace_data3);

  if (XmToggleButtonGetState(toggle_picks))
    for (n=start_pick_color; n<=end_pick_color; n++) 
      fprintf(out,"Pick: %d %d %d\n",*(raster_color_red[id]+n),
	      *(raster_color_green[id]+n),*(raster_color_blue[id]+n));

  fclose(out);

  return;
}
