/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
  This file contains function to
  create the drop down menus for
  the edit segment functions.
*/

#include "xdisplayP.h"
#include "prototyping.h"

extern Widget label_values;
extern Widget edit_window;
extern Pixmap pix;
extern int main_window;
extern int current_segment;

/*
*/
void edit_menu(long id)
{
  long id_anim;	/* RJM: handle 64-bit architectures */

				/* Get id for images display in animation. */
  id_anim=id;
  if (strcmp(xdisplay[id].filename,"Animation")==0)
    id_anim=animate_list[step_count];


  if ((edit_mode!=0)&&(edit_mode!=id_anim))
    quit_edit();

  changed_picks=True;

                                 /* Creates a pixmap so the screen can be 
				    quickly refresh when editting segments. */
  if (edit_mode!=id) 
    pix=XCreatePixmap(display,xdisplay[id].top,
		      xdisplay[id_anim].image->width, 
		      xdisplay[id_anim].image->height,8);

  edit_mode=id_anim;
}



/*
  This function deletes all the
  old picks.
*/
void new_segmentsCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  int n;
  long id;	/* RJM: handle 64-bit architectures */

				/* Change if using groups. */
/*  id=xdisplay[(long)client_data].parent; */

  id=0;     

  for (n=0; n<MAX_PICKS; n++)
    if (picks[n].init==-1) {
      if (picks[n].group==id) {
        if(picks[n].record)
          free((char *)picks[n].record); picks[n].record=NULL;
        if(picks[n].trace)
          free((char *)picks[n].trace); picks[n].trace=NULL;
        if(picks[n].sample)
          free((char *)picks[n].sample); picks[n].sample=NULL;
        picks[n].init=0;
      }
    }
  expose_all_images();
  expose_all_picks();
  current_segment=(-1);
}


/*
  This function deletes all the
  overlay picks.
*/
void new_overlayCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  int n;

  for (n=0; n<MAX_PICKS; n++)
    if (picks[n].init==-1) {
      if (picks[n].group==1) {
        if(picks[n].record)
          free((char *)picks[n].record); picks[n].record=NULL;
        if(picks[n].trace)
          free((char *)picks[n].trace); picks[n].trace=NULL;
        if(picks[n].sample)
          free((char *)picks[n].sample); picks[n].sample=NULL;
        picks[n].init=0;
      }
    }
  expose_all_images();
  expose_all_picks();
  current_segment=(-1);
}


/*
  This function deletes the
  edit picks window.
*/
void quit_edit()
{
				/* Free pixmap use in edit mode. */
  if( pix ) {	/* RJM: added */
    XFreePixmap(display,pix);
    pix =(Pixmap) NULL;
  }

				/* Clear edit_mode. */
  edit_mode=0;

  XtSetArg(args[0],XmNsensitive,False);
  XtSetValues(xdisplay[main_window].number_label,args,1);
  XtSetValues(xdisplay[main_window].number_text,args,1);

  expose_all_images();
  expose_all_picks();

  if (model_mode!=0) {		/* In model mode. */
    if (model_mode==main_window) {
      xdisplay[main_window].mode=18;
      set_mode_label(18,main_window);
    }
  }
}
