/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
  This file contains the functions for
  editing picks.
*/


#include "xdisplayP.h"
#include "prototyping.h"

				/* Store image into a pixmap so that
				   image refreshing is quick when editting. */
extern Pixmap pix;

struct values_struct values;
struct location_struct location;

int main_window;
int edit_mode=0;
int current_pick=(-1);
int current_segment=(-1);
int current_undo=(-1);

static float pick_record[MAX_P_LIST];
static float pick_trace[MAX_P_LIST];
static float pick_sample[MAX_P_LIST];
static long undo_id;
static int pick_size;
static int join_pick=(-1);
static int join_segment=(-1);
static int start_x=(-1),start_y;
static int round_x=(-1),round_y;
static int pick_x[MAX_P_LIST],pick_y[MAX_P_LIST],count=0;   /* Adding picks. */
static int start_adding;

/*
  This functions displays the edit 
  picks options.
*/
void edit_picks(Widget w, long id)
{
  long id_anim;

				/* Get id for images display in animation. */
  id_anim=id;
  if (strcmp(xdisplay[id].filename,"Animation")==0)
    id_anim=animate_list[step_count];

  expose_picks_animation(id,id_anim);

				/* Hide main menu. */
  main_window=id;

  edit_menu(id);

  XtSetArg(args[0],XmNsensitive,True);
  XtSetValues(xdisplay[id].number_label,args,1);
  XtSetValues(xdisplay[id].number_text,args,1);
}



/*
  This function reset the toggle
  button and puts the user back
  into the select mode.
*/
void reset_mode(long id,long id_anim,Boolean unselect)
{
				/* Unselect the current segment and pick. */
  if (unselect) {
    current_pick=(-1);
    current_segment=(-1);
  }
  expose_all_images();
  expose_all_picks();

  if (id!=id_anim) {
    expose_animation(id,id_anim);
    expose_picks_animation(id,id_anim);
  }

  draw_pix(id,id_anim,current_segment);
}



/*
  This function prompts the user
  for a segment label.
*/
void label_segment(XEvent *event, long id, long id_anim)
{
  Widget prompt,text;
  ClientData *message;

  if (current_segment==-1) {
    select_segment(event,id,id_anim);
    return;
  }

  if (event->xbutton.button==Button2)
    return;

  if (event->xbutton.button==Button3) {
    reset_mode(id,id_anim,True);
    return;
  }

				/* Indicates label is to be displayed. */
  xdisplay[id].label_flag=True;

  prompt=XmCreatePromptDialogVa(xdisplay[id].window,"prompt",
				XmNdialogTitle,XMstr("Input Label"),
				XmNtextString,XMstr(picks[current_segment].label),
				XmNselectionLabelString,XMstr("Input Label"),
				NULL);
  XmRemoveTabGroup(prompt);
  XmAddTabGroup(text=XmSelectionBoxGetChild(prompt,XmDIALOG_TEXT));
  XmAddTabGroup(XmSelectionBoxGetChild(prompt,XmDIALOG_HELP_BUTTON));

  /* DWN 12/11/97 label buffers are 20 bytes */
  XtVaSetValues(text,XmNcolumns,19,XmNmaxLength,19,NULL);

  message=(ClientData *)malloc(sizeof(ClientData));
  message->w=prompt;
  message->id=id;
  XtAddCallback(prompt,XmNokCallback,attach_labelCB,message);
  XtAddCallback(prompt,XmNcancelCallback,destroyCB,prompt);
  XtAddCallback(prompt,XmNhelpCallback,helpCB,"label.help");

  return;
}



/*
  This function changes the color
  of a segment label.
*/
void color_segment(XEvent *event, long id, long id_anim)
{
  if (current_segment==-1) {
    select_segment(event,id,id_anim);
    return;
  }

  if (event->xbutton.button==Button2)
    return;

  if (event->xbutton.button==Button3) {
    reset_mode(id,id_anim,True);
    return;
  }

  picks[current_segment].color=xdisplay[id].pick_color;

  reset_mode(id,id_anim,True);

  return;
}



/*
  This function attachs a label
  to the selected segment.
*/
void attach_labelCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  XmSelectionBoxCallbackStruct *CBst = (XmSelectionBoxCallbackStruct*)call_data;
  ClientData *message=(ClientData *)client_data;
  long id,id_anim;	/* RJM: handle 64-bit architectures */
  int y;
  char *label;

  id=message->id;
  id_anim=id;
  if (strcmp(xdisplay[id].filename,"Animation")==0)
    id_anim=animate_list[step_count];

				/* Get label from prompt dialog. */
  XmStringGetLtoR(CBst->value,XmSTRING_DEFAULT_CHARSET,&label);

				/* Check if there was a label entered. */
  if ( ! *label) {
    if( message->w != NULL )
      XtDestroyWidget( message->w );
    free(message);
    return;
  }

				/* Label can not have any blanks. */
  sscanf(label,"%s",picks[current_segment].label);

				/* Get the location of the first and second 
				   pick points. If the second point is a 
				   smaller value then the label should be 
				   located below the first pick point 
				   (opposite if the second pick point is 
				   larger (y direction. */
/*if(picks[current_segment].id != id_anim )
fprintf( stderr,"NOTE: attach_labelCB: picks[current_segment].id(%d) != id_anim(%d)\n", picks[current_segment].id, id_anim);
*/

/*location=get_location(*(picks[current_segment].record+1),*(picks[current_segment].trace+1),*(picks[current_segment].sample+1),id_anim); RJM */
  location=get_location(picks[current_segment].record[1],picks[current_segment].trace[1],picks[current_segment].sample[1],id_anim?id_anim:picks[current_segment].id);
  y=location.y;
/*location=get_location(*(picks[current_segment].record),*(picks[current_segment].trace),*(picks[current_segment].sample),id_anim); RJM */
  location=get_location(picks[current_segment].record[0],picks[current_segment].trace[0],picks[current_segment].sample[0],id_anim?id_anim:picks[current_segment].id);

  if (y<location.y)
    picks[current_segment].offset_y=10; 
  else 
    picks[current_segment].offset_y=(-2); 

  reset_mode(id,id_anim,True);

  if( message->w != NULL )
    XtDestroyWidget( message->w );
  free(message);
}



/*
  This function prompts the user for
  the record range to copies segments.
*/
void change_recordCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  Widget prompt;
  long id;	/* RJM: handle 64-bit architectures */
  ClientData *message;

  id=(long)client_data;

  sprintf(buf,"%d ",srec[id]);

  prompt=XmCreatePromptDialogVa(w,"prompt",
				XmNdialogTitle,XMstr("Change Record Number"),
				XmNtextString,XMstr(buf),
				XmNselectionLabelString,
				XMstr("FROM record to STARTING [ENDING] [INCREMENT] record number. "),
				NULL);
  XmRemoveTabGroup(prompt);
  XmAddTabGroup(XmSelectionBoxGetChild(prompt,XmDIALOG_TEXT));
  XmAddTabGroup(XmSelectionBoxGetChild(prompt,XmDIALOG_HELP_BUTTON));

  message=(ClientData *)malloc(sizeof(ClientData));
  message->w=prompt;
  message->id=id;
  XtAddCallback(prompt,XmNokCallback,attach_recordCB,message);
  XtAddCallback(prompt,XmNcancelCallback,destroyCB,prompt);
  XtAddCallback(prompt,XmNhelpCallback,helpCB,"record.help");
}



/*
  This function copies segments
  from one record to a range of others.
*/
void attach_recordCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  XmSelectionBoxCallbackStruct	*CBst = (XmSelectionBoxCallbackStruct*)call_data;
  ClientData *message=(ClientData *)client_data;
  int m,n,n1,n2,error,list[MAX_PICKS],count_list;
  int srec_num,erec_num,irec_num,rec_num,from_rec;
  long id;	/* RJM: handle 64-bit architectures */
  Boolean	flag;
  char *str;

  id=message->id;

				/* Get record range from prompt dialog. */
  XmStringGetLtoR(CBst->value,XmSTRING_DEFAULT_CHARSET,&str);

				/* Check if there was a record range. */
  if (! *str) {
    if( message->w != NULL )
      XtDestroyWidget( message->w );
    free(message);
    return;
  }

				/* Parses the record range. */
  error=sscanf(str,"%d %d %d %d",&from_rec,&srec_num,&erec_num,&irec_num);
  XtFree(str);

				/* Returns if no range was enter. */
  if ((error==0)||(error==1)) {
    if( message->w != NULL )
      XtDestroyWidget( message->w );
    free(message);
    return;
  }
				/* Sets the ending and increment. */
  if (error==2) {
    erec_num=srec_num;
    irec_num=1;
  }

				/* Sets the increment. */
  if (error==3) irec_num=1;

  count_list=0;			/* Loop through picks. To build list of
				   segments to be copied. */
  for (n=MAX_PICKS-1; n>=0; n--) 
    if ((picks[n].init==-1)&&
	(visible_segment(xdisplay[id].parent,picks[n].group))) {
      list[count_list]=n;
      count_list++;
    }

				/* Loop through the record range. */
  for (rec_num=srec_num; rec_num<=erec_num; rec_num+=irec_num)
    for (n2=0; n2<count_list; n2++) { /* Loop through the segment list. */
      n=list[n2];
      if ((picks[n].init==-1)&&
	  (visible_segment(xdisplay[id].parent,picks[n].group))) {
	flag=False;
/*	for (n1=srec[id]; n1<=erec[id]; n1+=irec[id])
	  if (*(picks[n].record)==n1) */
	if (*(picks[n].record)==from_rec)
	  flag=True;
	if (flag) {
				/* Setup for a new segment. */
	  m=next_picks();
	  picks[m].id=id;
	  picks[m].size=picks[n].size;
	  picks[m].record=(int *)malloc((unsigned)picks[m].size*sizeof(int));
	  picks[m].trace=(int *)malloc((unsigned)picks[m].size*sizeof(int));
	  picks[m].sample=(int *)malloc((unsigned)picks[m].size*sizeof(int));
	  picks[m].color=picks[n].color;
	  
				/* Loop through picks and copy. */
	  for (n1=0; n1<picks[m].size; n1++) {
	    *(picks[m].record+n1)=rec_num;
	    *(picks[m].trace+n1)=*(picks[n].trace+n1);
	    *(picks[m].sample+n1)=*(picks[n].sample+n1);
	  }
	}
      }
    }
  if( message->w != NULL )
    XtDestroyWidget( message->w );
  free(message);
}



/*
  This function copies segments
  from one record to a range of others.
*/
void copy_record1CB(Widget w, XtPointer client_data, XtPointer call_data)
{
  XmSelectionBoxCallbackStruct	*CBst = (XmSelectionBoxCallbackStruct*)call_data;
  ClientData *message=(ClientData *)client_data;
  int m,n,n1,n2,error,list[MAX_PICKS],count_list;
  int srec_num,erec_num;
  long id;	/* RJM: handle 64-bit architectures */
  char *str;

  id=message->id;

				/* Get record range from prompt dialog. */
  XmStringGetLtoR(CBst->value,XmSTRING_DEFAULT_CHARSET,&str);

				/* Check if there was a record range. */
  if (! *str) {
    if( message->w != NULL )
      XtDestroyWidget( message->w );
    free(message);
    return;
  }

				/* Parses for the record. */
  error=sscanf(str,"%d %d",&srec_num,&erec_num);
  XtFree(str);

				/* Returns if record was not enter. */
  if (error!=2) return;

  count_list=0;			/* Loop through picks. To build list of
				   segments to be copied. */
  for (n=MAX_PICKS-1; n>=0; n--) 
    if ((picks[n].init==-1)&&
	(visible_segment(xdisplay[id].parent,picks[n].group))) {
      list[count_list]=n;
      count_list++;
    }

				/* Loop through the record range. */
  for (n2=0; n2<count_list; n2++) { /* Loop through the segment list. */
    n=list[n2];
    if ((picks[n].init==-1)&&
	(visible_segment(xdisplay[id].parent,picks[n].group))) {

      if (*(picks[n].record)==srec_num) {
				/* Setup for a new segment. */
	m=next_picks();
	picks[m].id=id;
	picks[m].size=picks[n].size;
	picks[m].record=(int *)malloc((unsigned)picks[m].size*sizeof(int));
	picks[m].trace=(int *)malloc((unsigned)picks[m].size*sizeof(int));
	picks[m].sample=(int *)malloc((unsigned)picks[m].size*sizeof(int));
	picks[m].color=picks[n].color;
	
				/* Loop through picks and copy. */
	for (n1=0; n1<picks[m].size; n1++) {
	  *(picks[m].record+n1)=erec_num;
	  *(picks[m].trace+n1)=*(picks[n].trace+n1);
	  *(picks[m].sample+n1)=*(picks[n].sample+n1);
	}
      }
    }
  }
  if( message->w != NULL )
    XtDestroyWidget( message->w );
  free(message);
}




/*
  This function prompts the user for
  the record range to copies segments.
*/
void copy_recordCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  Widget prompt;
  long id;	/* RJM: handle 64-bit architectures */
  ClientData *message;

  id=(long)client_data;

  prompt=XmCreatePromptDialogVa(w,"prompt",
				XmNdialogTitle,XMstr("Copy Record"),
				XmNtextString,XMstr(""),
				XmNselectionLabelString,
				XMstr("Input FROM record and TO record number"),
				NULL);
  XmRemoveTabGroup(prompt);
  XmAddTabGroup(XmSelectionBoxGetChild(prompt,XmDIALOG_TEXT));
  XmAddTabGroup(XmSelectionBoxGetChild(prompt,XmDIALOG_HELP_BUTTON));

  message=(ClientData *)malloc(sizeof(ClientData));
  message->w=prompt;
  message->id=id;
  XtAddCallback(prompt,XmNokCallback,copy_record1CB,message);
  XtAddCallback(prompt,XmNcancelCallback,destroyCB,prompt);
  XtAddCallback(prompt,XmNhelpCallback,helpCB,"record.help");
}


/*
  This function deletes all the
  old picks.
*/
void new_picksCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  int n;

				/* Loop through pick list. */
  for (n=0; n<MAX_PICKS; n++)
    if (picks[n].init==-1)  {
				/* Free pick space. */
      if(picks[n].record)
        free((char *)picks[n].record); picks[n].record=NULL;
      if(picks[n].trace)
        free((char *)picks[n].trace); picks[n].trace=NULL;
      if(picks[n].sample)
        free((char *)picks[n].sample); picks[n].sample=NULL;
      picks[n].init=0;		/* Reset init so space can be reused. */
      strcpy(picks[n].label,"");
    }
  
  expose_all_images();
}


/*
  This function searchs the
  segment to find the segment
  nears to the mouse.
*/
void select_segment(XEvent *event, long id, long id_anim)
{
  int m,n,x,y,temp1,temp2;
  int temp_segment,temp_pick;
  int offset=(-1);
  char buf[3];

  if ((event->xbutton.button==Button2)||((event->xbutton.button==Button3))) {
    reset_mode(id,id_anim,True);
    return;
  }

				/* Button 1 is for selecting. */
  if (event->xbutton.button==Button1) {
				/* Get x and y according to zoom factor. */
    x=(event->xbutton.x*xdisplay[id_anim].pick_x);
    y=(event->xbutton.y*xdisplay[id_anim].pick_y);

			     /* Loop through segments to find the near one. */
    for (n=0; n<MAX_PICKS; n++) 
    {
/*if(picks[n].id != id_anim )
fprintf( stderr,"NOTE: select_segment: picks[n].id(%d) != id_anim(%d)\n", picks[n].id, id_anim);
*/
 
      if ((visible_segment(id_anim,picks[n].group))&&(picks[n].init==-1))
				/* Loop through picks to find the near one. */
	for (m=0; m<picks[n].size; m++) {
	  if (offset==-1) {
/*	    location=get_location(*(picks[n].record+m),*(picks[n].trace+m),*(picks[n].sample+m),id_anim); RJM */
	    location=get_location(picks[n].record[m],picks[n].trace[m],picks[n].sample[m],id_anim?id_anim:picks[n].id);
				/* Compute length of the pick from the mouse */
	    temp1=(location.x-x)*(location.x-x);
	    temp2=(location.y-y)*(location.y-y);
	    if (xdisplay[id_anim].record_flag) {
	      if ((*(picks[n].record+m)>=srec[id_anim])&&
		  (*(picks[n].record+m)<=erec[id_anim])) {
				/* Set the length to offset. */
		offset=temp1+temp2;
		temp_segment=n;
		temp_pick=m;
	      } 
	    } else {
				/* Set the length to offset. */
	      offset=temp1+temp2;
	      temp_segment=n;
	      temp_pick=m;
	    } 
	  }
/*	  location=get_location(*(picks[n].record+m),*(picks[n].trace+m),*(picks[n].sample+m),id_anim); RJM */
	  location=get_location(picks[n].record[m],picks[n].trace[m],picks[n].sample[m],id_anim?id_anim:picks[n].id);
				/* Compute length of the pick from the mouse */
	  temp1=(location.x-x)*(location.x-x);
	  temp2=(location.y-y)*(location.y-y);
	  if (xdisplay[id_anim].record_flag) {
				/* Check if offset is the smallest. */
	    if ((*(picks[n].record+m)>=srec[id_anim])&&
		(*(picks[n].record+m)<=erec[id_anim])&&
		((temp1+temp2)<offset)) {
				/* Set the length to offset. */
	      offset=temp1+temp2;
	      temp_segment=n;
	      temp_pick=m;
	    } 
	  } else 
				/* Check if offset is the smallest. */
	    if ((temp1+temp2)<offset) {
				/* Set the length to offset. */
	      offset=temp1+temp2;
	      temp_segment=n;
	      temp_pick=m;
	    }
	}
    }
  }


  if (offset==-1) return;      /* There are no picks. */


				/* temp_segment and temp_pick store
				   the near segment and pick to the mouse. */
  current_segment=temp_segment;
  current_pick=temp_pick;

  if (picks[current_segment].size!=1) {
    expose_some_picks(id,id_anim,current_segment);
  }
  draw_pix(id,id_anim,current_segment);
  draw_segment(id,id_anim);

  highlight_segment(id,id_anim);
				/* Update the text widget with 
				   the current segment.*/
  sprintf(buf,"%d",current_segment+1);
  XtSetArg(args[0],XmNvalue,buf);
  XtSetValues(xdisplay[id].number_text,args,1);

				/* Temporary store the segment to undo. */
  undo_id = picks[current_segment].id;
  for (n=0; n<picks[current_segment].size; n++) {
    pick_record[n]=*(picks[current_segment].record+n);
    pick_trace[n]=*(picks[current_segment].trace+n);
    pick_sample[n]=*(picks[current_segment].sample+n);
  }
  current_undo=current_segment;
  pick_size=picks[current_segment].size;

  return;
}


/*
  This function select a segment
  by number instead of the mouse.
*/
void select_by_numberCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  char *buf;
  long id,id_anim;	/* RJM: handle 64-bit architectures */
  int n;

  id=(long)client_data;
  id_anim=id;
  if (strcmp(xdisplay[id].filename,"Animation")==0)
    id_anim=animate_list[step_count];

				/* Get segment number from text widget. */
  XtSetArg(args[0],XmNvalue,&buf);
  XtGetValues(w,args,1);
  sscanf(buf,"%d",&current_segment);

				/* Decrement current_segment because
				   xsd internal array starts at 0. */
  current_segment--;

				/* Check if current_segment range is valid. */
  if (current_segment>=MAX_PICKS) {
    current_segment=(-1);
    return;
  }

				/* Check if current_segment exists. */
  if (picks[current_segment].init!=-1) {
    current_segment=(-1);
    return;
  }

				/* Make current pick zero. */
  current_pick=0;

  if (picks[current_segment].size!=1) {
    expose_some_picks(id,id_anim,current_segment);
  }
  draw_pix(id,id_anim,current_segment);
  draw_segment(id,id_anim);
  highlight_segment(id,id_anim);

				/* Temporary store the segment to undo. */
  for (n=0; n<picks[current_segment].size; n++) {
    pick_record[n]=*(picks[current_segment].record+n);
    pick_trace[n]=*(picks[current_segment].trace+n);
    pick_sample[n]=*(picks[current_segment].sample+n);
  }
  current_undo=current_segment;
  pick_size=picks[current_segment].size;
}


/*
  This function undoes
  the last edit operation.
*/
void undoCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  int n;
  long id;	/* RJM: handle 64-bit architectures */

  id=(long)client_data;

  if (current_undo==-1) 
    return;

  if (picks[current_undo].init!=-1)
    return;

				/* Undo by copying picks from undo storage. */
  for (n=0; n<picks[current_undo].size; n++) {
    *(picks[current_undo].record+n)=pick_record[n];
    *(picks[current_undo].trace+n)=pick_trace[n];
    *(picks[current_undo].sample+n)=pick_sample[n];
  }
  picks[current_undo].size=pick_size;
  picks[current_undo].id=undo_id;
  picks[current_undo].init=-1;

  expose_all_images();
  expose_all_picks();

  current_pick=(-1);
  current_segment=(-1);
  current_undo=(-1);
  xdisplay[id].mode=2;
  set_mode_label(2,id);
}


/*
  This function moves a pick.
*/
void move_pick(XEvent *event, long id, long id_anim)
{
  int temp_pick,x,y;

  if (current_segment==-1) {
    select_segment(event,id,id_anim);
    return;
  }

  if (event->xbutton.button==Button2) {
    return;
  }

  if (event->xbutton.button==Button3) {
    reset_mode(id,id_anim,True);
    return;
  }


  if (event->xbutton.button==Button1) {
    x=(event->xbutton.x*xdisplay[id_anim].pick_x);
    y=(event->xbutton.y*xdisplay[id_anim].pick_y);
    temp_pick=close_pick(x,y,id_anim);
  }

  clear_subsegment(id,id_anim);

  current_pick=temp_pick;

  values=get_values(x,y,id_anim);

				/* Save new pick location. */
  *(picks[current_segment].trace+current_pick)=values.trace;
  *(picks[current_segment].sample+current_pick)=values.sample;

if( picks[current_segment].id != id_anim )
fprintf( stderr, "move_pick NOTE: picks[current_segment].id(%d) != id_anim(%d)\n", picks[current_segment].id, id_anim );

  draw_picks(current_segment,id,id_anim);

  return;
}




/*
  This function moves a pick 
  while the mouse is still moving.
*/
void moving_pick_point(XEvent *event, long id, long id_anim)
{
  int x,y;

  if (current_segment==-1) {
    reset_mode(id,id_anim,True);
    return;
  }

  x=(event->xbutton.x*xdisplay[id_anim].pick_x);
  y=(event->xbutton.y*xdisplay[id_anim].pick_y);

  clear_subsegment(id,id_anim);
  
  values=get_values(x,y,id_anim);
				/* Save new pick location. */
  *(picks[current_segment].trace+current_pick)=values.trace;
  *(picks[current_segment].sample+current_pick)=values.sample;

if( picks[current_segment].id != id_anim )
fprintf( stderr, "moving_pick_point NOTE: picks[current_segment].id(%d) != id_anim(%d)\n", picks[current_segment].id, id_anim );


  draw_picks(current_segment,id,id_anim);

  return;
}


/*
  This function clears the smallest image
  area it can for current pick be changed.
*/
void clear_subsegment(long id, long id_anim)
{
  int m,n;
  int x2,y2,size;
  int x_max,x_min,y_max,y_min;

  n=current_segment;
  m=current_pick;

				/* Find the current pick location. */
/*location=get_location(*(picks[n].record+m),*(picks[n].trace+m),*(picks[n].sample+m),id_anim); RJM */
  location=get_location(picks[n].record[m],picks[n].trace[m],picks[n].sample[m],id_anim?id_anim:picks[n].id);
  x_max=(int)location.x/xdisplay[id_anim].pick_x;
  y_max=(int)location.y/xdisplay[id_anim].pick_y;
  x_min=x_max;
  y_min=y_max;

  if (m>0) {
				/* Find the location of the pick 
				   next to the current one. */
/*  location=get_location(*(picks[n].record+m-1),*(picks[n].trace+m-1),*(picks[n].sample+m-1),id_anim); RJM */
    location=get_location(picks[n].record[m-1],picks[n].trace[m-1],picks[n].sample[m-1],id_anim?id_anim:picks[n].id);
				/* Find the min and max boundaries. */
    x2=(int)location.x/xdisplay[id_anim].pick_x;
    if (x2 < x_min) x_min=x2;
    if (x2 > x_max) x_max=x2;
    y2=(int)location.y/xdisplay[id_anim].pick_y;
    if (y2 < y_min) y_min=y2;
    if (y2 > y_max) y_max=y2;
  }

  if (m<picks[n].size-1) {
				/* Find the location of the pick 
				   next to the current one. */
    m=current_pick;
/*  location=get_location(*(picks[n].record+m+1),*(picks[n].trace+m+1),*(picks[n].sample+m+1),id_anim); RJM */
    location=get_location(picks[n].record[m+1],picks[n].trace[m+1],picks[n].sample[m+1],id_anim?id_anim:picks[n].id);
				/* Find the min and max boundaries. */
    x2=(int)location.x/xdisplay[id_anim].pick_x;
    if (x2 < x_min) x_min=x2;
    if (x2 > x_max) x_max=x2;
    y2=(int)location.y/xdisplay[id_anim].pick_y;
    if (y2 < y_min) y_min=y2;
    if (y2 > y_max) y_max=y2;
  }

				/* Compute the node size. */
  if (line_width<=1)
    size=4;
  else
    size=4+line_width;

				/* Account for the node size. */
  if (x_min>size) x_min-=size;
  if (y_min>size) y_min-=size;
  if (x_max<xdisplay[id].image->width-size) x_max+=size;
  if (y_max<xdisplay[id].image->height-size) y_max+=size;

				/* Redraw the boundary. */
  XCopyArea(display,pix,xdisplay[id].top,xdisplay[id].gc,
	    x_min,y_min,(x_max-x_min),(y_max-y_min),
	    x_min,y_min);
}



/*
  This function adds picks
  to the current segment.
*/
void add_pick(XEvent *event, long id, long id_anim)
{
  int x1,y1,x2,y2;
  int m,n,temp_pick;
  int x,y;

  if (current_segment==-1) {
    select_segment(event,id,id_anim);
    return;
  }
  
				/* Undo last entry. */
  if (event->xbutton.button==Button2) {
    if( count <= 0 )	/* RJM: added */
      return;

    XSetForeground(display,xdisplay[id].gc,picks[current_segment].color);
    x1=pick_x[count-1]/xdisplay[id_anim].pick_x;
    y1=pick_y[count-1]/xdisplay[id_anim].pick_y;
    XCopyArea(display,pix,xdisplay[id].top,xdisplay[id].gc,
	      0,0,xdisplay[id_anim].image->width,
	      xdisplay[id_anim].image->height,0,0);
    count--;
    if (count<0) 
      count=0;
				/* Redraw pick segment. */
/*  if (count!=0) {	RJM: replaced */
    if (count>0) {
      x1=pick_x[count-1]/xdisplay[id_anim].pick_x;
      y1=pick_y[count-1]/xdisplay[id_anim].pick_y;
      x2=pick_x[count]/xdisplay[id_anim].pick_x;
      y2=pick_y[count]/xdisplay[id_anim].pick_y;
      XDrawLine(display,xdisplay[id].top,xdisplay[id].gc,x1,y1,x2,y2);
    }
    start_x=event->xbutton.x;
    start_y=event->xbutton.y;
    x1=pick_x[count-1]/xdisplay[id_anim].pick_x;
    y1=pick_y[count-1]/xdisplay[id_anim].pick_y;
    XDrawLine(display,xdisplay[id].top,xdisplay[id].gc,x1,y1,start_x,start_y);
				/* Redraw the segment. */
    for (n=1; n<count; n++) 
      XDrawLine(display,xdisplay[id].top,xdisplay[id].gc,
		pick_x[n-1],pick_y[n-1],pick_x[n],pick_y[n]);
	    
    return;
  }
				/* End adding picks. */
  if (event->xbutton.button==Button3) {
    if( count <= 0 ) {	/* RJM: added */
      return;
    }
				/* Get larger space for segment. */
    picks[current_segment].size=picks[current_segment].size+count-1;
    picks[current_segment].record=(int *)realloc((char *)picks[current_segment].record,
				   (unsigned)picks[current_segment].size*sizeof(int));
    picks[current_segment].trace=(int *)realloc((char *)picks[current_segment].trace,
				  (unsigned)picks[current_segment].size*sizeof(int));
    picks[current_segment].sample=(int *)realloc((char *)picks[current_segment].sample,
				   (unsigned)picks[current_segment].size*sizeof(int));

				/* Move picks so there is room. */
    for (m=picks[current_segment].size-1; m>=start_adding+count; m--) {
      *(picks[current_segment].record+m)=*(picks[current_segment].record+m-(count-1));
      *(picks[current_segment].trace+m)=*(picks[current_segment].trace+m-(count-1));
      *(picks[current_segment].sample+m)=*(picks[current_segment].sample+m-(count-1));
    }

if( picks[current_segment].id != id_anim )
fprintf( stderr, "add_pick NOTE: picks[current_segment].id(%d) != id_anim(%d)\n", picks[current_segment].id, id_anim );

				/* Add new picks. */
    for (m=1; m<count; m++) {
      values=get_values(pick_x[m],pick_y[m],id_anim);
      *(picks[current_segment].record+m+start_adding)=*(picks[current_segment].record+start_adding);
      *(picks[current_segment].trace+m+start_adding)=values.trace;
      *(picks[current_segment].sample+m+start_adding)=values.sample;
    }
    expose_all_images();
    expose_all_picks();
    reset_mode(id,id_anim,True);
    count=0;
    return;
  }

				/* Selecting segment and pick. */
  if (count==0) {
    if (event->xbutton.button==Button1) {
      x=(event->xbutton.x*xdisplay[id_anim].pick_x);
      y=(event->xbutton.y*xdisplay[id_anim].pick_y);
      temp_pick=close_pick(x,y,id_anim);
    }
/*if(picks[current_segment].id != id_anim )
fprintf( stderr,"NOTE: add_pick: picks[current_segment].id(%d) != id_anim(%d)\n", picks[current_segment].id, id_anim);
*/
 
/*  location=get_location(*(picks[current_segment].record+temp_pick),*(picks[current_segment].trace+temp_pick),*(picks[current_segment].sample+temp_pick),id_anim); RJM */
    location=get_location(picks[current_segment].record[temp_pick],picks[current_segment].trace[temp_pick],picks[current_segment].sample[temp_pick],id_anim?id_anim:picks[current_segment].id);
    pick_x[count]=location.x;
    pick_y[count]=location.y;
    start_x=pick_x[count]/xdisplay[id_anim].pick_x;
    start_y=pick_y[count]/xdisplay[id_anim].pick_y;
    count++;
    if (count>=MAX_P_LIST) {
      error_message("Too many picks are being used");
      count--;
    }
    start_adding=temp_pick;
    XSetForeground(display,xdisplay[id].gc,picks[current_segment].color);
    m=temp_pick+1;
/*  location=get_location(*(picks[current_segment].record+m-1),*(picks[current_segment].trace+m-1),*(picks[current_segment].sample+m-1),id_anim);	RJM */
    location=get_location(picks[current_segment].record[m-1],picks[current_segment].trace[m-1],picks[current_segment].sample[m-1],id_anim?id_anim:picks[current_segment].id);
    x1=(int)location.x/xdisplay[id_anim].pick_x;
    y1=(int)location.y/xdisplay[id_anim].pick_y;
/*  location=get_location(*(picks[current_segment].record+m),*(picks[current_segment].trace+m),*(picks[current_segment].sample+m),id_anim); RJM */
    location=get_location(picks[current_segment].record[m],picks[current_segment].trace[m],picks[current_segment].sample[m],id_anim?id_anim:picks[current_segment].id);
    x2=(int)location.x/xdisplay[id_anim].pick_x;
    y2=(int)location.y/xdisplay[id_anim].pick_y;
    XDrawLine(display,xdisplay[id].top,xdisplay[id].gc,x1,y1,x2,y2);
  } else {			/* Add pick point. */
    if (event->xbutton.button==Button1) {
      x=(event->xbutton.x*xdisplay[id_anim].pick_x);
      y=(event->xbutton.y*xdisplay[id_anim].pick_y);
      pick_x[count]=x;
      pick_y[count]=y;
      count++;
    }
  }
  return;
}



/*
  This function shows the picks
  are being added while the mouse is moving.
*/
void moving_add_pick(XEvent *event, long id, long id_anim)
{
  int n,x_min,y_min,x_max,y_max;
  int x1,y1,x2,y2;

  if (count==0) return;
  n=current_segment;

  XSetLineAttributes(display,xdisplay[id].gc,line_width,
                     LineSolid,CapNotLast,JoinRound);
  XSetForeground(display,xdisplay[id].gc,picks[n].color);

				/* Find the pick before the one being add. */
  x1=pick_x[count-1]/xdisplay[id_anim].pick_x;
  y1=pick_y[count-1]/xdisplay[id_anim].pick_y;

				/* Find the min and max boundary. */
  x_min=x1;
  x_max=x1;
  y_min=y1;
  y_max=y1;
  if (start_x < x_min) x_min=start_x;
  if (start_x > x_max) x_max=start_x;
  if (start_y < y_min) y_min=start_y;
  if (start_y > y_max) y_max=start_y;

				/* Redraw the boundary region. */
  XCopyArea(display,pix,xdisplay[id].top,xdisplay[id].gc,
	     x_min,y_min,(x_max-x_min)+5,(y_max-y_min)+5,
	     x_min,y_min);

				/* Redraw the picks being added. */
  for (n=1; n<count; n++) {
    x1=pick_x[n-1]/xdisplay[id_anim].pick_x;
    y1=pick_y[n-1]/xdisplay[id_anim].pick_y;
    x2=pick_x[n]/xdisplay[id_anim].pick_x;
    y2=pick_y[n]/xdisplay[id_anim].pick_y;
    XDrawLine(display,xdisplay[id].top,xdisplay[id].gc,
	      x1,y1,x2,y2);
  }
	    

  start_x=event->xbutton.x;
  start_y=event->xbutton.y;

  x1=pick_x[count-1]/xdisplay[id_anim].pick_x;
  y1=pick_y[count-1]/xdisplay[id_anim].pick_y;

				/* Draw line to the current mouse location. */
  XDrawLine(display,xdisplay[id].top,xdisplay[id].gc,x1,y1,start_x,start_y);
}


/*
  This function delete a pick.
*/
void delete_pick(XEvent *event, long id, long id_anim)
{
  int temp_pick;
  int x,y;
  int temp1;

  if (current_segment==-1) {
    select_segment(event,id,id_anim);
    return;
  }

  if (event->xbutton.button==Button2)
    return;
 
  if (event->xbutton.button==Button3) {
    reset_mode(id,id_anim,True);
    return;
  }

  if (event->xbutton.button==Button1) {
    x=(event->xbutton.x*xdisplay[id_anim].pick_x);
    y=(event->xbutton.y*xdisplay[id_anim].pick_y);
    temp_pick=close_pick(x,y,id_anim);
  }

				/* Redraw the display. */
  XCopyArea(display,pix,xdisplay[id].top,xdisplay[id].gc,
	    0,0,xdisplay[id_anim].image->width,
	    xdisplay[id_anim].image->height,0,0);

  current_pick=temp_pick;

  picks[current_segment].size--;
  temp1=(picks[current_segment].size-current_pick)*sizeof(int);
				/* Move picks over the deleted one. */
  memcpy((char *)(picks[current_segment].record+current_pick),
	 (char *)(picks[current_segment].record+current_pick+1),temp1);
  memcpy((char *)(picks[current_segment].trace+current_pick),
	 (char *)(picks[current_segment].trace+current_pick+1),temp1);
  memcpy((char *)(picks[current_segment].sample+current_pick),
	 (char *)(picks[current_segment].sample+current_pick+1),temp1);

				/* Redraw the new segment. */
  draw_picks(current_segment,id,id_anim);

  return;
}



/*
  This function is for storing the start
  point when a segment is being moved.
  The segment is move according to the 
  offset of the mouse to the starting point.
*/
void start_moving_segment(XEvent *event, long id, long id_anim)
{
  if (current_segment==-1) {
    select_segment(event,id,id_anim);
  }

  if (event->xbutton.button==Button2)
    return;

  if (event->xbutton.button==Button3) {
    reset_mode(id,id_anim,True);
    return;
  }

  if (event->xbutton.button==Button1) {
				/* Compute start x and y according to zoom. */
    start_x=(event->xbutton.x*xdisplay[id_anim].pick_x);
    start_y=(event->xbutton.y*xdisplay[id_anim].pick_y);  
  }

  return;
}


/*
  This function moves the segment
  as the mouse moves.
*/
void moving_segment(XEvent *event, long id, long id_anim)
{
  int m,x,y,dx,dy;

				/* Compute the x and y according to zoom. */
  x=(event->xbutton.x*xdisplay[id_anim].pick_x);
  y=(event->xbutton.y*xdisplay[id_anim].pick_y);

				/* Compute dx and dy. */
  values=get_values(x,y,id_anim);
  dx=values.trace;
  dy=values.sample;

  values=get_values(start_x,start_y,id_anim);
  dx-=values.trace;
  dy-=values.sample;

				/* Update the start x and y. */
  start_x=x;
  start_y=y;

				/* Refresh image. */
  XCopyArea(display,pix,xdisplay[id].top,xdisplay[id].gc,
	    0,0,xdisplay[id_anim].image->width,
	    xdisplay[id_anim].image->height,0,0);

if( picks[current_segment].id != id_anim )
fprintf( stderr, "moving_segment NOTE: picks[current_segment].id(%d) != id_anim(%d)\n", picks[current_segment].id, id_anim );

				/* Move the segment. */
  for (m=0; m<picks[current_segment].size; m++) {
    *(picks[current_segment].trace+m)+=dx;
    *(picks[current_segment].sample+m)+=dy;
  }

				/* Redraw the segment. */
  draw_picks(current_segment,id,id_anim);
}



/*
  This function rounds pick points.
*/
void round_picks(XEvent *event, long id, long id_anim)
{
  int m,n,x,y,value;
  int temp1,temp2,temp_segment,temp_pick;
  int offset=(-1);

  if (event->xbutton.button==Button2)
    return;

				/* Reset the rounding parameters. */
  if (event->xbutton.button==Button3) {
    round_x=(-1);
    start_x=(-1);
    reset_mode(id,id_anim,True);
    return;
  }

				/* First need a reference point 
				   for rounding. */
  if (round_x==-1) {
				/* Compute x and y according to zoom. */
    round_x=(event->xbutton.x*xdisplay[id_anim].pick_x);
    round_y=(event->xbutton.y*xdisplay[id_anim].pick_y);
    x=event->xbutton.x;
    y=event->xbutton.y;

				/* Round to a point. Mark point "X". */
    if (xdisplay[id].mode==9) {
      XDrawLine(display,xdisplay[id].top,xdisplay[id].gc,x-5,y+5,x+5,y-5);
      XDrawLine(display,xdisplay[id].top,xdisplay[id].gc,x-5,y-5,x+5,y+5);
    }

				/* Round to a horizontal line. */
    if (xdisplay[id].mode==10)
      XDrawLine(display,xdisplay[id].top,xdisplay[id].gc,0,y,xdisplay[id].image->width,y);

				/* Round to a vertial line. */
    if (xdisplay[id].mode==11)
      XDrawLine(display,xdisplay[id].top,xdisplay[id].gc,x,0,x,xdisplay[id].image->height);
    return;
  }

  temp_segment=(-1);
				/* Compute x and y according to zoom. */
  x=(event->xbutton.x*xdisplay[id_anim].pick_x);
  y=(event->xbutton.y*xdisplay[id_anim].pick_y);
				/* Loop through picks to find the near. */
  for (n=0; n<MAX_PICKS; n++) 
    if (visible_segment(id,picks[n].group)) {
      if (picks[n].init==-1) {
	for (m=0; m<picks[n].size; m++) {
	  if (offset==-1) {
/*	    location=get_location(*(picks[n].record+m),*(picks[n].trace+m),*(picks[n].sample+m),id_anim); RJM */
	    location=get_location(picks[n].record[m],picks[n].trace[m],picks[n].sample[m],id_anim?id_anim:picks[n].id);
	    temp1=(location.x-x)*(location.x-x);
	    temp2=(location.y-y)*(location.y-y);
	    offset=temp1+temp2;
	    temp_segment=n;
	    temp_pick=m;
	  }
/*	  location=get_location(*(picks[n].record+m),*(picks[n].trace+m),*(picks[n].sample+m),id_anim); RJM */
	  location=get_location(picks[n].record[m],picks[n].trace[m],picks[n].sample[m],id_anim?id_anim:picks[n].id);
	  temp1=(location.x-x)*(location.x-x);
	  temp2=(location.y-y)*(location.y-y);
	  if ((temp1+temp2)<offset) {
	    offset=temp1+temp2;
	    temp_segment=n;
	    temp_pick=m;
	  }
	}
      }
    }
  if (temp_segment==-1) return;
  value=xdisplay[id].mode;

/*values=get_values(round_x,round_y,id_anim); RJM */
  values=get_values(round_x,round_y,picks[temp_segment].id);

/* if( picks[temp_segment].id != id_anim )
fprintf( stderr, "round_picks NOTE: picks[temp_segment].id(%d) != id_anim(%d)\n", picks[temp_segment].id, id_anim );
*/

				/* Round pick to a point. */
  if (value==9) {
    *(picks[temp_segment].trace+temp_pick)=values.trace;
    *(picks[temp_segment].sample+temp_pick)=values.sample;
  }

				/* Round pick to a horizontal line. */
  if (value==11) {
    *(picks[temp_segment].trace+temp_pick)=values.trace;
  }

				/* Round pick to a vertical line. */
  if ((value==9)||(value==10))
    *(picks[temp_segment].sample+temp_pick)=values.sample;


  expose_all_images();
  expose_all_picks();

  expose_animation(id,id_anim);
  expose_picks_animation(id,id_anim);

				/* Recompute the x and y reference. */
  x=round_x/xdisplay[id_anim].pick_x;
  y=round_y/xdisplay[id_anim].pick_y;

				/* Redraw the reference point. */
  if (xdisplay[id].mode==9) {
    XDrawLine(display,xdisplay[id].top,xdisplay[id].gc,x-5,y+5,x+5,y-5);
    XDrawLine(display,xdisplay[id].top,xdisplay[id].gc,x-5,y-5,x+5,y+5);
  }

				/* Redraw the reference line. */
  if (xdisplay[id].mode==10)
    XDrawLine(display,xdisplay[id].top,xdisplay[id].gc,0,y,xdisplay[id].image->width,y);

				/* Redraw the reference line. */
  if (xdisplay[id].mode==11)
    XDrawLine(display,xdisplay[id].top,xdisplay[id].gc,x,0,x,xdisplay[id].image->height);

  return;
}



/*
  This function round a pick point
  to either the left of right boundary.
*/
void round_picks_side(XEvent *event, long id, long id_anim)
{
  int x,y,m,n,temp1,temp2,offset=(-1);
  int temp_segment,temp_pick;

  temp_segment=(-1);
  if (event->xbutton.button==Button1) {
				/* Compute x and y according to zoom. */
    x=(event->xbutton.x*xdisplay[id_anim].pick_x);
    y=(event->xbutton.y*xdisplay[id_anim].pick_y);
				/* Loop through pick to find near pick. */
    for (n=0; n<MAX_PICKS; n++) 
      if (visible_segment(id,picks[n].group)) {
	if (picks[n].init==-1) {
	  for (m=0; m<picks[n].size; m++) {
	    if (offset==-1) {
/*	      location=get_location(*(picks[n].record+m),*(picks[n].trace+m),*(picks[n].sample+m),id_anim); RJM */
	      location=get_location(picks[n].record[m],picks[n].trace[m],picks[n].sample[m],id_anim?id_anim:picks[n].id);
	      temp1=(location.x-x)*(location.x-x);
	      temp2=(location.y-y)*(location.y-y);
	      offset=temp1+temp2;
	      temp_segment=n;
	      temp_pick=m;
	    }
/*	    location=get_location(*(picks[n].record+m),*(picks[n].trace+m),*(picks[n].sample+m),id_anim); RJM */
	    location=get_location(picks[n].record[m],picks[n].trace[m],picks[n].sample[m],id_anim?id_anim:picks[n].id);
	    temp1=(location.x-x)*(location.x-x);
	    temp2=(location.y-y)*(location.y-y);
	    if ((temp1+temp2)<offset) {
	      offset=temp1+temp2;
	      temp_segment=n;
	      temp_pick=m;
	    }
	  }
	}
      }
    if (temp_segment==-1) return;

				/* Round pick to the left. */
    if (xdisplay[id].mode==15)
      x=0;
    
				/* Round pick to the right. */
    if (xdisplay[id].mode==16)
      x=(xdisplay[id_anim].image->width*xdisplay[id_anim].pick_x)+1;
    
    
    if ((xdisplay[id].mode==15)||(xdisplay[id].mode==16)) {
/*    values=get_values(x,0,id_anim); RJM */
      values=get_values(x,0,picks[temp_segment].id);

/*if( picks[temp_segment].id != id_anim )
fprintf( stderr, "round_picks_side NOTE: picks[temp_segment].id(%d) != id_anim(%d)\n", picks[temp_segment].id, id_anim );
*/

				/* Store new pick. */
      *(picks[temp_segment].trace+temp_pick)=values.trace;
    }
				/* Round pick to the top. */
    if (xdisplay[id].mode==29)
      y=0;
    
				/* Round pick to the bottom. */
    if (xdisplay[id].mode==30)
      y=(xdisplay[id_anim].image->height*xdisplay[id_anim].pick_y)+1;
    
    
    if ((xdisplay[id].mode==29)||(xdisplay[id].mode==30)) {
/*    values=get_values(0,y,id_anim); RJM */
      values=get_values(0,y,picks[temp_segment].id);
    
/*if( picks[temp_segment].id != id_anim )
fprintf( stderr, "round_picks_side NOTE: picks[temp_segment].id(%d) != id_anim(%d)\n", picks[temp_segment].id, id_anim );
*/

				/* Store new pick. */
      *(picks[temp_segment].sample+temp_pick)=values.sample;
    }


    expose_all_images();
    expose_all_picks();
    
    expose_animation(id,id_anim);
    expose_picks_animation(id,id_anim);
  }

  if (event->xbutton.button==Button2)
    return;

  if (event->xbutton.button==Button3)
    reset_mode(id,id_anim,True);

  return;
}



/*
  This function reset the round
  locations.
*/
void reset_roundCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  long id,id_anim;	/* RJM: handle 64-bit architectures */

  id=(long)client_data;
  id_anim=id;
  if (strcmp(xdisplay[id].filename,"Animation")==0)
    id_anim=animate_list[step_count];

				/* Reset from rounding. */
  round_x=(-1);
  start_x=(-1);


  expose_all_images();
  expose_all_picks();
  
  expose_animation(id,id_anim);
  expose_picks_animation(id,id_anim);
}


/*
  This function draw the current
  segment is a highlight color.
*/
void highlight_segment(long id, long id_anim)
{
  int m,n;
  int x1,x2,y1,y2;

  n=current_segment;

				/* Set color to the hightlight color. */
  XSetForeground(display,xdisplay[id].gc,(Pixel)(start_pick_color-1L));

				/* Loop through and draw the pick points. */
  for (m=1; m<picks[n].size; m++) {
/*  location=get_location(*(picks[n].record+m-1),*(picks[n].trace+m-1),*(picks[n].sample+m-1),id_anim); RJM */
    location=get_location(picks[n].record[m-1],picks[n].trace[m-1],picks[n].sample[m-1],id_anim?id_anim:picks[n].id);
    x1=(int)location.x/xdisplay[id_anim].pick_x;
    y1=(int)location.y/xdisplay[id_anim].pick_y,
/*  location=get_location(*(picks[n].record+m),*(picks[n].trace+m),*(picks[n].sample+m),id_anim); RJM */
    location=get_location(picks[n].record[m],picks[n].trace[m],picks[n].sample[m],id_anim?id_anim:picks[n].id);
    x2=(int)location.x/xdisplay[id_anim].pick_x;
    y2=(int)location.y/xdisplay[id_anim].pick_y;
    XDrawLine(display,xdisplay[id].top,xdisplay[id].gc,x1,y1,x2,y2);
    XFillArc(display,xdisplay[id].top,xdisplay[id].gc,x1-2,y1-2,4,4,0,23040);
  }
  if (picks[n].size==1) {
    m=0;
/*  location=get_location(*(picks[n].record+m),*(picks[n].trace+m),*(picks[n].sample+m),id_anim); RJM */
    location=get_location(picks[n].record[m],picks[n].trace[m],picks[n].sample[m],id_anim?id_anim:picks[n].id);
    x2=(int)location.x/xdisplay[id_anim].pick_x;
    y2=(int)location.y/xdisplay[id_anim].pick_y;
  }
  XFillArc(display,xdisplay[id].top,xdisplay[id].gc,x2-2,y2-2,4,4,0,23040);

				/* Reset the color. */
  XSetForeground(display,xdisplay[id].gc,picks[n].color);
}



/*
  This function redraw the 
  current segment.
*/
void draw_segment(long id, long id_anim)
{
  int m,n;
  int x1,x2,y1,y2;

  n=current_segment;


  XSetFunction(display,xdisplay[id].gc,GXequiv);

				/* Set the correct color. */
  XSetForeground(display,xdisplay[id].gc,picks[n].color);

				/* Loop through and draw the pick points. */
  for (m=1; m<picks[n].size; m++) {
/*  location=get_location(*(picks[n].record+m-1),*(picks[n].trace+m-1),*(picks[n].sample+m-1),id_anim); RJM */
    location=get_location(picks[n].record[m-1],picks[n].trace[m-1],picks[n].sample[m-1],id_anim?id_anim:picks[n].id);
    x1=(int)location.x/xdisplay[id_anim].pick_x;
    y1=(int)location.y/xdisplay[id_anim].pick_y,
/*  location=get_location(*(picks[n].record+m),*(picks[n].trace+m),*(picks[n].sample+m),id_anim); RJM */
    location=get_location(picks[n].record[m],picks[n].trace[m],picks[n].sample[m],id_anim?id_anim:picks[n].id);
    x2=(int)location.x/xdisplay[id_anim].pick_x;
    y2=(int)location.y/xdisplay[id_anim].pick_y;
    XDrawLine(display,xdisplay[id].top,xdisplay[id].gc,x1,y1,x2,y2);
    XFillArc(display,xdisplay[id].top,xdisplay[id].gc,x1-2,y1-2,4,4,0,23040);
  }
  if (picks[n].size==1) {
    m=0;
/*  location=get_location(*(picks[n].record+m),*(picks[n].trace+m),*(picks[n].sample+m),id_anim); RJM */
    location=get_location(picks[n].record[m],picks[n].trace[m],picks[n].sample[m],id_anim?id_anim:picks[n].id);
    x2=(int)location.x/xdisplay[id_anim].pick_x;
    y2=(int)location.y/xdisplay[id_anim].pick_y;
  }
  XFillArc(display,xdisplay[id].top,xdisplay[id].gc,x2-2,y2-2,4,4,0,23040);

  XSetFunction(display,xdisplay[id].gc,GXcopy);
}


/*
  This function deletes a segment.
*/
void delete_segment(XEvent *event, long id, long id_anim)
{
  if (current_segment==-1) {
    select_segment(event,id,id_anim);
    return;
  }

  if (event->xbutton.button==Button2)
    return;

  if (event->xbutton.button==Button3)
    return;
				/* Free segment space. */
  picks[current_segment].init=0;

  reset_mode(id,id_anim,True);
  
  return;
}


/*
  This function duplicate or
  copies a segment.
*/
void duplicate_segment(XEvent *event, long id, long id_anim)
{
  int m,n,count;

  if (current_segment==-1) {
    select_segment(event,id,id_anim);
    return;
  }

  if (event->xbutton.button==Button2)
    return;

  if (event->xbutton.button==Button3) {
    reset_mode(id,id_anim,True);
    return;
  }
  count=picks[current_segment].size;

				/* Get space for new segment. */
  m=next_picks();
  picks[m].id=id;
  picks[m].record=(int *)malloc((unsigned)count*sizeof(int));
  picks[m].trace=(int *)malloc((unsigned)count*sizeof(int));
  picks[m].sample=(int *)malloc((unsigned)count*sizeof(int));
  
				/* Copy segment into the new space. */
  memcpy((char *)picks[m].record,(char *)picks[current_segment].record,count*sizeof(int));
  memcpy((char *)picks[m].trace,(char *)picks[current_segment].trace,count*sizeof(int));
  memcpy((char *)picks[m].sample,(char *)picks[current_segment].sample,count*sizeof(int));
  picks[m].size=count;
  picks[m].color=xdisplay[id].pick_color;

				/* Offset the duplicate. */
  for (n=0; n<picks[m].size; n++)
    *(picks[current_segment].sample+n)+=3;

  reset_mode(id,id_anim,True);

  return;
}


/*
  This function splits a segment.
*/
void split_segment(XEvent *event, long id, long id_anim)
{
  int n,temp_pick;
  int x,y;

  if (current_segment==-1) {
    select_segment(event,id,id_anim);
    return;
  }


  n=current_segment;

  if ((event->xbutton.button==Button2)||
      (event->xbutton.button==Button3)) {
    expose_all_picks();
    current_segment=(-1);
    return;
  }

				/* Find the near pick. */
  if (event->xbutton.button==Button1) {
    x=(event->xbutton.x*xdisplay[id_anim].pick_x);
    y=(event->xbutton.y*xdisplay[id_anim].pick_y);
    temp_pick=close_pick(x,y,id_anim);
  }

  draw_segment(id,id_anim);

  current_pick=temp_pick;

				/* Get new space for segment. */
  n=next_picks();
  picks[n].id=id;
  picks[n].size=picks[current_segment].size-current_pick;
  picks[current_segment].size=current_pick+1;
  
  picks[n].record=(int *)malloc((unsigned)picks[n].size*sizeof(int));
  picks[n].trace=(int *)malloc((unsigned)picks[n].size*sizeof(int));
  picks[n].sample=(int *)malloc((unsigned)picks[n].size*sizeof(int));

				/* Copy the split part into the new space. */
  memcpy((char *)picks[n].record,
	 (char *)(picks[current_segment].record+current_pick),
	 picks[n].size*sizeof(int));
  memcpy((char *)picks[n].trace,
	 (char *)(picks[current_segment].trace+current_pick),
	 picks[n].size*sizeof(int));
  memcpy((char *)picks[n].sample,
	 (char *)(picks[current_segment].sample+current_pick),
	 picks[n].size*sizeof(int));
  picks[n].color=xdisplay[id_anim].pick_color;

  reset_mode(id,id_anim,True);

  return;
}


/*
  This function joins to segments.
*/
void join_segments(XEvent *event, long id, long id_anim)
{
  int x1,y1;
  int m,n,temp_pick;
  int x,y;
  int temp1;

  if (current_segment==-1) {
    select_segment(event,id,id_anim);
  }

  n=current_segment;

  if (event->xbutton.button==Button2) {
    reset_mode(id,id_anim,True);
    join_segment=(-1);    
    return;
  }
  if (event->xbutton.button==Button3) {
    reset_mode(id,id_anim,True);
    return;
  }

  if (event->xbutton.button==Button1) {
    x=(event->xbutton.x*xdisplay[id_anim].pick_x);
    y=(event->xbutton.y*xdisplay[id_anim].pick_y);
    temp_pick=close_pick(x,y,id_anim);
    if (temp_pick<(picks[n].size/2))
      temp_pick=0;
    else
      temp_pick=picks[n].size-1;
  }

  if (join_segment==-1) {
    join_segment=current_segment;
    join_pick=temp_pick;
/*  location=get_location(*(picks[n].record+temp_pick),*(picks[n].trace+temp_pick),*(picks[n].sample+temp_pick),id_anim); RJM */
    location=get_location(picks[n].record[temp_pick],picks[n].trace[temp_pick],picks[n].sample[temp_pick],id_anim?id_anim:picks[n].id);
    x1=(int)location.x/xdisplay[id_anim].pick_x;
    y1=(int)location.y/xdisplay[id_anim].pick_y,
    XDrawLine(display,xdisplay[id].top,xdisplay[id].gc,x1-5,y1+5,x1+5,y1-5);
    XDrawLine(display,xdisplay[id].top,xdisplay[id].gc,x1-5,y1-5,x1+5,y1+5);
  } else {
    if (join_segment==n) {	/* Can't join a segment to itself. */
      reset_mode(id,id_anim,True);
      error_message("Can't join a segment to itself.");
      return;
    }
    picks[join_segment].size+=picks[n].size;
    picks[join_segment].record=(int *)realloc((char *)picks[join_segment].record,
					 (unsigned)picks[join_segment].size*sizeof(int));
    picks[join_segment].trace=(int *)realloc((char *)picks[join_segment].trace,
					 (unsigned)picks[join_segment].size*sizeof(int));
    picks[join_segment].sample=(int *)realloc((char *)picks[join_segment].sample,
					 (unsigned)picks[join_segment].size*sizeof(int));
    if ((join_pick==(picks[join_segment].size-picks[n].size-1))&&
	(temp_pick==0)) {
      memcpy((char *)(picks[join_segment].record+join_pick+1),
	     (char *)picks[n].record,
	     picks[n].size*sizeof(int));
      memcpy((char *)(picks[join_segment].trace+join_pick+1),
	     (char *)picks[n].trace,
	     picks[n].size*sizeof(int));
      memcpy((char *)(picks[join_segment].sample+join_pick+1),
	     (char *)picks[n].sample,
	     picks[n].size*sizeof(int));
    }
    if ((join_pick==(picks[join_segment].size-picks[n].size-1))&&
	(temp_pick==(picks[n].size-1)))
      for (m=0; m<picks[n].size; m++) {
	*(picks[join_segment].record+join_pick+1+m)=*(picks[n].record+picks[n].size-m-1);
	*(picks[join_segment].trace+join_pick+1+m)=*(picks[n].trace+picks[n].size-m-1);
	*(picks[join_segment].sample+join_pick+1+m)=*(picks[n].sample+picks[n].size-m-1);
      }
    if ((join_pick==0)&&
	(temp_pick==(picks[n].size-1))) {
      for (m=(picks[join_segment].size-picks[n].size)-1; m>=0; m--) {
	temp1=picks[n].size+m;
	*(picks[join_segment].record+temp1)=*(picks[join_segment].record+m);
	*(picks[join_segment].trace+temp1)=*(picks[join_segment].trace+m);
	*(picks[join_segment].sample+temp1)=*(picks[join_segment].sample+m);
      }
      memcpy((char *)picks[join_segment].record,
	     (char *)picks[n].record,
	     picks[n].size*sizeof(int));
      memcpy((char *)picks[join_segment].trace,
	     (char *)picks[n].trace,
	     picks[n].size*sizeof(int));
      memcpy((char *)picks[join_segment].sample,
	     (char *)picks[n].sample,
	     picks[n].size*sizeof(int));
    }
    if ((join_pick==0)&&
	(temp_pick==0)) {
      for (m=(picks[join_segment].size-picks[n].size)-1; m>=0; m--) {
	temp1=picks[n].size+m;
	*(picks[join_segment].record+temp1)=*(picks[join_segment].record+m);
	*(picks[join_segment].trace+temp1)=*(picks[join_segment].trace+m);
	*(picks[join_segment].sample+temp1)=*(picks[join_segment].sample+m);
      }
      for (m=0; m<picks[n].size; m++) {
	*(picks[join_segment].record+m)=*(picks[n].record+picks[n].size-m-1);
	*(picks[join_segment].trace+m)=*(picks[n].trace+picks[n].size-m-1);
	*(picks[join_segment].sample+m)=*(picks[n].sample+picks[n].size-m-1);
      }
    }
    if(picks[current_segment].record)
      free((char *)picks[current_segment].record);
    if(picks[current_segment].trace)
      free((char *)picks[current_segment].trace);
    if(picks[current_segment].sample)
      free((char *)picks[current_segment].sample);
    picks[current_segment].record=NULL;
    picks[current_segment].trace=NULL;
    picks[current_segment].sample=NULL;
    picks[current_segment].init=0;
    join_segment=(-1);
  }

  reset_mode(id,id_anim,True);
  
  return;
}


/*
  This function refine (adds 
  mid-points between picks) a segment.
*/
void refine_segment(XEvent *event, long id, long id_anim)
{
  int n,m;

  if (current_segment==-1) {
    select_segment(event,id,id_anim);
    return;
  }


  if (event->xbutton.button==Button2)
    return;

  if (event->xbutton.button==Button3) {
    reset_mode(id,id_anim,True);
    return;
  }

  n=current_segment;

				/* Make the segment space larger. */
  picks[n].size+=(picks[n].size-1);
  picks[n].record=(int *)realloc((char *)picks[n].record,(unsigned)picks[n].size*sizeof(int));
  picks[n].trace=(int *)realloc((char *)picks[n].trace,(unsigned)picks[n].size*sizeof(int));
  picks[n].sample=(int *)realloc((char *)picks[n].sample,(unsigned)picks[n].size*sizeof(int));

				/* Move picks to every other space. */
  for (m=picks[n].size-1; m>=0; m-=2) {
    *(picks[n].record+m)=*(picks[n].record+(int)(m/2));
    *(picks[n].trace+m)=*(picks[n].trace+(int)(m/2));
    *(picks[n].sample+m)=*(picks[n].sample+(int)(m/2));
  }

				/* Fill in the empty spaces. */
  for (m=picks[n].size-2; m>=1; m-=2) {
    *(picks[n].record+m)=(*(picks[n].record+m-1)+(*(picks[n].record+m+1)))/2;
    *(picks[n].trace+m)=(*(picks[n].trace+m-1)+(*(picks[n].trace+m+1)))/2;
    *(picks[n].sample+m)=(*(picks[n].sample+m-1)+(*(picks[n].sample+m+1)))/2;
  }


  reset_mode(id,id_anim,True);

  return;
}




/*
  This function finds the 
  closest pick point to x,y.
*/
int close_pick(int x, int y, long id)
{
  int m,n,offset=(-1);
  int temp1,temp2,temp_pick;

  n=current_segment;

  for (m=0; m<picks[n].size; m++) {
    if (offset==-1) {
/*    location=get_location(*(picks[n].record+m),*(picks[n].trace+m),*(picks[n].sample+m),id); RJM */
      location=get_location(picks[n].record[m],picks[n].trace[m],picks[n].sample[m],id?id:picks[n].id);
      temp1=(location.x-x)*(location.x-x);
      temp2=(location.y-y)*(location.y-y);
      offset=temp1+temp2;
      temp_pick=m;
    }
/*  location=get_location(*(picks[n].record+m),*(picks[n].trace+m),*(picks[n].sample+m),id); RJM */
    location=get_location(picks[n].record[m],picks[n].trace[m],picks[n].sample[m],id?id:picks[n].id);
    temp1=(location.x-x)*(location.x-x);
    temp2=(location.y-y)*(location.y-y);
    if ((temp1+temp2)<offset) {
      offset=temp1+temp2;
      temp_pick=m;
    }
  }
  return(temp_pick);
}
