/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
  This file contains the functions for
  manipulating all the windows display
  seismic data in xsd.
*/

#include "xdisplayP.h"
#include "clocking.h"
#include <signal.h>
#include "prototyping.h"

#ifdef VIEW3D
#include "Xint/View3D.h"  /* XintGlChooseVisual */
#endif


extern GC vel_gc;
extern XtAppContext app_context;
extern int animate_list[MAX_IMAGES],animate_count;
extern Boolean animate_flag;
extern int paint_index;
extern int body_init;
extern Boolean server_flag;

static Widget list_window=NULL;
static Widget list_form=NULL;
static Widget list=NULL;
static Widget select_list=NULL;

static Boolean optimize_errors;

int window_list[MAX_IMAGES],list_count=0;
static XmString item[MAX_IMAGES+1];
static int item_count=0;


/* 
  This function is used select a window 
  to expose window or to select an old file 
  to redisplay (with the same parameters.
*/
void exposeCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  XmString item_expose[MAX_IMAGES+1];
  Widget list;
  int m,n,order[MAX_IMAGES],order_count;
  int temp;
  Boolean get_data_flag = (Boolean)((long)client_data && 0xff);	/* for 64-bit */
  int tally=1;
  char buf_temp[80];
  ClientData *message;

				/* If True then get data else expose window. */
  if (get_data_flag)
				/* Check if server is running. */
    if (!server_flag) {
      error_message("You must first start the data server.");
      return;
    }
				/* Put valid window ids into a list. */
  order_count=0;
  for (n=0; n<MAX_IMAGES; n++)
    if ((xdisplay[n].init!=0)&&(raster[n]!=NULL)) {
      order[order_count]=n;
      order_count++;
    }
				/* Sort windows by sequence number. */
  while (tally>0) {
    tally=0;
    for (n=1; n<order_count; n++)
      if (xdisplay[order[n-1]].sequence>xdisplay[order[n]].sequence) {
        temp=order[n-1];
        order[n-1]=order[n];
        order[n]=temp;
        tally++;
      }
  }

				/* Build XmString list for list widget. */
  m=0;
  for (temp=0; temp<order_count; temp++) {
    n=order[temp];
    if ((xdisplay[n].init!=0)&&(raster[n]!=NULL)) {
      window_title(buf,n);
      sprintf(buf_temp," %4.2f %4.2f ",1.0/xdisplay[n].pick_x,1.0/xdisplay[n].pick_y);
      strcat(buf,buf_temp);
      strcat(buf,xdisplay[n].type);
      if (xdisplay[n].hide_flag)
        strcat(buf," Hidden ");
      else
        strcat(buf,"        ");
      item_expose[m]=XmStringCreateLtoR(buf,XmSTRING_DEFAULT_CHARSET);
      m++;
    }
  }

				/* Mark the end of the XmString list. */
  item_expose[m]=NULL;
  item_count=m;
  
  n=0;
				/* If the list is not empty add the items. */
  if (m!=0) {
    XtSetArg(args[n],XmNlistItems,item_expose); n++;
    XtSetArg(args[n],XmNlistItemCount,m); n++;
  }
  XtSetArg(args[n],XmNlistVisibleItemCount,15); n++;

			/* Use get_data_flag to set the correct title. */
  if (get_data_flag) {
    XtSetArg(args[n],XmNlistLabelString,
	     XMstr("Double Click to Get Window Parameters")); n++;
    XtSetArg(args[n],XmNdialogTitle,
	     XMstr("Get Window Parameters")); n++;
  } else {
    XtSetArg(args[n],XmNlistLabelString,
	     XMstr("Double Click on a Window to Expose")); n++;
    XtSetArg(args[n],XmNdialogTitle,
	     XMstr("Expose Window")); n++;
  }
  list=XmCreateSelectionDialog(top_level,"Line Header",args,n);
  XtManageChild(list);

  message=(ClientData *)malloc(sizeof(ClientData));
  message->w=list;
  message->id=get_data_flag?1:0;
  XtAddCallback(list,XmNokCallback,expose_windowCB,message);
  XtAddCallback(list,XmNcancelCallback,destroyCB,list);

			/* Use get_data_flag to supply the correct help. */
  if (get_data_flag)
    XtAddCallback(list,XmNhelpCallback,helpCB,"data_list.help");
  else
    XtAddCallback(list,XmNhelpCallback,helpCB,"expose.help");


				/* Free all the XmString space. */
  for (n=0; n<m; n++)
      XmStringFree(item_expose[n]);

				/* Erases "Apply" button. Confused users. */
  XtUnmanageChild(XmSelectionBoxGetChild(list,XmDIALOG_APPLY_BUTTON));
}


/* 
  This function is exposes a window or 
  to select an old file to redisplay 
  (with the same parameters).
*/
void expose_windowCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  XmSelectionBoxCallbackStruct	*CBst = (XmSelectionBoxCallbackStruct*)call_data;
  ClientData *message=(ClientData *)client_data;
  int junk,error;
  long id, id1;	/* RJM: handle 64-bit architectures */
  Boolean get_data_flag;
  char *text;

				/* If True then get data else expose window. */
  get_data_flag=message->id==1?True:False;

				/* Get window selection. */
  XmStringGetLtoR(CBst->value,XmSTRING_DEFAULT_CHARSET,&text);
  if (*text=='\0') {
    if( message->w != NULL )
      XtDestroyWidget( message->w );
    free(message);
    return;
  }

				/* Parse window id. */
  error=sscanf(text,"%d Window: %d",&junk,&id);
  if (error!=2) {
    if( message->w != NULL )
      XtDestroyWidget( message->w );
    free(message);
    return;
  }

  if (get_data_flag) {		/* Set parameter from old window. */
    if (xdisplay[id].init!=-1) {
      error_message("This window has been deleted.");
      return;
    }
    id1=next_image();
    strcpy(xdisplay[id1].filename,xdisplay[id].filename);
    n4[id1]=n4[id];
    s4[id1]=s4[id];
    nrec[id1]=nrec[id];
    ntrace[id1]=ntrace[id];
    nsamp[id1]=nsamp[id];
    srec[id1]=srec[id];
    erec[id1]=erec[id];
    irec[id1]=irec[id];
    strace[id1]=strace[id];
    etrace[id1]=etrace[id];
    itrace[id1]=itrace[id];
    ssamp[id1]=ssamp[id];
    esamp[id1]=esamp[id];
    isamp[id1]=isamp[id];
    xdisplay[id1].sort=xdisplay[id].sort;
    xdisplay[id1].middle=xdisplay[id].middle;
    xdisplay[id1].flip_flag=xdisplay[id].flip_flag;
    xdisplay[id1].upside_flag=xdisplay[id].upside_flag;
    xdisplay[id1].swap_flag=xdisplay[id].swap_flag;
    xdisplay[id1].offset=xdisplay[id].offset;
    xdisplay[id1].scalar=xdisplay[id].scalar;
    strcpy(xdisplay[id1].hostname,xdisplay[id].hostname);
    data(xdisplay[id].window,id1,False); /* Call data to display parameters. */
  } else {
    if (xdisplay[id].hide_flag) {
				/* If window is hidden map it. */
      XtMapWidget(xdisplay[id].window);
      xdisplay[id].hide_flag=False;
    } else {
				/* If window is not hidden unmap then map. */
      XtUnmapWidget(xdisplay[id].window);
      XtMapWidget(xdisplay[id].window);
    }
  }

  if( message->w != NULL )
    XtDestroyWidget( message->w );
  free(message);
}


/*
  Creates the inital global window display.
*/
void init_global(void)
{
  int n;
  Widget label;
  Widget frame;
  Widget row_column;
  Widget button;
  Widget paned_window;
#ifdef VIEW3D
  Visual *vis;
#endif

  n=0;
  XtSetArg(args[n],XtNargc,savedArgc); n++;     /* RJM: added 1/17/97 */
  XtSetArg(args[n],XtNargv,savedArgv); n++;     /* RJM: added 1/17/97 */
  XtSetArg(args[n],XtNiconPixmap,xsd_pixmap); n++;
  XtSetArg(args[n],XtNvisual,visual); n++;
  XtSetArg(args[n],XtNdepth,screenDepth); n++;
/*list_window=XtAppCreateShell("xsd","global", RJM: commented out 1/17/97:
                               topLevelShellWidgetClass,display,args,n);
	application_name and application_class should be the same as those
	passed to XtOpenDisplay!!!
*/
  list_window=XtAppCreateShell(ApplicationName, ApplicationClass,
                               topLevelShellWidgetClass,display,args,n);
  quit_frame(list_window);
  
  paned_window=XmCreatePanedWindowVa(list_window,"paned",
                                     XmNtopAttachment,XmATTACH_FORM,
                                     XmNtopOffset,10,
                                     XmNleftAttachment,XmATTACH_FORM,
                                     XmNleftOffset,10,
                                     XmNbottomAttachment,XmATTACH_FORM,
                                     XmNbottomOffset,10,
                                     NULL);
  XtAddCallback(paned_window,XmNhelpCallback,helpCB,"global.help");
  
  list_form=XmCreateFormVa(paned_window,"form",
			   NULL);
  
  label=XmCreateLabelVa(list_form,"Window List (Double click on an item to put in selected list)",
			XmNtopAttachment,XmATTACH_FORM,
			XmNleftAttachment,XmATTACH_FORM,
			NULL);
  
  frame=XmCreateFrameVa(list_form,"frame",
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,label,
			XmNbottomAttachment,XmATTACH_FORM,
			XmNrightAttachment,XmATTACH_FORM,
			XmNleftAttachment,XmATTACH_FORM,
			NULL);
  
  list=XmCreateScrolledListVa(frame,"Window List",
			      XmNscrollBarDisplayPolicy,XmSTATIC,
			      XmNlistSizePolicy,XmCONSTANT,
			      XmNvisibleItemCount,10,
			      NULL);
  
  XtAddCallback(list,XmNdefaultActionCallback,add_itemCB,0);
  
  list_form=XmCreateFormVa(paned_window,"form",
			   XmNtopAttachment,XmATTACH_WIDGET,
			   XmNtopWidget,list_form,
			   NULL);

  label=XmCreateLabelVa(list_form,"Selected Window List (Double click on an item to erase from selected list)",
			XmNtopAttachment,XmATTACH_FORM,
			XmNleftAttachment,XmATTACH_FORM,
			NULL);
  
  frame=XmCreateFrameVa(list_form,"frame",
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,label,
			XmNbottomAttachment,XmATTACH_FORM,
			XmNrightAttachment,XmATTACH_FORM,
			XmNleftAttachment,XmATTACH_FORM,
			NULL);
  
  select_list=XmCreateScrolledListVa(frame,"Window List",
				     XmNscrollBarDisplayPolicy,XmSTATIC,
				     XmNlistSizePolicy,XmCONSTANT,
				     XmNvisibleItemCount,10,
				     NULL);
  
  XtAddCallback(select_list,XmNdefaultActionCallback,subtract_itemCB,0);
  
  row_column=XmCreateRowColumnVa(paned_window,"row_column",
				 XmNpacking,XmPACK_COLUMN,
				 XmNnumColumns,7,
				 XmNspacing,10,
				 NULL);
  
  button=XmCreatePushButtonVa(row_column,"Select All",NULL);
  XtAddCallback(button,XmNactivateCallback,select_allCB,list_form);
  
  button=XmCreatePushButtonVa(row_column,"Clear All",NULL);
  XtAddCallback(button,XmNactivateCallback,clear_allCB,list_form);
  
  button=XmCreatePushButtonVa(row_column,"Hide",NULL);
  XtAddCallback(button,XmNactivateCallback,unmapCB,list_form);
  XtAddCallback(button,XmNactivateCallback,build_listCB,0);
  XtAddCallback(button,XmNactivateCallback,hide_severalCB,0);
  
  button=XmCreatePushButtonVa(row_column,"Expose",NULL);
  XtAddCallback(button,XmNactivateCallback,unmapCB,list_form);
  XtAddCallback(button,XmNactivateCallback,build_listCB,0);
  XtAddCallback(button,XmNactivateCallback,expose_severalCB,0);
  
  button=XmCreatePushButtonVa(row_column,"Delete",NULL);
  XtAddCallback(button,XmNactivateCallback,unmapCB,list_form);
  XtAddCallback(button,XmNactivateCallback,build_listCB,0);
  XtAddCallback(button,XmNactivateCallback,delete_severalCB,0);
  XtAddCallback(button,XmNactivateCallback,clear_allCB,list_form);
  
  button=XmCreatePushButtonVa(row_column,"Overlay",NULL);
  XtAddCallback(button,XmNactivateCallback,unmapCB,list_form);
  XtAddCallback(button,XmNactivateCallback,build_listCB,0);
  XtAddCallback(button,XmNactivateCallback,overlayCB,0);
  
  button=XmCreatePushButtonVa(row_column,"Animate",NULL);
  XtAddCallback(button,XmNactivateCallback,unmapCB,list_form);
  XtAddCallback(button,XmNactivateCallback,build_listCB,0);
  XtAddCallback(button,XmNactivateCallback,animateCB,0);
  
  button=XmCreatePushButtonVa(row_column,"Interleave",NULL);
  XtAddCallback(button,XmNactivateCallback,unmapCB,list_form);
  XtAddCallback(button,XmNactivateCallback,build_listCB,0);
  XtAddCallback(button,XmNactivateCallback,interleaveCB,0);
  
  button=XmCreatePushButtonVa(row_column,"Save Images",NULL);
  XtAddCallback(button,XmNactivateCallback,unmapCB,list_form);
  XtAddCallback(button,XmNactivateCallback,build_listCB,0);
  XtAddCallback(button,XmNactivateCallback,set_typeCB,(XtPointer)3L);
  XtAddCallback(button,XmNactivateCallback,filer_promptCB,0);
  
  button=XmCreatePushButtonVa(row_column,"Delete Images",NULL);
  XtAddCallback(button,XmNactivateCallback,unmapCB,list_form);
  XtAddCallback(button,XmNactivateCallback,set_typeCB,(XtPointer)11L);
  XtAddCallback(button,XmNactivateCallback,filer_promptCB,0);
  
  button=XmCreatePushButtonVa(row_column,"Load Colormap",NULL);
  XtAddCallback(button,XmNactivateCallback,unmapCB,list_form);
  XtAddCallback(button,XmNactivateCallback,build_listCB,0);
  XtAddCallback(button,XmNactivateCallback,set_typeCB,(XtPointer)20L);
  XtAddCallback(button,XmNactivateCallback,filer_promptCB,0);
  
#ifdef VIEW3D
  if (do_view3d) {
    vis=XintGlChooseVisual(display,screen);
    if (vis!=NULL) {
      button=XmCreatePushButtonVa(row_column,"View3D",NULL);
      XtAddCallback(button,XmNactivateCallback,unmapCB,list_form);
      XtAddCallback(button,XmNactivateCallback,build_listCB,0);
      XtAddCallback(button,XmNactivateCallback,view3dCB,0);
    }
  }
#endif
  
  button=XmCreatePushButtonVa(row_column,"Help",NULL);
  XtAddCallback(button,XmNactivateCallback,helpCB,"global.help");
  
  button=XmCreatePushButtonVa(row_column,"Cancel",NULL);
  XtAddCallback(button,XmNactivateCallback,unmapCB,list_form);
  
  XtManageChild(list_form);
}


/*
  Displays global window display.
*/
void globalCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  static int init_list=0;
  int m,n,order[MAX_IMAGES],order_count;
  int temp,tally=1;
  char buf_temp[80];
  
				/* Put valid window ids into a list. */
  order_count=0;
  for (n=0; n<MAX_IMAGES; n++)
    if ((xdisplay[n].init!=0)&&(raster[n]!=NULL)) {
      order[order_count]=n;
      order_count++;
    }


				/* Sort windows by sequence number. */
  m=0;
  if (order_count>0) {
  while (tally>0) {
    tally=0;
    for (n=1; n<order_count; n++)
      if (xdisplay[order[n-1]].sequence>xdisplay[order[n]].sequence) {
	temp=order[n-1];
	order[n-1]=order[n];
	order[n]=temp;
	tally++;
      }
  }
    
				/* Build XmString list for list widget. */
  for (temp=0; temp<order_count; temp++) {
    n=order[temp];
    if ((xdisplay[n].init!=0)&&(raster[n]!=NULL)) {
      window_title(buf,n);
      sprintf(buf_temp," %4.2f %4.2f ",1.0/xdisplay[n].pick_x,1.0/xdisplay[n].pick_y);
      strcat(buf,buf_temp);
      strcat(buf,xdisplay[n].type);
      if (xdisplay[n].hide_flag)
	strcat(buf," Hidden ");
      else
	strcat(buf,"        ");
      item[m]=XmStringCreateLtoR(buf,XmSTRING_DEFAULT_CHARSET);
      m++;
    }
  }
  }

				/* Mark the end of the XmString list. */
  item[m]=NULL;
  item_count=m;
  
  XtVaSetValues(list,
		XmNitemCount,m,
		XmNitems,item,
		XmNvisibleItemCount,10,
		NULL);
  
  XtVaSetValues(select_list,
		XmNvisibleItemCount,10,
		NULL);

  if (init_list==0) {
				/* Realize global window once. */
    XtRealizeWidget(list_window);
    init_list=1;
  }

				/* Map the global window. */
  XtMapWidget(list_window);
}


/*
  This function unmaps the global window.
*/
void unmapCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  XtUnmapWidget(list_window);
}


/*
  This function adds the selected 
  item to the bottom list.
*/
void add_itemCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  XmListCallbackStruct	*CBst = (XmListCallbackStruct*)call_data;

  XmListAddItem(select_list,CBst->item,0);
}


/*
  This function subtracts the selected 
  item from the bottom list.
*/
void subtract_itemCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  XmListCallbackStruct	*CBst = (XmListCallbackStruct*)call_data;
  int item_count;

  XtVaGetValues(select_list,XmNitemCount, &item_count, NULL);
  if (item_count == 1)
    XmListDeleteAllItems(select_list);
  else
    XmListDeletePos(select_list,CBst->item_position);
}


/*
  This function put all the
  windows in the bottom list.
*/
void select_allCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  XtVaSetValues(select_list,
		XmNitemCount,item_count,
		XmNitems,item,
		NULL);
}


/*
  This function clears all the
  windows from the bottom list.
*/
void clear_allCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  XmListDeleteAllItems(select_list);
}



/*
  This function build a list of window
  ids from the bottom list widget.
*/
void build_listCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  char *text;
  XmString *item;
  int n,m,window_id;

  XtVaGetValues(select_list,
		XmNitemCount,&m,
		XmNitems,&item,
		NULL);

  list_count=0;
  for (n=0; n<m; n++) {
    XmStringGetLtoR(item[n],XmSTRING_DEFAULT_CHARSET,&text);
    sscanf(text,"%*d Window: %d",&window_id);
    if ((xdisplay[window_id].init!=0)&&(raster[window_id]!=NULL)) {
      window_list[list_count]=window_id;
      list_count++;
    }
  }
}


void hideCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  long id;	/* RJM: handle 64-bit architectures */

  id=(long)client_data;

  if (id==0)
    return;

  XtUnmapWidget(xdisplay[id].window);
  xdisplay[id].hide_flag=True;
}


void hide_severalCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  int n;

  for (n=0; n<list_count; n++) 
    if (window_list[n]!=0) {
      XtUnmapWidget(xdisplay[window_list[n]].window);
      xdisplay[window_list[n]].hide_flag=True;
    }
}


void expose_severalCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  int n;

  for (n=0; n<list_count; n++) {
    if (xdisplay[window_list[n]].hide_flag) {
      XtMapWidget(xdisplay[window_list[n]].window);
      xdisplay[window_list[n]].hide_flag=False;
    } else {
      XtUnmapWidget(xdisplay[window_list[n]].window);
      XtMapWidget(xdisplay[window_list[n]].window);
    }
  }
}

/*
  This function deletes a seismic window.
*/
void delete_windowCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  extern void free_imageCB( Widget, XtPointer, XtPointer ); /* RJM: added */

  int n;
  long id = (long)client_data;

  if (id==0)
    return;

  if (strcmp(xdisplay[id].filename,"Animation")==0)
    reset_animateCB(NULL,NULL,NULL);

  if (strcmp(xdisplay[id].type,"Paint")==0) {
    if( vel_gc ) {	/* RJM: added */
      XFreeGC(display,vel_gc);
      vel_gc = (GC)NULL;
    }
    paint_index=0;
    body_init=False;
  } else if (strcmp(xdisplay[id].type,"Model")==0) {
    delete_body_list();
    quit_model();
  }
				/* Make sure the window being deleted is
				   not be using in the animation window. */
  if (animate_flag) {
    for (n=0; n<animate_count; n++)
      if (animate_list[n]==id) {
	n=animate_count;
        if (optimize_errors==False) {
	  error_message("Cannot delete a window that is being used in the animation window.");
          optimize_errors=True;
        }
        return;
      }
  }

  for (n=0; n<MAX_IMAGES; n++)
    if ((xdisplay[n].init!=0)&&(raster[n]!=NULL)) {
      if (strcmp(xdisplay[n].type,"Interleave")==0) {
	if (xdisplay[n].inter_parent==id) {
          if (optimize_errors==False) {
	    error_message("Cannot delete a window that is being used in an interleave window.");
            optimize_errors=True;
          }
          return;
	}
      }
    }

  /* RJM: NOTE: instead of having free_imageCB get called via the
     XtDestroyCallback resource added during creation of xdisplay[id].window,
     I call free_imageCB explicitly here to prevent the access of already
     anhilated widgets.  free_imageCB calls set_mode_label(1,id) which sets
     xdisplay[id].mode_label. If we destroy xdisplay[id].window (via destroyCB),
     xdisplay[id].mode_label gets destroyed (since it's not referenced by
     other widgets) and is then later set by free_imageCB.  SEGMENTATION FAULT
     CITY MAN.
   */

/* free_imageCB must be called before destroyCB which deletes widgets referenced in this function!! */
  free_imageCB( NULL, (XtPointer)client_data, (XtPointer)NULL );

  destroyCB(NULL,(XtPointer)xdisplay[id].window,NULL);

  xdisplay[id].init=0;
}


/*
  This function deletes several seismic windows.
*/
void delete_severalCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  int window;
  long tmp;

  /* Delete the items in reverse order. suggested by--> Bill Felinski. */

/* DWN - this might be the cause of the global window hang problem ?????
   It certainly corrects the problem.
   It occurs in XtDestroyWidget via destroyCB via delete_windowCB.
   Why a backwards loop creates havoc with Motif or X I don't know.
  for (window=list_count-1; window>=0; window--)
*/

  optimize_errors=False;

  for (window=0; window<list_count; window++)
    if (window_list[window]!=0)
    {	/* RJM: changed to call delete_windowCB */
       tmp = window_list[window];
       delete_windowCB(w, (XtPointer)tmp, call_data);
       window_list[window]=0;
    }
}


/*
  This function hides the control panel.
*/
void squishCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  int width,height,root_x,root_y;
  long id;	/* RJM: handle 64-bit architectures */

  id=(long)client_data;

  XBell(display,100);

  locate_cursor(&root_x,&root_y);


  xdisplay[id].mode=1;		/* Squish mode is same as picking. */
  set_mode_label(1,id);


  XtSetArg(args[0],XmNtopOffset,0);
  XtSetValues(xdisplay[id].scroll,args,1);

  width=xdisplay[id].image->width;
  height=xdisplay[id].image->height;
  screen_size(id,&width,&height);
  if (width<MAX_WIDTH) {
    if (xdisplay[id].axis_flag) {
      width=xdisplay[id].image->width+50;
      height+=50;
    }  else {
      width=xdisplay[id].image->width;
    }
  }
/*
  XtVaGetValues(XtParent(xdisplay[id].menu),
		XmNmenuBar,NULL,
		XmNshowSeparator,False,
		NULL);
*/
  XtUnmanageChild(xdisplay[id].menu);
  XtUnmanageChild(xdisplay[id].menubar);
  

  width+=5;

  XtManageChild(xdisplay[id].control);

  XtVaSetValues(xdisplay[id].scroll,
		XmNtopAttachment,XmATTACH_WIDGET,
		XmNtopWidget,xdisplay[id].control,
		XmNwidth,width,
		XmNheight,height,
		NULL);

				/* Hack to have the scroll widget 
				   reattach itself to the form. */
  XtUnmanageChild(xdisplay[id].scroll);
  XtManageChild(xdisplay[id].scroll);
}



/*
  This function unsquishs the window.
*/
void unsquishCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  int width,height;
  long id;	/* RJM: handle 64-bit architectures */

  id=(long)client_data;

  xdisplay[id].mode=1;
  set_mode_label(1,id);

  if (xdisplay[id].axis_flag)
    width=xdisplay[id].image->width+50;
  else
    width=xdisplay[id].image->width;

  height=xdisplay[id].image->height;
  screen_size(id,&width,&height);

  XtUnmanageChild(xdisplay[id].control);
  XtManageChild(xdisplay[id].menu);
  XtManageChild(xdisplay[id].menubar);

  XtVaSetValues(xdisplay[id].scroll,
		XmNtopAttachment,XmATTACH_WIDGET,
		XmNtopWidget,xdisplay[id].menu,
		XmNtopOffset,0,
		XmNwidth,width,
		XmNheight,height+MIN_HEIGHT,
		NULL);
  XtResizeWindow(xdisplay[id].scroll);
  XtUnmanageChild(xdisplay[id].scroll);
  XtManageChild(xdisplay[id].scroll);

  set_cursor_color(id,0,0,0);
  XmUpdateDisplay(w);
}



/*
  This function changes the cursor to 
  a stop watch indicating busy working.
*/
/* #ifndef R5 */	/* RJM */
/* #if XlibSpecificationRelease < 5 */	/* Don't use dynamic watch...slows things */
#if 1
void show_watchCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  if (client_data==NULL)
    return;

  XDefineCursor(display,XtWindow((Widget)client_data),
		XCreateFontCursor(display,XC_watch));
  XmUpdateDisplay(w);
}
#else

static void change_cursor(int);
static Window current_window;

void show_watchCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  if (client_data==NULL)
    return;

  current_window=XtWindow((Widget)client_data);

  alarm(0);	/* RJM added: VERY IMPORTANT to turn off alarm since X-event */
		/* handler may call this routine before outstanding alarm ends*/

  signal(SIGALRM,change_cursor);
  change_cursor(NULL);

  XmUpdateDisplay(w);
}

static void change_cursor(int dummy)
{ 
  static int init=0;
  static int count=0;
  static XColor fg,bg;
  static Cursor cursor[8];
  Pixmap pixmap_mask,pixmap_source;
 
  if (init==0) {
    fg.pixel=1;
    fg.red=0;
    fg.green=0;
    fg.blue=0;
    bg.pixel=0;
    bg.red=65535;
    bg.green=65535;
    bg.blue=65535;
 
    pixmap_mask=XCreateBitmapFromData(display,XtWindow(top_level),
	(_Xconst char*)c_mask_bits,c1_width,c1_height);
    pixmap_source=XCreateBitmapFromData(display,XtWindow(top_level),
	(_Xconst char*)c1_bits,c1_width,c1_height);
    cursor[0]=XCreatePixmapCursor(display,pixmap_source,pixmap_mask,&fg,&bg,10,10);
    pixmap_source=XCreateBitmapFromData(display,XtWindow(top_level),
	(_Xconst char*)c2_bits,c1_width,c1_height);
    cursor[1]=XCreatePixmapCursor(display,pixmap_source,pixmap_mask,&fg,&bg,10,10);
    pixmap_source=XCreateBitmapFromData(display,XtWindow(top_level),
	(_Xconst char*)c3_bits,c1_width,c1_height);
    cursor[2]=XCreatePixmapCursor(display,pixmap_source,pixmap_mask,&fg,&bg,10,10);
    pixmap_source=XCreateBitmapFromData(display,XtWindow(top_level),
	(_Xconst char*)c4_bits,c1_width,c1_height);
    cursor[3]=XCreatePixmapCursor(display,pixmap_source,pixmap_mask,&fg,&bg,10,10);
    pixmap_source=XCreateBitmapFromData(display,XtWindow(top_level),
	(_Xconst char*)c5_bits,c1_width,c1_height);
    cursor[4]=XCreatePixmapCursor(display,pixmap_source,pixmap_mask,&fg,&bg,10,10);
    pixmap_source=XCreateBitmapFromData(display,XtWindow(top_level),
	(_Xconst char*)c6_bits,c1_width,c1_height);
    cursor[5]=XCreatePixmapCursor(display,pixmap_source,pixmap_mask,&fg,&bg,10,10);
    pixmap_source=XCreateBitmapFromData(display,XtWindow(top_level),
	(_Xconst char*)c7_bits,c1_width,c1_height);
    cursor[6]=XCreatePixmapCursor(display,pixmap_source,pixmap_mask,&fg,&bg,10,10);
    pixmap_source=XCreateBitmapFromData(display,XtWindow(top_level),
	(_Xconst char*)c8_bits,c1_width,c1_height);
    cursor[7]=XCreatePixmapCursor(display,pixmap_source,pixmap_mask,&fg,&bg,10,10);
    init=1;
  }
 
  count = ++count % 8;	/* neat trick I learned from Bob Mars */
 
  XDefineCursor(display,current_window,cursor[count]);
 
  XFlush(display);

  (void)alarm(1);	/* RJM: put after XFlush */
}

#endif

/*
  This function changes the cursor 
  back to it original state.
*/
void hide_watchCB(Widget w, XtPointer client_data, XtPointer call_data)
{
/* #ifdef R5 */	/* RJM */
/* #if XlibSpecificationRelease >= 5 */
#if 0
  (void)alarm(0);
#endif
  XDefineCursor(display,XtWindow((Widget)client_data),
		XCreateFontCursor(display,XC_left_ptr));
  XmUpdateDisplay(w);
}
