/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
  This file contains the functions for
  interleaving (or mixing) to seismic 
  images to product one.
*/

#include "xdisplayP.h"
#include "prototyping.h"

extern int window_list[MAX_IMAGES],list_count;


/*
  This function sets up the attributes
  and create the window for the interleaving
  to size.
*/
void interleaveCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  int root_x,root_y;
  Widget dialog;
 
  XBell(display,100);

  locate_cursor(&root_x,&root_y);

  
  dialog=XmCreateQuestionDialogVa(top_level,"Size Verification",
				  XmNdefaultPosition,False,
				  XmNx,root_x,
				  XmNy,root_y,
				  XmNmessageString,
				  XMstr("Do you want to interleave to size?"),
				  XmNdialogTitle,XMstr("Size Verification"),
				  XmNokLabelString,XMstr(" Yes "),
				  XmNcancelLabelString,XMstr("No"),
				  NULL); 
 
  XtAddCallback(dialog,XmNokCallback,do_interleaveCB,(XtPointer)1L);
  XtAddCallback(dialog,XmNokCallback,destroyCB,dialog);
  XtAddCallback(dialog,XmNcancelCallback,do_interleaveCB,(XtPointer)2L);
  XtAddCallback(dialog,XmNcancelCallback,destroyCB,dialog);
}



/*
  This function sets up the attributes
  and create the window for the interleaving.
*/
void do_interleaveCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  Widget wiggle_window;
  Widget main_window;
  Widget wiggle_form;
  int m,n,image_count;
  long id;	/* RJM: handle 64-bit architectures */
  int width_temp,height_temp;

  if (list_count<2)
    return;

  id=window_list[0];

  if (id==-1)
    return;

  if ((long)client_data==1L) {
    if (xdisplay[window_list[0]].image->width!=
	xdisplay[window_list[1]].image->width)
      size_windows((long*)&window_list[0],(long*)&window_list[1]);
  }
  id=window_list[0];

  image_count=next_image();

  xdisplay[image_count].inter_parent=window_list[0];

  n=0;
  XtSetArg(args[n],XtNargc,savedArgc); n++;     /* RJM: added 1/17/97 */
  XtSetArg(args[n],XtNargv,savedArgv); n++;     /* RJM: added 1/17/97 */
  XtSetArg(args[n],XtNiconPixmap,xsd_pixmap); n++;
  XtSetArg(args[n],XtNvisual,visual); n++;
  XtSetArg(args[n],XtNdepth,screenDepth); n++;
/*wiggle_window=XtAppCreateShell("xsd","wiggle",
                               topLevelShellWidgetClass,display,args,n);
RJM: commented out 1/17/97 */
  wiggle_window=XtAppCreateShell(ApplicationName, ApplicationClass,	/* RJM: added 1/17/97 */
                               topLevelShellWidgetClass,display,args,n);
  quit_frame(wiggle_window);

  copy_attributes(image_count,id);

				/* Create space for the new colormap. */
  load_color(image_count);
  
				/* Put one colormap into the first 
				   part of the colormap. */
  for (n=start_color; n<=end_color; n+=2) {
    m=((n-(int)start_color)/2)+(int)start_color;
    *(raster_color_red[image_count]+m)=(int)(*(raster_color_red[window_list[0]]+n)+*(raster_color_red[window_list[0]]+n+1))/2;
    *(raster_color_green[image_count]+m)=(int)(*(raster_color_green[window_list[0]]+n)+*(raster_color_green[window_list[0]]+n+1))/2;
    *(raster_color_blue[image_count]+m)=(int)(*(raster_color_blue[window_list[0]]+n)+*(raster_color_blue[window_list[0]]+n+1))/2;
  }

				/* Put other colormap into the second
				   part of the colormap. */
  for (n=start_color; n<=end_color; n+=2) {
/*  m=((n-(int)start_color)/2)+154; RJM: commented out! */
    m=((n-(int)start_color)/2)+(int)(start_color+end_color)/2+1;
    *(raster_color_red[image_count]+m)=(int)(*(raster_color_red[window_list[1]]+n)+*(raster_color_red[window_list[1]]+n+1))/2;
    *(raster_color_green[image_count]+m)=(int)(*(raster_color_green[window_list[1]]+n)+*(raster_color_green[window_list[1]]+n+1))/2;
    *(raster_color_blue[image_count]+m)=(int)(*(raster_color_blue[window_list[1]]+n)+*(raster_color_blue[window_list[1]]+n+1))/2;
  }

  strcpy(xdisplay[image_count].type,"Interleave");

  width_temp=xdisplay[id].image->width;
  height_temp=xdisplay[id].image->height;

				/* Create space for seismic image. */
  raster[image_count]=(unsigned char *)malloc(width_temp*height_temp
					      *sizeof(char));

				/* Store first image. */
  for (n=0; n<width_temp*height_temp; n++) {
				/* Rescale value for new colormap. */
    m=((int)(*(raster[window_list[0]]+n))-(int)start_color)/2;
    *(raster[image_count]+n)=m+(int)start_color;
  }
  
  xdisplay[image_count].image=XCreateImage(display,visual,screenDepth,ZPixmap,
                                           0,(char *)raster[image_count],
					   width_temp,height_temp,screenDepth,0);

  interleave_image(image_count,window_list[1]);

  screen_size(id,&width_temp,&height_temp);

  main_window=XmCreateMainWindowVa(wiggle_window,"child_form",
				   XmNshowSeparator,True,
				   NULL);

  strcpy(xdisplay[image_count].filename,xdisplay[id].filename);
  window_title(buf,image_count);

  XtVaSetValues(wiggle_window,
		XmNtitle,buf,
		NULL);

  wiggle_form=XmCreateFormVa(main_window,"main",
			     XmNwidth,width_temp,
			     XmNheight,height_temp+MIN_HEIGHT,
			     NULL);

                                /* Indicate general mode. */
  xdisplay[image_count].mode=1;
  set_mode_label(1,image_count);

  app_menus(wiggle_form,image_count,True);

  xdisplay_image(image_count,wiggle_window,wiggle_form,
		 width_temp,height_temp);

  XtRealizeWidget(wiggle_window);
}


/*
  This function will take the second 
  seimic image interleave with the 
  first image (doing every other pixel).
*/
void interleave_image(long id, long id1)
{
  int x,y,m;

  for (y=0; y<xdisplay[id].image->height; y+=2)
    for (x=0; x<xdisplay[id].image->width; x+=2)
      if ((x < xdisplay[id1].image->width)&&(y < xdisplay[id1].image->height)) {
	m=((int)(*(raster[id1]+x+(y*xdisplay[id1].image->width)))-(int)start_color)/2;
	*(raster[id]+x+(y*xdisplay[id].image->width))=m+(int)(start_color+end_color)/2+1;
      }

  for (y=1; y<xdisplay[id].image->height; y+=2)
    for (x=1; x<xdisplay[id].image->width; x+=2)
      if ((x < xdisplay[id1].image->width)&&(y < xdisplay[id1].image->height)) {
	m=((int)(*(raster[id1]+x+(y*xdisplay[id1].image->width)))-(int)start_color)/2;
	*(raster[id]+x+(y*xdisplay[id].image->width))=m+(int)(start_color+end_color)/2+1;
      }
}


/*
  This function sets up the attributes
  and create the window for the interleaving.
*/
void size_windows(long *id, long *id1)
{
  Widget zoom_window;
  Widget main_window;
  Widget zoom_form;
  float scale_x,scale_y;
  int temp,image_count,n,parent,x,y;
  Boolean old_record_flag, flag_switch=False;
  int temp1,temp2,temp3,temp4,offset,width_temp,height_temp;
/*int width,height; */
  unsigned char *data;
/*struct values_struct values; */
  struct location_struct location;

  if (xdisplay[*id1].image->width<xdisplay[*id].image->width) {
    temp=*id;
    *id=*id1;
    *id1=temp;
    flag_switch=True;
  }

  scale_x=(float)xdisplay[*id1].image->width/(float)xdisplay[*id].image->width;
  scale_y=1.0;
  
  image_count=next_image();
  
  n=0;
  XtSetArg(args[n],XtNargc,savedArgc); n++;     /* RJM: added 1/17/97 */
  XtSetArg(args[n],XtNargv,savedArgv); n++;     /* RJM: added 1/17/97 */
  XtSetArg(args[n],XtNiconPixmap,xsd_pixmap); n++;
  XtSetArg(args[n],XtNvisual,visual); n++;
  XtSetArg(args[n],XtNdepth,screenDepth); n++;
/*zoom_window=XtAppCreateShell("xsd","zoom",
                               topLevelShellWidgetClass,display,args,n);
RJM: commented out 1/17/97 */
  zoom_window=XtAppCreateShell(ApplicationName, ApplicationClass,	/* RJM: added 1/17/97 */
                               topLevelShellWidgetClass,display,args,n);
  quit_frame(zoom_window);

				/* Special case. Don't zoom from parent. */
  if (strcmp(xdisplay[*id].type,"Wiggle")==0)
    parent=*id;
  else
    parent=xdisplay[*id].parent;
  
  copy_attributes(image_count,*id);

  xdisplay[image_count].parent=parent;
  xdisplay[image_count].sort=xdisplay[*id].sort;
  xdisplay[image_count].middle=xdisplay[*id].middle;
  xdisplay[image_count].pick_x=(1/scale_x)*xdisplay[*id].pick_x;
  xdisplay[image_count].pick_y=(1/scale_y)*xdisplay[*id].pick_y;

/* RJM: LEAVE THIS BLOCK COMMENTED OUT!!! */
/*
  values=get_values(0,0,*id);

RJM: ALREADY HAVE srec/strace/ssamp, etc from copy_attributes.
ALSO, THIS METHOD OF USING get_values(0,0.. & get_values(width,height...
CAN CAUSE strace to be > etrace!!!  pick.c and other code fails all over the
blooming place when this happens!!!!!
  
  srec[image_count]=values.record;
  strace[image_count]=values.trace;
  ssamp[image_count]=values.sample;

  width=xdisplay[*id].image->width;
  height=xdisplay[*id].image->height;

  x=(int)(xdisplay[*id].pick_x*width);
  y=(int)(xdisplay[*id].pick_y*height);
  values=get_values(x,y,*id);

  erec[image_count]=values.record;
  etrace[image_count]=values.trace;
  esamp[image_count]=values.sample;

  irec[image_count]=irec[*id];
  itrace[image_count]=itrace[*id];
  isamp[image_count]=isamp[*id];
*/
/*fprintf( stderr, "size_windows: s&e&itrace[%d]=%d,%d,%d\n", image_count, strace[image_count], etrace[image_count], itrace[image_count] ); */
/*fprintf( stderr, "size_windows: s&e&irec[%d]=%d,%d,%d\n", image_count, srec[image_count], erec[image_count], irec[image_count] ); */
/*fprintf( stderr, "size_windows: s&e&isamp[%d]=%d,%d,%d\n", image_count, ssamp[image_count], esamp[image_count], isamp[image_count] ); */

				/* Reset record number so the correct x
				   and y will be return for zooming. */
  old_record_flag=xdisplay[xdisplay[image_count].parent].record_flag;
  xdisplay[xdisplay[image_count].parent].record_flag=True;
  
  location=get_location(srec[image_count],strace[image_count],ssamp[image_count],xdisplay[image_count].parent);
  temp1=location.x;
  temp2=location.y;

  location=get_location(erec[image_count],etrace[image_count],esamp[image_count],xdisplay[image_count].parent);
/*temp3=(location.x-temp1);
  temp4=(location.y-temp2); RJM */
  temp3=abs(location.x-temp1);
  temp4=abs(location.y-temp2);

				/* Restore the record flag. */
  xdisplay[xdisplay[image_count].parent].record_flag=old_record_flag;

  temp1=temp1/xdisplay[parent].pick_x;
  temp2=temp2/xdisplay[parent].pick_y;
  temp3=temp3/xdisplay[parent].pick_x;
  temp4=temp4/xdisplay[parent].pick_y;

  data=(unsigned char *)malloc(temp3*temp4*sizeof(char));
  if (strcmp(xdisplay[*id].type,"Wiggle")==0)
    parent=*id;
  else
    parent=xdisplay[*id].parent;
  offset=xdisplay[parent].image->bytes_per_line;
  for (y=temp2; y<temp2+temp4; y++)
    memcpy((char *)(data+(y-temp2)*temp3),
	   (xdisplay[parent].image->data+temp1+y*offset),
	   temp3*sizeof(char));

  width_temp=(xdisplay[parent].pick_x*temp3)/xdisplay[image_count].pick_x; 
width_temp=xdisplay[*id1].image->width;
  height_temp=(xdisplay[parent].pick_y*temp4)/xdisplay[image_count].pick_y;
  raster[image_count]=(unsigned char *)malloc(width_temp*height_temp
					      *sizeof(char));

  traceH[image_count]=traceH[*id];

  offset=temp3;
  scale_x=xdisplay[image_count].pick_x/xdisplay[parent].pick_x;
  scale_y=xdisplay[image_count].pick_y/xdisplay[parent].pick_y;

  for (y=0; y<height_temp; y++)
    for (x=0; x<width_temp; x++)
      *(raster[image_count]+x+y*width_temp)=*(data+(int)(x*scale_x)+
					      (int)(y*scale_y)*offset);

  xdisplay[image_count].image=XCreateImage(display,visual,screenDepth,ZPixmap,
                                           0,(char *)raster[image_count],
					   width_temp,height_temp,screenDepth,0);

  screen_size(*id,&width_temp,&height_temp);

  main_window=XmCreateMainWindowVa(zoom_window,"child_form",
				   XmNshowSeparator,True,
				   NULL);

  strcpy(xdisplay[image_count].filename,xdisplay[*id].filename);
  window_title(buf,image_count);
  
  XtVaSetValues(zoom_window,
		XmNtitle,buf,
		NULL);

  zoom_form=XmCreateFormVa(main_window,"main",
			   XmNwidth,width_temp,
			   XmNheight,height_temp+MIN_HEIGHT,
			   NULL);

                                /* Indicate general mode. */
  xdisplay[image_count].mode=1;
  set_mode_label(1,image_count);

  app_menus(zoom_form,image_count,False);

  xdisplay_image(image_count,zoom_window,zoom_form, width_temp,height_temp);

  XtRealizeWidget(zoom_window);

  *id=image_count;

  if (flag_switch) {
    temp=*id;
    *id=*id1;
    *id1=temp;
  }
}
