/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
  This file contains the functions for
  send comment to author.
*/

#include "xdisplayP.h"
#include "prototyping.h"

#define MAIL_DESTINATION	"bmars@trc.amoco.com"

static Widget text=NULL;


/*
  This function send the mail for
  a new user.
*/
void send_mail(void)
{
/*	RJM: no longer send mail from within xsd....do outside via startup script */
}



/*
  This function create a text widget
  where the user can type their comments
*/
void mail_commentsCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  Widget dialog_form;
  Widget button;
  ClientData *message;

  dialog_form=XmCreateFormDialogVa(w,"dataform",
				   XmNmarginHeight,10,
				   XmNmarginWidth,10,
				   XmNdeleteResponse,XmDO_NOTHING,
				   XmNdialogTitle,XMstr("Mail Comments"),
				   XtNmanageChild,False,
				   NULL);
  XtAddCallback(dialog_form,XmNhelpCallback,helpCB,"mail.help");

  sprintf(buf,"Comment about xsd for user %s.\n\n",getlogin());
  
  text=XmCreateTextVa(dialog_form,"comment",
		      XmNvalue,buf,
		      XmNrows,24,
		      XmNcolumns,40,
		      XmNeditMode,XmMULTI_LINE_EDIT,
		      XmNtopAttachment,XmATTACH_FORM,
		      XmNleftAttachment,XmATTACH_FORM,
		      XmNrightAttachment,XmATTACH_FORM,
		      NULL);

  message=(ClientData *)malloc(sizeof(ClientData));
  message->w=dialog_form;
  message->id=0;
  
  button=XmCreatePushButtonVa(dialog_form,"  OK  ",
			      XmNtopAttachment,XmATTACH_WIDGET,
			      XmNtopWidget,text,
			      XmNbottomAttachment,XmATTACH_FORM,
			      XmNleftAttachment,XmATTACH_FORM,
			      NULL);
  XtAddCallback(button,XmNactivateCallback,send_messageCB,message);

  
  button=XmCreatePushButtonVa(dialog_form,"Cancel",
			      XmNtopAttachment,XmATTACH_WIDGET,
			      XmNtopWidget,text,
			      XmNbottomAttachment,XmATTACH_FORM,
			      XmNrightAttachment,XmATTACH_FORM,  
			      NULL);
  XtAddCallback(button,XmNactivateCallback,destroyCB,dialog_form);


  XtManageChild(dialog_form);
}



/*
  This function mails the text
  from the text widget.
*/
void send_messageCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  ClientData *message=(ClientData *)client_data;
  char *str,*maildest;

  XmUpdateDisplay(w);

				/* Get text from text widget. */
  XtSetArg(args[0],XmNvalue,&str);
  XtGetValues(text,args,1);

  /* DWN 10/20/97 make mail destination an environment variable */

  maildest=getenv("XSD_MAIL_DESTINATION");

  if (maildest!=NULL && strlen(maildest)!=0) {

    sprintf(buf,"echo \"%s\" | mail %s",str, maildest);
    system(buf);

  }

  XtFree(str);

  if( message->w != NULL )
    XtDestroyWidget( message->w );
  free(message);
}
