/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
  This file contains the functions for
  creating the main menus.
*/

#include "xdisplayP.h"
#include "prototyping.h"

static void data_menu(long, Widget);
static void window_menu(long, Widget);
static void segment_menu(long, Widget);
static void build_menu(long, Widget);
static void misc_menu(long, Widget);
static void help_menu(Widget);
static void color_menu(long, Widget);
static void label_menu(long, Widget);

/*
  This function create the main
  menu for xsd.
*/
void app_menus(Widget main_form, long id, Boolean dual_flag)
{
  Widget menubar;

  menubar=XmCreateMenuBarVa(main_form,"menubar",
			    XmNtopAttachment,XmATTACH_FORM,
			    XmNleftAttachment,XmATTACH_FORM,
			    XmNrightAttachment,XmATTACH_FORM,
			    NULL);
  xdisplay[id].menubar=menubar;
			    
  if (id==0) {
    data_menu(id,menubar);
    window_menu(id,menubar);
    build_menu(id,menubar);
    misc_menu(id,menubar);
    help_menu(menubar);
    messages();
  } else {
    data_menu(id,menubar);
    window_menu(id,menubar);
    segment_menu(id,menubar);
    edit_segment_menu(id,menubar);
    color_menu(id,menubar);
    label_menu(id,menubar);
    build_menu(id,menubar);
    misc_menu(id,menubar);
    help_menu(menubar);
  }

  if (id!=0) {

    xdisplay[id].control=XmCreatePushButtonVa(main_form,"Display Controls",
					      XmNtopAttachment,XmATTACH_FORM,
					      XmNleftAttachment,XmATTACH_FORM,
					      XtNmanageChild,False,
					      XmNactivateCallback,
					      CBl(unsquishCB,(XtPointer)id),
					      NULL);

    xdisplay[id].menu=XmCreateFormVa(main_form,"form",
				     XmNtopAttachment,XmATTACH_WIDGET,
				     XmNtopWidget,menubar,
				     XmNleftAttachment,XmATTACH_FORM,
				     NULL );
    XtAddCallback(xdisplay[id].menu,XmNhelpCallback,helpCB,"window.help");

    if (dual_flag) color_half(xdisplay[id].menu,id);
    else color_sliders(xdisplay[id].menu,id);
  }
}



static void data_menu(long id, Widget menubar)
{
  Widget pulldown;
  Widget button;

  pulldown=XmCreatePulldownMenuVa(menubar,"pulldown",
				XtNmanageChild,False,
#ifdef TEAR_OFF_MENUS
				XmNtearOffModel, XmTEAR_OFF_ENABLED,/* RJM */
#endif
				XmNvisual, visual,	/* RJM */
				XmNdepth, screenDepth,	/* RJM */
				NULL);
  
  (void)XmCreateCascadeButtonVa(menubar,"File",
                                  XmNsubMenuId,pulldown,
                                  XmNmnemonic,(KeySym)'F',
                                  NULL);

  (void)XmCreatePushButtonVa(pulldown,"Open Data...",
                              XmNacceleratorText,XMstr("D"),
                              XmNaccelerator,"<Key>D",
                              XmNmnemonic,(KeySym)'D',
			      XmNactivateCallback,CBl(fileCB,(XtPointer)id),
			      NULL);

  (void)XmCreatePushButtonVa(pulldown,"Restart Server...",
			      XmNacceleratorText,XMstr("R"),
			      XmNaccelerator,"<Key>R",
                              XmNmnemonic,(KeySym)'R',
			      XmNactivateCallback,CBl(start_serverCB,(XtPointer)id),
			      NULL);

  (void)XmCreatePushButtonVa(pulldown,"Get Data List...",
                              XmNmnemonic,(KeySym)'L',
			      XmNactivateCallback,CBl(exposeCB,(XtPointer)1L),
			      NULL);

  (void)XmCreatePushButtonVa(pulldown,"New Segments",
			      XmNacceleratorText,XMstr("Ctrl+N"),
			      XmNaccelerator,"Ctrl <Key>N",
                              XmNmnemonic,(KeySym)'N',
			      XmNactivateCallback,CBl(segment_verifyCB,(XtPointer)id),
			      NULL);

  if( id != 0 ) {	/* RJM: added else loads into id 0 == main menu */
    button=XmCreatePushButtonVa(pulldown,"Open Segments...",
			      XmNacceleratorText,XMstr("S"),
			      XmNaccelerator,"<Key>S",
                              XmNmnemonic,(KeySym)'S',
			      NULL);
    XtAddCallback(button,XmNactivateCallback,set_typeCB,(XtPointer)0L);
    XtAddCallback(button,XmNactivateCallback,filer_promptCB,(XtPointer)id);
  }

  button=XmCreatePushButtonVa(pulldown,"Save Segments...",
			      XmNacceleratorText,XMstr("Shift+S"),
			      XmNaccelerator,"Shift <Key>S",
                              XmNmnemonic,(KeySym)'S',
			      NULL);
  XtAddCallback(button,XmNactivateCallback,set_typeCB,(XtPointer)1L);
  XtAddCallback(button,XmNactivateCallback,filer_promptCB,(XtPointer)id);

  if (id!=0) {
    button=XmCreatePushButtonVa(pulldown,"Save Trc Header...",
			      XmNmnemonic,(KeySym)'x',
			      NULL);
    XtAddCallback(button,XmNactivateCallback,set_typeCB,(XtPointer)19L);
    XtAddCallback(button,XmNactivateCallback,filer_promptCB,(XtPointer)id);
  }

  (void)XmCreatePushButtonVa(pulldown,"New Overlay",
                              XmNmnemonic,(KeySym)'e',
			      XmNactivateCallback,CBl(new_overlayCB,(XtPointer)id),
			      NULL);

  if( id != 0 ) {	/* RJM: added else loads into id 0 == main menu */
    button=XmCreatePushButtonVa(pulldown,"Open Overlay...",
                              XmNmnemonic,(KeySym)'O',
			      NULL);
    XtAddCallback(button,XmNactivateCallback,set_typeCB,(XtPointer)14L);
    XtAddCallback(button,XmNactivateCallback,filer_promptCB,(XtPointer)id);
  }

  if (id!=0) {
    button=XmCreatePushButtonVa(pulldown,"Open Local Colormap...",
				XmNacceleratorText,XMstr("C"),
				XmNaccelerator,"<Key>C",
				XmNmnemonic,(KeySym)'C',
				NULL);
    XtAddCallback(button,XmNactivateCallback,set_typeCB,(XtPointer)10L);
    XtAddCallback(button,XmNactivateCallback,filer_promptCB,(XtPointer)id);
    
    button=XmCreatePushButtonVa(pulldown,"Open Global Colormap...",
				XmNacceleratorText,XMstr("Shift+C"),
				XmNaccelerator,"Shift <Key>C",
				XmNmnemonic,(KeySym)'G',
				NULL);
    XtAddCallback(button,XmNactivateCallback,set_typeCB,(XtPointer)6L);
    XtAddCallback(button,XmNactivateCallback,filer_promptCB,(XtPointer)id);
  }
  
  button=XmCreatePushButtonVa(pulldown,"Open Image File...",
                              XmNmnemonic,(KeySym)'L',
			      NULL);
  XtAddCallback(button,XmNactivateCallback,set_typeCB,(XtPointer)2L);
  XtAddCallback(button,XmNactivateCallback,filer_promptCB,(XtPointer)0L);

  if (id!=0) {
    button=XmCreatePushButtonVa(pulldown,"Open Labels...",
				XmNmnemonic,(KeySym)'L',
				NULL);
    XtAddCallback(button,XmNactivateCallback,set_typeCB,(XtPointer)8L);
    XtAddCallback(button,XmNactivateCallback,filer_promptCB,(XtPointer)id);
    
    button=XmCreatePushButtonVa(pulldown,"Save Labels...",
				XmNmnemonic,(KeySym)'S',
				NULL);
    XtAddCallback(button,XmNactivateCallback,set_typeCB,(XtPointer)9L);
    XtAddCallback(button,XmNactivateCallback,filer_promptCB,(XtPointer)id);
  }
  (void)XmCreatePushButtonVa(pulldown,"Exit",
			      XmNacceleratorText,XMstr("Ctrl+x"),
			      XmNaccelerator,"Ctrl <Key>x",
                              XmNmnemonic,(KeySym)'x',
			      XmNactivateCallback,
			      CBl(exit_verifyCB,(XtPointer)(long)NULL),
			      NULL);
}


static void window_menu(long id, Widget menubar)
{
  Widget pulldown;
  Widget button;

  pulldown=XmCreatePulldownMenuVa(menubar,"pulldown",
				XtNmanageChild,False,
#ifdef TEAR_OFF_MENUS
				XmNtearOffModel, XmTEAR_OFF_ENABLED,/* RJM */
#endif
				XmNvisual, visual,	/* RJM */
				XmNdepth, screenDepth,	/* RJM */
				NULL);
  
  (void)XmCreateCascadeButtonVa(menubar,"Window",
				  XmNmnemonic,(KeySym)'W',
				  XmNsubMenuId,pulldown,
				  NULL);

  if (id!=0) {
    (void)XmCreatePushButtonVa(pulldown,"Hide",
				XmNmnemonic,(KeySym)'H',
				XmNacceleratorText,XMstr("Alt+H"),
				XmNaccelerator,"Alt <Key>H",
				XmNactivateCallback,CBl(hideCB,(XtPointer)id),
				NULL);
  } else {
    (void)XmCreatePushButtonVa(pulldown,"Hide",
				XmNmnemonic,(KeySym)'H',
				XmNacceleratorText,XMstr("Alt+H"),
				XmNaccelerator,"Alt <Key>H",
				XmNactivateCallback,CBl(hideCB,(XtPointer)id),
				XmNsensitive,False,
				NULL);
  }
  (void)XmCreatePushButtonVa(pulldown,"Expose",
                              XmNmnemonic,(KeySym)'E',
			      XmNacceleratorText,XMstr("Alt+E"),
			      XmNaccelerator,"Alt <Key>E",
			      XmNactivateCallback,CBl(exposeCB,False),
			      NULL);

  (void)XmCreatePushButtonVa(pulldown,"Global",
                              XmNmnemonic,(KeySym)'G',
			      XmNacceleratorText,XMstr("Alt+G"),
			      XmNaccelerator,"Alt <Key>G",
			      XmNactivateCallback,CBl(globalCB,(XtPointer)id),
			      NULL);

  if (id!=0) {
    if (strcmp(xdisplay[id].filename,"Animation")!=0) {
      (void)XmCreatePushButtonVa(pulldown,"Print Section",
				  XmNmnemonic,(KeySym)'P',
				  XmNactivateCallback,CBl(save_printCB,(XtPointer)id),
				  NULL);
      
      (void)XmCreatePushButtonVa(pulldown,"Hide Controls",
				  XmNactivateCallback,CBl(squishCB,(XtPointer)id),
				  NULL);
      
      (void)XmCreatePushButtonVa(pulldown,"Zoom & Copy",
				  XmNmnemonic,(KeySym)'Z',
				  XmNactivateCallback,CBl(zoom_allCB,(XtPointer)id),
				  NULL);
      
      (void)XmCreatePushButtonVa(pulldown,"Drag & Zoom",
				  XmNmnemonic,(KeySym)'D',
				  XmNactivateCallback,
				  CBl(set_modeCB,(XtPointer)(0x0000|id)),
				  NULL);
      
      (void)XmCreatePushButtonVa(pulldown,"Create Wiggles",
				  XmNmnemonic,(KeySym)'W',
				  XmNactivateCallback,CBl(wiggleCB,(XtPointer)id),
				  NULL);
      
      (void)XmCreatePushButtonVa(pulldown,"Set Grid Lines",
				  XmNmnemonic,(KeySym)'r',
				  XmNactivateCallback,CBl(grid_attributesCB,(XtPointer)id),
				  NULL);
      
      button=XmCreateToggleButtonVa(pulldown,"Axes On/Off",
				    NULL);
      XmToggleButtonSetState(button,xdisplay[id].axis_flag,False);
      XtAddCallback(button,XmNvalueChangedCallback,set_flagCB,&xdisplay[id].axis_flag);
      XtAddCallback(button,XmNvalueChangedCallback,refresh_imageCB,(XtPointer)id);
      
      button=XmCreateToggleButtonVa(pulldown,"Axes uses Trace Header",
				    NULL);
      XmToggleButtonSetState(button,xdisplay[id].axis_style,False);
      XtAddCallback(button,XmNvalueChangedCallback,set_flagCB,&xdisplay[id].axis_style);
      XtAddCallback(button,XmNvalueChangedCallback,refresh_imageCB,(XtPointer)id);
      
      
      (void)XmCreatePushButtonVa(pulldown,"Comment Window",
				  XmNmnemonic,(KeySym)'C',
				  XmNactivateCallback,CBl(commentCB,(XtPointer)id),
				  NULL);
      
      (void)XmCreatePushButtonVa(pulldown,"Lowpass Filter",
				  XmNmnemonic,(KeySym)'L',
				  XmNactivateCallback,CBl(lowpassCB,(XtPointer)id),
				  NULL);
    }

    (void)XmCreatePushButtonVa(pulldown,"Delete",
				XmNmnemonic,(KeySym)'D',
				XmNactivateCallback,CBl(delete_windowCB,(XtPointer)id),
				NULL);
  }
}


static void segment_menu(long id, Widget menubar)
{
  Widget pulldown;
  Widget toggle;

  pulldown=XmCreatePulldownMenuVa(menubar,"pulldown",
				XtNmanageChild,False,
#ifdef TEAR_OFF_MENUS
				XmNtearOffModel, XmTEAR_OFF_ENABLED,/* RJM */
#endif
				XmNvisual, visual,	/* RJM */
				XmNdepth, screenDepth,	/* RJM */
				NULL);
  
  (void)XmCreateCascadeButtonVa(menubar,"Segment",
				  XmNmnemonic,(KeySym)'S',
				  XmNsubMenuId,pulldown,
				  NULL);

  if (id!=0) {
    (void)XmCreatePushButtonVa(pulldown,"Add Segments",
				XmNmnemonic,(KeySym)'S',
				XmNacceleratorText,XMstr("Shift+S"),
				XmNaccelerator,"Shift <Key>S",
				XmNactivateCallback,CBl(set_modeCB,(XtPointer)(0x1000|id)),
				NULL);
    
    toggle=XmCreateToggleButtonVa(pulldown,"Hide Segments on/off",
				  NULL);
    XtAddCallback(toggle,XmNvalueChangedCallback,set_flagCB,&xdisplay[id].segment_flag);
    XtAddCallback(toggle,XmNvalueChangedCallback,refresh_imageCB,(XtPointer)id);
    
    toggle=XmCreateToggleButtonVa(pulldown,"Hide Overlay on/off",
				  NULL);
    XtAddCallback(toggle,XmNvalueChangedCallback,set_flagCB,&xdisplay[id].overlay_flag);
    XtAddCallback(toggle,XmNvalueChangedCallback,refresh_imageCB,(XtPointer)id);
    
    toggle=XmCreateToggleButtonVa(pulldown,"Honor Record on/off",
				  NULL);
    XtAddCallback(toggle,XmNvalueChangedCallback,set_flagCB,&xdisplay[id].record_flag);
    XtAddCallback(toggle,XmNvalueChangedCallback,refresh_imageCB,(XtPointer)id);
    xdisplay[id].record_flag=True;
    XmToggleButtonSetState(toggle,xdisplay[id].record_flag,False);
    
    toggle=XmCreateToggleButtonVa(pulldown,"Segment Labels on/off",
				  NULL);
    XtAddCallback(toggle,XmNvalueChangedCallback,set_flagCB,&xdisplay[id].label_flag);
    XtAddCallback(toggle,XmNvalueChangedCallback,refresh_imageCB,(XtPointer)id);
    xdisplay[id].label_flag=True;
    XmToggleButtonSetState(toggle,xdisplay[id].label_flag,False);
    
    toggle=XmCreateToggleButtonVa(pulldown,"Segment Numbers on/off",
				  NULL);
    XtAddCallback(toggle,XmNvalueChangedCallback,set_flagCB,&xdisplay[id].number_flag);
    XtAddCallback(toggle,XmNvalueChangedCallback,refresh_imageCB,(XtPointer)id);
    XmToggleButtonSetState(toggle,xdisplay[id].number_flag,False);
    
    toggle=XmCreateToggleButtonVa(pulldown,"Lines on/off",
				  NULL);
    XtAddCallback(toggle,XmNvalueChangedCallback,set_flagCB,&xdisplay[id].lines_flag);
    XtAddCallback(toggle,XmNvalueChangedCallback,refresh_imageCB,(XtPointer)id);
    XmToggleButtonSetState(toggle,xdisplay[id].lines_flag,False);
    
    
    (void)XmCreatePushButtonVa(pulldown,"Copy Segment From/To",
				XmNmnemonic,(KeySym)'C',
				XmNactivateCallback,CBl(change_recordCB,(XtPointer)id),
				NULL);
    
    (void)XmCreatePushButtonVa(pulldown,"Auto Picking",
				XmNmnemonic,(KeySym)'u',
				XmNactivateCallback,CBl(auto_pickCB,(XtPointer)id),
				NULL);    
    
    if (xdisplay[id].sort) {
      (void)XmCreatePushButtonVa(pulldown,"Toggle picks for sorts",
				  XmNmnemonic,(KeySym)'T',
				  XmNactivateCallback,CBl(set_middleCB,(XtPointer)id),
				  NULL);
    }
    
    (void)XmCreatePushButtonVa(pulldown,"Move Segment",
				XmNmnemonic,(KeySym)'M',
				XmNacceleratorText,XMstr("Ctrl+M"),
				XmNaccelerator,"Ctrl <Key>M",
				XmNactivateCallback,CBl(set_modeCB,(XtPointer)(0x8000|id)),
				NULL);
    
    (void)XmCreatePushButtonVa(pulldown,"Delete Segment",
				XmNmnemonic,(KeySym)'D',
				XmNacceleratorText,XMstr("Ctrl+D"),
				XmNaccelerator,"Ctrl <Key>D",
				XmNactivateCallback,CBl(set_modeCB,(XtPointer)(0x15000|id)),
				NULL);
    
    (void)XmCreatePushButtonVa(pulldown,"Duplicate Segment",
				XmNmnemonic,(KeySym)'u',
				XmNactivateCallback,CBl(set_modeCB,(XtPointer)(0x16000|id)),
				NULL);
    
    (void)XmCreatePushButtonVa(pulldown,"Refine Segment",
				XmNmnemonic,(KeySym)'R',
				XmNactivateCallback,CBl(set_modeCB,(XtPointer)(0x17000|id)),
				NULL);
    
    (void)XmCreatePushButtonVa(pulldown,"Split Segment",
				XmNmnemonic,(KeySym)'S',
				XmNactivateCallback,CBl(set_modeCB,(XtPointer)(0x6000|id)),
				NULL);
    
    (void)XmCreatePushButtonVa(pulldown,"Join Segment",
				XmNmnemonic,(KeySym)'J',
				XmNactivateCallback,CBl(set_modeCB,(XtPointer)(0x7000|id)),
				NULL);
    
    (void)XmCreatePushButtonVa(pulldown,"Label Segment",
				XmNmnemonic,(KeySym)'L',
				XmNactivateCallback,CBl(set_modeCB,(XtPointer)(0x18000|id)),
				NULL);
    
    (void)XmCreatePushButtonVa(pulldown,"Change Color",
				XmNmnemonic,(KeySym)'C',
				XmNactivateCallback,CBl(set_modeCB,(XtPointer)(0x19000|id)),
				NULL);
    
    (void)XmCreatePushButtonVa(pulldown,"Add Single Point Segment",
				XmNmnemonic,(KeySym)'A',
				XmNactivateCallback,CBl(set_modeCB,(XtPointer)(0x1b000|id)),
				NULL);
  }
}
  

static void color_menu(long id, Widget menubar)
{
  Widget pulldown;
/*Widget button; */

  pulldown=XmCreatePulldownMenuVa(menubar,"pulldown",
				XtNmanageChild,False,
#ifdef TEAR_OFF_MENUS
				XmNtearOffModel, XmTEAR_OFF_ENABLED,/* RJM */
#endif
				XmNvisual, visual,	/* RJM */
				XmNdepth, screenDepth,	/* RJM */
				NULL);
  
  (void)XmCreateCascadeButtonVa(menubar,"Color",
				  XmNmnemonic,(KeySym)'C',
				  XmNsubMenuId,pulldown,
				  NULL);

  (void)XmCreatePushButtonVa(pulldown,"Pick Color",
                              XmNmnemonic,(KeySym)'P',
			      XmNactivateCallback,CBl(pick_color_dialogCB,(XtPointer)id),
			      NULL);

  (void)XmCreatePushButtonVa(pulldown,"Set to Global Colormap",
                              XmNmnemonic,(KeySym)'G',
			      XmNactivateCallback,CBl(set_global_colorCB,(XtPointer)id),
			      NULL);

  (void)XmCreatePushButtonVa(pulldown,"Local Cursor Color",
                              XmNmnemonic,(KeySym)'C',
			      XmNactivateCallback,CBl(cursor_colorCB,(XtPointer)id),
			      NULL);

  (void)XmCreatePushButtonVa(pulldown,"Global Cursor Color",
                              XmNmnemonic,(KeySym)'l',
			      XmNactivateCallback,CBl(cursor_colorCB,(XtPointer)0),
			      NULL);

  (void)XmCreatePushButtonVa(pulldown,"Show Colormap Scale",
                              XmNmnemonic,(KeySym)'S',
			      XmNactivateCallback,CBl(show_colormapCB,(XtPointer)id),
			      NULL);

  (void)XmCreatePushButtonVa(pulldown,"Edit Colormap",
                              XmNmnemonic,(KeySym)'E',
			      XmNactivateCallback,CBl(edit_colormapCB,(XtPointer)id),
			      NULL);

  (void)XmCreatePushButtonVa(pulldown,"Segment Colors",
                              XmNmnemonic,(KeySym)'S',
			      XmNactivateCallback,CBl(segment_colorsCB,(XtPointer)id),
			      NULL);

  /* RJM: added back to this pulldown because customers wanted it */
/*button=XmCreatePushButtonVa(pulldown,"Open Local Colormap...",
                                XmNacceleratorText,XMstr("C"),
                                XmNaccelerator,"<Key>C",
                                XmNmnemonic,(KeySym)'C',
                                NULL);
  XtAddCallback(button,XmNactivateCallback,set_typeCB,(XtPointer)10L);
  XtAddCallback(button,XmNactivateCallback,filer_promptCB,(XtPointer)id);
 
  button=XmCreatePushButtonVa(pulldown,"Open Global Colormap...",
                                XmNacceleratorText,XMstr("Shift+C"),
                                XmNaccelerator,"Shift <Key>C",
                                XmNmnemonic,(KeySym)'G',
                                NULL);
  XtAddCallback(button,XmNactivateCallback,set_typeCB,(XtPointer)6L);
  XtAddCallback(button,XmNactivateCallback,filer_promptCB,(XtPointer)id);
*/
}


static void label_menu(long id, Widget menubar)
{
  Widget pulldown;
  Widget button;

  pulldown=XmCreatePulldownMenuVa(menubar,"pulldown",
				XtNmanageChild,False,
#ifdef TEAR_OFF_MENUS
				XmNtearOffModel, XmTEAR_OFF_ENABLED,/* RJM */
#endif
				XmNvisual, visual,	/* RJM */
				XmNdepth, screenDepth,	/* RJM */
				NULL);
  
  (void)XmCreateCascadeButtonVa(menubar,"Label",
				  XmNmnemonic,(KeySym)'L',
				  XmNsubMenuId,pulldown,
				  NULL);

  (void)XmCreatePushButtonVa(pulldown,"Create Label",
                              XmNmnemonic,(KeySym)'C',
			      XmNactivateCallback,CBl(add_labelCB,(XtPointer)id),
			      NULL);

  (void)XmCreatePushButtonVa(pulldown,"Delete Label",
                              XmNmnemonic,(KeySym)'D',
			      XmNactivateCallback,CBl(delete_labelCB,(XtPointer)id),
			      NULL);

  button=XmCreateToggleButtonVa(pulldown,"Hide Text Labels On/Off", 
				XmNmnemonic,(KeySym)'H',
				NULL);
  XmToggleButtonSetState(button,xdisplay[id].text_flag,False);
  XtAddCallback(button,XmNvalueChangedCallback,set_flagCB,
		&xdisplay[id].text_flag);
  XtAddCallback(button,XmNvalueChangedCallback,refresh_imageCB,(XtPointer)id);
  
  (void)XmCreatePushButtonVa(pulldown,"Rename Label",
                              XmNmnemonic,(KeySym)'R',
			      XmNactivateCallback,CBl(rename_labelCB,(XtPointer)id),
			      NULL);

  (void)XmCreatePushButtonVa(pulldown,"Move Label",
                              XmNmnemonic,(KeySym)'M',
			      XmNactivateCallback,CBl(move_labelCB,(XtPointer)id),
			      NULL);

  (void)XmCreatePushButtonVa(pulldown,"Copy Label",
                              XmNmnemonic,(KeySym)'C',
			      XmNactivateCallback,CBl(copy_labelCB,(XtPointer)id),
			      NULL);
}


static void build_menu(long id, Widget menubar)
{
  Widget pulldown;

  pulldown=XmCreatePulldownMenuVa(menubar,"pulldown",
				XtNmanageChild,False,
#ifdef TEAR_OFF_MENUS
				XmNtearOffModel, XmTEAR_OFF_ENABLED,/* RJM */
#endif
				XmNvisual, visual,	/* RJM */
				XmNdepth, screenDepth,	/* RJM */
				NULL);
  
  (void)XmCreateCascadeButtonVa(menubar,"Model",
				  XmNmnemonic,(KeySym)'M',
				  XmNsubMenuId,pulldown,
				  NULL);

  (void)XmCreatePushButtonVa(pulldown,"Start Velocity Builder",
                              XmNmnemonic,(KeySym)'S',
			      XmNactivateCallback,CBl(build_modelCB,(XtPointer)id),
			      NULL);

  (void)XmCreatePushButtonVa(pulldown,"Start Velocity Painter",
                              XmNmnemonic,(KeySym)'t',
			      XmNactivateCallback,CBl(vel_paintCB,(XtPointer)id),
			      NULL);
}


static void misc_menu(long id, Widget menubar)
{
  Widget pulldown;
  Widget button;

  pulldown=XmCreatePulldownMenuVa(menubar,"pulldown",
				XtNmanageChild,False,
#ifdef TEAR_OFF_MENUS
				XmNtearOffModel, XmTEAR_OFF_ENABLED,/* RJM */
#endif
				XmNvisual, visual,	/* RJM */
				XmNdepth, screenDepth,	/* RJM */
				NULL);

  (void)XmCreateCascadeButtonVa(menubar,"Options",
				  XmNmnemonic,(KeySym)'O',
				  XmNsubMenuId,pulldown,
				  NULL);

  (void)XmCreatePushButtonVa(pulldown,"Project",
                              XmNmnemonic,(KeySym)'P',
			      XmNactivateCallback,CBl(defaults_fileCB,(XtPointer)id),
			      NULL);

  if (id!=0) {
    (void)XmCreatePushButtonVa(pulldown,"Line Header",
				XmNmnemonic,(KeySym)'L',
				XmNactivateCallback,CBl(line_headerCB,(XtPointer)id),
				NULL);

    (void)XmCreatePushButtonVa(pulldown,"Trace Header Item 1",
				XmNmnemonic,(KeySym)'T',
				XmNactivateCallback,
				CBl(trace_headerCB,(XtPointer)((id<<8)|1)),
				NULL);

    (void)XmCreatePushButtonVa(pulldown,"Trace Header Item 2",
				XmNmnemonic,(KeySym)'r',
				XmNactivateCallback,
				CBl(trace_headerCB,(XtPointer)((id<<8)|2)),
				NULL);

    (void)XmCreatePushButtonVa(pulldown,"Trace Header Item 3",
				XmNmnemonic,(KeySym)'r',
				XmNactivateCallback,
				CBl(trace_headerCB,(XtPointer)((id<<8)|3)),
				NULL);
  }

  (void)XmCreatePushButtonVa(pulldown,"Mail Comments",
                              XmNmnemonic,(KeySym)'M',
			      XmNactivateCallback,CBl(mail_commentsCB,(XtPointer)id),
			      NULL);
  
  (void)XmCreatePushButtonVa(pulldown,"Save State",
                              XmNmnemonic,(KeySym)'S',
			      XmNactivateCallback,CBl(save_stateCB,(XtPointer)id),
			      NULL);
  (void)XmCreatePushButtonVa(pulldown,"Recover State",
                              XmNmnemonic,(KeySym)'R',
			      XmNactivateCallback,CBl(recover_stateCB,(XtPointer)id),
			      NULL);
  button=XmCreateToggleButtonVa(pulldown,"Verbose on/off",
				NULL);
  XmToggleButtonSetState(button,False,False);
  XtAddCallback(button,XmNvalueChangedCallback,set_flagCB,&verbose);
}


static void help_menu(Widget menubar)
{
  Widget pulldown;
  Widget cascade;

  pulldown=XmCreatePulldownMenuVa(menubar,"pulldown",
				XtNmanageChild,False,
#ifdef TEAR_OFF_MENUS
				XmNtearOffModel, XmTEAR_OFF_ENABLED,/* RJM */
#endif
				XmNvisual, visual,	/* RJM */
				XmNdepth, screenDepth,	/* RJM */
				NULL);
  
  cascade=XmCreateCascadeButtonVa(menubar,"Help",
				  XmNmnemonic,(KeySym)'H',
				  XmNsubMenuId,pulldown,
				  NULL);

  XtVaSetValues(menubar,
                XmNmenuHelpWidget,cascade,
                NULL);

  (void)XmCreatePushButtonVa(pulldown,"On Help",
                              XmNmnemonic,(KeySym)'H',
			      XmNactivateCallback,CBl(helpCB,"help.help"),
			      NULL);

  (void)XmCreatePushButtonVa(pulldown,"On Window",
                              XmNmnemonic,(KeySym)'W',
			      XmNactivateCallback,CBl(helpCB,"window.help"),
			      NULL);

  (void)XmCreatePushButtonVa(pulldown,"On Version",
                              XmNmnemonic,(KeySym)'V',
			      XmNactivateCallback,CBl(versionCB,0),
			      NULL);

  (void)XmCreatePushButtonVa(pulldown,"On News",
                              XmNmnemonic,(KeySym)'N',
			      XmNactivateCallback,CBl(helpCB,"update.help"),
			      NULL);
}


void edit_segment_menu(long id, Widget menubar)
{
  Widget pulldown;
  Widget button;

  pulldown=XmCreatePulldownMenuVa(menubar,"pulldown",
				XtNmanageChild,False,
#ifdef TEAR_OFF_MENUS
				XmNtearOffModel, XmTEAR_OFF_ENABLED,/* RJM */
#endif
				XmNvisual, visual,	/* RJM */
				XmNdepth, screenDepth,	/* RJM */
				NULL);
  
  (void)XmCreateCascadeButtonVa(menubar,"Picks",
				  XmNmnemonic,(KeySym)'P',
				  XmNsubMenuId,pulldown,
				  NULL);

  (void)XmCreatePushButtonVa(pulldown,"Undo",
			      XmNmnemonic,(KeySym)'U',
                              XmNacceleratorText,XMstr("Ctrl+U"),
                              XmNaccelerator,"Ctrl <Key>U",
			      XmNactivateCallback,CBl(undoCB,(XtPointer)id),
			      NULL);

  (void)XmCreatePushButtonVa(pulldown,"Move Picks",
			      XmNmnemonic,(KeySym)'M',
                              XmNacceleratorText,XMstr("Shift+M"),
                              XmNaccelerator,"Shift <Key>M",
			      XmNactivateCallback,CBl(set_modeCB,(XtPointer)(0x3000|id)),
			      NULL);

  (void)XmCreatePushButtonVa(pulldown,"Delete Picks",
			      XmNmnemonic,(KeySym)'D',
                              XmNacceleratorText,XMstr("Shift+D"),
                              XmNaccelerator,"Shift <Key>D",
			      XmNactivateCallback,CBl(set_modeCB,(XtPointer)(0x5000|id)),
			      NULL);

  (void)XmCreatePushButtonVa(pulldown,"Add Picks",
			      XmNmnemonic,(KeySym)'A',
                              XmNacceleratorText,XMstr("Shift+A"),
                              XmNaccelerator,"Shift <Key>A",
			      XmNactivateCallback,CBl(set_modeCB,(XtPointer)(0x4000|id)),
			      NULL);

  (void)XmCreatePushButtonVa(pulldown,"Round Picks Left",
			      XmNmnemonic,(KeySym)'L',
                              XmNacceleratorText,XMstr("Ctrl+L"),
                              XmNaccelerator,"Ctrl <Key>L",
			      XmNactivateCallback,CBl(set_modeCB,(XtPointer)(0xf000|id)),
			      NULL);

  (void)XmCreatePushButtonVa(pulldown,"Round Picks Right",
			      XmNmnemonic,(KeySym)'R',
                              XmNacceleratorText,XMstr("Ctrl+R"),
                              XmNaccelerator,"Ctrl <Key>R",
			      XmNactivateCallback,CBl(set_modeCB,(XtPointer)(0x10000|id)),
			      NULL);

  (void)XmCreatePushButtonVa(pulldown,"Round Picks Top",
			      XmNmnemonic,(KeySym)'T',
                              XmNacceleratorText,XMstr("Ctrl+T"),
                              XmNaccelerator,"Ctrl <Key>T",
			      XmNactivateCallback,CBl(set_modeCB,(XtPointer)(0x1d000|id)),
			      NULL);

  (void)XmCreatePushButtonVa(pulldown,"Round Picks Bottom",
			      XmNmnemonic,(KeySym)'B',
                              XmNacceleratorText,XMstr("Ctrl+B"),
                              XmNaccelerator,"Ctrl <Key>B",
			      XmNactivateCallback,CBl(set_modeCB,(XtPointer)(0x1e000|id)),
			      NULL);

  button=XmCreatePushButtonVa(pulldown,"Round Picks Point",
			      XmNmnemonic,(KeySym)'P',
                              XmNacceleratorText,XMstr("Ctrl+P"),
                              XmNaccelerator,"Ctrl <Key>P",
			      NULL);
  XtAddCallback(button,XmNactivateCallback,reset_roundCB,(XtPointer)id);
  XtAddCallback(button,XmNactivateCallback,set_modeCB,(XtPointer)(0x9000|id));

  button=XmCreatePushButtonVa(pulldown,"Round Picks Horizontal",
			      XmNmnemonic,(KeySym)'H',
                              XmNacceleratorText,XMstr("Ctrl+H"),
                              XmNaccelerator,"Ctrl <Key>H",
			      NULL);
  XtAddCallback(button,XmNactivateCallback,reset_roundCB,(XtPointer)id);
  XtAddCallback(button,XmNactivateCallback,set_modeCB,(XtPointer)(0xa000|id));

  button=XmCreatePushButtonVa(pulldown,"Round Picks Vertical",
                              XmNacceleratorText,XMstr("Ctrl+V"),
                              XmNaccelerator,"Ctrl <Key>V",
			      XmNmnemonic,(KeySym)'V',
			      NULL);
  XtAddCallback(button,XmNactivateCallback,reset_roundCB,(XtPointer)id);
  XtAddCallback(button,XmNactivateCallback,set_modeCB,(XtPointer)(0xb000|id));
}


void set_middleCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  long id;	/* RJM: handle 64-bit architectures */

  id=(long)client_data;

  if (xdisplay[id].middle)
    xdisplay[id].middle=0;
  else
    xdisplay[id].middle=1;

  expose_image(id);
}


/*
  This function prompts the user
  to verify that he/she wants to
  erase the segments.
*/
void segment_verifyCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  long id;	/* RJM: handle 64-bit architectures */
  Widget dialog;
 
  id=(long)client_data;

  XBell(display,100);
  dialog=XmCreateQuestionDialogVa(w,"Erase Verification",
				  XmNmessageString,
				  XMstr("Do you want to erase all segment(s)?"),
				  XmNdialogTitle,XMstr("Erase Verification"),
				  XmNokLabelString,XMstr(" Yes "),
				  XmNcancelLabelString,XMstr("No"),
				  NULL);
 
  XtAddCallback(dialog,XmNokCallback,new_segmentsCB,(XtPointer)id);
  XtAddCallback(dialog,XmNokCallback,erase_modelCB,(XtPointer)id);
  XtAddCallback(dialog,XmNokCallback,destroyCB,(XtPointer)dialog);
  XtAddCallback(dialog,XmNcancelCallback,destroyCB,(XtPointer)dialog);
}
 

/*
  This function refreshs the display.
*/
void refresh_imageCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  long id,id1;	/* RJM: handle 64-bit architectures */
  
  id=(long)client_data;

                                              /* Check for animation window. */
  if (strcmp(xdisplay[id].filename,"Animation")==0) {
    id1=animate_list[step_count];
    expose_animation(id,id1);
  } else {
    expose_image(id);
  }

  if( !xdisplay[id].axis_flag  && !xdisplay[id].hide_flag ) {
    XtUnmapWidget(xdisplay[id].window);	/* RJM: added to make sure is updated */
    XtMapWidget(xdisplay[id].window);
  }
}
