/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
  This file contains the function for
  set parmeters for the model building.
*/

#include "xdisplayP.h"
#include "prototyping.h"

extern Boolean server_flag;
extern int paint_index;

static void model_prompt(long);
static void modelCB(Widget , XtPointer , XtPointer );
static void model_parCB(Widget , XtPointer, XtPointer );
static void model_okCB(Widget , XtPointer , XtPointer );
static void model_cancelCB(Widget , XtPointer , XtPointer);

static Widget text_default[7];
static Widget toggle[4];

char vel_dir[1024];

void erase_modelCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  v_index=0;
}

/*
  This function prompts the user
  to pick one four states to start
  the velocity builder.
*/
void build_modelCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  Widget dialog_form;
  Widget dialog_window;
  Widget button;
  int root_x,root_y;
  long id;	/* RJM: handle 64-bit architectures */

  id=(long)client_data;

  if (!server_flag) {
    error_message("You must first start the data server.");
    return;
  }

  if (paint_index!=0) {
    error_message("You must first quit the velocity painter.");
    return;
  }

  locate_cursor(&root_x,&root_y);
  
  dialog_form=XmCreateFormDialogVa(xdisplay[id].window,"form",
				   XmNdefaultPosition,False,
				   XmNx,root_x,
				   XmNy,root_y,
				   XmNmarginHeight,10,
				   XmNmarginWidth,10,
				   XmNdeleteResponse,XmDO_NOTHING,
				   XmNdialogTitle,XMstr("Velocity Builder"),
				   XtNmanageChild,False,
				   NULL);
  XtAddCallback(dialog_form,XmNhelpCallback,helpCB,"model_par.help");

  dialog_window=XmCreateRadioBoxVa(dialog_form,"row_column",
				   XmNpacking,XmPACK_COLUMN,
				   XmNnumColumns,1,
				   XmNleftAttachment,XmATTACH_FORM,
				   XmNrightAttachment,XmATTACH_FORM,
				   XmNtopAttachment,XmATTACH_FORM,
				   XmNtopOffset,15,
				   NULL);

  toggle[0]=XmCreateToggleButtonVa(dialog_window,"Use velocity values stored in memory.",
				   NULL);
  toggle[1]=XmCreateToggleButtonVa(dialog_window,"Load velocity values and picks from a file.",
				   NULL);
  toggle[2]=XmCreateToggleButtonVa(dialog_window,"Load only the velocity values from a file.",
				   NULL);
  toggle[3]=XmCreateToggleButtonVa(dialog_window,"Clear all velocity values from memory.",
				   NULL);

  XmToggleButtonSetState(toggle[0],True,False);
  XmToggleButtonSetState(toggle[1],False,False);
  XmToggleButtonSetState(toggle[2],False,False);
  XmToggleButtonSetState(toggle[3],False,False);

  button=XmCreatePushButtonVa(dialog_form,"  OK  ",
			      XmNtopAttachment,XmATTACH_WIDGET,
			      XmNtopWidget,dialog_window,
			      XmNtopOffset,20,
			      XmNbottomAttachment,XmATTACH_FORM, 
			      XmNleftAttachment,XmATTACH_FORM, 
			      NULL);
  XtAddCallback(button,XmNactivateCallback,modelCB,(XtPointer)id);
  XtAddCallback(button,XmNactivateCallback,destroyCB,dialog_form); 
  
  button=XmCreatePushButtonVa(dialog_form,"Cancel",
			      XmNtopAttachment,XmATTACH_WIDGET,
			      XmNtopWidget,dialog_window,
			      XmNtopOffset,20,
			      XmNbottomAttachment,XmATTACH_FORM, 
			      XmNrightAttachment,XmATTACH_FORM, 
			      NULL);
  XtAddCallback(button,XmNactivateCallback,destroyCB,dialog_form); 

  XtManageChild(dialog_form);
}


static void modelCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  long id = (long)client_data;	/* RJM: changed from ClientData */

  if (XmToggleButtonGetState(toggle[1])) {
    set_typeCB(w,(XtPointer)17L,(XtPointer)NULL);
    filer_promptCB(w,(XtPointer)id,(XtPointer)NULL);
    return;
  }
    
  if (XmToggleButtonGetState(toggle[2])) {
    set_typeCB(w,(XtPointer)18L,(XtPointer)NULL);
    filer_promptCB(w,(XtPointer)id,(XtPointer)NULL);
    return;
  }
    
  if (XmToggleButtonGetState(toggle[3]))
    v_index=0;

  model(id);
}


/*
  This function prompts the 
  user for the parameter for
  starting the velocity builder.
*/
void model(long id)
{
  Widget dialog;
  int n,m,root_x=0,root_y=0;
  Boolean flag=False;

  for (n=0; n<MAX_PICKS; n++) 
    if (picks[n].init==-1)
      for (m=0; m<picks[n].size; m++) 
	if (*(picks[n].record+m)!=1)
	{
	  flag=True;
	  break;
	}
      
  if (flag) {
    dialog=XmCreateQuestionDialogVa(top_level,"question",
				    XmNdefaultPosition,False,
				    XmNx,root_x,
				    XmNy,root_y,
				    XmNmessageString,
				    XMstr("There are segments that are not on record 1. Move them to record 1?"),
				    XmNdialogTitle,XMstr("Velocity Builder"),
				    XmNokLabelString,XMstr(" Yes "),
				    XmNcancelLabelString,XMstr("No"),
				    NULL);
    
    XtAddCallback(dialog,XmNokCallback,model_okCB,(XtPointer)id);
    XtAddCallback(dialog,XmNokCallback,destroyCB,dialog);	/* RJM: added */

    XtAddCallback(dialog,XmNcancelCallback,model_cancelCB,(XtPointer)id);
    XtAddCallback(dialog,XmNcancelCallback,destroyCB,dialog);	/* RJM: added */
  } else
    model_prompt(id);
}


static void model_okCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  long id = (long)client_data;
  int m,n;

  for (n=0; n<MAX_PICKS; n++) 
    if (picks[n].init==-1)
      for (m=0; m<picks[n].size; m++)
	*(picks[n].record+m)=1;
  
  model_prompt(id);
}


static void model_cancelCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  long id = (long)client_data;

  model_prompt(id);
}


/*
  This function prompts the 
  user for the parameter for
  starting the velocity builder.
*/
static void model_prompt(long id)
{
  Widget dialog_form;
  Widget dialog_window;
  Widget button;
  int root_x,root_y;

  locate_cursor(&root_x,&root_y);
  
  dialog_form=XmCreateFormDialogVa(xdisplay[id].window,"form",
				   XmNdefaultPosition,False,
				   XmNx,root_x,
				   XmNy,root_y,
				   XmNmarginHeight,10,
				   XmNmarginWidth,10,
				   XmNdeleteResponse,XmDO_NOTHING,
				   XmNdialogTitle,
				   	XMstr("Velocity Builder Setup"),
				   XtNmanageChild,False,
				XmNallowShellResize, True,
				   NULL);
  XtAddCallback(dialog_form,XmNhelpCallback,helpCB,"model_par2.help");
  
  dialog_window=XmCreateRowColumnVa(dialog_form,"row_column",
				    XmNpacking,XmPACK_COLUMN,
				    XmNnumColumns,1,
				    XmNspacing,MAGIC_SPACING,
				    XmNleftAttachment,XmATTACH_FORM,
				    XmNtopAttachment,XmATTACH_FORM,
				    XmNtopOffset,15,
				    NULL);

  (void)XmCreateLabelVa(dialog_window,"Input Velocity Tape",NULL);
  (void)XmCreateLabelVa(dialog_window,"Number of Traces",NULL);
  (void)XmCreateLabelVa(dialog_window,"Number of Samples",NULL);
  (void)XmCreateLabelVa(dialog_window,"Fill Factor",NULL);
  (void)XmCreateLabelVa(dialog_window,"Round Factor",NULL);
  (void)XmCreateLabelVa(dialog_window,"Global Minimum Vel",NULL);
  (void)XmCreateLabelVa(dialog_window,"Global Maximum Vel",NULL);

  dialog_window=XmCreateRowColumnVa(dialog_form,"row_column",
				    XmNpacking,XmPACK_COLUMN,
				    XmNnumColumns,1,
				    XmNtopAttachment,XmATTACH_FORM,
				    XmNrightAttachment,XmATTACH_FORM,
				    XmNleftAttachment,XmATTACH_WIDGET,
				    XmNleftWidget,dialog_window,
				    NULL);

  if (id==0) {
    strcpy(buf,"");
  } else {
    strcpy(buf,xdisplay[id].filename);
    strcpy(strrchr(buf,'/'),"/");
  }
  strcpy(vel_dir,buf);
  
  text_default[0]=XmCreateTextVa(dialog_window,"directory",
				 XmNvalue,vel_dir,
				 XmNcolumns,50,
				 NULL);
  if (id==0) {
    strcpy(buf,"");
  } else {
    sprintf(buf,"%d",ntrace[id]);
  }
  
  text_default[1]=XmCreateTextVa(dialog_window,"min",
				 XmNvalue,buf,
				 XmNcolumns,10,
				 NULL);
  if (id==0) {
    strcpy(buf,"");
  } else {
    sprintf(buf,"%d",nsamp[id]);
  }
  
  text_default[2]=XmCreateTextVa(dialog_window,"max",
				 XmNvalue,buf,
				 XmNcolumns,10,
				 NULL);
  
  sprintf(buf,"%d",fill_skip);
  
  text_default[3]=XmCreateTextVa(dialog_window,"text",
				 XmNvalue,buf,
				 XmNcolumns,10,
				 NULL);
  
  sprintf(buf,"%d",round_factor);
  
  text_default[4]=XmCreateTextVa(dialog_window,"text",
				 XmNvalue,buf,
				 XmNcolumns,10,
				 NULL);
  
  sprintf(buf,"%d",global_min);
  
  text_default[5]=XmCreateTextVa(dialog_window,"min",
				 XmNvalue,buf,
				 XmNcolumns,10,
				 NULL);
  
  sprintf(buf,"%d",global_max);
  
  text_default[6]=XmCreateTextVa(dialog_window,"max",
				 XmNvalue,buf,
				 XmNcolumns,10,
				 NULL);

  button=XmCreatePushButtonVa(dialog_form,"  OK  ",
			      XmNtopAttachment,XmATTACH_WIDGET,
			      XmNtopWidget,dialog_window,
			      XmNbottomAttachment,XmATTACH_FORM, 
			      XmNleftAttachment,XmATTACH_FORM, 
			      NULL);
  XtAddCallback(button,XmNactivateCallback,model_parCB,(XtPointer)id);
  XtAddCallback(button,XmNactivateCallback,destroyCB,dialog_form); 
  
  button=XmCreatePushButtonVa(dialog_form,"Cancel",
			      XmNtopAttachment,XmATTACH_WIDGET,
			      XmNtopWidget,dialog_window,
			      XmNbottomAttachment,XmATTACH_FORM, 
			      XmNrightAttachment,XmATTACH_FORM, 
			      NULL);
  XtAddCallback(button,XmNactivateCallback,destroyCB,dialog_form); 

  XtManageChild(dialog_form);
}


/*
  This function records the
  parameter and starts the builder.
*/
static void model_parCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  long id = (long)client_data;
  char *str,vel_filename[1024];

  XtSetArg(args[0],XmNvalue,&str); /* Get parameters. */
  XtGetValues(text_default[0],args,1);

  if (strcmp(vel_dir,str)!=0)
    strcpy(vel_filename,str);
  else 
    strcpy(vel_filename,"");
  XtFree(str);

  XtGetValues(text_default[1],args,1);
  sscanf(str,"%d",&model_width);
  XtFree(str);

  XtGetValues(text_default[2],args,1);
  sscanf(str,"%d",&model_height);
  XtFree(str);

  XtGetValues(text_default[3],args,1);
  sscanf(str,"%d",&fill_skip);
  XtFree(str);

  XtGetValues(text_default[4],args,1);
  sscanf(str,"%d",&round_factor);
  XtFree(str);

  XtGetValues(text_default[5],args,1);
  sscanf(str,"%d",&global_min);
  XtFree(str);

  XtGetValues(text_default[6],args,1);
  sscanf(str,"%d",&global_max);
  XtFree(str);

  real_width=model_width;
  real_height=model_height;

  if (fill_skip<1) fill_skip=1;

  model_width=model_width/fill_skip;
  model_height=model_height/fill_skip;

  if (strlen(vel_filename)==0) {
    if ((model_width==0)||(model_height==0)) {
      error_message("Cannot create velocity model with zero traces or samples.");
      return;
    }
  }

  build_model(id,vel_filename);
}
