/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
  This file contains the functions for
  the remote file selection.
*/

#include "xdisplayP.h"
#include "prototyping.h"

extern Widget dir[4];
extern Widget text_file[5];
extern Boolean dir_flag[4];
extern char directory[4][1024];
extern Boolean server_flag;
extern XtIntervalId time_out;

static Widget dir_list=NULL;
static Widget file_list=NULL;

Widget open_file_form=NULL;
Widget autoFormatDetectionWidget = NULL;
int open_file_init=0;
char old_filename[1024];
XmString dir_items[9216],file_items[9216];


/*
  This function prompts the user
  for the filename of the seismic data.
*/
void fileCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  Widget radio_box, row_column;
  Widget dir_label, file_label;
  Widget frame;
  Widget dir_form, file_form, select_form;
  Widget label;
  Widget button;
  Widget separator;
  int m,m1,n,nbytes,select,pos;
  long id;	/* RJM: handle 64-bit architectures */
  char *string;

  id=(long)client_data;

				/* Check if server is running. If not
				   start the server. */
  if (!server_flag) {
    start_serverCB(w,(XtPointer)id,call_data);
    return;
  }

  if( 0 != amoco_check_server( buf ) )
  {
#ifndef NO_TIME_OUT
	XtRemoveTimeOut(time_out);  /* abort error dialog pop-up */
#endif
	error_message( buf );
	error_message("Server error (12). Try restarting server.");
	return;
  }

				/* Create the filer box once. */
  if (open_file_init!=0) {
    XtSetArg(args[0],XmNvalue,&directory[0][0]);
    XtSetValues(text_file[0],args,1);
    XtSetArg(args[0],XmNvalue,&directory[1][0]);
    XtSetValues(text_file[1],args,1);
    XtSetArg(args[0],XmNvalue,&directory[2][0]);
    XtSetValues(text_file[2],args,1);
    XtSetArg(args[0],XmNvalue,&directory[3][0]);
    XtSetValues(text_file[3],args,1);
    XtSetArg(args[0],XmNvalue,old_filename); 
    XtSetValues(text_file[4],args,1);
    XtManageChild(open_file_form);
  } else {
    open_file_init=1;
    
    open_file_form=XmCreateFormDialogVa(w,"form",
					XmNmarginHeight,10,
					XmNmarginWidth,10,
					XmNautoUnmanage,False,
					XmNdeleteResponse,XmDO_NOTHING,
					XmNdialogTitle,XMstr("Seismic File"),
					XtNmanageChild,False,
					XmNallowShellResize, True,
					XmNhelpCallback,
					CBl(helpCB,"openfile.help"),
					NULL);
  
    radio_box=XmCreateRadioBoxVa(open_file_form,"radio_box",
				 XmNpacking,XmPACK_COLUMN,
				 XmNnumColumns,1,
				 XmNspacing,20,
				 XmNleftAttachment,XmATTACH_FORM,
				 XmNtopAttachment,XmATTACH_FORM,
				 XmNtopOffset,15,
				 NULL);
    
    dir[0]=XmCreateToggleButtonVa(radio_box,"Directory #1",
                 XmNheight,24,
                 NULL);
    dir[1]=XmCreateToggleButtonVa(radio_box,"Directory #2",
                 XmNheight,24,
                 NULL);
    dir[2]=XmCreateToggleButtonVa(radio_box,"Directory #3",
                 XmNheight,24,
                 NULL);
    dir[3]=XmCreateToggleButtonVa(radio_box,"Directory #4",
                 XmNheight,24,
                 NULL);

    XtAddCallback(dir[0],XmNarmCallback,show_watchCB,open_file_form);
    XtAddCallback(dir[0],XmNarmCallback,update_dirCB,0);
    XtAddCallback(dir[0],XmNarmCallback,hide_watchCB,open_file_form);
    XtAddCallback(dir[1],XmNarmCallback,show_watchCB,open_file_form);
    XtAddCallback(dir[1],XmNarmCallback,update_dirCB,(XtPointer)1L);
    XtAddCallback(dir[1],XmNarmCallback,hide_watchCB,open_file_form);
    XtAddCallback(dir[2],XmNarmCallback,show_watchCB,open_file_form);
    XtAddCallback(dir[2],XmNarmCallback,update_dirCB,(XtPointer)2L);
    XtAddCallback(dir[2],XmNarmCallback,hide_watchCB,open_file_form);
    XtAddCallback(dir[3],XmNarmCallback,show_watchCB,open_file_form);
    XtAddCallback(dir[3],XmNarmCallback,update_dirCB,(XtPointer)3L);
    XtAddCallback(dir[3],XmNarmCallback,hide_watchCB,open_file_form);

    XmToggleButtonSetState(dir[0],dir_flag[0],False);
    XmToggleButtonSetState(dir[1],dir_flag[1],False);
    XmToggleButtonSetState(dir[2],dir_flag[2],False);
    XmToggleButtonSetState(dir[3],dir_flag[3],False);
    
/*
    row_column=XmCreateRowColumnVa(open_file_form,"row_column",
				   XmNorientation,XmVERTICAL,
				   XmNadjustLast,False,
				   XmNentryAlignment,XmALIGNMENT_CENTER,
				   XmNpacking,XmPACK_COLUMN,
				   XmNnumColumns,1,
				   XmNtopAttachment,XmATTACH_FORM,
				   XmNleftAttachment,XmATTACH_WIDGET,
				   XmNleftWidget,radio_box,
				   XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET,
				   XmNbottomWidget,radio_box,
				   XmNrightAttachment,XmATTACH_FORM,
				   NULL);
*/

    row_column=XmCreateFormVa(open_file_form,"form",
			      XmNtopAttachment,XmATTACH_FORM,
			      XmNleftAttachment,XmATTACH_WIDGET,
			      XmNleftWidget,radio_box,
			      XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET,
			      XmNbottomWidget,radio_box,
			      XmNbottomOffset,-10,
			      XmNrightAttachment,XmATTACH_FORM,
			      NULL);
 
    text_file[0]=XmCreateTextVa(row_column,"text",
				XmNcolumns,50,
				XmNvalue,&directory[0][0],
				XmNtopAttachment,XmATTACH_POSITION,
				XmNtopPosition,0,
				XmNleftAttachment,XmATTACH_FORM,
				XmNrightAttachment,XmATTACH_FORM,
				NULL);
    XtAddCallback(text_file[0],XmNactivateCallback,show_watchCB,open_file_form);
    XtAddCallback(text_file[0],XmNactivateCallback,update_dirCB,0);
    XtAddCallback(text_file[0],XmNactivateCallback,hide_watchCB,open_file_form);
    
    text_file[1]=XmCreateTextVa(row_column,"text",
				XmNcolumns,50,
				XmNvalue,&directory[1][0],
				XmNtopAttachment,XmATTACH_POSITION,
				XmNtopPosition,25,
				XmNleftAttachment,XmATTACH_FORM,
				XmNrightAttachment,XmATTACH_FORM,
				NULL);
    XtAddCallback(text_file[1],XmNactivateCallback,show_watchCB,open_file_form);
    XtAddCallback(text_file[1],XmNactivateCallback,update_dirCB,(XtPointer)1L);
    XtAddCallback(text_file[1],XmNactivateCallback,hide_watchCB,open_file_form);
    
    text_file[2]=XmCreateTextVa(row_column,"text",
				XmNcolumns,50,
				XmNvalue,&directory[2][0],
				XmNtopAttachment,XmATTACH_POSITION,
				XmNtopPosition,50,
				XmNleftAttachment,XmATTACH_FORM,
				XmNrightAttachment,XmATTACH_FORM,
				NULL);
    XtAddCallback(text_file[2],XmNactivateCallback,show_watchCB,open_file_form);
    XtAddCallback(text_file[2],XmNactivateCallback,update_dirCB,(XtPointer)2L);
    XtAddCallback(text_file[2],XmNactivateCallback,hide_watchCB,open_file_form);
    
    text_file[3]=XmCreateTextVa(row_column,"text",
				XmNcolumns,50,
				XmNvalue,&directory[3][0],
				XmNtopAttachment,XmATTACH_POSITION,
				XmNtopPosition,75,
				XmNleftAttachment,XmATTACH_FORM,
				XmNrightAttachment,XmATTACH_FORM,
				NULL);
    XtAddCallback(text_file[3],XmNactivateCallback,show_watchCB,open_file_form);
    XtAddCallback(text_file[3],XmNactivateCallback,update_dirCB,(XtPointer)3L);
    XtAddCallback(text_file[3],XmNactivateCallback,hide_watchCB,open_file_form);
    
    if (strstr(ServerName, "dds"))
      autoFormatDetectionWidget = XmCreateToggleButtonVa(open_file_form,
		"Automagically recognize seismic data format",
		XmNset, True,
		XmNtopAttachment,XmATTACH_WIDGET,
		XmNtopWidget,radio_box,
		XmNtopOffset,20,
		XmNleftAttachment,XmATTACH_FORM,
		XmNleftOffset,10,
		NULL );

    /*
     * setup selection form
     */
    select_form=XmCreateFormVa(open_file_form,"form",
			XmNleftAttachment,XmATTACH_FORM,
			XmNrightAttachment,XmATTACH_FORM,
			XmNbottomAttachment,XmATTACH_FORM,
			NULL);
    
    label=XmCreateLabelVa(select_form,"Selection",
			  XmNleftAttachment,XmATTACH_FORM,
			  XmNtopAttachment,XmATTACH_FORM,
			  NULL);
    
    strcpy(buf,old_filename);
    
    text_file[4]=XmCreateTextVa(select_form,"text",
				XmNleftAttachment,XmATTACH_FORM,
				XmNrightAttachment,XmATTACH_FORM,
				XmNtopAttachment,XmATTACH_WIDGET,
				XmNtopWidget,label,
				XmNcolumns,25,
				XmNvalue,buf,
				NULL);
    XtAddCallback(text_file[4],XmNactivateCallback,show_watchCB,open_file_form);
    XtAddCallback(text_file[4],XmNactivateCallback,cancelCB,0);
    XtAddCallback(text_file[4],XmNactivateCallback,get_dataCB,0);
    XtAddCallback(text_file[4],XmNactivateCallback,hide_watchCB,open_file_form);
    
    separator=XmCreateSeparatorVa(select_form,"separator",
				  XmNleftAttachment,XmATTACH_FORM,
				  XmNrightAttachment,XmATTACH_FORM,
				  XmNtopAttachment,XmATTACH_WIDGET,
				  XmNtopWidget,text_file[4],
				  XmNtopOffset,10,
				  NULL);
    
    button=XmCreatePushButtonVa(select_form,"  OK  ",
				XmNtopAttachment,XmATTACH_WIDGET,
				XmNtopWidget,separator,
				XmNtopOffset,10,
				XmNbottomAttachment,XmATTACH_FORM,
				XmNleftAttachment,XmATTACH_POSITION,
				XmNleftPosition,12,
				XmNleftOffset,-25,
				NULL);
    XtAddCallback(button,XmNactivateCallback,show_watchCB,open_file_form);
    XtAddCallback(button,XmNactivateCallback,cancelCB,0);
    XtAddCallback(button,XmNactivateCallback,get_dataCB,0);
    XtAddCallback(button,XmNactivateCallback,hide_watchCB,open_file_form);
    
    button=XmCreatePushButtonVa(select_form,"Update",
				XmNtopAttachment,XmATTACH_WIDGET,
				XmNtopWidget,separator,
				XmNtopOffset,10,
				XmNbottomAttachment,XmATTACH_FORM,
				XmNleftAttachment,XmATTACH_POSITION,
				XmNleftPosition,37,
				XmNleftOffset,-25,
				NULL);
    XtAddCallback(button,XmNactivateCallback,updateCB,0);
    
    button=XmCreatePushButtonVa(select_form,"Cancel",
				XmNtopAttachment,XmATTACH_WIDGET,
				XmNtopWidget,separator,
				XmNtopOffset,10,
				XmNbottomAttachment,XmATTACH_FORM,
				XmNleftAttachment,XmATTACH_POSITION,
				XmNleftPosition,62,
				XmNleftOffset,-25,
				NULL);
    XtAddCallback(button,XmNactivateCallback,cancelCB,0);
    
    button=XmCreatePushButtonVa(select_form," Help ",
				XmNtopAttachment,XmATTACH_WIDGET,
				XmNtopWidget,separator,
				XmNtopOffset,10,
				XmNbottomAttachment,XmATTACH_FORM,
				XmNleftAttachment,XmATTACH_POSITION,
				XmNleftPosition,87,
				XmNleftOffset,-25,
				NULL);
    XtAddCallback(button,XmNactivateCallback,helpCB,"openfile.help");

    /*
     * setup directory list
     */
    dir_form=XmCreateFormVa(open_file_form,"form",
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,strstr( ServerName, "dds" ) ?
			autoFormatDetectionWidget: radio_box,
			XmNtopOffset,20,
			XmNleftAttachment,XmATTACH_FORM,
			XmNrightAttachment,XmATTACH_POSITION,
			XmNrightPosition,40,
			XmNbottomAttachment,XmATTACH_WIDGET,
			XmNbottomWidget,select_form,
			NULL);
    
    dir_label=XmCreateLabelVa(dir_form,"Directories               ",
			      XmNleftAttachment,XmATTACH_FORM,
			      XmNtopAttachment,XmATTACH_FORM,
			      NULL);
    
    if (dir_flag[0])
      select=0;
    if (dir_flag[1])
      select=1;
    if (dir_flag[2])
      select=2;
    if (dir_flag[3])
      select=3;
    
    strcpy(buf,&directory[select][0]);
    
    /* Get remote directory listing. */
    nbytes=amoco_ls_size(buf);
    if (nbytes < 0) reportDSerror(-95);
    string=(char *)malloc(nbytes+1);
    amoco_ls_files(string,nbytes);
    if (nbytes >= 0) *(string+nbytes) = '\0';
    
    m=0;
    m1=0;
    pos=nbytes;
    while (pos>0) {
      sscanf(string,"%s",buf);
      /* Check for "/" indicating a directory. */
      if (buf[strlen(buf)-1] == '/') {
	dir_items[m]=XmStringCreateLtoR(buf,XmSTRING_DEFAULT_CHARSET);
	m++;
      } else{
	file_items[m1]=XmStringCreateLtoR(buf,XmSTRING_DEFAULT_CHARSET);
	m1++;
      }	
      pos-=(strlen(buf)+1);
      if( pos > 0 )
        memcpy(string,(string+strlen(buf)+1),pos);
    }
    /* Mark the end of the lists. */
    dir_items[m]=NULL;
    file_items[m1]=NULL;
    if(string)
      free(string);
    
    frame=XmCreateFrameVa(dir_form,"frame",
			  XmNtopAttachment,XmATTACH_WIDGET,
			  XmNtopWidget,dir_label,
			  XmNleftAttachment,XmATTACH_FORM,
			  XmNrightAttachment,XmATTACH_FORM,
			  XmNbottomAttachment,XmATTACH_FORM,
			  NULL);
    
    dir_list=XmCreateScrolledListVa(frame,"datewindow",
				    XmNvisibleItemCount,15,
				    XmNlistSizePolicy,XmCONSTANT,
				    XmNscrollBarDisplayPolicy,XmSTATIC,
				    NULL);
    XtAddCallback(dir_list,XmNdefaultActionCallback,show_watchCB,open_file_form);
    XtAddCallback(dir_list,XmNdefaultActionCallback,set_dirCB,0);
    XtAddCallback(dir_list,XmNdefaultActionCallback,updateCB,0);
    XtAddCallback(dir_list,XmNdefaultActionCallback,hide_watchCB,open_file_form);
    if (m>0) XtVaSetValues(dir_list,
			   XmNitems,dir_items,
			   XmNitemCount,m,
			   NULL);
    
    /*
     * setup files list
     */
    file_form=XmCreateFormVa(open_file_form,"form",
			XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			XmNtopWidget,dir_form,
			XmNleftAttachment,XmATTACH_WIDGET,
			XmNleftWidget,dir_form,
			XmNleftOffset,10,
			XmNrightAttachment,XmATTACH_FORM,
			XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET,
			XmNbottomWidget,dir_form,
			NULL);
    
    file_label=XmCreateLabelVa(file_form,"Files",
			       XmNleftAttachment,XmATTACH_FORM,
			       XmNtopAttachment,XmATTACH_FORM,
			       NULL);
    
    frame=XmCreateFrameVa(file_form,"frame",
			  XmNtopAttachment,XmATTACH_WIDGET,
			  XmNtopWidget,file_label,
			  XmNleftAttachment,XmATTACH_FORM,
			  XmNrightAttachment,XmATTACH_FORM,
			  XmNbottomAttachment,XmATTACH_FORM,
			  NULL);
    
    file_list=XmCreateScrolledListVa(frame,"datewindow",
				     XmNvisibleItemCount,15,
				     XmNlistSizePolicy,XmCONSTANT,
				     XmNscrollBarDisplayPolicy,XmSTATIC,
				     NULL);
    XtAddCallback(file_list,XmNdefaultActionCallback,show_watchCB,open_file_form);
    XtAddCallback(file_list,XmNdefaultActionCallback,set_fileCB,0);
    XtAddCallback(file_list,XmNdefaultActionCallback,get_dataCB,0);
    XtAddCallback(file_list,XmNdefaultActionCallback,hide_watchCB,open_file_form);
    XtAddCallback(file_list,XmNdefaultActionCallback,cancelCB,0);
    XtAddCallback(file_list,XmNbrowseSelectionCallback,set_fileCB,0);
    if (m1>0) {
      XtVaSetValues(file_list,
		    XmNitems,file_items,
		    XmNitemCount,m1,
		    NULL);
    }
    
    for (n=0;n<m;n++)  XmStringFree(dir_items[n]);
    for (n=0;n<m1;n++) XmStringFree(file_items[n]);
    
    XtManageChild(open_file_form);
  }
}


/*
  This function updates the remote 
  file selection list. 
*/
void update_dirCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  char *string,*dirpath;
  int nbytes,n,m,m1,pos;
  long select;

  select=(long)client_data;

  XmToggleButtonSetState(dir[0],False,False);
  XmToggleButtonSetState(dir[1],False,False);
  XmToggleButtonSetState(dir[2],False,False);
  XmToggleButtonSetState(dir[3],False,False);
  XmToggleButtonSetState(dir[select],True,False);
  
  XtSetArg(args[0],XmNvalue,&dirpath);
  XtGetValues(text_file[0],args,1);
  if ((strchr(dirpath,'"')!=NULL)|| /* Checking for illegal characters. */
      (strchr(dirpath,'\'')!=NULL)||
      (strchr(dirpath,'`')!=NULL)) {
    error_message("Illegal character in directory path (ie. \" \' `)");
    return;
  }
  strcpy(&directory[0][0],dirpath);

  XtGetValues(text_file[1],args,1);
  if ((strchr(dirpath,'"')!=NULL)|| /* Checking for illegal characters. */
      (strchr(dirpath,'\'')!=NULL)||
      (strchr(dirpath,'`')!=NULL)) {
    error_message("Illegal character in directory path (ie. \" \' `)");
    return;
  }
  strcpy(&directory[1][0],dirpath);

  XtGetValues(text_file[2],args,1);
  if ((strchr(dirpath,'"')!=NULL)|| /* Checking for illegal characters. */
      (strchr(dirpath,'\'')!=NULL)||
      (strchr(dirpath,'`')!=NULL)) {
    error_message("Illegal character in directory path (ie. \" \' `)");
    return;
  }
  strcpy(&directory[2][0],dirpath);

  XtGetValues(text_file[3],args,1);
  if ((strchr(dirpath,'"')!=NULL)|| /* Checking for illegal characters. */
      (strchr(dirpath,'\'')!=NULL)||
      (strchr(dirpath,'`')!=NULL)) {
    error_message("Illegal character in directory path (ie. \" \' `)");
    return;
  }
  strcpy(&directory[3][0],dirpath);

  strcpy(buf,&directory[select][0]);

  /* Get remote directory listing. */
  nbytes=amoco_ls_size(buf);
  if (nbytes < 0) reportDSerror(-95);
  string=(char *)malloc(nbytes+1); /* RJM: need extra byte for NULL. */
  amoco_ls_files(string,nbytes);
  if (nbytes >= 0) *(string+nbytes) = '\0';

  m=0;
  m1=0;
  pos=nbytes;
  while (pos>0) {
    sscanf(string,"%s",buf);
				
    /* Check for "/" indicating a directory. */
    if (buf[strlen(buf)-1] == '/') {
      dir_items[m]=XmStringCreateLtoR(buf,XmSTRING_DEFAULT_CHARSET);
      m++;
    } else {
      file_items[m1]=XmStringCreateLtoR(buf,XmSTRING_DEFAULT_CHARSET);
      m1++;
    }	
    pos-=(strlen(buf)+1);
    if (pos > 0) memcpy(string,(string+strlen(buf)+1),pos);
  }
  dir_items[m]=NULL;
  file_items[m1]=NULL;
  if(string) free(string);

  XtVaSetValues(dir_list,
		XmNitems,dir_items,
		XmNitemCount,m,
		NULL);
  XtVaSetValues(file_list,
		XmNitems,file_items,
		XmNitemCount,m1,
		NULL);

  for (n=0; n<m; n++)
    XmStringFree(dir_items[n]);
  for (n=0; n<m1; n++)
    XmStringFree(file_items[n]);
}


/*
  This function updates.
*/
void updateCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  char *string,*dirpath;
  int m,m1,nbytes,n,select,pos;

  XtSetArg(args[0],XmNvalue,&dirpath);

  XtGetValues(text_file[0],args,1);
  strcpy(&directory[0][0],dirpath);
  XtGetValues(text_file[1],args,1);
  strcpy(&directory[1][0],dirpath);
  XtGetValues(text_file[2],args,1);
  strcpy(&directory[2][0],dirpath);
  XtGetValues(text_file[3],args,1);
  strcpy(&directory[3][0],dirpath);

  dir_flag[0]=XmToggleButtonGetState(dir[0]);
  dir_flag[1]=XmToggleButtonGetState(dir[1]);
  dir_flag[2]=XmToggleButtonGetState(dir[2]);
  dir_flag[3]=XmToggleButtonGetState(dir[3]);

  if (dir_flag[0]) select=0;
  if (dir_flag[1]) select=1;
  if (dir_flag[2]) select=2;
  if (dir_flag[3]) select=3;

  strcpy(buf,&directory[select][0]);

  nbytes=amoco_ls_size(buf);
  if (nbytes < 0) reportDSerror( -95 );
  string=(char *)malloc(nbytes+1);
  amoco_ls_files(string,nbytes);
  if (nbytes >= 0) *(string+nbytes) = '\0';

  m=0;
  m1=0;
  pos=nbytes;
  while (pos>0) {
    sscanf(string,"%s",buf);
    if (buf[strlen(buf)-1] == '/') {
      dir_items[m]=XmStringCreateLtoR(buf,XmSTRING_DEFAULT_CHARSET);
      m++;
    } else{
      file_items[m1]=XmStringCreateLtoR(buf,XmSTRING_DEFAULT_CHARSET);
      m1++;
    }	
    pos-=(strlen(buf)+1);
    if (pos > 0) memcpy(string,(string+strlen(buf)+1),pos);
  }
  dir_items[m]=NULL;
  file_items[m1]=NULL;
  if(string) free(string);
  
  XtVaSetValues(dir_list,
		XmNitems,dir_items,
		XmNitemCount,m,
		NULL);

  XtVaSetValues(file_list,
		XmNitems,file_items,
		XmNitemCount,m1,
		NULL);

  for (n=0; n<m; n++)
    XmStringFree(dir_items[n]);
  for (n=0; n<m1; n++)
    XmStringFree(file_items[n]);
}



/*
  This function updates the directory name.
*/
void set_dirCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  XmListCallbackStruct	*CBst = (XmListCallbackStruct*)call_data;
  int m,select;
  char *text,*dirpath, *ptr;

  XtSetArg(args[0],XmNvalue,&dirpath);

  XtGetValues(text_file[0],args,1);
  strcpy(&directory[0][0],dirpath);
  XtGetValues(text_file[1],args,1);
  strcpy(&directory[1][0],dirpath);
  XtGetValues(text_file[2],args,1);
  strcpy(&directory[2][0],dirpath);
  XtGetValues(text_file[3],args,1);
  strcpy(&directory[3][0],dirpath);

  dir_flag[0]=XmToggleButtonGetState(dir[0]);
  dir_flag[1]=XmToggleButtonGetState(dir[1]);
  dir_flag[2]=XmToggleButtonGetState(dir[2]);
  dir_flag[3]=XmToggleButtonGetState(dir[3]);

  if (dir_flag[0])
    select=0;
  if (dir_flag[1])
    select=1;
  if (dir_flag[2])
    select=2;
  if (dir_flag[3])
    select=3;

  strcpy(buf,&directory[select][0]);

  XmStringGetLtoR(CBst->item,XmSTRING_DEFAULT_CHARSET,&text);

  if (strcmp(text,"./")==0)
    return;

  /* remove any wildcard filename */
  ptr = strchr(buf,'*');
  if (ptr) {
    *ptr = '\0';
    ptr = strrchr(buf,'/');
    if (ptr) *ptr = '\0'; 
  }

  if (strcmp(text,"../")==0) {
    /* remove last subdirectory level */
    for(m=strlen(buf)-2;m>0;m--) {
      if (buf[m]=='/') {
         buf[m] = '\0';
         break;
      }
    }
  } else {
    /* tack on new subdirectory name */
    if (buf[strlen(buf)-1]!='/') strcat(buf,"/");
    strcat(buf,text);
  }
    

  strcpy(&directory[select][0],buf);

  XtSetArg(args[0],XmNvalue,buf); 

  if (dir_flag[0])
    XtSetValues(text_file[0],args,1);
  if (dir_flag[1])
    XtSetValues(text_file[1],args,1);
  if (dir_flag[2])
    XtSetValues(text_file[2],args,1);
  if (dir_flag[3])
    XtSetValues(text_file[3],args,1);
}


/*
  This function puts the filename in the text widget.
*/
void set_fileCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  XmListCallbackStruct	*CBst = (XmListCallbackStruct*)call_data;
  char *text;
 
  XmStringGetLtoR(CBst->item,XmSTRING_DEFAULT_CHARSET,&text);
 
  if (strcmp(&text[strlen(text)-1],"*")==0)
    strcpy(&text[strlen(text)-1],&text[strlen(text)]);

  XtSetArg(args[0],XmNvalue,text); 
  XtSetValues(text_file[4],args,1);
}



/*
  This function unmanages the remote filer box.
*/
void cancelCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  XtUnmanageChild(open_file_form);
}
