/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/************************************************************************
 * Routine: RMVDUPPOINTS2
 * Purpose: Remove duplicate points along curve segments.
 * Author:  Bob Mars
 * Date:    3-1-89
 ***********************************************************************/


typedef struct {
   float  x;
   float  y;
} Tuple, *Tupleptr;


void rmvduppoints2( crvs, ncrvs, ncrvpts, descriptors )
   Tupleptr	crvs[];
   int		*ncrvs, ncrvpts[];
   char		*descriptors[];
{
   int      ccrv, pt, i;


   for( ccrv = 0;  ccrv < *ncrvs;  ccrv++ )
      for( pt = 0;  pt < ncrvpts[ccrv]-1; )
         if( (crvs[ccrv]+pt)->x == (crvs[ccrv]+pt+1)->x  &&
             (crvs[ccrv]+pt)->y == (crvs[ccrv]+pt+1)->y )  {
            for( i = pt;  i < ncrvpts[ccrv] - 1;  i++ )  {
               (crvs[ccrv]+i)->x = (crvs[ccrv]+i+1)->x;
               (crvs[ccrv]+i)->y = (crvs[ccrv]+i+1)->y;
            }

            ncrvpts[ccrv]--;
         } else
            pt++;
}
