/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/************************************************************************
 * Routine: rmvdupsubsegs
 * Purpose: Remove colinear segments anywhere they may occur.
 * Author:  Bob Mars
 * Date:    4-6-90
 * Notes:   Colinear segments are those with identical vertices.
 *          There's plenty of room for improving the efficiency of this code. 
 ***********************************************************************/



#include <math.h>
#include <memory.h>
#include "std.h"


#define TOP_DOWN	1
#define IN_ORDER	2
#define SMALLEST_ANGLE	3


typedef struct {
   float  x;
   float  y;
} Tuple, *Tupleptr;


void rmvdupsubsegs( segs, nsegs, nsegpts, parentcrvs, method )
   Tupleptr   segs[];
   int        *nsegs, nsegpts[], parentcrvs[], method;
{
   static float		ymin();

   Boolean		same_seg2, done;
   unsigned int		seg1, seg2, pt1, pt2, nextpt1, nextpt2, prevpt2, seg;
   unsigned int		npts;
   float		seg1_ymin, seg2_ymin;


   for( seg1 = 0;  seg1 < *nsegs-1;  seg1++ )  {
      if( method == TOP_DOWN )
         seg1_ymin = ymin( segs[seg1], nsegpts[seg1] );
      for( seg2 = seg1+1;  seg2 < *nsegs;  seg2++ )  {
         if( method == TOP_DOWN )
            seg2_ymin = ymin( segs[seg2], nsegpts[seg2] );
         same_seg2 = FALSE;
         for( pt1 = 0;  pt1 < nsegpts[seg1];  pt1++ )  {
            for( pt2 = 0;  pt2 < nsegpts[seg2];  pt2++ )
               if( segs[seg1][pt1].x == segs[seg2][pt2].x  &&
                   segs[seg1][pt1].y == segs[seg2][pt2].y )  {
                  nextpt1 = (pt1+1) % nsegpts[seg1];
                  nextpt2 = (pt2+1) % nsegpts[seg2];
                  done = FALSE;
                  while( !done )
                     if( segs[seg1][nextpt1].x == segs[seg2][nextpt2].x  &&
                         segs[seg1][nextpt1].y == segs[seg2][nextpt2].y )
                        switch( method )  {
                        case TOP_DOWN:
                           if( seg1_ymin <= seg2_ymin )  {
                              /* give seg1 precedence; remove pts from seg2 */
                              if( (npts = nsegpts[seg2] - nextpt2 - 1) > 0 )
                                 (void)memcpy( (char *)&segs[seg2][pt2],
                                               (char *)&segs[seg2][nextpt2],
                                               npts * sizeof( Tuple ) );
                              --nsegpts[seg2];
                              if( npts == 0 )
                                 break;
                              nextpt1 = (nextpt1+1) % nsegpts[seg1];
                           } else {
                              /* give seg2 precedence; remove pts from seg1 */
                              if( (npts = nsegpts[seg1] - nextpt1 - 1) > 0 )
                                 (void)memcpy( (char *)&segs[seg1][pt1],
                                               (char *)&segs[seg1][nextpt1],
                                               npts * sizeof( Tuple ) );
                              --nsegpts[seg1];
                              if( npts == 0 )
                                 break;
                              nextpt2 = (nextpt2+1) % nsegpts[seg2];
                           }
                           break;
                        case IN_ORDER:  /* seg1 always gets precedence */
                           if( (npts = nsegpts[seg2] - nextpt2 - 1) > 0 )
                              (void)memcpy( (char *)&segs[seg2][pt2],
                                            (char *)&segs[seg2][nextpt2],
                                            npts * sizeof( Tuple ) );
                           --nsegpts[seg2];
                           if( npts == 0 )
                              break;
                           nextpt1 = (nextpt1+1) % nsegpts[seg1];
                           break;
                        case SMALLEST_ANGLE:
                           break;
                        }
                     else
                        done = TRUE;

                  prevpt2 = (pt2 == 0 ? nsegpts[seg2]-1: --pt2);
                  done = FALSE;
                  while( !done )
                     if( segs[seg1][nextpt1].x == segs[seg2][prevpt2].x  &&
                         segs[seg1][nextpt1].y == segs[seg2][prevpt2].y )  {
                        switch( method )  {
                        case TOP_DOWN:
                           if( seg1_ymin <= seg2_ymin )  {
                              /* give seg1 precedence; remove pts from seg2 */
                              if( (npts = nsegpts[seg2] - prevpt2 - 2) > 0 )
                                 (void)memcpy( (char *)&segs[seg2][prevpt2],
                                               (char *)&segs[seg2][prevpt2+1],
                                               npts * sizeof( Tuple ) );
                              --nsegpts[seg2];
                              if( npts == 0 )
                                 break;
                              nextpt1 = (nextpt1+1) % nsegpts[seg1];
                              prevpt2 = (prevpt2 == 0 ? nsegpts[seg2]-1
                                                      : --prevpt2);
                           } else {
                              /* give seg2 precedence; remove pts from seg1 */
                              if( (npts = nsegpts[seg1] - nextpt1 - 1) > 0 )
                                 (void)memcpy( (char *)&segs[seg1][pt1],
                                               (char *)&segs[seg1][nextpt1],
                                               npts * sizeof( Tuple ) );
                              --nsegpts[seg1];
                              if( npts == 0 )
                                 break;
                              prevpt2 = (prevpt2 == 0 ? nsegpts[seg2]-1
                                                      : --prevpt2);
                           }
                           break;
                        case IN_ORDER:  /* seg1 always gets precedence */
                           if( (npts = nsegpts[seg2] - prevpt2 - 2) > 0 )
                              (void)memcpy( (char *)&segs[seg2][prevpt2],
                                            (char *)&segs[seg2][prevpt2+1],
                                            npts * sizeof( Tuple ) );
                           --nsegpts[seg2];
                           if( npts == 0 )
                              break;
                           nextpt1 = (nextpt1+1) % nsegpts[seg1];
                           prevpt2 = (prevpt2 == 0 ? nsegpts[seg2]-1:--prevpt2);
                           break;
                        case SMALLEST_ANGLE:
                           break;
                        }
                     } else
                        done = TRUE;

                  if( nsegpts[seg2] == 0 )  {
                     free( segs[seg2] );  /* chuck seg2 */
                     for( seg = seg2;  seg < *nsegs - 1;  seg++ )  {
                        segs[seg] = segs[seg+1];
                        nsegpts[seg] = nsegpts[seg+1];
                        parentcrvs[seg] = parentcrvs[seg+1];
                     }

                     (*nsegs)--;
                     same_seg2 = TRUE;  
                     break;
                  } else
                     break;
               }
            if( same_seg2 )
               break;
         }
         if( same_seg2 )
            --seg2;
      }
   }
}


static float
ymin( segment, npts )
   Tupleptr		segment;
   unsigned int		npts;
{
   unsigned int		i;
   float		y_min = segment[0].y;


   for( i = 1;  i < npts;  i++ )
      if( segment[i].y < y_min )
         y_min = segment[i].y;

   return( y_min );
}
