/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
 *	Name: std.h
 *	Purpose: useful constants, operators, macros and adt's.
 *	Author: Bob Mars
 */

#ifndef _std_h
#define _std_h

#ifdef __convex__
#include <float.h>
#define MAXFLOAT	FLT_MAX
#define MAXDOUBLE	DBL_MAX
#else
#include <values.h>
#endif
#include "funcproto.h"
#include "C++ExternC.h"

#if defined(__sgi)
#define endl		'\n'
#endif
 
_CPLUSPLUSEXTERNCBEGIN

#ifndef OFF
#define OFF		0
#endif
#ifndef ON
#define ON		1
#endif

#ifndef MATCH
#define MATCH		0   /* useful for strcmp equivalence comparator */
#endif

#ifndef PI
#define PI		3.1415926535897932384626433
#endif

#ifndef SMALL_NUM
#define SMALL_NUM	-MAXFLOAT
#endif
#ifndef BIG_NUM
#define BIG_NUM		MAXFLOAT
#endif

#ifndef INTEGER_FIELD_SIZE
#define INTEGER_FIELD_SIZE	11
#endif
#ifndef FLOAT_FIELD_SIZE
#define FLOAT_FIELD_SIZE	16
#endif
#ifndef DOUBLE_FIELD_SIZE
#define DOUBLE_FIELD_SIZE	25
#endif

#ifndef FOREVER
#define FOREVER		for(;;)
#endif

#ifndef MIN
#define MIN(x,y)	((x) < (y) ? (x) : (y))
#endif

#ifndef MAX
#define MAX(x,y)	((x) > (y) ? (x) : (y))
#endif

#ifndef REALLOC
#define REALLOC(x,y)    ((x)? realloc((x),(y)) : malloc(y));
#endif

#define RENEW(a,n,b,t)	if( 0==(n)%(b) ) (a) = (t*)REALLOC( (a), \
						((n)/(b)+1)*(b)*sizeof(t))

#ifndef SQUARE
#define SQUARE(x)	((x) * (x))
#endif

#ifndef EVEN
#define EVEN(x)	((((x) / 2) * 2) == (x))
#endif

#ifndef ODD
#define ODD(x)	((((x) / 2) * 2) != (x))
#endif

#ifdef INT
#undef INT
#endif
#define INT		long;

#ifdef new_node
#undef new_node
#endif
#define new_node(type)	((type *) malloc( sizeof( type ) ))

typedef char	*Typeless;
typedef void	(*FunctionPtr)();


#ifdef _XtIntrinsic_h
/* #if defined(_XtIntrinsic_h) */

#if NeedFunctionPrototypes
/* #if defined(FUNCPROTO) || defined(__STDC__) || defined(__cplusplus) || defined(c_plusplus) */

#define CB_PROTO(func)	void func( Widget w, XtPointer client_data, \
				XtPointer call_data );
#define CB_DECL(func)	void func( Widget w, XtPointer client_data, \
				XtPointer call_data )
#define EH_PROTO(func)	void func( Widget w, XtPointer client_data, \
				XEvent *event, Boolean *continue_to_dispatch );
#define EH_DECL(func)	void func( Widget w, XtPointer client_data, \
				XEvent *event, Boolean *continue_to_dispatch )
typedef void    (*CB)( Widget w, XtPointer client_data, XtPointer call_data );

#endif

#endif /* _XtIntrinsic_h */


#ifndef _XtIntrinsic_h

typedef char	Boolean;
typedef char	*String;

#ifndef False
#define False	((Boolean)0)
#endif
#ifndef True
#define True	((Boolean)1)
#endif

#endif /* _XtIntrinsic_h */


#ifndef FALSE
#define FALSE		False
#endif
#ifndef TRUE
#define TRUE		True
#endif

_CPLUSPLUSEXTERNCEND

#endif /* _std_h */
