/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
  This file contains the functions for
  writting out a velocity tape.
*/

#include "xdisplayP.h"
#include "prototyping.h"
#include "ut_defs.h"

extern char vel_dir[1024];

static CB_PROTO( create_velCB )

static Widget vel_text[6];


/*
  Prompt use for parameters for writing velocity tape from vel. paint window.
*/
CB_DECL ( create_vel_tapeCB )
{
	static Widget	dialog_form = NULL;
	Widget		rowColumn;
	char		*header;
	int		rc, n, unit_flag=1, smpint=0;
	float		dx=0.0, dz=0.0;
	ClientData	*message;
	long		id = (long)client_data;	/* RJM: handle 64-bit architectures */

	if( dialog_form != NULL )
	{
		XtManageChild( dialog_form );
		return;
	}

	if (strlen(xdisplay[id].filename)!=0)
	{
		rc = amoco_read_line_header( &header, xdisplay[id].filename );
		if( rc < 0 )
			reportDSerror( rc );

		C_SAVER( (int*)header, "Dx1000", &n, 0 );
		dx=(float)n/1000.0;
		C_SAVER( (int*)header, "Dz1000", &n, 0 );
		dz=(float)n/1000.0;
		C_SAVER( (int*)header, "SmpInt", &n, 0 );
		smpint = n;
		C_SAVER( (int*)header, "UnitFl", &unit_flag, 0 );
		if( header )
			free( header );
	}

	dialog_form=XmCreateFormDialogVa(w,"velPaintForm",
		XmNmarginHeight,10,
		XmNmarginWidth,10,
		XmNdialogTitle,XMstr("Velocity Tape Parameters"),
		XtNmanageChild, False,
		XmNhelpCallback,
			CBl( helpCB, "vel.help" ),
		NULL);
  
	rowColumn=XmCreateRowColumnVa(dialog_form,"row_column",
		XmNpacking,XmPACK_COLUMN,
		XmNnumColumns,1,
		XmNspacing,MAGIC_SPACING,
		XmNleftAttachment,XmATTACH_FORM,
		XmNtopAttachment,XmATTACH_FORM,
		XmNtopOffset,MAGIC_SPACING,
		NULL);
 
	(void)XmCreateLabelVa(rowColumn,"Velocity File:",NULL);
	(void)XmCreateLabelVa(rowColumn,"Dx",NULL);
	(void)XmCreateLabelVa(rowColumn,"Dz",NULL);
	(void)XmCreateLabelVa(rowColumn,"SmpInt",NULL);
	(void)XmCreateLabelVa(rowColumn,"UnitFl (0=ft,1=m)",NULL);
	(void)XmCreateLabelVa(rowColumn,"Fill Factor",NULL);
 
	rowColumn=XmCreateRowColumnVa(dialog_form,"row_column",
		XmNpacking,XmPACK_COLUMN, 
		XmNnumColumns,1,
		XmNtopAttachment,XmATTACH_FORM,
		XmNleftAttachment,XmATTACH_WIDGET,
		XmNleftWidget,rowColumn,
		XmNrightAttachment,XmATTACH_FORM,
		NULL);

	vel_text[0]=XmCreateTextVa(rowColumn,"text",
		XmNvalue,vel_dir,
		XmNcolumns,50,
		NULL);

	sprintf(buf,"%f",dx);
	vel_text[1]=XmCreateTextVa(rowColumn,"text",
		XmNvalue,buf,
		XmNcolumns,50,
		NULL);

	sprintf(buf,"%f",dz);
	vel_text[2]=XmCreateTextVa(rowColumn,"text",
		XmNvalue,buf,
		XmNcolumns,50,
		NULL);
  
	sprintf(buf,"%d",smpint);
	vel_text[3]=XmCreateTextVa(rowColumn,"text",
		XmNvalue,buf,
		XmNcolumns,50,
		NULL);
  
	sprintf(buf,"%d",unit_flag);
	vel_text[4]=XmCreateTextVa(rowColumn,"text",
		XmNvalue,buf,
		XmNcolumns,50,
		NULL);
  
	sprintf(buf,"%d",fill_skip);
	vel_text[5]=XmCreateTextVa(rowColumn,"text",
		XmNvalue,buf,
		XmNcolumns,50,
		NULL);
  
	message=(ClientData *)malloc(sizeof(ClientData));
	message->w = dialog_form;
	message->id=id;
	(void)XmCreatePushButtonVa(dialog_form,"  OK  ",
		XmNtopAttachment,XmATTACH_WIDGET,
		XmNtopWidget,rowColumn,
		XmNtopOffset,10,
		XmNbottomAttachment,XmATTACH_FORM,
		XmNleftAttachment,XmATTACH_FORM,
		XmNactivateCallback,
			CBlist( show_watchCB, (XtPointer)dialog_form,
				create_velCB, (XtPointer)message,
				hide_watchCB, (XtPointer)dialog_form,
				NULL ),
		NULL);

	(void)XmCreatePushButtonVa(dialog_form,"Cancel",
		XmNtopAttachment,XmATTACH_WIDGET,
		XmNtopWidget,rowColumn,
		XmNtopOffset,10,
		XmNbottomAttachment,XmATTACH_FORM,
		XmNrightAttachment,XmATTACH_FORM,
		NULL);
 
	XtManageChild(dialog_form);
}
 

/*
	Generate velocity tape via genvel system call.
*/
static CB_DECL( create_velCB )
{
	ClientData	*message=(ClientData *)client_data;
	long		id;	/* RJM: handle 64-bit architectures */
	float		dx,dz;
	int		smpint, fill_skip, unit_flag;
	String		sis_out, str, slash;
	char		filename[1024];

	id=message->id;

	XtVaGetValues( vel_text[0], XmNvalue, &sis_out,
		NULL );

	if ( strcmp(xdisplay[id].hostname,"sc")==0	/* remote a Cray? */
	|| strcmp(xdisplay[id].hostname,"sk")==0
	|| strcmp(xdisplay[id].hostname,"sf")==0 )
	{
		if ((int)strlen(strrchr(sis_out,'/'))>15)
		{
			error_message("Velocity tape filename is too long for the Cray (14 character limit).");
			XtFree(sis_out);
			return;
		}
	}

	XtVaGetValues( vel_text[1], XmNvalue, &str,
		NULL );
	(void)sscanf(str,"%f",&dx);
	XtFree(str);

	XtVaGetValues( vel_text[2], XmNvalue, &str,
		NULL );
	(void)sscanf(str,"%f",&dz);
	XtFree(str);

	XtVaGetValues( vel_text[3], XmNvalue, &str,
		NULL );
	(void)sscanf(str,"%d",&smpint);
	XtFree(str);

	XtVaGetValues( vel_text[4], XmNvalue, &str,
		NULL );
	(void)sscanf(str,"%d",&unit_flag);
	XtFree(str);

	XtVaGetValues( vel_text[5], XmNvalue, &str,
		NULL );
	(void)sscanf(str,"%d",&fill_skip);
	XtFree(str);
	if( fill_skip < 0 )
		fill_skip = 1;

	if( strlen( xdisplay[id].hostname ) == 0 )
		(void)strcpy( xdisplay[id].hostname, "=" );

	if( (slash = strrchr( sis_out, '/' )) == NULL )
		strcpy( filename, "xsd.vel" );
	else					/* is a directory */
	{
		strncpy( filename, sis_out, slash-sis_out+1 );
		filename[slash-sis_out+1] = '\0';
		strcat( filename, "xsd.vel" );
	}

	if( strcmp( xdisplay[id].hostname, "=" ) == 0 )	/* local machine */
	{
		save_vel( filename );

		if( (int)strlen( xdisplay[id].filename ) == 0 )
			sprintf( buf,
				"genvel -P%s -O%s -X%f -Z%f -U%d -F%d -I%d",
				filename,sis_out,dx,dz,unit_flag,fill_skip,smpint);
		else
			sprintf( buf,
				"genvel -P%s -N%s -O%s -X%f -Z%f -U%d -F%d -I%d",
				filename,xdisplay[id].filename,sis_out,
				dx,dz,unit_flag,fill_skip,smpint);

		fprintf( stderr, "%s\n", buf );
		system(buf);
	}
	else						/* remote machine */
	{
		save_vel( "/tmp/xsd.vel" );

		sprintf(buf,"rcp /tmp/xsd.vel %s:%s",xdisplay[id].hostname,filename);
		fprintf( stderr, "%s\n", buf );
		system(buf);

		sprintf(buf,"rcp /tmp/xsd.vel.picks %s:%s.picks",xdisplay[id].hostname,filename);
		fprintf( stderr, "%s\n", buf );
		system(buf);

		if( (int)strlen( xdisplay[id].filename ) == 0 )
			sprintf(buf,
				"rsh -n %s genvel -P%s -O%s -X%f -Z%f -U%d -F%d -I%d",
				xdisplay[id].hostname,filename,
				sis_out,dx,dz,unit_flag,fill_skip,smpint);
		else
			sprintf(buf,
				"rsh -n %s genvel -P%s -N%s -O%s -X%f -Z%f -U%d -F%d -I%d",
				xdisplay[id].hostname,filename,
				xdisplay[id].filename,
				sis_out,dx,dz,unit_flag,fill_skip,smpint);

		fprintf( stderr, "%s\n", buf );
		system(buf);

/*		ERIC KEYSER DOESN'T WANT THESE DELETED! */
/*		unlink( filename );
		strcat( filename, ".picks" );
		unlink( filename );
*/
	}

	XtFree(sis_out);
 
	if( message->w != NULL )
		XtUnmanageChild( message->w );

/*	free(message);*//* RJM: CAN'T FREE message SINCE USER MAY CREATE >1
				VELOCITY TAPE FOR GIVEN WINDOW/MALLOC */
}
