/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
  This file contains the functions for
  generating wiggle traces.
*/

#include "xdisplayP.h"
#include "prototyping.h"

static void create_wiggle(int, long, int, int );

static Widget wiggle_text[7];
static Widget toggle[2];
static Widget draw_background=NULL;
static Widget draw_wiggle=NULL;
static Widget toggle_color[2];
Boolean toggle_value[2];
static int start_trace=1,skip_trace=3,zero_line=0;
static Pixel foreground;
static float wiggle_scale=1.0,overlap=10,scale_x=2.0,scale_y=1.0;
    
extern void vlint_( float*, int*, float*, int*, float*, int*, int* );


/*
  This function prompts the user
  for parameters to generate wiggles.
*/
void wiggleCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  Widget wiggle_window;
  Widget dialog_form;
  Widget dialog_window;
  Widget temp_widget;
  Widget label[7];
  Widget frame;
  Widget frame1;
  Widget form;
  Widget *buttons;
#if defined(__sgi) || defined(sun)	/* added sun in case redirect disp from sun to sgi */
  Widget backgroundColorButton;
  Widget wiggleColorButton;
#endif
  int n;
  long id = (long)client_data;	/* RJM: handle 64-bit architectures */
  ClientData *message;
  Pixel m;

  foreground=black;
  xdisplay[id].background=white;

  n=0;
  XtSetArg(args[n],XtNargc,savedArgc); n++;     /* RJM: added 1/17/97 */
  XtSetArg(args[n],XtNargv,savedArgv); n++;     /* RJM: added 1/17/97 */
  XtSetArg(args[n],XtNiconPixmap,xsd_pixmap); n++;
  XtSetArg(args[n],XtNvisual,visual); n++;
  XtSetArg(args[n],XtNdepth,screenDepth); n++;
/*wiggle_window=XtAppCreateShell("xsd","edit",
                               topLevelShellWidgetClass,display,args,n);
RJM: commented out 1/17/97 */
  wiggle_window=XtAppCreateShell(ApplicationName, ApplicationClass,	/* RJM: added 1/17/97 */
                               topLevelShellWidgetClass,display,args,n);
  quit_frame(wiggle_window);

  dialog_form=XmCreateFormVa(wiggle_window,"form", 
		XmNmarginHeight,10,
		XmNmarginWidth,10,
		XmNdialogTitle,XMstr("Wiggle Parameters"),
		XtNmanageChild,False,
		XmNhelpCallback, CBl( helpCB, (XtPointer)"wiggle.help" ),
		NULL);
  
  frame=XmCreateFrameVa(dialog_form,"frame",
			XmNtopAttachment,XmATTACH_FORM,
			XmNleftAttachment,XmATTACH_FORM,
			XmNrightAttachment,XmATTACH_FORM,
			NULL);

  dialog_window=XmCreateRowColumnVa(frame,"row_column",
				    XmNpacking,XmPACK_COLUMN,
				    XmNnumColumns,2,
				    XmNleftAttachment,XmATTACH_FORM,
				    XmNtopAttachment,XmATTACH_FORM,
				    NULL);

  label[0]=XmCreateLabelVa(dialog_window,"Start Trace",NULL);
  label[1]=XmCreateLabelVa(dialog_window,"Trace Increment",NULL);
  label[2]=XmCreateLabelVa(dialog_window,"Wiggle Amplitude",NULL);
  label[3]=XmCreateLabelVa(dialog_window,"Max deflection in pixels",NULL);
  label[4]=XmCreateLabelVa(dialog_window,"Zero Line",NULL);
  label[5]=XmCreateLabelVa(dialog_window,"Horizontal Zoom",NULL);
  label[6]=XmCreateLabelVa(dialog_window,"Vertical Zoom",NULL);
  
  sprintf(buf,"%d",start_trace);
  wiggle_text[0]=XmCreateTextVa(dialog_window,"text",
				XmNvalue,buf,
				NULL);
  sprintf(buf,"%d",skip_trace);
  wiggle_text[1]=XmCreateTextVa(dialog_window,"text",
				XmNvalue,buf,
				NULL);
  sprintf(buf,"%f",wiggle_scale);
  wiggle_text[2]=XmCreateTextVa(dialog_window,"text",
				XmNvalue,buf,
				NULL);
  sprintf(buf,"%f",overlap);
  wiggle_text[3]=XmCreateTextVa(dialog_window,"text",
				XmNvalue,buf,
				NULL);
  sprintf(buf,"%d",zero_line);
  wiggle_text[4]=XmCreateTextVa(dialog_window,"text",
				XmNvalue,buf,
				NULL);
  sprintf(buf,"%f",scale_x);
  wiggle_text[5]=XmCreateTextVa(dialog_window,"text",
				XmNvalue,buf,
				NULL);
  sprintf(buf,"%f",scale_y);
  wiggle_text[6]=XmCreateTextVa(dialog_window,"text",
				XmNvalue,buf,
				NULL);
  
  frame=XmCreateFrameVa(dialog_form,"frame",
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,frame,
			XmNleftAttachment,XmATTACH_FORM,
			XmNrightAttachment,XmATTACH_FORM,
			NULL);

  dialog_window=XmCreateFormVa(frame,"form",
			       NULL);

  toggle[1]=XmCreateToggleButtonVa(dialog_window,"Negative Fill",
				   XmNleftAttachment,XmATTACH_FORM,
				   XmNset,toggle_value[1],
				   NULL);
  
  toggle[0]=XmCreateToggleButtonVa(dialog_window,"Positive Fill",
				   XmNleftAttachment,XmATTACH_WIDGET,
				   XmNleftWidget,toggle[1],
				   XmNleftOffset,100,
				   XmNset,toggle_value[0],
				   NULL);
  
  frame1=XmCreateFrameVa(dialog_form,"frame",
			 XmNtopAttachment,XmATTACH_WIDGET,
			 XmNtopWidget,frame,
			 XmNleftAttachment,XmATTACH_FORM,
			 XmNrightAttachment,XmATTACH_FORM,
			 NULL);
  
  form=XmCreateFormVa(frame1,"form",
		      XmNleftAttachment,XmATTACH_FORM,
		      NULL);

  label[0]=XmCreateLabelVa(form,"Select a Color",
			   XmNleftAttachment,XmATTACH_FORM,
			   XmNtopAttachment,XmATTACH_FORM,
			   XmNtopOffset,10,
			   NULL);

  dialog_window=XmCreateRowColumnVa(form,"row_column",
				    XmNpacking,XmPACK_COLUMN,
				    XmNnumColumns,12,
				    XmNleftAttachment,XmATTACH_WIDGET,
				    XmNleftWidget,label[0],
				    XmNtopAttachment,XmATTACH_FORM,
				    NULL);
  temp_widget=dialog_window;
  
#if defined(__sgi) || defined(sun)	/* added sun in case redirect disp from sun to sgi */
  backgroundColorButton=XmCreatePushButtonVa(dialog_window,"  ",
#else
  (void)XmCreatePushButtonVa(dialog_window,"  ",
#endif
		XmNarmColor,black,
		XmNbackground,white,
		XmNtopShadowColor, black,
		XmNbottomShadowColor, black,
		XmNhighlightColor, white,
		XmNselectColor, black,
		XmNactivateCallback,
			CBl( set_wiggle_colorCB, (XtPointer)((id<<8)|white) ),
		NULL);

#if defined(__sgi) || defined(sun)	/* added sun in case redirect disp from sun to sgi */
  wiggleColorButton=XmCreatePushButtonVa(dialog_window,"  ",
#else
  (void)XmCreatePushButtonVa(dialog_window,"  ",
#endif
		XmNarmColor,black,
		XmNbackground,black,
		XmNtopShadowColor, black,
		XmNbottomShadowColor, black,
		XmNhighlightColor, white,
		XmNselectColor, black,
		XmNactivateCallback,
			CBl( set_wiggle_colorCB, (XtPointer)((id<<8)|black) ),
		NULL);

#if defined(__sgi) || defined(sun)	/* added sun in case redirect disp from sun to sgi */
    buttons = (Widget*)malloc( (end_pick_color-start_pick_color+1) * sizeof( Widget ) );
#endif

  for (m=start_pick_color; m<=end_pick_color; m++)
#if defined(__sgi) || defined(sun)	/* added sun in case redirect disp from sun to sgi */
	buttons[m-start_pick_color] = XmCreatePushButtonVa( dialog_window,"  ",
#else
	(void)XmCreatePushButtonVa( dialog_window,"  ",
#endif
			XmNarmColor,black,
			XmNbackground,(Pixel)m,
                        XmNtopShadowColor, black,
                        XmNbottomShadowColor, black,
                        XmNhighlightColor, white,
                        XmNselectColor, black,
			XmNactivateCallback,
				CBl( set_wiggle_colorCB,(XtPointer)((id<<8)|m)),
			NULL);

  dialog_window=XmCreateRadioBoxVa(form,"row_column",
				   XmNleftAttachment,XmATTACH_FORM,
				   XmNtopAttachment,XmATTACH_WIDGET,
				   XmNtopWidget,dialog_window,
				   NULL);
  
  toggle_color[0]=XmCreateToggleButtonVa(dialog_window,"Background Color",
			NULL);
  toggle_color[1]=XmCreateToggleButtonVa(dialog_window,"Wiggle Color",
			XmNset, True,
			NULL);

  dialog_window=XmCreateRowColumnVa(form,"row_column",
				    XmNpacking,XmPACK_COLUMN,
				    XmNnumColumns,1,
				    XmNleftAttachment,XmATTACH_WIDGET,
				    XmNleftWidget,dialog_window,
				    XmNtopAttachment,XmATTACH_WIDGET,
				    XmNtopWidget,temp_widget,
				    NULL);
  
  draw_background=XmCreatePushButtonVa(dialog_window,"  ",
		XmNbackground,white,
		XmNtopShadowColor, black,
		XmNbottomShadowColor, black,
		XmNhighlightColor, white,
		XmNselectColor, black,
		NULL);
  
  draw_wiggle=XmCreatePushButtonVa(dialog_window,"  ",
		XmNbackground,black,
		XmNtopShadowColor, black,
		XmNbottomShadowColor, black,
		XmNhighlightColor, white,
		XmNselectColor, black,
		NULL);
  
  message = (ClientData *)malloc( sizeof( ClientData ) );
  message->w = wiggle_window;
  message->id = id;
  (void)XmCreatePushButtonVa(dialog_form,"  OK  ",
		XmNtopAttachment,XmATTACH_WIDGET,
		XmNtopWidget,frame1,
		XmNtopOffset,10,
		XmNbottomAttachment,XmATTACH_FORM,
		XmNleftAttachment,XmATTACH_FORM,
		XmNactivateCallback,
			CBlist( show_watchCB, (XtPointer)dialog_form,
				wiggle_windowCB, (XtPointer)message,
				hide_watchCB, (XtPointer)dialog_form,
				NULL ),
		NULL);
  
  (void)XmCreatePushButtonVa(dialog_form,"Cancel",
		XmNtopAttachment,XmATTACH_WIDGET,
		XmNtopWidget,frame1,
		XmNtopOffset,10,
		XmNbottomAttachment,XmATTACH_FORM,
		XmNrightAttachment,XmATTACH_FORM,
		XmNactivateCallback,
			CBl( destroyCB, (XtPointer)wiggle_window ),
		NULL);

  XtManageChild(dialog_form);

  XtRealizeWidget(wiggle_window); 

  XSetWindowColormap(display,XtWindow(wiggle_window),xdisplay[id].cmap);
#if defined(__sgi) || defined(sun)	/* added sun in case redirect disp from sun to sgi */
  XSetWindowColormap(display,XtWindow(backgroundColorButton),xdisplay[id].cmap);
  XSetWindowColormap(display,XtWindow(wiggleColorButton),xdisplay[id].cmap);
  XSetWindowColormap(display,XtWindow(draw_background),xdisplay[id].cmap);
  XSetWindowColormap(display,XtWindow(draw_wiggle),xdisplay[id].cmap);
  for( m = 0; m < end_pick_color-start_pick_color+1; m++ )
	XSetWindowColormap(display,XtWindow(buttons[m]),xdisplay[id].cmap);
  free( buttons );
#endif
}


/*
  This function set the color for the wiggles.
*/
void set_wiggle_colorCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  long id;
  Pixel color;

  id =((long)client_data>>8);
  color=((long)client_data&0xff);

  XtSetArg(args[0],XmNbackground,color);

  if (XmToggleButtonGetState(toggle_color[0])) {
    xdisplay[id].background=color;
    XtSetValues(draw_background,args,1);
  } else {
    foreground=color;
    XtSetValues(draw_wiggle,args,1);
  }
}


/*
  This function get the parameters
  for generating the wiggles.
*/
void wiggle_windowCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  ClientData *message=(ClientData *)client_data;
  Widget wiggle_window;
  Widget main_window;
  Widget wiggle_form;
  int n,image_count;
  long id;	/* RJM: handle 64-bit architectures */
  int width_temp,height_temp;
  char *str;

  id=message->id;

  if (id==-1) {
    if( message->w != NULL )
      XtDestroyWidget( message->w );
    free(message);
    return;
  }

  XtSetArg(args[0],XmNvalue,&str);
  XtGetValues(wiggle_text[0],args,1);
  sscanf(str,"%d",&start_trace);
  XtFree(str);
  XtGetValues(wiggle_text[1],args,1);
  sscanf(str,"%d",&skip_trace);
  XtFree(str);
  XtGetValues(wiggle_text[2],args,1);
  sscanf(str,"%f",&wiggle_scale);
  XtFree(str);
  XtGetValues(wiggle_text[3],args,1);
  sscanf(str,"%f",&overlap);
  XtFree(str);
  XtGetValues(wiggle_text[4],args,1);
  sscanf(str,"%d",&zero_line);
  XtFree(str);
  XtGetValues(wiggle_text[5],args,1);
  sscanf(str,"%f",&scale_x);
  XtFree(str);
  XtGetValues(wiggle_text[6],args,1);
  sscanf(str,"%f",&scale_y);
  XtFree(str);

  if (scale_x<1.0) scale_x=1.0;
  if (scale_y<1.0) scale_y=1.0;

  toggle_value[0]=XmToggleButtonGetState(toggle[0]);
  toggle_value[1]=XmToggleButtonGetState(toggle[1]);

  image_count=next_image();
  
  n=0;
  XtSetArg(args[n],XtNargc,savedArgc); n++;     /* RJM: added 1/17/97 */
  XtSetArg(args[n],XtNargv,savedArgv); n++;     /* RJM: added 1/17/97 */
  XtSetArg(args[n],XtNiconPixmap,xsd_pixmap); n++;
  XtSetArg(args[n],XtNvisual,visual); n++;
  XtSetArg(args[n],XtNdepth,screenDepth); n++;
/*wiggle_window=XtAppCreateShell("xsd","wiggle",
                               topLevelShellWidgetClass,display,args,n);
RJM: commented out 1/17/97 */
  wiggle_window=XtAppCreateShell(ApplicationName, ApplicationClass,	/* RJM: added 1/17/97 */
                               topLevelShellWidgetClass,display,args,n);
  quit_frame(wiggle_window);

  copy_attributes(image_count,id);
  xdisplay[image_count].parent=xdisplay[id].parent;
  strcpy(xdisplay[image_count].type,"Wiggle");

  width_temp=scale_x*xdisplay[id].image->width;
  height_temp=scale_y*xdisplay[id].image->height;

  create_wiggle(image_count,id,width_temp,height_temp);

  xdisplay[image_count].image=XCreateImage(display,visual,screenDepth,ZPixmap,
                                          0,(char *)raster[image_count],
				          width_temp,height_temp,screenDepth,0);

  screen_size(id,&width_temp,&height_temp);

  main_window=XmCreateMainWindowVa(wiggle_window,"child_form",
				   XmNshowSeparator,True,
				   NULL);

  strcpy(xdisplay[image_count].filename,xdisplay[id].filename);
  window_title(buf,image_count);
  strcat(buf," Wiggle");

  XtVaSetValues(wiggle_window,
		XmNtitle,buf,
		NULL);
   
  wiggle_form=XmCreateFormVa(main_window,"form",
			     XmNwidth,width_temp,
			     XmNheight,height_temp+MIN_HEIGHT,
			     NULL);

                                /* Indicate general mode. */
  xdisplay[image_count].mode=1;
  set_mode_label(1,image_count);

  app_menus(wiggle_form,image_count,False);

  xdisplay_image(image_count,wiggle_window,wiggle_form,
		 width_temp,height_temp);

  xdisplay[image_count].pick_x=(1/scale_x)*xdisplay[image_count].pick_x;
  xdisplay[image_count].pick_y=(1/scale_y)*xdisplay[image_count].pick_y;

  XtRealizeWidget(wiggle_window);

  if( message->w != NULL )
    XtDestroyWidget( message->w );
  free(message);
}


/*
  This function generates the wiggles.
*/
void create_wiggle(int image_count, long id, int width_temp, int height_temp)
{
  int i,x,y,fill,value,value_old=0,stride1,stride2,skip_tmp;
  int middle,temp_value,count,id_parent,start_x,start_y,temp_offset;
  float scale,del;
  float *trash,*trash_in,*trash_out;
  struct values_struct values;
  struct location_struct location;

  /* Get the background and foreground colors. */
  XtSetArg(args[0],XmNbackground,&xdisplay[image_count].background);
  XtGetValues(draw_background,args,1);
  XtSetArg(args[0],XmNbackground,&foreground);
  XtGetValues(draw_wiggle,args,1);

  raster[image_count]=(unsigned char *)malloc(width_temp*height_temp*sizeof(char));

  /* Initialize the image to the background. */
  memset((char *)raster[image_count],(int)(xdisplay[id].background&0xffffffff),width_temp*height_temp*sizeof(char));
				
  /* Find the middle or zero value. */
  middle=(end_color+start_color)/2;
				
  /* Compute the scale factor. */
  scale=overlap/100.0;

  id_parent=xdisplay[id].parent;

  /* Scale by zoom factor. */
  skip_tmp=scale_x*skip_trace/xdisplay[id].pick_x; 

  /* Create some temporary space. */
  trash=(float *)malloc(height_temp*sizeof(float));
  trash_in=(float *)malloc(height_temp*sizeof(float));
  trash_out=(float *)malloc(height_temp*sizeof(float));

  /* Loop through the traces. */
  /* for (x=start_trace; x<width_temp; x+=skip_tmp) { */
  for (x=skip_tmp/2; x<width_temp; x+=skip_tmp) {
    stride1=1;
    stride2=xdisplay[id_parent].image->width;
    temp_value=xdisplay[id_parent].image->height;

    values=get_values((int)(x/scale_x*xdisplay[id].pick_x),0,id);
    location=get_location(values.record,values.trace,values.sample,id_parent);
    start_x=location.x;
    start_y=location.y;
    location=get_location(values.record,values.trace,esamp[id],id_parent);
    del=xdisplay[id].pick_y;
    if (del > 1.0) del=1.0;
    for (count=0;count<height_temp;count++) {
      *(trash+count)=(float)(count*del/scale_y);
      y=(int)((count+start_y)/del);
      if (y >= temp_value) {
	*(trash_in+count)=(float)(*(trash_in+count-1));
      } else {
	*(trash_in+count)=(float)(*(raster[id_parent]
	     +(int)(start_x/xdisplay[id_parent].pick_x)+y*stride2));
      }
    }
				
    /* Do a linear interplation. */
    vlint_(trash_in,&height_temp,trash,&stride1,trash_out,&stride1,&height_temp);
    *(trash_out+height_temp-1)=(float)(*(trash_in+height_temp-1));

    /* Plot wiggle for each sample. */
    for (y=0; y<height_temp; y++) {
      temp_value=wiggle_scale*((int)(*(trash_out+y))-middle);
      if (temp_value>((int)end_color-middle)) 
	temp_value=(int)end_color-middle;
      if (temp_value<((int)start_color-middle)) 
	temp_value=(int)start_color-middle;
      value=(int)(temp_value*scale);
      if (value==value_old) {
	temp_offset=x+value;
	if (temp_offset<0) temp_offset=0;
	else if (temp_offset>=width_temp) temp_offset=width_temp;
	temp_offset=temp_offset+y*width_temp;
	if (((value+x)>=0)&&((value+x)<width_temp)&&(value!=0)) {
	  *(raster[image_count]+temp_offset)=foreground&0xffffffff;
	} else {
	  if (zero_line==0) {
	    *(raster[image_count]+temp_offset)=foreground&0xffffffff;
	  } else {
	    if ((((x/skip_tmp)%zero_line)==0)&&(zero_line!=1)) {
	      *(raster[image_count]+temp_offset)=foreground&0xffffffff;
	    }
	  }  
	}    
      }

      if ((toggle_value[0])&&((value_old)>0))
	for (fill=0; fill<=value; fill++) {
	  if (((fill+x)>=0)&&((fill+x)<width_temp)) {
	    *(raster[image_count]+x+(y*width_temp)+fill)=foreground&0xffffffff;
	  }
	}
      else
	for (fill=value_old+1; fill<=value; fill++) {
	  if (((fill+x)>=0)&&((fill+x)<width_temp)) {
	    *(raster[image_count]+x+(y*width_temp)+fill)=foreground&0xffffffff;
	  }
	}

      if ((toggle_value[1])&&((value_old)<0))
	for (fill=value; fill<=0; fill++) {
	  if (((fill+x)>=0)&&((fill+x)<width_temp)) {
	    *(raster[image_count]+x+(y*width_temp)+fill)=foreground&0xffffffff;
	  }
	}
      else
	for (fill=value; fill<=value_old-1; fill++) {
	  if (((fill+x)>=0)&&((fill+x)<width_temp)) {
	    *(raster[image_count]+x+(y*width_temp)+fill)=foreground&0xffffffff;
	  }
	}
      value_old=value;
    }
  }

  if(trash) free((char*)trash); trash=NULL;
  if(trash_in) free((char*)trash_in); trash_in=NULL;
  if(trash_out) free((char*)trash_out); trash_out=NULL;
}
