C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c -----------------  Main Routine -----------------------
c  quick boutiqe code to do output limiting based on x,y coord limitation
c which got popular and was requested by enough users to justify pushing it out
c should also go to FreeUSP.  I have left the ist, iend stuff in here but 
c commented it out on the command line.  It was less work that way and I an lazy
c today.....PGAG.

c     Program Changes:

c      - original written: January 31, 2001 - Garossino

c     Program Description:

c      - for Kenny Gullette

c get machine dependent parameters 

      implicit none

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c dimension standard USP variables 

      integer     itr ( SZLNHD )
     
      integer     nsamp, nsi, ntrc, ntrco, nrec, nreco, iform
      integer     luin , luout, lbytes, nbytes, lbyout, obytes
      integer     ist, iend, irs, ire, ns, ne, argis, jerr, JJ, KK

      character   ntap*255, otap*255, name*6

      logical     verbos

c Program Specific _ static memory variables

      integer ifmt_WrdX,l_WrdX,ln_WrdX, i_WrdX
      integer ifmt_WrdY,l_WrdY,ln_WrdY, i_WrdY

      real r_WrdX, r_WrdY, minX, minY, maxX, maxY

      character c_WrdX*6, c_WrdY*6

c Initialize variables

      data name/"XYEDIT"/

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

c get command line input parameters

      call cmdln ( ntap, otap, ns, ne, irs, ire, ist, iend, 
     :     c_Wrdx, c_WrdY, maxX, maxY, minX, minY, name, verbos )

c POLICEMAN check to make sure both header entries are present

      if ( c_Wrdx .eq. ' ' .or. c_WrdY .eq. ' ' ) then
         write(LERR,*)' '
         write(LERR,*)' you must enter a mnemonic for both '
         write(LERR,*)'  -hwx and -hwy'
         write(LERR,*)' command line entries, fix and resubmit'
         write(LERR,*)' '
         write(LERR,*)'FATAL '
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'XYEDIT: '
         write(LER,*)' you must enter a mnemonic for both '
         write(LER,*)'  -hwx and -hwy'
         write(LER,*)' command line entries, fix and resubmit'
         write(LER,*)' '
         write(LER,*)'FATAL '
         write(LER,*)' '
         stop
      endif

c open input and output files

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c  read input line header and save certain parameters

      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LER,*)'XYEDIT: no line header on input dataset',ntap
         write(LER,*)'FATAL'
         stop
      endif

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)

c define pointers to header words required by your routine

      call savelu(c_Wrdx,ifmt_WrdX,l_WrdX,ln_WrdX,TRACEHEADER)
      call savelu(c_WrdY,ifmt_WrdY,l_WrdY,ln_WrdY,TRACEHEADER)

c historical line header and print to printout file 

      call hlhprt (itr, lbytes, name, 6, LERR)

c check user supplied boundary conditions and set defaults

      if ( irs .eq. 0 ) irs = 1
      if ( ire .eq. 0 .or. ire .gt. nrec ) ire = nrec

      if ( ns .eq. 0 ) ns = 1
      if ( ne .eq. 0 .or. ne .gt. ntrc ) ne = ntrc

      ist = nint ( float(ist) / float(nsi) )
      iend = nint ( float(iend) / float(nsi) )
      if ( ist .eq. 0 ) ist = 1
      if ( iend .eq. 0 .or. iend .gt. nsamp ) iend = nsamp

      nreco = ire - irs + 1
      ntrco = ne - ns + 1

c modify line header to reflect actual record configuration output
c NOTE: in this case the sample limits ist and iend are used to 
c       limit processing only.   All data samples are actually passed.

      call savew(itr, 'NumRec', nreco, LINHED)
      call savew(itr, 'NumTrc', ntrco  , LINHED)

c number output bytes

      obytes = SZTRHD + SZSMPD * nsamp 

c save out hlh and line header

      call savhlh  ( itr, lbytes, lbyout )
      call wrtape ( luout, itr, lbyout )

c verbose output of all pertinent information before processing begins

      call verbal( ntap, otap, nsamp, nsi, ntrc, nrec, iform, ist, 
     :     iend, irs, ire, ns, ne, c_Wrdx, c_WrdY, minX, maxX, minY, 
     :     maxY, verbos)

c BEGIN PROCESSING 

c skip unwanted input records

      call recskp ( 1, irs-1, luin, ntrc, itr )

      DO JJ = irs, ire
 
c skip to start trace

         call trcskp ( JJ, 1, ns-1, luin, ntrc, itr )

         DO KK = ns, ne

            nbytes = 0
            call rtape( luin, itr, nbytes)

c if end of data encountered (nbytes=0) then bail out

            if(nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on input at:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif

c do format independant header read


            if ( ifmt_WrdX .eq. SAVE_FLOAT_DEF .or.
     :             ifmt_WrdX .eq. SAVE_FKFLT_DEF ) then

               call saver2( itr, ifmt_WrdX, l_WrdX, ln_WrdX, 
     :              r_WrdX, TRACEHEADER )

            else

               call saver2( itr, ifmt_WrdX, l_WrdX, ln_WrdX, 
     :              i_WrdX, TRACEHEADER )
               r_WrdX = float(i_WrdX)

            endif

            if ( ifmt_WrdY .eq. SAVE_FLOAT_DEF .or.
     :           ifmt_WrdY .eq. SAVE_FKFLT_DEF )then

 
               call saver2( itr, ifmt_WrdY, l_WrdY, ln_WrdY, 
     :              r_WrdY, TRACEHEADER )

            else

               call saver2( itr, ifmt_WrdY, l_WrdY, ln_WrdY, 
     :              i_WrdY, TRACEHEADER )
               r_WrdY = float(i_WrdY)

            endif


            if ( r_WrdX .le. maxX .and. 
     :           r_WrdX .ge. minX .and. 
     :           r_WrdY .ge. minY .and. 
     :           r_WrdY .le. maxY ) then

c write output data on if inside area

               call wrtape (luout, itr, obytes)

            endif
 
         ENDDO
 
c skip to end of record

         call trcskp ( JJ, ne+1, ntrc, luin, ntrc, itr )

      ENDDO

c close data files 

      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'xyedit: Normal Termination'
      write(LER,*)'xyedit: Normal Termination'
      stop

 999  continue

      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'xyedit: ABNORMAL Termination'
      write(LER,*)'xyedit: ABNORMAL Termination'
      stop
      end

c -----------------  Subroutine -----------------------

      subroutine help()

c provide terse online help [detailed help goes in man page]

#include <f77/iounit.h>

      write(LER,*)' '
      write(LER,*)'===================================================='
      write(LER,*)' '
      write(LER,*)' Command Line Arguments for xyedit: USP template'
      write(LER,*)' '
      write(LER,*)' For a more detailed description of these parameters'
      write(LER,*)' see the online man page using uman, xman or xuspman'
      write(LER,*)' '
      write(LER,*)'Input...................................... (def)'
      write(LER,*)' '
      write(LER,*)'-N[]   -- input data set                  (stdin)'
      write(LER,*)'-O[]   -- output data set                (stdout)'
      write(LER,*)'-ns[]  -- start trace number                  (1)'
      write(LER,*)'-ne[]  -- end trace number           (last trace)'
      write(LER,*)'-rs[]  -- start record                        (1)'
      write(LER,*)'-re[]  -- end record                (last record)'
      write(LER,*)'-hwx[] -- trace header X coord           (CDPBCX)'
      write(LER,*)'-hwy[] -- target header Y coord          (CDPBCY)'
      write(LER,*)'-minX[]-- minimum X coord               (-1.0e32)'
      write(LER,*)'-maxX[]-- maximum X coord               ( 1.0e32)'
      write(LER,*)'-minY[]-- minimum Y coord               (-1.0e32)'
      write(LER,*)'-maxY[]-- maximum Y coord               ( 1.0e32)'
      write(LER,*)'-V     -- verbos printout'
      write(LER,*)' '
      write(LER,*)'Usage:'
      write(LER,*)'    xyedit -N[] -O[] -ns[] -ne[] -rs[] -re[] '
      write(LER,*)'           -hwx[] -hwy[] -minX[] -maxX[] -minY[]'
      write(LER,*)'           -maxY[] -V'
      write(LER,*)' '
      write(LER,*)'===================================================='
      
      return
      end

c -----------------  Subroutine -----------------------

c pick up command line arguments 

      subroutine cmdln ( ntap, otap, ns, ne, irs, ire, ist, iend, 
     :     c_Wrdx, c_WrdY, maxX, maxY, minX, minY, name, verbos )

      implicit none

#include <f77/iounit.h>

      integer    ist, iend, ns, ne, irs, ire, argis

      real maxX, maxY, minX, minY

      character  ntap*(*), otap*(*), name*(*), c_WrdX*6, c_WrdY*6

      logical    verbos

           call argi4 ( '-e', iend, 0, 0 )

           call argr4 ( '-minX', minX, -1.0e32, -1.0e32 )
           call argr4 ( '-minY', minY, -1.0e32, -1.0e32 )
           call argr4 ( '-maxX', maxX, 1.0e32, 1.0e32 )
           call argr4 ( '-maxY', maxY, 1.0e32, 1.0e32 )

           call argi4 ( '-ne', ne, 0, 0 )
           call argi4 ( '-ns', ns, 0, 0 )
           call argstr ( '-N', ntap, ' ', ' ' ) 

           call argstr ( '-O', otap, ' ', ' ' ) 

           call argi4 ( '-re', ire, 0, 0 )
           call argi4 ( '-rs', irs, 0, 0 )

           call argi4 ( '-s', ist, 1, 1 )

           verbos = (argis('-V') .gt. 0)

           call argstr ( '-hwx', c_Wrdx, 'CDPBCX', 'CDPBCX' ) 
           call argstr ( '-hwy', c_WrdY, 'CDPBCY', 'CDPBCY' ) 

c check for extraneous arguments and abort if found to
c catch all manner of user typo's (eat,die)

      call xtrarg ( name, ler, .FALSE., .FALSE. )
      call xtrarg ( name, lerr, .FALSE., .TRUE. )

           
      return
      end

c -----------------  Subroutine -----------------------

c verbal printout of pertinent program particulars


      subroutine verbal ( ntap, otap, nsamp, nsi, ntrc, nrec, iform, 
     :     ist, iend, irs, ire, ns, ne, c_Wrdx, c_WrdY, minX, maxX, 
     :     minY, maxY, verbos)

      implicit none

#include <f77/iounit.h>

      integer nsamp, ntrc, iform, ist, iend, irs, ire, ns, ne, nsi
      integer nrec

      real minX, maxX, minY, maxY

      character  ntap*(*), otap*(*), c_Wrdx*6, c_WrdY*6

      logical    verbos

      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      write(LERR,*) ' input data set name   =  ', ntap
      write(LERR,*) ' samples per trace     =  ', nsamp
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' number of records     =  ', nrec
      write(LERR,*) ' data format           =  ', iform
      write(LERR,*) ' sample interval       =  ', nsi
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      write(LERR,*) ' output data set name  =  ', otap
      write(LERR,*) ' start record          =  ', irs 
      write(LERR,*) ' end record            =  ', irs 
      write(LERR,*) ' start trace           =  ', ns
      write(LERR,*) ' end trace             =  ', ne
      write(LERR,*) ' X coord header word   = ', c_WrdX
      write(LERR,*) ' Y coord header word   = ', c_WrdY
      write(LERR,*) ' minimium X desired    = ', minX
      write(LERR,*) ' minimium Y desired    = ', minY
      write(LERR,*) ' maximium X desired    = ', maxX
      write(LERR,*) ' maximium Y desired    = ', maxY
      if ( verbos )  write(LERR,*) ' verbose printout requested'
      write(LERR,*)' '
      write(LERR,*)'========================================== '
      write(LERR,*)' '

      return
      end
