C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cmdln ( ntap, otap, ftap, ns, ne, irs, ire, mnemonic, 
     :     mnemonicX, mnemonicY, mnemonicZ, geometry, reverse, map, 
     :     notseq,
     :     verbos )

#include <f77/iounit.h>

      integer     ns, ne, irs, ire, argis 

      character   ntap*(*), otap*(*), ftap*(*), mnemonic*(*)
      character   mnemonicX*(*), mnemonicY*(*), mnemonicZ*(*)

      logical     geometry, verbos, reverse, map, notseq

      call argstr( '-F', ftap, ' ', ' ' )

      geometry =   (argis('-geometry') .gt. 0)

      call argstr( '-hw1', mnemonicX, ' ', ' ' )
      call argstr( '-hw2', mnemonicY, ' ', ' ' )
      call argstr( '-hw3', mnemonicZ, ' ', ' ' )
      call argstr( '-hw', mnemonic, 'TVPT01', 'TVPT01' )

      call argi4 ( '-ne', ne ,   0  ,  0    )
      call argi4 ( '-ns', ns ,   0  ,  0    )

      call argstr( '-N', ntap, ' ', ' ' )

      call argstr( '-O', otap, ' ', ' ' )

      call argi4 ( '-re', ire ,   0  ,  0    )
      call argi4 ( '-rs', irs ,   0  ,  0    )

      reverse =   (argis('-R') .gt. 0)
      map =   (argis('-map') .gt. 0)
      notseq = (argis('-actual') .gt. 0)
cmam  notseq = (argis('-noseq') .gt. 0)

      verbos =   (argis('-V') .gt. 0)

c policeman

      if ( geometry ) then
         if ( mnemonicX .eq. ' ' .or. mnemonicY .eq. ' ' )then
            write(LERR,*)' '
            write(LERR,*)'XYZ2HEAD: When using the -geometry option '
            write(LERR,*)'          you must specify on the command'
            write(LERR,*)'          line a -hw1 and -hw2 to which to'
            write(LERR,*)'          load the X and Y coordinates.'
            write(LERR,*)'FATAL '
            write(LER,*)' '
            write(LER,*)'XYZ2HEAD: When using the -geometry option '
            write(LER,*)'          you must specify on the command'
            write(LER,*)'          line a -hw1 and -hw2 to which to'
            write(LER,*)'          load the X and Y coordinates.'
            write(LER,*)'FATAL '
            stop
         endif
      endif

      return
      end
