C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c ----- ----- ----- ----- xyz2head ----- ----- ----- ----- ----- ----- ---
c get machine dependent parameters -----

#include <save_defs.h> 
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c ----- dimension standard USP variables -----

      integer     itr ( SZLNHD )
     
      integer     nsamp, nsi, ntrc, ntrco, nrec, nreco, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     irs, ire, ns, ne, argis

      character   ntap*255, otap*255, name*8

      logical     verbos

c dimension program specific variables

      integer     l_Wrd, ln_Wrd, ifmt_Wrd, Wrd
      integer     l_WrdX, ln_WrdX, ifmt_WrdX, WrdX
      integer     l_WrdY, ln_WrdY, ifmt_WrdY, WrdY
      integer     l_WrdZ, ln_WrdZ, ifmt_WrdZ, WrdZ
      integer     l_StaCor, ln_StaCor, ifmt_StaCor, StaCor
      integer     l_Rec, ln_Rec, ifmt_Rec, IREC
      integer     l_Trc, ln_Trc, ifmt_Trc, ITRC
      integer     ThisTrace

      real        Rec, Trc, Value, Index
      real*8      X, Y

      character   ftap*255, mnemonic*6, mnemonicX*6, mnemonicY*6
      character   mnemonicZ*6

      logical     hold, geometry, reverse, map, GotIt, notseq

c Initialize variables

      data lbytes/0/
      data nbytes/0/

      data name/'XYZ2HEAD'/
      data hold/.false./
      data geometry/.false./
      data reverse/.false./
      data map /.false./
      data notseq /.false./

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or.
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

c get command line input parameters

      call cmdln( ntap, otap, ftap, ns, ne, irs, ire, mnemonic, 
     :     mnemonicX, mnemonicY, mnemonicZ, geometry, reverse, map, 
     :     notseq,
     :     verbos )

c open input and output datasets

      call getln(luin , ntap,'r', 0)
      if ( .not. reverse ) call getln(luout, otap,'w', 1)

c  read line header of input save certain parameters

      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LOT,*)'XYZ2HEAD: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif


      call savelu ( mnemonic, ifmt_Wrd, l_Wrd, ln_Wrd, TRACEHEADER )

c get pointers for -hw1 and -hw2 only if they are being used

      if ( mnemonicX .ne. ' ' .and. mnemonicY .ne. ' ' ) then 
         call savelu ( mnemonicX, ifmt_WrdX, l_WrdX, ln_WrdX, 
     :        TRACEHEADER )
         call savelu ( mnemonicY, ifmt_WrdY, l_WrdY, ln_WrdY, 
     :        TRACEHEADER )
      elseif ( map .and. .not. reverse ) then

c the defaults for -map in the forward case are these

         call savelu ( 'LinInd', ifmt_WrdX, l_WrdX, ln_WrdX, 
     :        TRACEHEADER )
         call savelu ( 'DphInd', ifmt_WrdY, l_WrdY, ln_WrdY, 
     :        TRACEHEADER )
      endif

c get pointer for -hw3 only if they are being used

      if ( mnemonicZ .ne. ' ' ) 
     :     call savelu ( mnemonicZ, ifmt_WrdZ, l_WrdZ, ln_WrdZ, 
     :     TRACEHEADER )

cmam get pointer for IREC and ITRC if input flat file is keyed to actual
cmam     rec,tr values, not sequential rec,tr values
      call savelu ( 'RecNum', ifmt_Rec, l_Rec, ln_Rec, 
     :     TRACEHEADER )
      call savelu ( 'TrcNum', ifmt_Trc, l_Trc, ln_Trc, 
     :     TRACEHEADER )

      call savelu ( 'StaCor', ifmt_StaCor, l_StaCor, ln_StaCor, 
     :     TRACEHEADER )

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)

      call hlhprt (itr, lbytes, name, 8, LERR)

c ensure that command line values are compatible with data set

      call cmdchk( ns, ne, irs, ire, ntrc, nrec )

c modify line header to reflect actual number of traces output

      nreco = ire - irs + 1
      ntrco = ne - ns + 1

      call savew(itr, 'NumRec', nreco, LINHED)
      call savew(itr, 'NumTrc', ntrco  , LINHED)

c number output bytes

      obytes = SZTRHD + nsamp * SZSMPD

c save out hlh and line header

      call savhlh(itr,lbytes,lbyout)
      if ( .not. reverse ) call wrtape (luout, itr, lbyout)

c verbose output of all pertinent information before processing begins

      call verbal( nsamp, nsi, ntrc, nrec, iform, ntap, otap, ftap, 
     :     geometry, mnemonic, mnemonicX, mnemonicY, map, reverse,
     :     notseq )

c open flat file as required

      if ( reverse ) then
         luflat = 6
         if ( ftap .ne. ' ' ) then
            length = lenth(ftap)
            open ( luflat, file=ftap(1:length), status='unknown', 
     :           err=990 )
         endif
      else
         call alloclun ( luflat )
         length = lenth(ftap)
	 if (length .eq. 0) go to 990
         open ( luflat, file=ftap(1:length), status='old', err=990 )
      endif

c BEGIN PROCESSING

c read first entry in flat file

      if ( geometry .and. .not. reverse ) then
         read (luflat, *, end=992, err=992) Index, X, Y
      elseif ( map .and. .not. reverse ) then
         read (luflat, *, end=992, err=992) X, Y, Value
      elseif( .not. reverse ) then
         read(luflat, *, end=992, err=992 ) Rec, Trc, Value
      endif

c skip unwanted records 

      call recskp( 1, irs-1, luin, ntrc, itr )

c  process desired trace records 

      DO JJ = irs, ire
 
c skip to start trace

         call trcskp ( JJ, 1, ns-1, luin, ntrc, itr )
         ThisTrace = 0

c if loading things like water bottom at record then only get one
c entry per record

         if ( map .and. .not. reverse .and. JJ .gt. irs ) 
     :        read (luflat, *, end=992, err=992) X, Y, Value   
      
         DO KK = ns, ne

c read trace

            nbytes = 0
            call rtape( luin, itr, nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'Premature End of file on input:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif

c load header if appropriate

            IF ( geometry .and. .not. reverse ) then

               call saver2 ( itr, ifmt_Wrd, l_Wrd, ln_Wrd, Wrd, 
     :              TRACEHEADER )

               if ( Wrd .eq. nint(Index) ) then
                  call savew2 ( itr, ifmt_WrdX, l_WrdX, ln_WrdX, 
     :                 nint(X), TRACEHEADER )
                  call savew2 ( itr, ifmt_WrdY, l_WrdY, ln_WrdY, 
     :                 nint(Y), TRACEHEADER )
                  read (luflat, *, end=991, err=992) Index, X, Y

               elseif (verbos) then
                  write(LERR,*)' '
                  write(LERR,*)' XYZ2HEAD: mismatch indexing between '
                  write(LERR,*)'           seismic and attached coord'
                  write(LERR,*)'           file'
                  write(LERR,*)' Record = ',JJ,' Trace = ',KK,' last file
     : entry = ',Index          
                  write(LERR,*)' WARNING'
                  write(LERR,*)' '
                  
                  write(LER,*)' '
                  write(LER,*)' XYZ2HEAD: mismatch indexing between '
                  write(LER,*)'           seismic and attached coord'
                  write(LER,*)'           file'
                  write(LER,*)' Record = ',JJ,' Trace = ',KK,' last file
     : entry = ',Index          
                  write(LER,*)' WARNING'
                  write(LER,*)' '
               endif
            ELSEIF ( map .and. .not. reverse ) then

               call saver2 ( itr, ifmt_WrdX, l_WrdX, ln_WrdX, WrdX, 
     :              TRACEHEADER )
               call saver2 ( itr, ifmt_WrdY, l_WrdY, ln_WrdY, WrdY, 
     :              TRACEHEADER )
               
c policeman to check if coordinates ever mismatch

               if ( nint(X) .ne. WrdX .or. nint(Y) .ne. WrdY ) then
                  write(LERR,*)' Coordinate mismatch in record ',JJ
                  write(LERR,*)' Input LI, DI = ',X,Y
                  write(LERR,*)' Data LI, DI = ',WrdX,WrdY
                  write(LERR,*)'WARNING'
                  if ( verbos ) then
                     write(LER,*)'XYZ2HEAD'
                     write(LER,*)' Coordinate mismatch in record ',JJ
                     write(LER,*)' Input LI, DI = ',X,Y
                     write(LER,*)' Data LI, DI = ',WrdX,WrdY
                     write(LER,*)'WARNING'
                  endif
               endif

               if ( ifmt_Wrd .eq. SAVE_FKFLT_DEF ) then
                  call savew2( itr, ifmt_Wrd, l_Wrd, ln_Wrd, 
     :                 Value, TRACEHEADER )
               else
                  Wrd = nint(Value)
                  call savew2( itr, ifmt_Wrd, l_Wrd, ln_Wrd, Wrd, 
     :                 TRACEHEADER )
               endif

            ELSEIF ( .not. reverse ) then

cmam if we are using actual rec,tr values instead of sequential ones,
cmam       need to read them from trace header
             if ( notseq ) then
                call saver2 (itr,ifmt_Rec,l_Rec,ln_Rec,IREC,
     :               TRACEHEADER)
                call saver2 (itr,ifmt_Trc,l_Trc,ln_Trc,ITRC,
     :               TRACEHEADER)
             else
                IREC = JJ
                ITRC = KK
             endif

               if ( nint(Rec) .eq. IREC )  then
                  if ( nint(Trc) .eq. ITRC ) then

                     if ( ifmt_Wrd .eq. SAVE_FKFLT_DEF ) then
                        call savew2( itr, ifmt_Wrd, l_Wrd, ln_Wrd, 
     :                       Value, TRACEHEADER )
                     else
                        Wrd = nint(Value)
                        call savew2( itr, ifmt_Wrd, l_Wrd, ln_Wrd, Wrd, 
     :                       TRACEHEADER )
                     endif

                     hold = .false.
                  elseif( nint(Trc) .gt. ITRC ) then
                     hold = .true.
                  endif
               elseif( nint(Rec) .gt. IREC ) then
                  hold = .true.
               endif

c read next flat file entry if required

               if ( .not. hold ) 
     :              read(luflat, *, end=991, err=992 ) Rec, Trc, Value

            ELSE


               call saver2 (itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :              StaCor, TRACEHEADER )

               if ( .not. map ) then

                  if ( StaCor .ne. 30000 ) then

c write info for live traces only

                     call saver2 (itr, ifmt_Wrd, l_Wrd, ln_Wrd, Wrd, 
     :                    TRACEHEADER )
                     call saver2 ( itr, ifmt_WrdX, l_WrdX, ln_WrdX, 
     :                    WrdX, TRACEHEADER )
                     call saver2 ( itr, ifmt_WrdY, l_WrdY, ln_WrdY, 
     :                    WrdY, TRACEHEADER )

c optional header word Z

                     if ( mnemonicZ .ne. ' ' )
     :                    call saver2 ( itr, ifmt_WrdZ, l_WrdZ, ln_WrdZ, 
     :                    WrdZ, TRACEHEADER )
                     
c watch for traces with nothing in the requested header entries.

                     if ( WrdX .eq. 0 .and. WrdY .eq. 0 ) then
                        write(LERR,*)' Rec ',JJ,' Trc ',KK,' ', 
     :                       MnemonicX, ' ', WrdX, ' ', MnemonicY,' ',
     :                       WrdY
                     endif

c write out the header data
                     if ( mnemonicZ .eq. ' ' ) then
                        write(luflat,'(3f15.2)')float(Wrd), float(WrdX), 
     :                       float(WrdY)
                     else
                        write(luflat,'(4f15.2)')float(Wrd), float(WrdX), 
     :                       float(WrdY), float(WrdZ)
                     endif
                  endif

               else

c here we just want to get some stuff from the headers for output, like
c a basemap of shot locations for instance.  In this case we only
c want one output for a given record and want to raise a flag if no 
c non-zero output is available for a record that has live traces

                  if ( StaCor .ne. 30000 .and. .not. GotIt ) then
                     call saver2 (itr, ifmt_Wrd, l_Wrd, ln_Wrd, Wrd, 
     :                    TRACEHEADER )
                     call saver2 ( itr, ifmt_WrdX, l_WrdX, ln_WrdX,
     :                    WrdX, TRACEHEADER )
                     call saver2 ( itr, ifmt_WrdY, l_WrdY, ln_WrdY,
     :                    WrdY, TRACEHEADER )

c optional header word Z

                     if ( mnemonicZ .ne. ' ' )
     :                    call saver2 ( itr, ifmt_WrdZ, l_WrdZ, ln_WrdZ, 
     :                    WrdZ, TRACEHEADER )
                     
c watch for traces with nothing in the requested header entries.

                     if ( WrdX .eq. 0 .and. WrdY .eq. 0 ) then
                        write(LERR,*)' Rec ',JJ,' Trc ',KK,' ', 
     :                       MnemonicX,' ',WrdX, ' ',MnemonicY,' ',WrdY
                     else

c write out the header data

                        if ( mnemonicZ .eq. ' ' ) then
                           write(luflat,'(4f15.2)') float(JJ), 
     :                          float(Wrd), float(WrdX), float(WrdY)
                        else
                           write(luflat,'(5f15.2)') float(JJ), 
     :                          float(Wrd), float(WrdX), float(WrdY), 
     :                          float(WrdZ)
                        endif
                        GotIt = .true.
                        ThisTrace = kk + 1
                        goto 20
                     endif
                  endif

               endif
            ENDIF
            
c write out trace

 10         if ( .not. reverse ) call wrtape (luout, itr, obytes)
            ThisTrace = ne + 1

         ENDDO
 
c  skip to end of record 

 20      call trcskp(JJ,ThisTrace,ntrc,luin,ntrc,itr)
         GotIt = .false.

      ENDDO

c  close data files 

 999  continue

      call lbclos ( luin )
      if ( .not. reverse ) call lbclos ( luout )
      close(luflat)

      write(LERR,*)'end of prgm, processed',nreco,' record(s)',
     :             ' with ',ntrc, ' traces'

      write(LER,*)' xyz2head: Normal Termination'
      stop

c 	error messages 

 990  write(LERR,*) ' error opening flat file: check spelling'

      stop

c end of flat file before end of data

 991  write(LERR,*)' Encountered EOF on flat file prior to end'
      write(LERR,*)' of data.  Will pass rest of input dataset'
      write(LERR,*)' '
      write(LERR,*)' WARNING '
      write(LERR,*)' '
      Rec = float(ire + 1)
      goto 10

 992  write(LERR,*)' Error reading flatfile.  Check contents'
      write(LERR,*)' and rerun'
      write(LERR,*)' FATAL'
      write(LER,*)' XYZ2HEAD: Error reading flatfile.  Check contents'
      write(LER,*)'           and rerun'
      write(LER,*)' FATAL'
      stop
      
      end
