C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine GetZycorLimits ( luin, Xmax, Xmin, dX, Ymax, Ymin, dY, 
     :     FirstIsX )

c gets limits from Zycor grid file
 
#include <f77/iounit.h>

      integer luin

      real Xmax,Xmin,dX,Ymax,Ymin,dY
      real x,y,z
      real tempXmin, tempdX
      
      logical FirstIsX
      
      Xmax = 0.
      Xmin = 0.
      Ymax = 0.
      Ymin = 0.
      dX = 0.
      dY = 0.

      read(luin,*,end=990,err=991)x,y,z
      Xmin = x
      Ymin = y

      read(luin,*,end=990,err=991)x,y,z

      if ( abs(x - Xmin) .gt. 1.e-30 ) dX = x - Xmin
      if ( abs(y-Ymin) .gt. 1.e-30) dY = y - Ymin

c deterine which column cycles the fastest and make it x

      FirstIsX = .false.
      if ( abs (dX) .ge. abs(dY) ) FirstIsX = .true.

      if ( .not. FirstIsX ) then

         tempXmin = Xmin
         Xmin = Ymin
         Ymin = tempXmin
         tempdX = dX
         dX = dY
         dY = tempdX

      endif

      do while (1.eq.1)

         if ( FirstIsX ) then
         
            read(luin,*,end=10,err=991)x,y,z

         else
         
            read(luin,*,end=10,err=991)y,x,z

         endif

         if(abs(dX).lt.1.e-30.and.abs(x-Xmin).gt.1.e-30)dX = x-Xmin
         if(abs(dY).lt.1.e-30.and.abs(y-Ymin).gt.1.e-30)dY = y-Ymin

      enddo

 10   continue

      Xmax = x
      Ymax = y

      rewind(luin)

      return
      
 990  write(LERR,*)'XYZ2SIS: premature EOF on input'
      write(LERR,*)'FATAL'
      write(LERR,*)' '
      write(LER,*)' '
      write(LER,*)'XYZ2SIS: premature EOF on input'
      write(LER,*)'FATAL'
      write(LER,*)' '
      stop
 991  write(LERR,*)'XYZ2SIS: error reading input'
      write(LERR,*)'FATAL'
      write(LERR,*)' '
      write(LER,*)' '
      write(LER,*)'XYZ2SIS: error reading input' 
      write(LER,*)'FATAL'
      write(LER,*)' '
      stop
      end



      


