C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************

      subroutine verbal( nsamp, nsampo, nsi, ntrc, ntrco, nrec, nreco,
     :     mnemonic1, mnemonic2, mnemonic3, mnemonic4, 
     :     iform, ist, iend, ns, ne, irs, ire, reverse, NullValue,
     :     NullReplaceValue, GeoQuest, ntap, otap, Swap, Horizon, Title,
     :     flat, flat1, flat2, verbos )

#include <f77/iounit.h>
      
      integer nsamp, nsi, ntrc, nrec, iform, ist, iend, ns, ne
      integer nsampo, ntrco, nreco, length

      real NullValue, NullReplaceValue

      character ntap*255, otap*255, Horizon*16, Title*60
      character mnemonic1*6, mnemonic2*6
      character mnemonic3*6, mnemonic4*6

      logical reverse, verbos, GeoQuest, flat, flat1, Swap, flat2

      if ( reverse ) then
         write(LERR,*)' '
         write(LERR,*)' Converting from USP to [x,y,z]'
         write(LERR,*)' '
         write(LERR,*)' Input Line Header Parameters'
         write(LERR,*)' '
         length = lenth(ntap)
         if (length .gt. 0) then
           write(LERR,*)' Input Dataset Name :  ',ntap(1:length)
         else
           write(LERR,*)' Input Dataset Name :  stdin'
         endif
         write(LERR,*)' Sample Interval    =  ', nsi
         write(LERR,*)' Samples/Record     =  ',nsamp
         write(LERR,*)' Records/Line       =  ', nrec
         write(LERR,*)' Traces/Record      =  ', ntrc
         write(LERR,*)' Data Format        =  ', iform
         write(LERR,*)' '
         write(LERR,*)' Command Line Parameters'
         write(LERR,*)' '

         if ( otap .ne. ' ' ) then
            length = lenth(otap)
            write(LERR,*)' Output Grid File Name     =  ',otap(1:length)
         else
            write(LERR,*)' Output Grid File on a pipe to stdout'
         endif

         write(LERR,*)' '

         if ( GeoQuest ) then
            write(LERR,*)'GeoQuest Grid File Output'
         else
            if ( Swap ) then
               write(LERR,*)'Zycor [y,x,z] Grid File Output'
            elseif ( flat ) then  
               write(LERR,*)'Header Entries Used in Flat File'
               write(LERR,*) ' -hw1 =  ', mnemonic1
               write(LERR,*) ' -hw2 =  ', mnemonic2
               write(LERR,*) ' -hw3 =  ', mnemonic3
               write(LERR,*) ' -hw4 =  ', mnemonic4
            elseif ( flat1 ) then  
               write(LERR,*)' trace, sample, amplitude in Flat File'
            else  
               write(LERR,*)'Zycor [x,y,z] Grid File Output'
            endif
         endif
         write(LERR,*)' window start              =  ', ist*nsi
         write(LERR,*)' window end                =  ', iend*nsi
         write(LERR,*)' trace start               =  ', ns
         write(LERR,*)' trace end                 =  ', ne
         write(LERR,*)' record start              =  ', irs
         write(LERR,*)' record end                =  ', ire
         write(LERR,*)' Null Value                =  ',NullValue
         write(LERR,*)' Null Replacement Amplitude=  ',NullReplaceValue
         write(LERR,*)' '

      elseif ( flat2 ) then
         write(LERR,*)' '
         write(LERR,*)' Converting from [tr,rec,samp,value] to USP'
         write(LERR,*)' '
         write(LERR,*)' Command Line Paramters'
         length = lenth(ntap)
	 if (length .gt. 0) then
           write(LERR,*)' Input Flat2 File Name      =  ',ntap(1:length)
	 else
           write(LERR,*)' Input Flat2 File Name      =  pipe'
	 endif
         write(LERR,*)' Trace fill amplitude value =  ',NullReplaceValue
         write(LERR,*)' '
         write(LERR,*)' Output Line Header Parameters'
         write(LERR,*)' '
         write(LERR,*)' Sample Interval    =  ', nsi
         write(LERR,*)' Samples/Record     =  ',nsampo
         write(LERR,*)' Records/Line       =  ', nreco
         write(LERR,*)' Traces/Record      =  ', ntrco
         write(LERR,*)' Data Format        =  ', iform
         write(LERR,*) ' '

      else
         write(LERR,*)' '
         write(LERR,*)' Converting from [x,y,z] to USP'
         write(LERR,*)' '
         write(LERR,*)' Command Line Parameters'
         write(LERR,*)' '
         if ( GeoQuest ) then
            write(LERR,*)'GeoQuest Grid File Input'
            write(LERR,*)' '
            write(LERR,*)'         Horizon: ',Horizon
            write(LERR,*)'         Title: ',Title
         else
            write(LERR,*)'Zycor Grid File Input'
         endif

         write(LERR,*)' '
         length = lenth(ntap)
         if (length .gt. 0) then
           write(LERR,*)' Input Grid File Name      =  ',ntap(1:length)
         else
           write(LERR,*)' Input Grid File Name      =  stdin'
         endif
         write(LERR,*)' Null Value                =  ',NullValue
         write(LERR,*)' Null Replacement Amplitude=  ',NullReplaceValue
         write(LERR,*)' '
         write(LERR,*)' Output Line Header Parameters'
         write(LERR,*)' '
         write(LERR,*)' Sample Interval    =  ', nsi
         write(LERR,*)' Samples/Record     =  ',nsampo
         write(LERR,*)' Records/Line       =  ', nreco
         write(LERR,*)' Traces/Record      =  ', ntrco
         write(LERR,*)' Data Format        =  ', iform
         write(LERR,*) ' '
      endif

      if(verbos)write(LERR,*)' Verbose printout enabled'

      write(LERR,*) ' '
      return
      end
