C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c pick up command line arguments 

      subroutine cmdln ( ntap, otap, xyztap, name, tol, max_tol,
     :     Cosine, min_num_desired, z_scalar, z_replacement, exponent, 
     :     c_Xhdrwrd, c_Yhdrwrd, c_Zhdrwrd, X_col, Y_col, Z_col,
     :     verbos )

#include <f77/iounit.h>

c declare variables passed from calling routine

      integer X_col, Y_col, Z_col

      real    tol, max_tol, z_scalar, exponent, min_num_desired
      real z_replacement

      character  ntap*(*), otap*(*), xyztap*(*), name(*)
      character c_Xhdrwrd*6, c_Yhdrwrd*6, c_Zhdrwrd*6 

      logical Cosine, verbos

c declare local variables

      integer argis

c parse command line
 
      call argr4 ( '-amp', z_scalar, 1., 1. )

      Cosine = ( argis('-C') .gt. 0 )

      call argr4 ( '-exp', exponent, 0., 0. )

      call argstr ( '-F', xyztap, ' ', ' ' ) 

      call argr4 ('-maxtol', max_tol, 0., 0.)

      call argi4 ( '-num', min_num_desired, 5, 5 )
      call argstr ( '-N', ntap, ' ', ' ' ) 
 
      call argstr ( '-O', otap, ' ', ' ' ) 
      

      call argr4 ('-tol', tol, 0., 0.)
 
      verbos = ( argis('-V') .gt. 0 )
 
      call argstr ( '-xhw', c_Xhdrwrd, 'RcPtXC', 'RcPtXC' ) 
      call argi4 ( '-x', X_col, 1, 1 )

      call argstr ( '-yhw', c_Yhdrwrd, 'RcPtYC', 'RcPtYC' ) 
      call argi4 ( '-y', Y_col, 2, 2 )

      call argr4 ('-z_replace', z_replacement, 0., 0.)
      call argstr ( '-zhw', c_Zhdrwrd, 'GrpElv', 'GrpElv' ) 
      call argi4 ( '-z', Z_col, 3, 3 )

c check for extraneous arguments and abort if found to
c catch all manner of user typo's

      call xtrarg ( name, LER, .FALSE., .FALSE. )
      call xtrarg ( name, LERR, .FALSE., .TRUE. )
           
      return
      end
