C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal ( ntap, otap, xyztap, tol, max_tol, exponent, 
     :     nrec, ntrc, nsamp, nsi, Cosine, min_num_desired, z_scalar, 
     :     c_X_hdrwrd, c_Y_hdrwrd, c_Z_hdrwrd, X_col, Y_col, Z_col, 
     :     z_replacement, verbos )

#include <f77/iounit.h>

c declare variables passed from calling routine

      integer  nrec, ntrc, nsamp, min_num_desired, X_col, Y_col, Z_col

      real  tol, max_tol, z_scalar, exponent, z_replacement

      character  ntap*(*), otap*(*), xyztap*(*)

      logical Cosine, verbos

c declare local variables

      integer length

      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' Input X,Y,Z  Parameters'
      write(LERR,*)' ----------------------------- '
      write(LERR,*)' '
      length = lenth(xyztap)
      if (length .gt. 0) then
        write(LERR,*)' Input x,y,z filename = ', xyztap(1:length)
      else
        write(LERR,*)' Input x,y,z file     = pipe'
      endif
      write(LERR,*)' X coordinate in column ',X_col
      write(LERR,*)' Y coordinate in column ',Y_col
      write(LERR,*)' Z coordinate in column ',Z_col
      write(LERR,*)' '

      write(LERR,*)' Input USP Parameters'
      write(LERR,*)' --------------------'
      write(LERR,*)' '
      length = lenth(ntap)
      if (length .gt. 0) then
        write(LERR,*)' Data set name  = ', ntap(1:length)
      else
        write(LERR,*)' Data set name  = stdin'
      endif
      write(LERR,*)' Number of records           = ', nrec
      write(LERR,*)' Number of traces per record = ', ntrc
      write(LERR,*)' Number of samples per trace = ', nsamp
      write(LERR,*)' Sample interval             = ', nsi
      write(LERR,*)' '

      write(LERR,*)' '
      write(LERR,*)' Command line Parameters'
      write(LERR,*)' -----------------------'
      write(LERR,*)' '
      length = lenth(otap)
      if (length .gt. 0) then
        write(LERR,*)' Output data set name  =  ', otap(1:length)
      else
        write(LERR,*)' Output data set name  =  stdout'
      endif
      write(LERR,*)' Z Scalar              = ',z_scalar
      write(LERR,*)' Z value to use past Maximum Radius = ',
     :     z_replacement
      write(LERR,*)' Radius of investigation = ', tol
      write(LERR,*)' Maximum Radius of investigation = ', max_tol
       write(LERR,*)' Number of functions in extrapolation zone = ', 
     :     min_num_desired
      if ( Cosine ) then
         write(LERR,*)' using Cosine Bell weighting of z values'
         write(LERR,*)' within radius of investigation'
      elseif ( exponent .gt. 1.e-32 ) then
         write(LERR,*)' using 1/r**n weighting using an exponent'
         write(LERR,*)' of ',exponent
      else
         write(LERR,*)' using distance weighted average of velocities' 
         write(LERR,*)' within radius of investigation'
      endif
      write(LERR,*)' '
      write(LERR,*)' X header mnemonic = ',c_Xhdrwrd
      write(LERR,*)' Y header mnemonic = ',c_Yhdrwrd
      write(LERR,*)' Z header mnemonic = ',c_Zhdrwrd
      write(LERR,*)' '

      if ( verbos ) write(LERR,*)' verbose printout requested'
      write(LERR,*)' '
      write(LERR,*)' '
      return
      end
