C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine X2Trace(x,z,RecTrace,deltaX,KB,LineTie,Elevation,
     :     NumDepths)

      integer NumDepths,LineTie,deltaX,MaxOffset

      real x(*),z(*),RecTrace(*)
      real KB,zMax,xMax,Elevation

c
c ----- initialize variables -----
c

      zMax = 0
      xMax = 0

c
c ----- correct zMeasured to zSubsea -----
c

      do i=1,NumDepths

         z(i) = 2*Elevation - z(i) - KB
         if(z(i).gt.zMax)zMax = z(i)
         if(abs(x(i)).gt.xMax)xMax = abs(x(i))

      enddo

      MaxOffset = nint(xmax/float(deltaX))+1
c
c ----- Move x co-ordinate to closest trace -----
c       xsd will take care of z but I must take
c       care of x
c

      do 100 i=1,NumDepths

         if(abs(x(i)).le.float(deltaX))then

c
c ----- this logic only handles well deviating to the right -----
c       I need to embellish this to handle the left as well
c       Lets assume that the left is -ve x and the right is +ve x
c       for now.
c

            A = float(deltaX) - abs(x(i))

            if(A.ge.abs(x(i)))then

               RecTrace(i) = LineTie 

            else

               RecTrace(i) = LineTie + 1 * (abs(x(i))/x(i))

            endif

         else

            do j = 2,MaxOffset

               if(abs(x(i)).lt.float(j*deltaX)) then

                  A = float(j*deltaX) - abs(x(i))
                  B = abs(x(i)) - float((j-1)*deltaX)

                  if(A.ge.B)then

                     RecTrace(i) = LineTie + (j - 1)*(abs(x(i))/x(i))
                     goto 100

                  else

                     RecTrace(i) = LineTie + j*(abs(x(i))/x(i))
                     goto 100

                  endif

               endif

            enddo

         endif

 100  continue

      return
      end
