C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c-----------------------------------------------------------------------
c xz2xsd reads a flat file (supposedly xz data for well path projected
c to the plane of the section) and outputs an xsd pickfile with one
c xz point per segment.
c-----------------------------------------------------------------------
c
c     declare variables
c
#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      integer     luflat,lupick,lein,leout
      integer     NumDepths,deltaX,deltaZ,LineTie
      integer     argis,iostat,Color
      integer     errcd1,errcd2,errcd3,abort
 
      real        KB,SeisDatum,Elevation
      real        x,z,RecTrace

      pointer     (wkadr1,x(2000000))
      pointer     (wkadr2,z(2000000))
      pointer     (wkadr3,RecTrace(2000000))

      character   ntap*100,otap*100,name*6

      logical     verbos,query,heap,record,flip
 
      data luflat/25/
      data lupick/26/      
      data name/'XZ2XSD'/
      data abort/0/      
      data record/.false./
      data flip/.false./

c
c ----- get help if asked for -----
c
 
      query = ( argis ( '-?' ) .gt. 0 )

      if ( query ) then

         call help()
         stop

      endif

c
c ----- open printout file -----
c
 
#include <f77/open.h>
 
c
c ----- get command line entries -----
c

      call cmdln(ntap,otap,deltaX,deltaZ,record,LineTie,SeisDatum,KB,
     :    Elevation,Color,flip,verbos)
 
c
c ----- open input and output files -----
c

      lein = lenth(ntap)
      leout = lenth(otap)

      if (lein .eq. 0) then
         write(LERR,*)'XZ2XSD: No input file specified'
         write(LERR,*)'FATAL'
         write(LER,*)'XZ2XSD: No input file specified'
         write(LER,*)'FATAL'
      endif
      open(unit=luflat,file=ntap(1:lein),status='unknown',iostat=ierr)

      if(iostat .ne. 0) then
         write(LOT,*)'XZ2XSD: Cannot open input file ',ntap(1:lein)
         write(LOT,*)'FATAL   Check existence and rerun.'
         stop
      endif

      if (leout .eq. 0) then
         write(LERR,*)'XZ2XSD: No input file specified'
         write(LERR,*)'FATAL'
         write(LER,*)'XZ2XSD: No input file specified'
         write(LER,*)'FATAL'
      endif
      open(unit=lupick,file=otap(1:leout),status='unknown',iostat=ierr)

      if(iostat .ne. 0) then
         write(LOT,*)'XZ2XSD: Cannot open output file ',otap(1:leout)
         write(LOT,*)'FATAL   Check permissions and rerun'
         stop
      endif

c
c ----- determine required size of arrays -----
c

      call FlatCount(luflat,NumDepths)

c 
c ----- allocate required memory -----
c  

      heap = .true.
 
      item =  NumDepths * SZSMPD
 
      call galloc (wkadr1, item, errcd1, abort)
      call galloc (wkadr2, item, errcd2, abort)
      call galloc (wkadr3, item, errcd3, abort)
 
      if (errcd1 .ne. 0 .or. errcd2 .ne. 0 .or. errcd3 .ne. 0
     :     ) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) 3*item,'  bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) 3*item,'  bytes'
         write(LERR,*)' '
      endif

c
c ----- verbos info if desired -----
c

      if ( verbos ) then

         call verbal(ntap,otap,deltaX,deltaZ,record,LineTie,SeisDatum,
     :        Elevation,KB,Color,flip)

      endif
 
c
c ----- read in flat file (x,z) data -----
c

      call ReadFlat(luflat,x,z,NumDepths,flip,verbos)
      call X2Trace(x,z,RecTrace,deltaX,KB,LineTie,Elevation,NumDepths)
      call WritePick(lupick,RecTrace,z,record,NumDepths,SeisDatum,
     :     deltaZ,Color)

  999 continue
 
      close ( luflat )
      close ( lupick )
 
      write(LERR,*)'end of xz2xsd, processed',NumDepths,' entries'
      stop      
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'xz2xsd reads x,z data and writes an xsd pickfile. '
         write(LER,*)
     :'see manual pages for details ( online by typing uman xz2xsd )'
        write(LER,*)' '
        write(LER,*)
     :'execute xz2xsd by typing xz2xsd and the of program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (no default) : input (x,z) flat file name'
        write(LER,*)
     :' -O [otap]    (no default) : output file name'
        write(LER,*)
     :' -dx [dx]     (default: 20) : Trace Spacing in m or ft'
        write(LER,*)
     :' -dz [dz]     (default: 10) : Depth Increment in m or ft'
        write(LER,*)
     :' -loc [loc]   (default: 0) : Trace or Record at well'
        write(LER,*)
     :' -kb [kb]     (default: 0) : KB Subsea Elevation (m or ft)'
        write(LER,*)
     :' -datum [dat] (default: 0) : Seismic Subsea Datum (m or ft)'
        write(LER,*)
     :' -elev [elev](default: 0)  : Wellhead Subsea Elevation (m or ft)'
        write(LER,*)
     :' -color      (default: 1)  : xsd Pick color number (1=red)'        write(LER,*)
        write(LER,*)
     :' -F  FLip welltrack 180 degrees'
        write(LER,*)
     :' -R  Stacked Section is one record of many traces'
        write(LER,*) ' '
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*)
     :'example:   xz2xsd -Ndatain -Odataout -dx20 -dz10 -loc167 -kb875' 
        write(LER,*)
     :'                -datum2000 -elev866.6 -color1 -R -V' 
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine cmdln(ntap,otap,deltaX,deltaZ,record,LineTie,SeisDatum,
     :     KB,Elevation,Color,flip,verbos)

#include <f77/iounit.h>

      integer     deltaX, deltaZ, LineTie, Color, argis

      real        KB,SeisDatum,Elevation

      character   ntap*(*), otap*(*)

      logical     record,flip,verbos

      call argstr( '-N', ntap, ' ', ' ' )
      call argstr( '-O', otap, ' ', ' ' )
      call argi4 ( '-color', Color , 1 , 1 )
      call argr4 ( '-datum', SeisDatum, 0., 0. )
      call argi4 ( '-dx', deltaX , 20 , 20 )
      call argi4 ( '-dz', deltaZ , 10 , 10 )
      call argr4 ( '-elev', Elevation, 0., 0. )
      call argr4 ( '-kb', KB , 0. , 0.)
      call argi4 ( '-loc', LineTie ,  0 , 0 )

      flip = (argis('-F') .gt. 0)

      record = (argis('-R') .gt. 0)
      verbos = (argis('-V') .gt. 0)
 
      return
      end
 
C***********************************************************************
      subroutine verbal(ntap,otap,deltaX,deltaZ,record,LineTie,
     :     SeisDatum,Elevation,KB,Color,flip)

#include <f77/iounit.h>
 
      integer     deltaX,deltaZ,LineTie,Color

      real        SeisDatum,Elevation,KB

      character   ntap*(*), otap*(*)

      logical     record,flip 

      write(LERR,*)' '
      write(LERR,*)' Parameter input to xz2xsd'
      write(LERR,*)' '
      write(LERR,*)' input well data file name =  ', ntap
      write(LERR,*)' output xsd pickfile name=  ', otap
      write(LERR,*)' trace spacing = ',deltaX
      write(LERR,*)' Sample interval = ',deltaZ
      write(LERR,*)' Well Location on stack= ',LineTie
      write(LERR,*)' Seismic Datum (Subsea)= ',SeisDatum
      write(LERR,*)' Wellhead Elevation (Subsea)= ',Elevation
      write(LERR,*)' KB Elevation (Subsea)= ',KB
      write(LERR,*)' Pick Color Number= ',Color

      if(record)then

         write(LERR,*)'Data is one record of many traces'

      else

         write(LERR,*)'Data is many one trace records'      

      endif

      if(flip)write(LERR,*)'Flipping welltrack 180 degrees'
   
c-----
c    write out printout file in case program bombs later
c-----
            call flush (LERR)
 
      return
      end
 
