C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
         subroutine zombie_sub ( SeismicRecord, SeismicHeaders, ntrc,  
     :        ntrco, nsamp, nsampo, NumIter, StarFlag, fmt_StaCor,  
     :        l_StaCor, ln_StaCor, Single, dot, verbos )

c zombie_sub takes data from the main program in the SeismicRecord array
c averages values for dead traces and averages statics for dead traces
c from adjacent traces.
c

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c  variables passed from main 

      integer ntrc, ntrco, nsamp, nsampo, NumIter
      integer SeismicHeaders(ntrc*ITRWRD)
      integer l_StaCor, ln_StaCor, fmt_StaCor

      real    dot(ntrco)
      real SeismicRecord(ntrc*nsamp)

      logical StarFlag, verbos, Single

c  local variables 

      integer i, j, ij, ijnext, ijlast, isum
      integer ijtop_last, ijbot_last, ij2_last, ij2top_last, ij2bot_last
      integer ijtop_next, ijbot_next, ij2_next, ij2top_next, ij2bot_next
      integer indexTrace, indexHeader, indexLastHeader
      integer StaCor, LastStaCor, NextStaCor

      real sum1, sum2, sum3, sum

c  variable definitions 

c integer

c       NumIter : number of iterations to make on record
c                 (usefull for adjacent dead traces)
c	SeismicHeaders[*,*] : array of trace header data
c	ij,ijnext,ijlast : sample location indices
c       isum : contains averaged static for output to revived trace
c	ijtop_last - through - ij2bot_next : sample indices used in star search

c real
c
c	dot : scalar result of dot product set as an array
c	sum : star search output adjacent sample sum
c	sum1 : top left - bottom right sum
c       sum2 : adjacent sample sum
c       sum3 : bottom left - top right sum
c
c logical
c
c	StarFlag : sets interpolation type (true=star search
c	 				false=adjacent sample average)
c       Single : if true then only interpolates single dead traces

c  initialize data 


      do i = 1, ntrco
         dot(i) = 1.0
      enddo

      DO Iter = 1, NumIter

         indexTrace = 1 - nsampo
         indexHeader = 1 - ITRWRD
         
         do i = 1, ntrco

            indexTrace = indexTrace + nsampo

            indexLastHeader = indexHeader
            if ( i .gt. 1 )
     :           call saver2( SeismicHeaders(indexLastHeader), 
     :           fmt_StaCor, l_StaCor,ln_StaCor, LastStaCor ,
     :           TRACEHEADER )

            indexHeader = indexHeader + ITRWRD
            call saver2( SeismicHeaders(indexHeader), fmt_StaCor,
     :           l_StaCor,ln_StaCor, StaCor ,TRACEHEADER )

            indexNextHeader = indexHeader + ITRWRD 
            call saver2( SeismicHeaders(indexNextHeader), fmt_StaCor,
     :           l_StaCor,ln_StaCor, NextStaCor ,TRACEHEADER )
            
            
c form dot product of trace and assign to scalar dot to determine
c     if trace is perhaps dead.
            
           
            if (Iter .eq. 1) 
     :           call dotpr( SeismicRecord(indexTrace), 1, 
     :           SeismicRecord(indexTrace), 1, dot(i), nsampo )
           
        
            if ( StaCor .eq. 30000 .or. dot(i) .le. 1.0e-32 ) then

               if ( .not. ( Single .and. ( LastStaCor .eq. 30000 
     :              .or. NextStaCor .eq. 30000 ) ) ) then

                  if ( i .gt. 1 .and. i .lt. ntrco ) then
                  
c     if not iterating then replace StaCor on first go 
c     else wait until Iter = NumIter to do it.  This will not
c     help zero traces not Flagged 30000 but will iterate on
c     any trace Flagged as dead
                  
                     if ( Iter .eq. NumIter ) then
                        if( LastStaCor .lt. 20000 .and. StaCor
     :                       .lt. 20000 )
     :                       then
                           isum = LastStaCor + StaCor
                           StaCor = nint( float(isum) / 2. )
                           call savew2( SeismicHeaders(indexHeader), 
     :                          fmt_StaCor, l_StaCor,ln_StaCor, StaCor,
     :                          TRACEHEADER )
                        else
                           StaCor = 0
                           call savew2( SeismicHeaders(indexHeader), 
     :                          fmt_StaCor, l_StaCor,ln_StaCor, StaCor,
     :                          TRACEHEADER )
                        endif
                     endif

                     IF( .not. StarFlag ) then

c perform simple adjacent sample average 
 
                        do j = 1, nsampo
                           ij = indexTrace + j -1
                           ijlast = indexTrace - nsampo + j - 1
                           ijnext = indexTrace + nsampo + j - 1 
                           SeismicRecord(ij) = ( SeismicRecord(ijlast) + 
     :                          SeismicRecord(ijnext) ) / 2.
                        enddo

                     ELSE

c perform adjacent sample average with samples chosen from 
c star pattern based on measure of sameness (like sign) 

                        do j= 1, nsampo
                           ij = indexTrace + j
                           ijlast = indexTrace - nsampo + j
                           ijtop_last = indexTrace - nsampo + j - 1
                           ijbot_last = indexTrace - nsampo + j + 1
                           ij2_last = indexTrace - 2*nsampo + j
                           ij2top_last = indexTrace - 2*nsampo + j - 2
                           ij2bot_last = indexTrace - 2*nsampo + j + 2
                           
                           ijnext = indexTrace + nsampo + j
                           ijtop_next = indexTrace + nsampo + j - 1
                           ijbot_next = indexTrace + nsampo + j + 1
                           ij2_next = indexTrace + 2*nsampo + j
                           ij2top_next = indexTrace + 2*nsampo + j - 2
                           ij2bot_next = indexTrace + 2*nsampo + j + 2
                           
c In this approach the choice of which samples to average is 
c a function of the sign of the pair.  like signs outweigh
c unlike signs.  If all signs are alike or different the
c the choice is made on the basis of amplitude.

                           same1 = 0
                           same2 = 0
                           same3 = 0
                           sum = 0.

c assign star pattern amplitudes 

                           sum1 = ( SeismicRecord(ijtop_last) + 
     :                          SeismicRecord(ijbot_next) )
                           sum2 = ( SeismicRecord(ijnext) + 
     :                          SeismicRecord(ijlast) )
                           sum3 = ( SeismicRecord(ijbot_last) + 
     :                          SeismicRecord(ijtop_next) )
                           
                           if ( sign( 1.0, SeismicRecord(ijtop_next) )  
     :                          .eq.
     :                          sign( 1.0, SeismicRecord (ijbot_last))) 
     :                          same1 = 1
                           if ( sign( 1.0, SeismicRecord(ijnext) ) .eq. 
     :                          sign( 1.0, SeismicRecord(ijlast) ) ) 
     :                          same2 = 1
                           if ( sign( 1.0, SeismicRecord(ijbot_next) ) 
     :                          .eq. 
     :                          sign( 1.0, SeismicRecord(ijtop_last))) 
     :                          same3 = 1

                           IF ( ( same1 .eq. 1 
     :                          .and. same2 .eq. 1 
     :                          .and. same3 .eq. 1 ) .or. 
     :                          ( same1 .eq. 0 
     :                          .and. same2 .eq. 0
     :                          .and. same3. eq. 0 ) ) then
                              
                              sum = sum1
                              if( abs(sum2) .gt. abs(sum) ) sum = sum2
                              if( abs(sum3) .gt. abs(sum) ) sum = sum3

                           ELSEIF( same1 .eq. 1 
     :                             .and. same2 .eq. 1
     :                             .and. same3 .ne. 1 ) then
  
                              sum = sum1
                              if( abs(sum2) .gt. abs(sum) ) sum = sum2
                              
                           ELSEIF( same1 .eq. 1
     :                             .and. same3 .eq. 1
     :                             .and. same2 .ne. 1 ) then
                              
                              sum = sum1
                              if( abs(sum3) .gt. abs(sum) ) sum = sum3
                              
                           ELSEIF( same2 .eq. 1
     :                             .and. same3 .eq. 1
     :                             .and. same1 .ne. 1 ) then
                              
                              sum = sum2
                              if( abs(sum3) .gt. abs(sum) ) sum = sum3
                              
                           ELSEIF( same1 .eq. 1 
     :                             .and. same2 .ne. 1 
     :                             .and. same3 .ne. 1 ) then
                              
                              sum = sum1

                           ELSEIF( same1 .ne. 1 
     :                             .and. same2 .eq. 1 
     :                             .and. same3 .ne. 1 ) then
                              
                              sum = sum2
                           
                           ELSEIF( same1 .ne. 1 
     :                             .and. same2 .ne. 1 
     :                             .and. same3 .eq. 1 ) then

                              sum = sum3

                           ENDIF

c load output sample

                           SeismicRecord(ij) = sum / 2.0
                        enddo
                     ENDIF

                  else

c handle interpolation if there is no trace on each side 
c as happens with the first or last trace of the gather

                     if( i .eq. 1 ) then
                        if( Iter .eq. NumIter ) then
                        
                           if (NextStaCor .lt. 20000 ) then
                              StaCor = NextStaCor
                              call savew2( SeismicHeaders(indexHeader), 
     :                             fmt_StaCor, l_StaCor,ln_StaCor, 
     :                             StaCor, TRACEHEADER )
                           else
                              StaCor = 0
                              call savew2( SeismicHeaders(indexHeader), 
     :                             fmt_StaCor, l_StaCor,ln_StaCor, 
     :                             StaCor, TRACEHEADER )
                           endif
                        endif

                        do j= 1,nsampo
                           ij = indexTrace + j
                           ijnext = indexTrace + nsampo + j
                           SeismicRecord(ij) = SeismicRecord(ijnext)
                        enddo
                     endif

                     if( i .eq. ntrc ) then
                        if( Iter .eq. NumIter ) then
                           if( LastStaCor .lt. 20000 ) then
                              StaCor = LastStaCor
                              call savew2( SeismicHeaders(indexHeader), 
     :                             fmt_StaCor, l_StaCor,ln_StaCor, 
     :                             StaCor, TRACEHEADER )
                           else
                              StaCor = 0
                              call savew2( SeismicHeaders(indexHeader), 
     :                             fmt_StaCor, l_StaCor,ln_StaCor, 
     :                             StaCor, TRACEHEADER )
                           endif
                        endif

                        do j = 1, nsampo
                           ij = indexTrace + j - 1
                           ijlast = indexTrace - nsampo + j -1
                           SeismicRecord(ij) = SeismicRecord(ijlast)
                        enddo
                     endif

                  endif
               endif
            endif

         enddo
            
      ENDDO

      return
      end
