C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rdzeta(zeta,zeta4,nz,zmin,zmax,dzeql,nzeql,       
     1                  mapzeql,jzetamin,jzetamax,luzeta,luprt) 
C
      real      zeta  (0:nz)       
      real      zeta4 (0:nz*4)         
      integer   mapzeql(0:nzeql)
C_______________________________________________________________________
c     read in zeta.                                   
C______________________________________________________________________
      read(luzeta,*)
      read(luzeta,*) (jzeta,zeta(izeta),izeta=0,nz)
      close(luzeta)
C***********************************************************************
C     FIND MIN AND MAX DEPTH INDICES
C***********************************************************************
      jzetamin=nz
      jzetamax=0
      dzmin=1.e+20
      dzmax=1.e+20
      do 50000 jzeta=0,nz
       if(abs(zeta(jzeta)-zmin) .lt. dzmin) then
          jzetamin=jzeta
          dzmin=abs(zeta(jzeta)-zmin)
       endif
       if(abs(zeta(jzeta)-zmax) .lt. dzmax) then
          jzetamax=jzeta
          dzmax=abs(zeta(jzeta)-zmax)
       endif
50000 continue
C***********************************************************************
C     REFINE THE DEPTH GRID TO .25 TIMES THE ORIGINAL SPACING.
C***********************************************************************
      zeta4(0)=zeta(0)
      DO 10 JZ = 1,NZ
       iz=(jz-1)*4
       dzeta=zeta(jz)-zeta(jz-1)
       zeta4(iz+1)=zeta(jz-1)+.25*dzeta
       zeta4(iz+2)=zeta(jz-1)+.50*dzeta
       zeta4(iz+3)=zeta(jz-1)+.75*dzeta
       zeta4(iz+4)=zeta(jz-1)+1.00*dzeta
   10 CONTINUE
c
      last=0     
      do 60000 izeql=0,nzeql
       zeql=zeta4(0)+izeql*dzeql
       distmin=1.e+20               
       do 40000 izeta4=last,nz*4
        dist=abs(zeql-zeta4(izeta4))
        if(dist .gt. distmin)  then
           last=izeta4-1
           mapzeql(izeql)=last
           go to 60000
        else
           distmin=dist
        endif
40000  continue
       last=nz*4
       mapzeql(izeql)=last
60000 continue
C

      write(luprt,*) 'irregular to regular mapping'
      write(luprt,'(/,2a12)') 'iz','zeta4'
      write(luprt,'(i12,f12.3)') (iz,zeta4(iz),iz=1,nz) 
      write(luprt,'(/,4a12)') 'izeql','mapzeql','zeql','zeta4'
      write(luprt,'(2i12,2f12.3)') (izeql,mapzeql(izeql),
     1      zeta(0)+dzeql*izeql,zeta4(mapzeql(izeql)),izeql=0,nzeql)
C
      RETURN
      END
