C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine zstrsub(ueql,uirreg,w,zeta,
     1 leftzeta,idiv,ndiv,nz,nzeql,nzbuf,dzeql,ntr,nrec,   
     2 lerr,hbegin,lenhed,nbytes_out,iws,iwe,luzeta,lureg,luirreg,
     3 tracebuf,trheader,lenbuf,cputim,waltim)
C
      integer   hbegin
      integer   leftzeta(0:nzeql),idiv(0:nzeql)
      real      zeta(0:nz)
      real      trheader(lenhed,ntr)
      real      ueql(0:nzeql,ntr)   
      real      uirreg(iws:nz+iwe,ntr)
      real      w(iws:iwe,0:ndiv) 
      real      tracebuf(hbegin:*)
      real      cputim(*),waltim(*)
C
C_______________________________________________________________________
c     read in the irregular depth sampling grid.
c     same grid for the entire line.
C_______________________________________________________________________
      call zeta2z(zeta,nz,dzeql,nzeql,
     1            leftzeta,idiv,ndiv,luzeta,lerr)
      do 90000 irec=1,nrec             
C_______________________________________________________________________
C      read in a seismic record.                                 
c      save trace header.
c      move into array with appropriate shift.
C_______________________________________________________________________
       call timstr(v1,w1) 
       do 50000 itr=1,ntr
        nbytes_in=0
        call rtape(luirreg,tracebuf,nbytes_in)
        call vmov(tracebuf(hbegin),1,trheader(1,itr),1,lenhed)
        call vmov(tracebuf(1),1,uirreg(0,itr),1,nz+1)             
50000  continue
       call timend(cputim(1),v1,v2,waltim(1),w1,w2)
C_______________________________________________________________________
C      interpolate to regular grid using a 6 point lagrange operator.
C_______________________________________________________________________
       call timstr(v1,w1) 
       call mint6(uirreg,ueql,w,leftzeta,idiv,ndiv,
     1            hbegin,nz,nzbuf,nzeql,ntr)
       call timend(cputim(2),v1,v2,waltim(2),w1,w2)
C_______________________________________________________________________
C      write trace header plus data
C_______________________________________________________________________
      call timstr(v1,w1) 
      do 60000 itr = 1,ntr
       call vmov(trheader(1,itr),1,tracebuf(hbegin),1,lenhed)
       call vmov(ueql(0,itr),1,tracebuf(1),1,nzeql+1)
       call wrtape(lureg,tracebuf(hbegin),nbytes_out)
60000 continue
      call timend(cputim(3),v1,v2,waltim(3),w1,w2)
 
90000 continue
      call lbclos(lureg)
      call lbclos(luirreg)
c
      return
      end
