c---------------------------------------------------------------------c
c                                                                     c
c      COMPUTER PROGRAMS IN SEISMOLOGY                                c
c      VOLUME I                                                       c
c                                                                     c
c      PROGRAM: SYMBOL                                                c
c                                                                     c
c      COPYRIGHT (C)  1986 R. B. Herrmann                             c
c                                                                     c
c      Department of Earth and Atmospheric Sciences                   c
c      Saint Louis University                                         c
c      221 North Grand Boulevard                                      c
c      St. Louis, Missouri 63103                                      c
c      U. S. A.                                                       c
c                                                                     c
c---------------------------------------------------------------------c
      subroutine symbol (xloc,yloc,height,inbuf,angle,nocar) 
c-----
c       produces either 1) one symbol of choice or 2) character string
c
c       xloc    x-coordinate lower left corner of symbol
c               if nocar < 0 and symbol is centered, center x point
c       yloc    y-coordinate lower left corner of symbol or string
c       height  height in inches of symbol
c       inbuf   nocar > 0 inbuf is ascii string of characters
c               nocar long
c               nocar < 0 inbuf is a single character of an
c                         integer equivalent, e.g., char(inteq)
c
c                         of the symbol to be plotted
c       angle   angle of rotaion of symbol in degrees
c       nocar   > 0 number of characters in inbuf string
c               -1 pen is up during move after which single symbol
c                  is plotted
c               -2 pen is down, a line is drawn from present position
c                  to point where symbol is drawn
c-----
      integer symblo
	integer symb00,symb01,symb02,symb03,symb04,symb05,symb06
	integer symb07,symb08,symb09,symb10,symb11
	dimension symblo(9,120)
	dimension symb00(9,10),symb01(9,10),symb02(9,10),symb03(9,10)
c - had to re-dimension symb07 to what it has in the data statement to 
c - get by the convex compiler. - j.m.wade 8/31/92
 	dimension symb04(9,10),symb05(9,10),symb06(9,10),symb07(9,10)
c       dimension symb04(9,10),symb05(9,10),symb06(9,10),symb07(9,9)
	dimension symb08(9,10),symb09(9,10),symb10(9,10),symb11(9,10)
      common/Scplot/x0,y0
      dimension map(128)
      character*1 inbuf(4) 
      equivalence (symblo(1,1),symb00(1,1)),(symblo(1,11),symb01(1,1)),
     1        (symblo(1,21),symb02(1,1)),(symblo(1,31),symb03(1,1)),
     2        (symblo(1,41),symb04(1,1)),(symblo(1,51),symb05(1,1)),
     3        (symblo(1,61),symb06(1,1)),(symblo(1,71),symb07(1,1)),
     4        (symblo(1,81),symb08(1,1)),(symblo(1,91),symb09(1,1)),
     5        (symblo(1,101),symb10(1,1)),(symblo(1,111),symb11(1,1))
c 
c 
c mapping from ascii +1 to array default is space
      data map/1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,17,17,
     1         17,17,17,17,17,17,17,17,17,17,17,17,17,
     2         17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,
     3         35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,
     4         50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
     5         65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,
     6         80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,
     7         95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,
     8         110,111,112/
c      the first step is setting up a data table containing the 
c      representation of all characters to be used as a set of 
c      plotting vectors in cartesian coordinates.  the characters 
c      are represented here as four digit integers.  the first two 
c      digits of the first integer is the number of vectors re- 
c      quired to plot that particular character.  after that, 
c      each two digits represents a location on a 5 by 7 grid. 
c      for letters requiring dark vectors, such as "a","x",etc, 
c      the x coordinate of the vector to be a dark one is incr- 
c      eased by five.  this is easily detected because the normal 
c      range of x is from zero to four. 
c 
c      The vectors are ordered y,x,y,x quads 
c
c - Changed the comments for the symbxx data declarations to 
c   precede the data statement to appease the Absoft Linux compiler.
c					- joe m. wade 5/21/98
c 
c symb00: square , octagon , triangle , X , diamond , hat , table , Z , Y

      data symb00/0822,4240,0004,4442,2200,0000,0000,0000,0000,
     1            1222,4241,3010,0103,1434,4342,2200,0000,0000,
     2            0622,4210,1442,2200,0000,0000,0000,0000,0000,
     3            0722,2420,2202,4222,0000,0000,0000,0000,0000,
     4            0722,4004,2200,4422,0000,0000,0000,0000,0000,
     5            0722,4220,0224,4222,0000,0000,0000,0000,0000,
     6            0722,0242,2024,4222,0000,0000,0000,0000,0000,
     7            0622,0044,4004,2200,0000,0000,0000,0000,0000,
     8            1122,0004,0044,4044,2221,2322,0000,0000,0000,
     9            0722,4422,4022,0222,0000,0000,0000,0000,0000/

c symb01: sq-X , asterisk , hr-glas , vertlin , star , dash , space , !  , "

      data symb01/1422,3331,4031,1100,1113,0413,3344,2200,0000,
     1            1422,4202,2220,2422,4004,2200,4422,0000,0000,
     2            0722,0044,4004,0022,0000,0000,0000,0000,0000,
     3            0422,4202,2200,0000,0000,0000,0000,0000,0000,
     4            1122,4210,1442,3230,0234,3222,0000,0000,0000,
     5            0322,2422,0000,0000,0000,0000,0000,0000,0000,
     6            0000,0000,0000,0000,0000,0000,0000,0000,0000,
     7            0462,3217,0200,0000,0000,0000,0000,0000,0000,
     8            0461,4148,6300,0000,0000,0000,0000,0000,0000,
     9            0861,0007,6345,4425,2400,0000,0000,0000,0000/            

c symb02: $ , % , & , ' , ( , ) , * , + , comma , - 

      data symb02/1454,6361,5040,3133,2414,0301,1007,6200,0000,
     1            1260,5051,6160,1814,0403,1305,6400,0000,0000,
     2            1004,4050,6152,2010,0102,2400,0000,0000,0000,
     3            0463,6242,6300,0000,0000,0000,0000,0000,0000,
     4            0664,6352,1203,0400,0000,0000,0000,0000,0000,
     5            0660,6152,1201,0000,0000,0000,0000,0000,0000,
     6            0812,5255,1439,3015,5400,0000,0000,0000,0000,
     7            0412,5235,3400,0000,0000,0000,0000,0000,0000,
     8            0422,2302,2200,0000,0000,0000,0000,0000,0000,
     9            0221,2400,0000,0000,0000,0000,0000,0000,0000/

c symb03: period , / , 0 , 1 , 2 , 3 , 4 , 5 , 6 , 7

      data symb03/0510,0112,2110,0000,0000,0000,0000,0000,0000,
     1            0200,6400,0000,0000,0000,0000,0000,0000,0000,
     2            0963,6150,1001,0314,5463,0000,0000,0000,0000,
     3            0501,0302,6251,0000,0000,0000,0000,0000,0000,
     4            0904,0021,3344,5463,6150,0000,0000,0000,0000,
     5            0910,0103,1434,4337,6460,0000,0000,0000,0000,
     6            0561,3034,5803,0000,0000,0000,0000,0000,0000,
     7            0910,0103,1434,4340,6064,0000,0000,0000,0000,
     8            0962,2010,0103,1424,3331,0000,0000,0000,0000,
     9            0750,6064,5432,1101,0000,0000,0000,0000,0000/

c symb04: 8, 9, : , ; , < , = , > , ? , @ , A

      data symb04/1631,4050,6163,5444,3331,2010,0103,1424,3300,
     1            0901,4454,6361,5040,3133,0000,0000,0000,0000,
     2            1043,4232,3343,2712,1323,2200,0000,0000,0000,
     3            0943,4232,3343,2702,2322,0000,0000,0000,0000,
     4            0354,3014,0000,0000,0000,0000,0000,0000,0000,
     5            0441,4429,2100,0000,0000,0000,0000,0000,0000,
     6            0350,3410,0000,0000,0000,0000,0000,0000,0000,
     7            1202,0313,1202,2744,5463,6150,4000,0000,0000,
     8            1623,4352,4131,2223,3454,6361,5020,0103,1400,
     9            0500,6204,2623,0000,0000,0000,0000,0000,0000/

c symb05: B , C , D , E , F , G , H , I , J , K

      data symb05/1300,0314,2433,3133,4454,6360,6101,0000,0000,
     1            0854,6361,5010,0103,1400,0000,0000,0000,0000,
     2            0800,0314,5463,6061,0100,0000,0000,0000,0000,
     3            0764,6030,3330,0004,0000,0000,0000,0000,0000,
     4            0664,6030,3330,0000,0000,0000,0000,0000,0000,
     5            1054,6361,5010,0103,1434,3300,0000,0000,0000,
     6            0600,6030,3464,0400,0000,0000,0000,0000,0000,
     7            0601,0302,6261,6300,0000,0000,0000,0000,0000,
     8            0510,0103,1464,0000,0000,0000,0000,0000,0000,
     9            0600,6020,6442,0400,0000,0000,0000,0000,0000/

c symb06: L , M , N , O , P , Q , R , S , T , U

      data symb06/0360,0004,0000,0000,0000,0000,0000,0000,0000,
     1            0500,6032,6404,0000,0000,0000,0000,0000,0000,
     2            0400,6004,6400,0000,0000,0000,0000,0000,0000,
     3            0910,5061,6354,1403,0110,0000,0000,0000,0000,
     4            0801,6160,6354,4433,3100,0000,0000,0000,0000,
     5            1003,0110,5061,6354,1427,0400,0000,0000,0000,
     6            1001,6160,6354,4433,3133,0400,0000,0000,0000,
     7            1254,6361,5040,3133,2414,0301,1000,0000,0000,
     8            0460,6462,0200,0000,0000,0000,0000,0000,0000,
     9            0664,1403,0110,6000,0000,0000,0000,0000,0000/

c symb07: V , W , X , Y , Z , [ , \ , ] , ^ , _ 

      data symb07/0364,0260,0000,0000,0000,0000,0000,0000,0000,
     1            0564,0332,0160,0000,0000,0000,0000,0000,0000,
     2            0460,0405,6400,0000,0000,0000,0000,0000,0000,
     3            0564,3202,3260,0000,0000,0000,0000,0000,0000,
     4            0404,0064,6000,0000,0000,0000,0000,0000,0000,
     5            0462,6000,0200,0000,0000,0000,0000,0000,0000,
     6            0260,0400,0000,0000,0000,0000,0000,0000,0000,
     7            0462,6404,0200,0000,0000,0000,0000,0000,0000,
     8            0320,5224,0000,0000,0000,0000,0000,0000,0000,
     9            0200,0400,0000,0000,0000,0000,0000,0000,0000/

c symb08: ` , a , b , c , d , e , f , g , h , i

      data symb08/0461,6242,6100,0000,0000,0000,0000,0000,0000,
     1            1041,4334,0419,0301,1021,2400,0000,0000,0000,
     2            1061,0126,3233,2414,0302,1100,0000,0000,0000,
     3            0644,4130,1001,0400,0000,0000,0000,0000,0000,
     4            1064,0424,3332,2111,0203,1400,0000,0000,0000,
     5            0920,2434,4341,3010,0103,0000,0000,0000,0000,
     6            0702,5263,5444,3633,0000,0000,0000,0000,0000,
     7            1362,6354,4433,3241,5162,4914,0301,0000,0000,
     8            0761,0126,3233,2404,0000,0000,0000,0000,0000,
     9            0761,6145,4101,0502,0000,0000,0000,0000,0000/

c symb09: j , k , l , m , n , o , p , q , r , s

      data symb09/0662,6215,0112,5200,0000,0000,0000,0000,0000,
     1            0661,0136,0426,4300,0000,0000,0000,0000,0000,
     2            0561,6202,0603,0000,0000,0000,0000,0000,0000,
     3            1030,0025,3122,0227,3324,0400,0000,0000,0000,
     4            0731,0126,3233,2404,0000,0000,0000,0000,0000,
     5            0932,3324,1403,0211,2132,0000,0000,0000,0000,
     6            0861,0166,6354,4433,3100,0000,0000,0000,0000,
     7            0963,0304,3831,4050,6163,0000,0000,0000,0000,
     8            0631,0126,3233,2400,0000,0000,0000,0000,0000,
     9            0843,4130,2123,1403,0100,0000,0000,0000,0000/

c symb10: t , u , v , w , x , y , z , { , | , }

      data symb10/0662,1203,1446,4300,0000,0000,0000,0000,0000,
     1            0734,0436,1102,0314,0000,0000,0000,0000,0000,
     2            0340,0244,0000,0000,0000,0000,0000,0000,0000,
     3            0930,1001,1232,1703,1434,0000,0000,0000,0000,
     4            0431,0406,3400,0000,0000,0000,0000,0000,0000,
     5            0944,3332,4161,6914,0302,0000,0000,0000,0000,
     6            0431,3401,0400,0000,0000,0000,0000,0000,0000,
     7            0964,6352,4231,2212,0304,0000,0000,0000,0000,
     8            0462,4227,0200,0000,0000,0000,0000,0000,0000,
     9            0960,6152,4233,2212,0100,0000,0000,0000,0000/

c symb11: ~

      data symb11/0420,3123,3400,0000,0000,0000,0000,0000,0000,
     1            0000,0000,0000,0000,0000,0000,0000,0000,0000,
     2            0000,0000,0000,0000,0000,0000,0000,0000,0000,
     3            0000,0000,0000,0000,0000,0000,0000,0000,0000,
     4            0000,0000,0000,0000,0000,0000,0000,0000,0000,
     5            0000,0000,0000,0000,0000,0000,0000,0000,0000,
     6            0000,0000,0000,0000,0000,0000,0000,0000,0000,
     7            0000,0000,0000,0000,0000,0000,0000,0000,0000,
     8            0000,0000,0000,0000,0000,0000,0000,0000,0000,
     9            0000,0000,0000,0000,0000,0000,0000,0000,0000/

c 
c      we now save the value of the origin, since we manipulate 
c      it extensively in this routine and we would introduce 
c      outrageous complications into the calling routine if we 
c      failed to reset it to its original value. 
c 
c 
   10 if(xloc.lt.999.0) x0=xloc
      if(yloc.lt.999.0) y0=yloc
c for symbols we want to decrement the height by 6.
      heitgh=height/6.
      heigh=height
c 
c 
c      we now find the angle in radians of our plot, 
c      move the origin to our starting point. 
c 
c 
      rangle=-(angle+0.01)/57.29578 
      sinth=sin(rangle)
      costh=cos(rangle)
c 
c      looping is initiated to treat each of the 
c      characters in the string to be plotted. 
c 
c 
      if(nocar.gt.0)uplim=iabs(nocar)
	ipen = 3
	if(nocar.lt.0)then
		if(nocar.lt.-1) call plot(xloc,yloc,2)
		uplim=1
	else
		uplim = nocar
	endif
      do 50 j=1,uplim 
        i=j 
c-----NEW STANDARD
	jindex = ichar(inbuf(j))
	if(nocar.lt.0)then
		if(jindex.lt.16)then
			index = map(jindex+1)
		else
			index = map(jindex+17)
		endif
	else
		index = map(jindex+1)
	endif
      if(index.eq.17)go to 40
c 
c       if the character is lower case, the symloc routine is
c       called to properly scale or shift the lower case letter.
c 
c       default values are set (for most characters)
      scal = 1.
      shify = 0.
      shifx = 0.
      if (index .ge. 82 .and. index .le. 106)
     1               call symloc(index,scal,shify,shifx)
	if(index.le.16)call symloc(index,scal,shify,shifx)
c 
c       the first two digits  of the current character's first 
c       four digit integer are now isolated and used to determine 
c       the number of loops which must be done to plot all of the 
c       vectors which make up the character.  this is accomplished 
c       by allowing an integer division by 100 to truncate off the 
c       following two digits. 
c 
  32        loops=symblo(1,index)/100 
c       the coordinates of the first point are now obtained. 
c       they are then enlarged by the scaling factor, "heitgh", 
c       rotated if the angle from horizontal is noticeably 
c       large, and moved to via dark vector since it is the 
c       starting point of the character. 
c 
**** Initialize shift
      shy = shify*heitgh
      shx = shifx*heitgh
c 
       x1=(symblo(1,index)-symblo(1,index)/10*10) 
       y1=((symblo(1,index)-symblo(1,index)/100*100)/10) 
       x=x1*heitgh *scal-shx
       y=y1*heitgh *scal-shy
       if (abs(angle).gt.2.0)
     1       call symrot(x,y,sinth,costh)
       call plot (x+x0,y+y0,3) 
c 
c       looping is initiated to treat the subsequent vectors of 
c       the current character plot. 
c 
      do 45 m=2,loops,2 
c 
c       the particular four digit integer of the current character 
c       to be treated is found here by "m" and treated in a way 
c       basically like the first one was:,,the digits are isolated 
c       and tested to determine whether dark or not, then scaled to 
c       "heitgh", rotated if necessary, and plotted in the desig- 
c       nated mode. 
c 
c 
          l=m/2+1 
          y1=(symblo(l,index)/1000) 
          x1=(symblo(l,index)/100-y1*10)
	call symscl(x1,y1,x,y,ipen,angle,sinth,costh,
     1		heitgh,scal,shx,shy)
	call plot(x+x0,y+y0,ipen)
c 
c 
c       if the prescribed number of vectors has been plotted, 
c       there is no need to analyze the rest of the current 
c       four digit integer, so the loop is exited, otherwise 
c       continue as you were. 
c 
c 
            if(m.eq.loops) go to 40
                    y2=(symblo(l,index)/10-y1*100-x1*10) 
                    x2=(symblo(l,index)-y1*1000-x1*100-y2*10) 
        call symscl(x2,y2,x,y,ipen,angle,sinth,costh,
     1		heitgh,scal,shx,shy)
	call plot(x+x0,y+y0,ipen)
   45 	continue
c 
c 
c       now that the character is completely plotted, 
c       the origin is moved to a point to the right of the 
c       character in readiness for the next. 
c 
c 
   40 	continue
	if(nocar.gt.-1)then
           y0=y0-6.0*heitgh*sin(rangle) 
           x0=x0+6.0*heitgh*cos(rangle) 
           call plot (x0,y0,3) 
	endif
  50  continue 
c 
c 
c     after all characters have been plotted, we reset the 
c     origin to its initial value and move the cursor there. 
c 
c 
   99 continue
      return 
      end 
      subroutine symrot (x,y,s,c) 
c 
c     this subroutine is called directly by symbol, and serves 
c     to alter the coordinates of a point by rotating them about 
c     the current origin by the angle passed by the calling 
c     routine.  it is based on the trigonometric identities. 
c 
      x1=x
      y1=y
      x=c*x1 + s*y1
      y=-s*x1 + c*y1
      return 
      end 
c 
c 
c
c       this subroutine determines if the particular lower case
c       letter needs to be shifted or scaled down
      subroutine symloc(index,scldwn,shify,shifx)
         dimension ishift(6),iscale(6)
c-----
c     shift down g,j,p,q,y
c     scale down a,c,e,i,s,v
c-----
	data ishift/88,91,97,98,106,-1/
	data iscale/82,84,86,90,100,103/
	if(index.le.16)then
		scldwn = 1.5
		shifx = 3.0
		shify = 3.0
	else
	      do 10 i=1,6
	            if (index .eq. ishift(i)) then
			if(index .le.91)then
	                	shify = (7.+1.)/3.
			else
				shify = (7.+2.)/3.
			endif
	                shifx = 1./7.
	            end if
	            if (index .eq. iscale(i)) then
	                scldwn = 4./5.
	                shifx = -5./5.
	            end if
   10 		continue
	endif
      return
      end
	subroutine symscl(x1,y1,x,y,ipen,angle,sinth,costh,
     1		heitgh,scal,shx,shy)
	if(x1.ge.5)then
		x=(x1-5)*heitgh*scal-shx
		ipen = 3
	else
		x=x1*heitgh*scal - shx
		ipen =2
	endif
	y = y1*heitgh*scal - shy
	if(abs(angle).gt.2.0)call symrot(x,y,sinth,costh)
	return
	end
