/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
	File	:	unpackbytes.c
	Author	:	Dean Kopesky
	Date	:	23 June 1987
	Changed	:	27 June 1991
			Changed name from unpack() to unpackbytes() to avoid
			a name conflict with a system routine.

	unpackbytes() unpacks a contiguous byte stream from inbuf starting at
	inptr, and writes perword bytes into each word of outbuf, padding the
	words with a specified character.

	Calling sequence, C:

		void	unpackbytes();
		char	inbuf[ INLEN ], outbuf[ OUTLEN ];
		long	inptr;
		int	number, perword;
		char	pad;

		unpackbytes( inbuf, inptr, outbuf, number, perword, pad );

	Calling sequence, FORTRAN:

		DIMENSION inbuf( INLEN ), outbuf( OUTLEN )
		INTEGER inptr, number, perword
		INTEGER	pad

		CALL UNPACKBT( inbuf, inptr, outbuf, number, perword, pad )

	Parameters:

		inbuf	input	The buffer to read from.
		inptr	input	The byte in inbuf to start reading at
				(numbered from 1).
		outbuf	output	The buffer to unpack into.
		number	input	The number of bytes to unpack.
		perword	input	The number of bytes to put in each word of
				outbuf.
		pad	input	The character to pad the words with.

	Example:

		DIMENSION INBUF( 100 ), OUTBUF( 200 )
		< set INBUF >
		CALL UNPACKBT( INBUF, 1, OUTBUF, 800, 4, ' ' )
*/
#include <sisio.h>

#define	MIN(a,b)	( ( a < b ) ? ( a ) : ( b ) )


void	unpackbytes( inbuf, inptr, outbuf, number, perword, pad )

	char	*inbuf, *outbuf;
	long	inptr;
	int	number, perword;
	int	pad;

{
	char	*instr, *outstr;
	int	copied = 0;
	int	ncopy;

	char	*memcpy(), *memset();

	instr  = inbuf + inptr - 1;
	outstr = outbuf;

	while ( copied < number )
	{
		ncopy = MIN( perword, number - copied );
		memcpy( outstr, instr, ncopy );
		memset( outstr + ncopy, pad, WORDSIZE - ncopy );
		instr  += ncopy;
		outstr += WORDSIZE;
		copied += ncopy;
	}
}


void	UNPACKBT( inbuf, inptr, outbuf, number, perword, pad )

	char	*inbuf, *outbuf;
	long	*inptr;
	int	*number, *perword;
	int	*pad;

{
	unpackbytes( inbuf, *inptr, outbuf, *number, *perword, *pad );
}
