/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
	File	:	vftc2is.c
	Author	:	Dean Kopesky
	Date	:	May 1990
	Changed	:	June 1991
			Changed pack() to packbytes().

	Compile with either -D IEEE or -D IBM.

	vftc2s translates a velocity function (format V) record from
	Cray to IEEE format.

	vftc2i translates a velocity function (format V) record from
	Cray to IBM format.

	The basis for this routine was generated by gencon with the following
	format.  It required much hand modification, however.

	6i2 1i4 1c4 1i4 2c1 19i2 1c3 1b1 1i4 1c1 1c5 1c1 1b1 1c1 1b1 2c1
	100i2 100c6 0c8
*/


#include	<stdio.h>


#define	IEEESIZE	2000
#define	CRAYSIZE	( 996 * 8 )


#ifdef	IEEE
void	vftc2s( inbuf, inlen, outbuf, outlen )
#endif
#ifdef	IBM
void	vftc2i( inbuf, inlen, outbuf, outlen )
#endif

	char *	inbuf;
	int *	inlen;
	char *	outbuf;
	int *	outlen;

{
	int	start, number, length, perword, ier;
	int	n, m, j;

	if ( *inlen != CRAYSIZE )
	{
		fprintf( stderr, "vftc2[is]:  record length must be %d.\n",
			CRAYSIZE );
		exit( 1 );
	}
	(void) memset( outbuf, 0, IEEESIZE );

	start = 1;
	number = 6;
	length = 2;
	USICTI( inbuf + 0, outbuf, &start, &number, &length, &ier );
	start = 13;
	number = 1;
	length = 4;
	USICTI( inbuf + 48, outbuf, &start, &number, &length, &ier );
#ifdef	IEEE
	packbytes( inbuf + 56, outbuf, 17, 4, 4 );
#endif
#ifdef	IBM
	start = 17;
	number = 4;
	perword = 4;
	USCCTI( inbuf + 56, outbuf, &start, &number, &perword );
#endif
	start = 21;
	number = 1;
	length = 4;
	USICTI( inbuf + 64, outbuf, &start, &number, &length, &ier );
#ifdef	IEEE
	packbytes( inbuf + 72, outbuf, 25, 2, 1 );
#endif
#ifdef	IBM
	start = 25;
	number = 2;
	perword = 1;
	USCCTI( inbuf + 72, outbuf, &start, &number, &perword );
#endif
	start = 27;
	number = 19;
	length = 2;
	USICTI( inbuf + 88, outbuf, &start, &number, &length, &ier );
#ifdef	IEEE
	packbytes( inbuf + 240, outbuf, 65, 3, 3 );
#endif
#ifdef	IBM
	start = 65;
	number = 3;
	perword = 3;
	USCCTI( inbuf + 240, outbuf, &start, &number, &perword );
#endif
	memset( outbuf + 67, '\0', 1 );
	start = 69;
	number = 1;
	length = 4;
	USICTI( inbuf + 248, outbuf, &start, &number, &length, &ier );
#ifdef	IEEE
	packbytes( inbuf + 256, outbuf, 73, 1, 1 );
	packbytes( inbuf + 264, outbuf, 74, 5, 5 );
	packbytes( inbuf + 272, outbuf, 79, 1, 1 );
#endif
#ifdef	IBM
	start = 73;
	number = 1;
	perword = 1;
	USCCTI( inbuf + 256, outbuf, &start, &number, &perword );
	start = 74;
	number = 5;
	perword = 5;
	USCCTI( inbuf + 264, outbuf, &start, &number, &perword );
	start = 79;
	number = 1;
	perword = 1;
	USCCTI( inbuf + 272, outbuf, &start, &number, &perword );
#endif
	memset( outbuf + 79, '\0', 1 );
#ifdef	IEEE
	packbytes( inbuf + 280, outbuf, 81, 1, 1 );
#endif
#ifdef	IBM
	start = 81;
	number = 1;
	perword = 1;
	USCCTI( inbuf + 280, outbuf, &start, &number, &perword );
#endif
	memset( outbuf + 81, '\0', 1 );
#ifdef	IEEE
	packbytes( inbuf + 288, outbuf, 83, 2, 1 );
#endif
#ifdef	IBM
	start = 83;
	number = 2;
	perword = 1;
	USCCTI( inbuf + 288, outbuf, &start, &number, &perword );
#endif

	/* Grab N, M, and J. */

	memcpy( &n, inbuf + (24 * 8), 8 );
	memcpy( &m, inbuf + (25 * 8), 8 );
	memcpy( &j, inbuf + (26 * 8), 8 );

	/* Convert 4N + M ints to I2s. */

	start = 85;
	number = 4 * n + m;
	length = 2;
	USICTI( inbuf + 304, outbuf, &start, &number, &length, &ier );

	/* Convert M words to A6s. */

#ifdef	IEEE
	packbytes( inbuf + 304 + 8*(4*n+m), outbuf, 85 + 2*(4*n+m), 6 * m, 6 );
#endif
#ifdef	IBM
	start = 85 + 2*(4*n+m);
	number = 6 * m;
	perword = 6;
	USCCTI( inbuf + 304 + 8*(4*n+m), outbuf, &start, &number, &perword );
#endif

	/* Convert interpreter's comments. */

#ifdef	IEEE
	packbytes(inbuf + 304 + 8*(4*n+2*m), outbuf, 85 + 2*(4*n+m)+6*m, j, 8);
#endif
#ifdef	IBM
	start = 85 + 2*(4*n+m)+6*m;
	number = j;
	perword = 8;
	USCCTI( inbuf + 304 + 8*(4*n+2*m), outbuf, &start, &number, &perword );
#endif
	/* *outlen = 84 + 2 * ( 4 * n + m ) + 6 * m + j; */
	*outlen = IEEESIZE;
}
