/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
	File	:	cs2i.c
	Author	:	Dean Kopesky
	Company	:	Minnesota Supercomputer Center, Inc.
	Date	:	August 1989

	Cs2i must be linked as follows:

		ldr -o cs2i cs2i.o wrtape.i.o -l./sisieee.a
*/


#include	<stdio.h>

#define	MODULE	"cs2i"
#define	USAGE	\
"usage:	cs2i [ -H ]\n\
	cs2i [ ieee(4) ] > ibm(4)\n\
	cat cray(8) | cs2i > ibm(4)\n"

#define	E_GOOD	0
#define	E_BAD	1

static	char	helptext[] = 
"\
\n\
Cs2i reads a CRAY-2 format SIS file from a pipe or an IEEE format SIS file\n\
from disk, and writes to stdout an IBM format SIS file.\n\
\n\
Usage:\n\
\n\
	cs2i [ -H ]\n\
	cs2i [ ieee(4) ] > ibm(4)\n\
	cat cray(8) | cs2i > ibm(4)\n\
\n\
	-H		Prints this help listing.\n\
	ibm(4)		An IBM format SIS file (with 4-byte control words).\n\
	ieee(4)		An IEEE format SIS file (with 4-byte control words).\n\
	cray(8)		A CRAY format SIS file (with 8-byte control words).\n\
\n\
";


int	main( argc, argv )

	int	argc;
	char *	argv[];

{
	char	buffer[ 200000 ];
	int	inunit;
	int	length;
	int	records;

	/*
		Parse command line.
	*/

	if ( argc > 2 )
	{
		fprintf( stderr, USAGE );
		return E_BAD;
	}
	else if ( argc == 2 )
	{
		if ( strcmp( argv[ 1 ], "-H" ) == 0 )
		{
			fprintf( stderr, helptext );
			return E_GOOD;
		}
		else
		{
			lbopen( &inunit, argv[ 1 ], "r" );
		}
	}
	else
	{
		inunit = 0;
	}
		
	/*
		Copy and translate.
	*/

	siswhen( 1, "always" );
	sislgbuf( inunit, "on" );
	sislgbuf( 1, "on" );

	records = 0;
	rtape( inunit, buffer, &length );

	while ( length > 0 )
	{
		wrtape( 1, buffer, length );
		records += 1;
		rtape( inunit, buffer, &length );
	}

	lbclos( 1 );
	fprintf( stderr, "%s:  %d records processed\n", MODULE, records );

	return E_GOOD;
}
