/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
	File	:	getargs.c
	Program	:	gencon
	Author	:	Dean Kopesky
	Date	:	May 1988
	Changed	:	March 1990
			Cleaned up test for alphanumerics in routine name.
*/


#include	<ctype.h>
#include	"gencon.h"


void getargs( argc, argv, routine, direction, format )

	int	argc;
	char *	argv[];
	char **	routine;
	int  *	direction;
	FILE **	format;

{
	int	i;

	if ( argc < 3 || argc > 4 )
	{
		fprintf( stderr, "usage: %s routine direction [ format ]\n",
			MODULE );
		exit( EUSAGE );
	}

	/*
		Get routine name.
	*/

	if ( strlen( argv[ 1 ] ) < 1 || strlen( argv[ 1 ] ) > 8 )
	{
		fprintf( stderr, "%s: invalid routine name (%s).\n",
			MODULE, argv[ 1 ] );
		exit( EUSAGE );
	}

	i = -1;
	while ( argv[ 1 ][ ++i ] != '\0' )
		if ( ! isalnum( argv[ 1 ][ i ] ) )
		{
			fprintf( stderr, "%s: invalid routine name (%s).\n",
				MODULE, argv[ 1 ] );
			exit( EUSAGE );
		}

	*routine = argv[ 1 ];

	/*
		Get direction.
	*/

	if ( strcmp( argv[ 2 ], "i2c" ) == 0 )
		*direction = I2C;
	else if ( strcmp( argv[ 2 ], "c2i" ) == 0 )
		*direction = C2I;
	else if ( strcmp( argv[ 2 ], "s2c" ) == 0 )
		*direction = S2C;
	else if ( strcmp( argv[ 2 ], "c2s" ) == 0 )
		*direction = C2S;
	else if ( strcmp( argv[ 2 ], "in2s" ) == 0 )
		*direction = IN2S;
	else if ( strcmp( argv[ 2 ], "s2in" ) == 0 )
		*direction = S2IN;
	else
	{
		fprintf( stderr, "%s: invalid direction (%s).\n",
			MODULE, argv[ 2 ] );
		exit( EUSAGE );
	}

	/*
		Get format file.
	*/

	if ( argc < 4 )
		*format = stdin;
	else
	{
		*format = fopen( argv[ 3 ], "r" );
		if ( *format == NULL )
		{
			fprintf( stderr, "%s: cannot open format file (%s).\n",
				MODULE, argv[ 3 ] );
			exit( ENOOPEN );
		}
	}
}
