/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
	File	:	prfmtb.c
	Program	:	gencon
	Author	:	Dean Kopesky
	Date	:	May 1988

	Generate subroutine calls to generate or skip dummy bytes.
*/


#include	"gencon.h"


void prfmtb( direction, count, size, inptr, outptr )

	int	direction;
	int	count;
	int	size;
	int *	inptr;
	int *	outptr;

{
/* debug
	printf("prfmtb: count = %d, size = %d, inptr = %d, outptr = %d\n",
		count,size,*inptr,*outptr);
*/
	switch( direction )
	{
		case I2C:
		case S2C:
		case S2IN:

			*inptr += count * size;
			break;

		case C2S:
		case C2I:
		case IN2S:

printf( "	memset( outbuf + %d, '\\0', %d );\n", *outptr, count * size );
			*outptr += count * size;
			break;

		default:

			fprintf( stderr, "%s: internal error in prfmtb.\n",
				MODULE );
			exit( EINTERN );
			break;
	}
}
