/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
	Package	:	sisio
	File	:	_error.c
	Author	:	Dean Kopesky
	Company	:	Minnesota Supercomputer Center, Inc.


	_Error prints an appropriate error message for the specified code
	and, if aborting is enabled for the unit, aborts the program.

	_error( module, unit, code );

	module	input	char *	Module from which the error comes.
	unit	input	int	Unit on which the error occurs.
	code	input	int	The error code.


	$Header: /m/s1/dmk/xlate/sisio/RCS/_error.c,v 4.1 90/07/13 08:51:22 dmk Exp $

	$Log:	_error.c,v $
	Revision 4.1  90/07/13  08:51:22  dmk
	MODSET: 4.1
	Added new error codes, message prefix for SISB4MSG, and perror() call.
	
	Revision 2.1  88/07/12  15:08:55  dmk
	MODSET: 2.1
	Added E_NOUNITS, E_NORMAL.  Removed E_ISOPEN, E_LGOPER, E_STDOPEN.
	
	Revision 1.2  88/06/27  09:31:22  dmk
	MODSET: 1.2
	Will now print an error message even if aborting is disabled.
	
	Revision 1.1  88/06/24  10:33:57  dmk
	Initial revision
	
*/


#include	<stdio.h>
#include	<errno.h>
#include	"sisio.h"


void _error( module, unit, code )

	char *	module;
	int	unit;
	int	code;

{
	char *	msg;

	switch ( code )
	{
case E_SISIO:		msg = "sisio error";				break;

case E_NORMAL:		msg = "no error";				break;
case E_BADFMT:		msg = "bad sis format code";			break;
case E_BADMODE:		msg = "access mode too long or invalid";	break;
case E_BADNAME:		msg = "name string too long or invalid";	break;
case E_BADSWITCH:	msg = "switch too long or invalid";		break;
case E_BADUNIT:		msg = "unit number out of range";		break;
case E_CLOSE:		msg = "close system call error";		break;
case E_INTERNAL:	msg = "internal error in function";		break;
case E_LSEEK:		msg = "lseek system call error";		break;
case E_NEGREC:		msg = "negative record count illegal";		break;
case E_NEWLEN:		msg = "record length has changed";		break;
case E_NOBUFFER:	msg = "unable to allocate buffer";		break;
case E_NOFMT:		msg = "sis format code unknown";		break;
case E_NOTFILE:		msg = "file is not a disk file or pipe";	break;
case E_NOTOPEN:		msg = "unit is not open";			break;
case E_NOTRCLEN:	msg = "trace length unknown";			break;
case E_NOUNITS:		msg = "no more units available";		break;
case E_OPEN:		msg = "open system call error";			break;
case E_PASTEOF:		msg = "attempt to skip past eof";		break;
case E_READ:		msg = "read system call error";			break;
case E_RECLEN:		msg = "wrong record length in file";		break;
case E_WRITE:		msg = "write system call error";		break;
case E_NOTONL:		msg = "operation not allowed on format L";	break;
case E_BADPREFIX:	msg = "message prefix too long or invalid";	break;

default:		msg = "(no message for this error)";		break;
	}

	if ( _msg_prefix[ 0 ] == '\0' )
		( void ) fprintf( stderr, "sisio,%s,%d,%d: %s (%s).\n",
			module, unit, code, msg, _sisfit[ unit ].filename );
	else
		( void ) fprintf( stderr, "%s - sisio,%s,%d,%d: %s (%s).\n",
			_msg_prefix, module, unit, code, msg,
			_sisfit[ unit ].filename );

	if ( errno != -1 )
	{
		if ( _sisfit[ unit ].filename != NULL)
			perror( _sisfit[ unit ].filename );
		else
			perror( "sisio" );
		errno = -1;
	}

	if ( unit >= 0 && unit <= MAXUNIT && ! _sisfit[ unit ].abort )
	{
		_sisfit[ unit ].error = code;
	}
	else
	{
		exit( E_SISIO + code );
	}
}
