/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* ---------------------------------------------------------------------------

	Package	:	sisio
	File	:	lbclos.c
	Author	:	Dean Kopesky
	Company	:	Minnesota Supercomputer Center, Inc.


	LBCLOS closes the specified unit.

	FORTRAN:

	CALL LBCLOS( unit )

	unit	input	integer	Unit number of file to close.

	C:

	lbclos( unit );

	unit	input	int	Unit number of file to close.


	$Header: /m/s1/dmk/xlate/sisio/RCS/lbclos.c,v 4.3 91/09/11 08:47:12 dmk Exp $

	$Log:	lbclos.c,v $
	Revision 4.3  91/09/11  08:47:12  dmk
	MODSET: 4.3
	Changed entry point names to macros.
	
	Revision 4.1  90/07/13  09:16:10  dmk
	MODSET: 4.1
	Added free( .filename ).  Changed SUN to sun.
	
	Revision 3.1  89/09/27  09:53:45  dmk
	MODSET: 3.1
	Added C entry point.
	
	Revision 2.1  88/07/12  15:33:10  dmk
	MODSET: 2.1
	Added lower case entry point for SUN.  Now flushes a large buffer only
	if program has been writing to the unit (bit of a bug otherwise).
	
	Revision 1.2  88/06/24  16:16:58  dmk
	MODSET: 1.2
	Buffer is now flushed before the file is closed rather than after.
	
	Revision 1.1  88/06/24  14:59:50  dmk
	Initial revision
	
--------------------------------------------------------------------------- */


#include	"sisio.h"

#define	MODULE	"LBCLOS"


void	F_LBCLOS( unit )

	int *	unit;

{
	C_LBCLOS( *unit );
}


void	C_LBCLOS( unit )

	int	unit;

{
	int	ier;

	/*
		Initialize package if necessary; check unit for range;
		check for outstanding errors on unit; see if unit is open.
	*/

	INITIALIZE;
	CHECKRANGE( MODULE, unit );
	CHECKERROR( MODULE, unit );
	CHECKOPEN( MODULE, unit );

	/*
		Flush and deallocate buffer.
	*/

	if ( _sisfit[ unit ].largebuf && _sisfit[ unit ].lgoper == L_WRITE )
	{
		ier = _flushit( unit );

		if ( ier != 0 )
		{
			_error( MODULE, unit, -ier );
			return;
		}
	}

	free( _sisfit[ unit ].buffer );

	/*
		Close unit if not stdin or stdout; otherwise, simply
		disconnect it.
	*/

	if ( _sisfit[ unit ].filedes != 0 && _sisfit[ unit ].filedes != 1 )
		if ( close( _sisfit[ unit ].filedes ) != 0 )
		{
			_error( MODULE, unit, E_CLOSE );
			return;
		}

	free( _sisfit[ unit ].filename );
	_fitinit( unit );
}
