/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* ---------------------------------------------------------------------------

	Package	:	sisio
	File	:	rtape4.c
	Author	:	Dean Kopesky
	Company	:	Minnesota Supercomputer Center, Inc.


	RTAPE4 reads a record from a specified unit, translating to CRAY
	format iff necessary, and returning the lengths of the translated
	and untranslated records in bytes.  The length is set to zero if
	the file is at EOF.

	This routine is included only for compatibility with an older
	library and its use is discouraged.  This routine has no C calling
	sequence.  It does not work on format L.


	CALL RTAPE4( unit, buffer, length, dlen )

	unit	input	integer	The unit to read from.
	buffer	output	array	The buffer to read into.
	length	output	integer	The length of the data in buffer in bytes.
	dlen	output	integer	The length of the data on disk in bytes.


	$Header: /m/s1/dmk/xlate/sisio/RCS/rtape4.c,v 4.3 91/09/11 08:49:03 dmk Exp $

	$Log:	rtape4.c,v $
	Revision 4.3  91/09/11  08:49:03  dmk
	MODSET: 4.3
	Changed entry point names to macros.
	
	Revision 4.1  90/07/13  09:18:48  dmk
	MODSET: 4.1
	Added check for format L.  Changed SUN to sun.
	
	Revision 3.1  89/09/27  09:55:00  dmk
	MODSET: 3.1
	Changed to use rtape() rather than RTAPE().
	
	Revision 2.3  88/08/16  12:47:41  dmk
	MODSET: 2.3
	Changed so that dlen is set to 0 at EOF.
	
	Revision 2.1  88/07/12  16:01:07  dmk
	MODSET: 2.1
	Initial revision.  This file added to sisio at version 2.1.
	
--------------------------------------------------------------------------- */

#ifdef DEBUG
#include <stdio.h>
#endif
#include	"sisio.h"

#define	MODULE	"RTAPE4"


void	F_RTAPE4( unit, buffer, length, dlen )

	int *	unit;
	char *	buffer;
	int *	length;
	int *	dlen;

{
	if ( _sisfit[ *unit ].format == 'L' )
	{
		_error( MODULE, *unit, E_NOTONL );
		return;
	}

	C_RTAPE( *unit, buffer, length );

#ifdef DEBUG
	fprintf(stderr,"%s: length = %d\n",MODULE,*length);
#endif
	if ( _sisfit[ *unit ].error != 0 ) return;

#ifdef DEBUG
	fprintf(stderr,"%s: pointer = %d\n",MODULE,_sisfit[ *unit ].pointer);
	fprintf(stderr,"%s: hdrlen = %d\n",MODULE,_sisfit[ *unit ].hdrlen);
#endif
	if ( *length == 0 )
		*dlen = 0;
	else if ( _sisfit[ *unit ].pointer > 1 )
		*dlen = _sisfit[ *unit ].trclen;
	else
		*dlen = _sisfit[ *unit ].hdrlen;
}
