/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* ---------------------------------------------------------------------------

	Package	:	sisio
	File	:	siserror.c
	Author	:	Dean Kopesky
	Company	:	Minnesota Supercomputer Center, Inc.


	SISERROR retrieves the error code of the last operation on the unit,
	and then resets it to zero.  The code will be zero if no error
	occurred, or one of a number of non-zero values otherwise.  This
	subroutine is only useful if preceded by:

		CALL SISABORT( unit, 'off' )

	FORTRAN:

	CALL SISERROR( unit, error )

	unit	input	integer	Unit number to check.
	error	output	integer	Last error code for unit.

	C:

	siserror( unit, error );

	unit	input	int	Unit number to check.
	error	output	int *	Last error code for unit.


	$Header: /m/s1/dmk/xlate/sisio/RCS/siserror.c,v 4.3 91/09/11 08:50:10 dmk Exp $

	$Log:	siserror.c,v $
	Revision 4.3  91/09/11  08:50:10  dmk
	MODSET: 4.3
	Changed entry point names to macros.
	
	Revision 4.1  90/07/13  09:22:05  dmk
	MODSET: 4.1
	Changed SUN to sun.
	
	Revision 3.1  89/09/27  09:57:07  dmk
	MODSET: 3.1
	Added C entry point.
	
	Revision 2.1  88/07/12  15:18:29  dmk
	MODSET: 2.1
	Added lower case entry point for SUN.  Now uses CHECKRANGE.
	
	Revision 1.1  88/06/29  08:44:05  dmk
	Initial revision
	
--------------------------------------------------------------------------- */


#include	"sisio.h"

#define	MODULE	"SISERROR"


void	F_SISERROR( unit, error )

	int *	unit;
	int *	error;

{
	C_SISERROR( *unit, error );
}


void	C_SISERROR( unit, error )

	int	unit;
	int *	error;

{
	/*
		Initialize iff necessary and check unit for range.
	*/

	INITIALIZE;
	CHECKRANGE( MODULE, unit );

	/*
		Get and reset error code.
	*/

	*error = _sisfit[ unit ].error;
	_sisfit[ unit ].error = 0;
}
