/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* ---------------------------------------------------------------------------

	Package	:	sisio
	File	:	sisprt.c
	Author	:	Dean Kopesky
	Company	:	Minnesota Supercomputer Center, Inc.


	SISPRT prints the file information table for a unit in human-readable
	form.

	FORTRAN:

	CALL SISPRT( unit )

	unit	input	integer	The unit to print the information for.

	C:

	sisprt( unit );

	unit	input	int	The unit to print the information for.


	$Header: /m/s1/dmk/xlate/sisio/RCS/sisprt.c,v 4.3 91/09/11 08:59:34 dmk Exp $

	$Log:	sisprt.c,v $
	Revision 4.3  91/09/11  08:59:34  dmk
	MODSET: 4.3
	Changed entry point names to macros.
	
	Revision 4.1  90/07/13  09:26:22  dmk
	MODSET: 4.1
	Added code to print new FIT fields.  Changed SUN to sun.
	
	Revision 3.1  89/09/27  09:57:56  dmk
	MODSET: 3.1
	Added C entry point.
	
	Revision 2.2  88/07/20  08:56:23  dmk
	MODSET: 2.2
	Added line to print .doio field of the FIT.
	
	Revision 2.1  88/07/12  15:36:48  dmk
	MODSET: 2.1
	Added lower case entry point for SUN.
	
	Revision 1.1  88/06/29  08:55:54  dmk
	Initial revision
	
--------------------------------------------------------------------------- */


#include	<stdio.h>
#include	"sisio.h"

#define	MODULE	"SISPRT"


void	F_SISPRT( unit )

	int *	unit;

{
	C_SISPRT( *unit );
}


void	C_SISPRT( unit )

	int	unit;

{
	/*
		Check and initialize if necessary.  Check unit for range.
	*/

	INITIALIZE;
	CHECKRANGE(MODULE,unit);

	/*
		Print report about specified unit.
	*/

( void ) fprintf( stderr, "sisio, unit %d file information table:\n", unit );

( void ) fprintf( stderr, "filename =	%s\n", _sisfit[ unit ].filename );
( void ) fprintf( stderr, "filedes =	%d\t", _sisfit[ unit ].filedes );
( void ) fprintf( stderr, "isopen =	%d\n", _sisfit[ unit ].isopen );
( void ) fprintf( stderr, "isdisk =	%d\t", _sisfit[ unit ].isdisk );
( void ) fprintf( stderr, "doio =		%d\n", _sisfit[ unit ].doio );
( void ) fprintf( stderr, "trwhen =	%d\t", _sisfit[ unit ].trwhen );
( void ) fprintf( stderr, "dotraces =	%d\n", _sisfit[ unit ].dotraces );
( void ) fprintf( stderr, "pointer =	%d\t", _sisfit[ unit ].pointer );
( void ) fprintf( stderr, "format =	%d\n", _sisfit[ unit ].format );
( void ) fprintf( stderr, "hdrlen =	%d\t", _sisfit[ unit ].hdrlen );
( void ) fprintf( stderr, "trclen =	%d\n", _sisfit[ unit ].trclen );
( void ) fprintf( stderr, "cwlen =		%d\t", _sisfit[ unit ].cwlen );
( void ) fprintf( stderr, "abort =		%d\n", _sisfit[ unit ].abort );
( void ) fprintf( stderr, "error =		%d\t", _sisfit[ unit ].error );
( void ) fprintf( stderr, "largebuf =	%d\n", _sisfit[ unit ].largebuf );
( void ) fprintf( stderr, "bufsize =	%d\t", _sisfit[ unit ].bufsize );
( void ) fprintf( stderr, "bfrbeg =	%d\n", _sisfit[ unit ].bfrbeg );
( void ) fprintf( stderr, "bfrend =	%d\t", _sisfit[ unit ].bfrend );
( void ) fprintf( stderr, "lgoper =	%d\n", _sisfit[ unit ].lgoper );
( void ) fprintf( stderr, "buffer =	%d\t", _sisfit[ unit ].buffer );
( void ) fprintf( stderr, "headerat =	%d\n", _sisfit[ unit ].headerat );

}
