/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* ---------------------------------------------------------------------------

	Package	:	sisio
	Module	:	sistrace.c
	Author	:	Dean Kopesky
	Company	:	Minnesota Supercomputer Center, Inc.


	Enables and disables the translation of trace data on the specified
	unit.  If fswitch = 'off', only the line header and trace headers will
	be translated.  If fswitch = 'on', all data will be translated.

	FORTRAN:

	CALL SISTRACE( unit, fswitch )

	unit	input	integer	Unit number.
	fswitch	input	charact	Set to 'on' or 'off' to enable or disable
				translation of trace data.

	C:

	sistrace( unit, cswitch );

	unit	input	int	Unit number.
	cswitch	input	char *	Set to 'on' or 'off' to enable or disable
				translation of trace data.


	$Header: /m/s1/dmk/xlate/sisio/RCS/sistrace.c,v 4.3 91/09/11 09:01:10 dmk Exp $

	$Log:	sistrace.c,v $
	Revision 4.3  91/09/11  09:01:10  dmk
	MODSET: 4.3
	Changed entry point names to macros.   Tests for NEVER_TRANSLATE.
	
	Revision 4.1  90/07/13  09:27:46  dmk
	MODSET: 4.1
	Changed SUN to sun.
	
	Revision 3.1  89/09/27  09:58:45  dmk
	MODSET: 3.1
	Added C entry point.
	
	Revision 2.3  88/08/16  12:42:13  dmk
	MODSET: 2.3
	Added the fswlen parameter to fix a bug in the SUN version.
	
	Revision 2.1  88/07/12  15:27:47  dmk
	MODSET: 2.1
	Added lower case entry point for SUN.  Added SUN clause:  never sets
	dotraces to TRUE.  Now uses CHECKRANGE.
	
	Revision 1.1  88/06/27  12:28:00  dmk
	Initial revision
	
--------------------------------------------------------------------------- */


#ifdef	CRAY
#include	<fortran.h>
#endif

#include	"sisio.h"

#define	MODULE	"SISTRACE"

#define STRLEN	128


#ifdef	CRAY
void	F_SISTRACE( unit, fswitch )

	int *	unit;
	_fcd	fswitch;
#endif
#ifdef	STRLEN_IS_ARG
void	F_SISTRACE( unit, fswitch, fswlen )

	int *	unit;
	char *	fswitch;
	int	fswlen;
#endif

{
	char	cswitch[ STRLEN ];

	/*
		Check and translate switch.
	*/

#ifdef	CRAY
	if ( _strf2c( fswitch, cswitch, STRLEN ) < 0 )
#endif
#ifdef	STRLEN_IS_ARG
	if ( _strf2c( fswitch, fswlen, cswitch, STRLEN ) < 0 )
#endif
	{
		_error( MODULE, *unit, E_BADSWITCH );
		return;
	}

	/*
		Call C version.
	*/

	C_SISTRACE( *unit, cswitch );
}


void	C_SISTRACE( unit, cswitch )

	int	unit;
	char *	cswitch;

{
	/*
		Initialize if necessary and check unit for range and
		outstanding error.
	*/

	INITIALIZE;
	CHECKRANGE( MODULE, unit );
	CHECKERROR( MODULE, unit );

	/*
		Set dotraces field.
	*/

	_strlower( cswitch );

	if ( ! strcmp( cswitch, "on" ) )
#ifdef	NEVER_TRANSLATE
		/* do nothing */ ;
#else
		_sisfit[ unit ].dotraces = TRUE;
#endif
	else if ( ! strcmp( cswitch, "off" ) )
		_sisfit[ unit ].dotraces = FALSE;
	else
	{
		_error( MODULE, unit, E_BADSWITCH );
		return;
	}
}
