/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* ---------------------------------------------------------------------------

	Package	:	sisio
	Module	:	seekt.c
	Author	:	Dean Kopesky
	Company	:	Minnesota Supercomputer Center, Inc.


	SEEKT positions the unit at the specified byte.  This subroutine is
	included only for compatibility with an older library and its use	
	is highly discouraged.  This routine has no C calling sequence.

	CALL SEEKT( unit, byte )

	unit	input	integer	Unit to position.
	byte	input	integer	Number of byte to position unit at.


	$Header: /m/s1/dmk/xlate/sisio/RCS/seekt.c,v 4.3 91/09/11 08:49:19 dmk Exp $

	$Log:	seekt.c,v $
	Revision 4.3  91/09/11  08:49:19  dmk
	MODSET: 4.3
	Changed entry point names to macros.
	
	Revision 4.1  90/07/13  09:19:53  dmk
	MODSET: 4.1
	Changed SUN to sun.
	
	Revision 3.1  89/09/27  09:56:01  dmk
	MODSET: 3.1
	Fixed comments only (they were wrong).
	
	Revision 2.1  88/07/12  15:36:00  dmk
	MODSET: 2.1
	Added lower case entry point for SUN.
	
	Revision 1.2  88/06/27  10:17:09  dmk
	MODSET: 1.2
	Will now flush the buffer if large buffering is enabled, rather than
	flagging an error.
	
	Revision 1.1  88/06/24  12:16:12  dmk
	Initial revision
	
--------------------------------------------------------------------------- */


#include	"sisio.h"
#include	<sys/types.h>

#define	MODULE	"SEEKT"


void	F_SEEKT( unit, byte )

	int *	unit;
	unsigned int *	byte;	/* was int* */

{
	int	ferror;

	/*
		Initialize iff necessary, check unit for range, outstanding
		errors and openness.
	*/

	INITIALIZE;
	CHECKRANGE(MODULE,*unit);
	CHECKERROR(MODULE,*unit);
	CHECKOPEN(MODULE,*unit);

	/*
		Check for large buffering.  If so, flush the buffer.
	*/

	if ( _sisfit[ *unit ].largebuf )
	{
		ferror = _flushit( *unit );
		if ( ferror < 0 )
		{
			_error( MODULE, *unit, -ferror );
			return;
		}
	}

	/*
		Seek.
	*/

#ifndef __convex__
	if ( lseek( _sisfit[ *unit ].filedes, ( off_t ) *byte, 0 ) != *byte )
#else
	if ( lseek( _sisfit[ *unit ].filedes,
		( off64_t) *byte, 0 ) != *byte )
#endif
	{
		_error( MODULE, *unit, E_LSEEK );
		return;
	}

	/*
		Guess trace number if possible.
	*/

	if ( _sisfit[ *unit ].hdrlen != 0 && _sisfit[ *unit ].trclen != 0 &&
			_sisfit[ *unit ].cwlen != 0 )
	{
		_sisfit[ *unit ].pointer = ( *byte - _sisfit[ *unit ].hdrlen -
			_sisfit[ *unit ].cwlen ) / ( _sisfit[ *unit ].trclen +
			_sisfit[ *unit ].cwlen ) + 1;
	}
}
