/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* ---------------------------------------------------------------------------

	Package	:	sisio
	File	:	sisinfo.c
	Author	:	Dean Kopesky
	Company	:	Minnesota Supercomputer Center, Inc.


	Retrieves the file information table for the specified unit.

	FORTRAN:

	CALL SISINFO( unit, fit )

	unit	input	integer	Unit number of unit to check.
	fit	output	int(n)	File information table for unit; this is
				an integer array.

	C:

	sisinfo( unit, fit );

	unit	input	int	Unit number of unit to check.
	fit	output	int[]	File information table for unit; this is
				an integer array.


	$Header: /m/s1/dmk/xlate/sisio/RCS/sisinfo.c,v 4.3 91/09/11 08:50:41 dmk Exp $

	$Log:	sisinfo.c,v $
	Revision 4.3  91/09/11  08:50:41  dmk
	MODSET: 4.3
	Changed entry point names to macros.
	
	Revision 4.1  90/07/13  09:24:12  dmk
	MODSET: 4.1
	Changed SUN to sun.
	
	Revision 3.1  89/09/27  09:57:25  dmk
	MODSET: 3.1
	Added C entry point.
	
	Revision 2.1  88/07/12  15:19:11  dmk
	MODSET: 2.1
	Added lower case entry point for SUN.  Now uses CHECKRANGE.
	
	Revision 1.1  88/06/29  08:49:07  dmk
	Initial revision
	
--------------------------------------------------------------------------- */


#include	"sisio.h"

#define	MODULE	"SISINFO"


void	F_SISINFO( unit, fit )

	int *	unit;
	int *	fit;

{
	C_SISINFO( *unit, fit );
}


void	C_SISINFO( unit, fit )

	int	unit;
	int *	fit;

{
	/*
		Initialize iff necessary and check unit for range.
	*/

	INITIALIZE;
	CHECKRANGE( MODULE, unit );

	/*
		Copy file information table to fit.
	*/

	( void ) memcpy( ( char * ) fit, ( char * ) &( _sisfit[ unit ] ),
		sizeof( fitentry ) );
}
