C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       CFFT2                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       Computes a complex to complex forward or inverse radix 2 fft.  *
C       Functional equivalent of the Cray SCILIB routine of the same   *
C       name.                                                          *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      CFFT2  (INIT,IDIR,N,A,TAB,C)                                    *
C  ARGUMENTS:                                                          *
C      INIT    INTEGER  ??IOU*      -                                  *
C      IDIR    INTEGER  ??IOU*      -                                  *
C      N       INTEGER  ??IOU*      -                                  *
C      A       COMPLEX  ??IOU*  (*) -                                  *
C      TAB     COMPLEX  ??IOU*  (*) -                                  *
C      C       COMPLEX  ??IOU*  (*) -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 97/02/13  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       FORTRAN 77                                                     *
C                                                                      *
C  HISTORY:                                                            *
C       ORIGINAL                MAR 92          R.D. COLEMAN, CETech   *
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL CFFT2( INIT, IDIR, N, A, TAB, C )                         *
C                                                                      *
C  PARAMETERS:                                                         *
C       INIT    INTEGER INPUT SCALAR                                   *
C               Initialization flag:                                   *
C                 != 0, Generate sine and cosine tables in TAB.        *
C                  = 0, Calculates FFT using tables generated in a     *
C                       previous call.                                 *
C                                                                      *
C       IDIR    INTEGER INPUT SCALAR                                   *
C               FFT direction switch: IDIR < 0 for forward FFT's and   *
C               IDIR > 0 for inverse FFT's.                            *
C                                                                      *
C       N       INTEGER INPUT SCALAR                                   *
C               Number of elements - must be 2**m where m >= 3.        *
C                                                                      *
C       A       COMPLEX INPUT VECTOR OF LENGTH N                       *
C               Source vector.  Vector A may overlay TAB or C in which *
C               case it is overwritten.                                *
C                                                                      *
C       TAB     COMPLEX INPUT/OUTPUT VECTOR OF LENGTH 5*N/2            *
C               Sine and cosine tables and work space.                 *
C                                                                      *
C       C       COMPLEX OUTPUT VECTOR OF LENGTH N                      *
C               Result vector.                                         *
C                                                                      *
C  DESCRIPTION:                                                        *
C       CFFT2 calculates:                                              *
C                                                                      *
C          C(k+1) = SUM[ A(j+1) * exp( isgn*2*pi*i*j*k/n ), j = 0, n-1 *
C             for k = 0, n-1                                           *
C                                                                      *
C          where i = sqrt( -1 ) and isgn = -1 if IDIR < 0 and isgn = 1 *
C          if IDIR > 0.                                                *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       Math Advantage: VMOV, CFTTX                                    *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       If N is not an integer power of 2, or IDIR = 0 and INIT = 0,   *
C       or the tables in TAB are invalid for N, then the results are   *
C       undefined.                                                     *
C                                                                      *
C--------------------------------------------------------------------- *
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      VMOV  -                                                         *
C      CFFTX -                                                         *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 97/02/13 ==================   *
C NAME: CFFT2     COMPLEX FFT - RADIX 2                REL 1.0  MAR 92 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      subroutine cfft2( init, idir, n, a, tab, c )
 
      integer idir, init, n, itab, jdir, ierr
      complex a(*), tab(*), c(*)
 
c-----------------------------------------------------------------------
 
      itab = 1 + n
      if( init .eq. 0 ) then
         jdir = - idir
         if( jdir .ne. 0 ) call vmov( a, 1, c, 1, 2*n )
      else
         jdir = 0
      endif
 
      call cfftx( c, 2, n, jdir, init, tab(itab), ierr )
 
      return
      end
